/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.codegen.languages;

import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FilenameUtils;
import org.openapitools.codegen.CodegenConfig;
import org.openapitools.codegen.DefaultCodegen;
import org.openapitools.codegen.GeneratorLanguage;
import org.openapitools.codegen.utils.ModelUtils;
import org.openapitools.codegen.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRubyCodegen
extends DefaultCodegen
implements CodegenConfig {
    private final Logger LOGGER = LoggerFactory.getLogger(AbstractRubyCodegen.class);

    public AbstractRubyCodegen() {
        this.setReservedWordsLowerCase(Arrays.asList("__FILE__", "and", "def", "end", "in", "or", "self", "unless", "__LINE__", "begin", "defined?", "ensure", "module", "redo", "super", "until", "BEGIN", "break", "do", "false", "next", "rescue", "then", "when", "END", "case", "else", "for", "nil", "retry", "true", "while", "alias", "class", "elsif", "if", "not", "return", "undef", "yield"));
        this.languageSpecificPrimitives.clear();
        this.languageSpecificPrimitives.add("String");
        this.languageSpecificPrimitives.add("Boolean");
        this.languageSpecificPrimitives.add("Integer");
        this.languageSpecificPrimitives.add("Float");
        this.languageSpecificPrimitives.add("Date");
        this.languageSpecificPrimitives.add("Time");
        this.languageSpecificPrimitives.add("Array");
        this.languageSpecificPrimitives.add("Hash");
        this.languageSpecificPrimitives.add("File");
        this.languageSpecificPrimitives.add("Object");
        this.typeMapping.clear();
        this.typeMapping.put("string", "String");
        this.typeMapping.put("boolean", "Boolean");
        this.typeMapping.put("char", "String");
        this.typeMapping.put("int", "Integer");
        this.typeMapping.put("integer", "Integer");
        this.typeMapping.put("long", "Integer");
        this.typeMapping.put("short", "Integer");
        this.typeMapping.put("float", "Float");
        this.typeMapping.put("double", "Float");
        this.typeMapping.put("number", "Float");
        this.typeMapping.put("decimal", "Float");
        this.typeMapping.put("date", "Date");
        this.typeMapping.put("DateTime", "Time");
        this.typeMapping.put("array", "Array");
        this.typeMapping.put("set", "Array");
        this.typeMapping.put("List", "Array");
        this.typeMapping.put("map", "Hash");
        this.typeMapping.put("object", "Object");
        this.typeMapping.put("AnyType", "Object");
        this.typeMapping.put("file", "File");
        this.typeMapping.put("binary", "String");
        this.typeMapping.put("ByteArray", "String");
        this.typeMapping.put("UUID", "String");
        this.typeMapping.put("URI", "String");
        this.instantiationTypes.put("map", "Hash");
        this.instantiationTypes.put("array", "Array");
        this.instantiationTypes.put("set", "Set");
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)System.getenv("RUBY_POST_PROCESS_FILE"))) {
            this.LOGGER.info("Hint: Environment variable 'RUBY_POST_PROCESS_FILE' (optional) not defined. E.g. to format the source code, please try 'export RUBY_POST_PROCESS_FILE=\"/usr/local/bin/rubocop -a\"' (Linux/Mac)");
        }
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String getTypeDeclaration(Schema schema) {
        if (ModelUtils.isArraySchema(schema)) {
            Schema inner = ((ArraySchema)schema).getItems();
            return this.getSchemaType(schema) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (ModelUtils.isMapSchema(schema)) {
            Schema inner = ModelUtils.getAdditionalProperties(schema);
            return this.getSchemaType(schema) + "<String, " + this.getTypeDeclaration(inner) + ">";
        }
        return super.getTypeDeclaration(schema);
    }

    @Override
    public String toInstantiationType(Schema schema) {
        if (ModelUtils.isMapSchema(schema)) {
            return (String)this.instantiationTypes.get("map");
        }
        if (ModelUtils.isArraySchema(schema)) {
            String parentType = ModelUtils.isSet(schema) ? "set" : "array";
            return (String)this.instantiationTypes.get(parentType);
        }
        return super.toInstantiationType(schema);
    }

    @Override
    public String toDefaultValue(Schema p) {
        if (ModelUtils.isIntegerSchema(p = ModelUtils.getReferencedSchema(this.openAPI, p)) || ModelUtils.isNumberSchema(p) || ModelUtils.isBooleanSchema(p)) {
            if (p.getDefault() != null) {
                return p.getDefault().toString();
            }
        } else if (ModelUtils.isStringSchema(p) && p.getDefault() != null) {
            if (p.getDefault() instanceof Date) {
                Date date = (Date)p.getDefault();
                LocalDate localDate = date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
                return "Date.parse(\"" + String.format(Locale.ROOT, localDate.toString(), "") + "\")";
            }
            if (p.getDefault() instanceof OffsetDateTime) {
                return "Time.parse(\"" + String.format(Locale.ROOT, ((OffsetDateTime)p.getDefault()).atZoneSameInstant(ZoneId.systemDefault()).toString(), "") + "\")";
            }
            return "'" + this.escapeText(String.valueOf(p.getDefault())) + "'";
        }
        return null;
    }

    @Override
    public String toEnumDefaultValue(String value, String datatype) {
        return datatype + "::" + value;
    }

    @Override
    public String toVarName(String name) {
        if (this.nameMapping.containsKey(name)) {
            return (String)this.nameMapping.get(name);
        }
        String varName = this.sanitizeName(name);
        if (name.matches("^[A-Z_]*$")) {
            varName = varName.toLowerCase(Locale.ROOT);
        }
        if (this.isReservedWord(varName = StringUtils.underscore(varName)) || varName.matches("^\\d.*")) {
            varName = this.escapeReservedWord(varName);
        }
        return varName;
    }

    @Override
    public String toRegularExpression(String pattern) {
        return this.addRegularExpressionDelimiter(pattern);
    }

    @Override
    public String addRegularExpressionDelimiter(String pattern) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)pattern)) {
            return pattern;
        }
        if (!pattern.matches("^/.*")) {
            return "/" + pattern.replaceAll("(?<!\\\\)\\/", "\\\\/") + "/";
        }
        return pattern;
    }

    @Override
    public String toParamName(String name) {
        if (this.parameterNameMapping.containsKey(name)) {
            return (String)this.parameterNameMapping.get(name);
        }
        return this.toVarName(name);
    }

    @Override
    public String toOperationId(String operationId) {
        if (this.isReservedWord(operationId)) {
            String newOperationId = StringUtils.underscore("call_" + operationId);
            this.LOGGER.warn("{} (reserved word) cannot be used as method name. Renamed to {}", (Object)operationId, (Object)newOperationId);
            return newOperationId;
        }
        return StringUtils.underscore(operationId);
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("'", "");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("=end", "=_end").replace("=begin", "=_begin").replace("#{", "\\#{");
    }

    @Override
    public void postProcessFile(File file, String fileType) {
        block17: {
            if (file == null) {
                return;
            }
            String rubyPostProcessFile = System.getenv("RUBY_POST_PROCESS_FILE");
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)rubyPostProcessFile)) {
                return;
            }
            if ("rb".equals(FilenameUtils.getExtension((String)file.toString()))) {
                String command = rubyPostProcessFile + " " + file;
                try {
                    Process p = Runtime.getRuntime().exec(command);
                    int exitValue = p.waitFor();
                    if (exitValue != 0) {
                        try (InputStreamReader inputStreamReader = new InputStreamReader(p.getErrorStream(), StandardCharsets.UTF_8);
                             BufferedReader br = new BufferedReader(inputStreamReader);){
                            String line;
                            StringBuilder sb = new StringBuilder();
                            while ((line = br.readLine()) != null) {
                                sb.append(line);
                            }
                            this.LOGGER.error("Error running the command ({}). Exit value: {}, Error output: {}", new Object[]{command, exitValue, sb});
                            break block17;
                        }
                    }
                    this.LOGGER.info("Successfully executed: `{}`", (Object)command);
                }
                catch (IOException | InterruptedException e) {
                    this.LOGGER.error("Error running the command ({}). Exception: {}", (Object)command, (Object)e.getMessage());
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public GeneratorLanguage generatorLanguage() {
        return GeneratorLanguage.RUBY;
    }
}

