/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.infra;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.BenchmarkParamsL1;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.runner.WorkloadParams;

abstract class BenchmarkParamsL2
extends BenchmarkParamsL1
implements Serializable,
Comparable<BenchmarkParams> {
    private static final long serialVersionUID = -1068219503090299117L;
    protected final String benchmark;
    protected final String generatedTarget;
    protected final boolean synchIterations;
    protected final int threads;
    protected final int[] threadGroups;
    protected final int forks;
    protected final int warmupForks;
    protected final IterationParams warmup;
    protected final IterationParams measurement;
    protected final Mode mode;
    protected final WorkloadParams params;
    protected final TimeUnit timeUnit;
    protected final int opsPerInvocation;
    protected final String jvm;
    protected final Collection<String> jvmArgs;

    public BenchmarkParamsL2(String benchmark, String generatedTarget, boolean synchIterations, int threads, int[] threadGroups, int forks, int warmupForks, IterationParams warmup, IterationParams measurement, Mode mode, WorkloadParams params, TimeUnit timeUnit, int opsPerInvocation, String jvm, Collection<String> jvmArgs) {
        this.benchmark = benchmark;
        this.generatedTarget = generatedTarget;
        this.synchIterations = synchIterations;
        this.threads = threads;
        this.threadGroups = threadGroups;
        this.forks = forks;
        this.warmupForks = warmupForks;
        this.warmup = warmup;
        this.measurement = measurement;
        this.mode = mode;
        this.params = params;
        this.timeUnit = timeUnit;
        this.opsPerInvocation = opsPerInvocation;
        this.jvm = jvm;
        this.jvmArgs = jvmArgs;
    }

    public BenchmarkParamsL2(BenchmarkParams other) {
        this.benchmark = other.benchmark;
        this.generatedTarget = other.generatedTarget;
        this.synchIterations = other.synchIterations;
        this.threads = other.threads;
        this.threadGroups = other.threadGroups;
        this.forks = other.forks;
        this.warmupForks = other.warmupForks;
        this.warmup = other.warmup;
        this.measurement = other.measurement;
        this.mode = other.mode;
        this.params = other.params;
        this.timeUnit = other.timeUnit;
        this.opsPerInvocation = other.opsPerInvocation;
        this.jvm = other.jvm;
        this.jvmArgs = other.jvmArgs;
    }

    public boolean shouldSynchIterations() {
        return this.synchIterations;
    }

    public IterationParams getWarmup() {
        return this.warmup;
    }

    public IterationParams getMeasurement() {
        return this.measurement;
    }

    public int getThreads() {
        return this.threads;
    }

    public int[] getThreadGroups() {
        return Arrays.copyOf(this.threadGroups, this.threadGroups.length);
    }

    public int getForks() {
        return this.forks;
    }

    public int getWarmupForks() {
        return this.warmupForks;
    }

    public Mode getMode() {
        return this.mode;
    }

    public String getBenchmark() {
        return this.benchmark;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public int getOpsPerInvocation() {
        return this.opsPerInvocation;
    }

    public Collection<String> getParamsKeys() {
        return this.params.keys();
    }

    public String getParam(String key) {
        if (this.params != null) {
            return this.params.get(key);
        }
        return null;
    }

    public String generatedBenchmark() {
        return this.generatedTarget;
    }

    public String getJvm() {
        return this.jvm;
    }

    public Collection<String> getJvmArgs() {
        return Collections.unmodifiableCollection(this.jvmArgs);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BenchmarkParams that = (BenchmarkParams)o;
        if (!this.benchmark.equals(that.benchmark)) {
            return false;
        }
        if (this.mode != that.mode) {
            return false;
        }
        return this.params.equals(that.params);
    }

    public int hashCode() {
        int result = this.benchmark.hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.params.hashCode();
        return result;
    }

    @Override
    public int compareTo(BenchmarkParams o) {
        int v = this.mode.compareTo(o.mode);
        if (v != 0) {
            return v;
        }
        int v1 = this.benchmark.compareTo(o.benchmark);
        if (v1 != 0) {
            return v1;
        }
        if (this.params == null || o.params == null) {
            return 0;
        }
        return this.params.compareTo(o.params);
    }

    public String id() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.benchmark).append("-");
        sb.append((Object)this.mode);
        for (String key : this.params.keys()) {
            sb.append("-");
            sb.append(key).append("-").append(this.params.get(key));
        }
        return sb.toString();
    }
}

