/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.profile.InternalProfiler;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ResultRole;
import org.openjdk.jmh.util.HashMultiset;
import org.openjdk.jmh.util.Multiset;
import org.openjdk.jmh.util.Multisets;

public class StackProfiler
implements InternalProfiler {
    private static final int SAMPLE_STACK_LINES = Integer.getInteger("jmh.stack.lines", 1);
    private static final int SAMPLE_TOP_STACKS = Integer.getInteger("jmh.stack.top", 10);
    private static final int SAMPLE_PERIOD_MSEC = Integer.getInteger("jmh.stack.period", 10);
    private static final boolean SAMPLE_LINE = Boolean.getBoolean("jmh.stack.detailLine");
    private static final String[] IGNORED_THREADS = new String[]{"Finalizer", "Signal Dispatcher", "Reference Handler", "main", "Sampling Thread", "Attach Listener"};
    private volatile SamplingTask samplingTask;

    @Override
    public void beforeIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.samplingTask = new SamplingTask();
        this.samplingTask.start();
    }

    @Override
    public Collection<? extends Result> afterIteration(BenchmarkParams benchmarkParams, IterationParams iterationParams) {
        this.samplingTask.stop();
        return Arrays.asList(new StackResult(this.samplingTask.stacks));
    }

    @Override
    public boolean checkSupport(List<String> msg) {
        return true;
    }

    @Override
    public String label() {
        return "stack";
    }

    @Override
    public String getDescription() {
        return "Simple and naive Java stack profiler";
    }

    static String dottedLine(String header) {
        int HEADER_WIDTH = 100;
        StringBuilder sb = new StringBuilder();
        sb.append("....");
        if (header != null) {
            header = "[" + header + "]";
            sb.append(header);
        } else {
            header = "";
        }
        for (int c = 0; c < 96 - header.length(); ++c) {
            sb.append(".");
        }
        sb.append("\n");
        return sb.toString();
    }

    public static class StackResultAggregator
    implements Aggregator<StackResult> {
        @Override
        public Result aggregate(Collection<StackResult> results) {
            EnumMap<Thread.State, Multiset<StackRecord>> sum = new EnumMap<Thread.State, Multiset<StackRecord>>(Thread.State.class);
            for (StackResult r : results) {
                for (Map.Entry entry : r.stacks.entrySet()) {
                    if (!sum.containsKey(entry.getKey())) {
                        sum.put((Thread.State)((Object)entry.getKey()), new HashMultiset());
                    }
                    Multiset sumSet = (Multiset)sum.get(entry.getKey());
                    for (StackRecord rec : ((Multiset)entry.getValue()).keys()) {
                        sumSet.add(rec, ((Multiset)entry.getValue()).count(rec));
                    }
                }
            }
            return new StackResult(sum);
        }
    }

    public static class StackResult
    extends Result<StackResult> {
        private static final long serialVersionUID = 2609170863630346073L;
        private final Map<Thread.State, Multiset<StackRecord>> stacks;

        public StackResult(Map<Thread.State, Multiset<StackRecord>> stacks) {
            super(ResultRole.SECONDARY, "@stack", StackResult.of(Double.NaN), "---", AggregationPolicy.AVG);
            this.stacks = stacks;
        }

        @Override
        protected Aggregator<StackResult> getThreadAggregator() {
            return new StackResultAggregator();
        }

        @Override
        protected Aggregator<StackResult> getIterationAggregator() {
            return new StackResultAggregator();
        }

        @Override
        public String toString() {
            return "<delayed till summary>";
        }

        @Override
        public String extendedInfo(String label) {
            return this.getStack(this.stacks);
        }

        public String getStack(final Map<Thread.State, Multiset<StackRecord>> stacks) {
            ArrayList<Thread.State> sortedStates = new ArrayList<Thread.State>(stacks.keySet());
            Collections.sort(sortedStates, new Comparator<Thread.State>(){

                private long stateSize(Thread.State state) {
                    Multiset set = (Multiset)stacks.get((Object)state);
                    return set == null ? 0L : set.size();
                }

                @Override
                public int compare(Thread.State s1, Thread.State s2) {
                    return Long.valueOf(this.stateSize(s2)).compareTo(this.stateSize(s1));
                }
            });
            long totalSize = this.getTotalSize(stacks);
            StringBuilder builder = new StringBuilder();
            builder.append("Stack profiler:\n\n");
            builder.append(StackProfiler.dottedLine("Thread state distributions"));
            for (Thread.State state : sortedStates) {
                if (!this.isSignificant(stacks.get((Object)state).size(), totalSize)) continue;
                builder.append(String.format("%5.1f%% %7s %s%n", new Object[]{(double)stacks.get((Object)state).size() * 100.0 / (double)totalSize, "", state}));
            }
            builder.append("\n");
            for (Thread.State state : sortedStates) {
                Multiset<StackRecord> stateStacks = stacks.get((Object)state);
                if (!this.isSignificant(stateStacks.size(), totalSize)) continue;
                builder.append(StackProfiler.dottedLine("Thread state: " + state.toString()));
                int totalDisplayed = 0;
                for (StackRecord s : Multisets.countHighest(stateStacks, SAMPLE_TOP_STACKS)) {
                    String[] lines = s.lines;
                    if (lines.length <= 0) continue;
                    totalDisplayed = (int)((long)totalDisplayed + stateStacks.count(s));
                    builder.append(String.format("%5.1f%% %5.1f%% %s%n", (double)stateStacks.count(s) * 100.0 / (double)totalSize, (double)stateStacks.count(s) * 100.0 / (double)stateStacks.size(), lines[0]));
                    if (lines.length <= 1) continue;
                    for (int i = 1; i < lines.length; ++i) {
                        builder.append(String.format("%13s %s%n", "", lines[i]));
                    }
                    builder.append("\n");
                }
                if (this.isSignificant(stateStacks.size() - (long)totalDisplayed, stateStacks.size())) {
                    builder.append(String.format("%5.1f%% %5.1f%% %s%n", (double)(stateStacks.size() - (long)totalDisplayed) * 100.0 / (double)totalSize, (double)(stateStacks.size() - (long)totalDisplayed) * 100.0 / (double)stateStacks.size(), "<other>"));
                }
                builder.append("\n");
            }
            return builder.toString();
        }

        private boolean isSignificant(long part, long total) {
            return part * 1000L >= total;
        }

        private long getTotalSize(Map<Thread.State, Multiset<StackRecord>> stacks) {
            long sum = 0L;
            for (Multiset<StackRecord> set : stacks.values()) {
                sum += set.size();
            }
            return sum;
        }
    }

    private static class StackRecord
    implements Serializable {
        private static final long serialVersionUID = -1829626661894754733L;
        public final String[] lines;

        private StackRecord(String[] lines) {
            this.lines = lines;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StackRecord that = (StackRecord)o;
            return Arrays.equals(this.lines, that.lines);
        }

        public int hashCode() {
            return Arrays.hashCode(this.lines);
        }
    }

    public static class SamplingTask
    implements Runnable {
        private final Thread thread;
        private final Map<Thread.State, Multiset<StackRecord>> stacks = new EnumMap<Thread.State, Multiset<StackRecord>>(Thread.State.class);

        public SamplingTask() {
            for (Thread.State s : Thread.State.values()) {
                this.stacks.put(s, new HashMultiset());
            }
            this.thread = new Thread(this);
            this.thread.setName("Sampling Thread");
        }

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                ThreadInfo[] infos;
                block3: for (ThreadInfo info : infos = ManagementFactory.getThreadMXBean().dumpAllThreads(false, false)) {
                    for (String ignore : IGNORED_THREADS) {
                        if (info.getThreadName().equalsIgnoreCase(ignore)) continue block3;
                    }
                    StackTraceElement[] stack = info.getStackTrace();
                    String[] stackLines = new String[Math.min(stack.length, SAMPLE_STACK_LINES)];
                    for (int i = 0; i < Math.min(stack.length, SAMPLE_STACK_LINES); ++i) {
                        stackLines[i] = stack[i].getClassName() + '.' + stack[i].getMethodName() + (SAMPLE_LINE ? ":" + stack[i].getLineNumber() : "");
                    }
                    Thread.State state = info.getThreadState();
                    this.stacks.get((Object)state).add(new StackRecord(stackLines));
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(SAMPLE_PERIOD_MSEC);
                }
                catch (InterruptedException e) {
                    return;
                }
            }
        }

        public void start() {
            this.thread.start();
        }

        public void stop() {
            this.thread.interrupt();
            try {
                this.thread.join();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

