/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.results;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.Aggregator;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.util.Multimap;
import org.openjdk.jmh.util.TreeMultimap;

public class IterationResult
implements Serializable {
    private static final long serialVersionUID = 960397066774710819L;
    private final BenchmarkParams benchmarkParams;
    private final IterationParams params;
    private final List<Result> primaryResults;
    private final Multimap<String, Result> secondaryResults;
    private String scoreUnit;

    public IterationResult(BenchmarkParams benchmarkParams, IterationParams params) {
        this.benchmarkParams = benchmarkParams;
        this.params = params;
        this.primaryResults = new ArrayList<Result>();
        this.secondaryResults = new TreeMultimap<String, Result>();
    }

    public void addResults(Collection<? extends Result> rs) {
        for (Result result : rs) {
            this.addResult(result);
        }
    }

    public void addResult(Result result) {
        if (result.getRole().isPrimary()) {
            if (this.scoreUnit == null) {
                this.scoreUnit = result.getScoreUnit();
            } else if (!this.scoreUnit.equals(result.getScoreUnit())) {
                throw new IllegalStateException("Adding the result with another score unit!");
            }
            this.primaryResults.add(result);
        }
        if (result.getRole().isSecondary()) {
            this.secondaryResults.put(result.getLabel(), result);
        }
    }

    public Collection<Result> getRawPrimaryResults() {
        return this.primaryResults;
    }

    public Multimap<String, Result> getRawSecondaryResults() {
        return this.secondaryResults;
    }

    public Map<String, Result> getSecondaryResults() {
        TreeMap<String, Result> answer = new TreeMap<String, Result>();
        for (String label : this.secondaryResults.keys()) {
            Collection<Result> results = this.secondaryResults.get(label);
            Result next = results.iterator().next();
            Aggregator aggregator = next.getThreadAggregator();
            Result result = aggregator.aggregate(results);
            answer.put(label, result);
        }
        return answer;
    }

    public Result getPrimaryResult() {
        Result next = this.primaryResults.iterator().next();
        Aggregator aggregator = next.getThreadAggregator();
        return aggregator.aggregate(this.primaryResults);
    }

    public IterationParams getParams() {
        return this.params;
    }

    public BenchmarkParams getBenchmarkParams() {
        return this.benchmarkParams;
    }

    public String getScoreUnit() {
        return this.scoreUnit;
    }
}

