/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.IOException;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.ForkedRunner;
import org.openjdk.jmh.runner.link.BinaryLinkClient;
import org.openjdk.jmh.runner.options.Options;

class ForkedMain {
    private static volatile boolean gracefullyFinished;

    ForkedMain() {
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            throw new IllegalArgumentException("Empty arguments for forked VM");
        }
        BinaryLinkClient link = null;
        try {
            String hostName = argv[0];
            int hostPort = Integer.valueOf(argv[1]);
            link = new BinaryLinkClient(hostName, hostPort);
            ForkedMain.addShutdownHook(link);
            Options options = link.requestOptions();
            System.setErr(link.getErrStream());
            System.setOut(link.getOutStream());
            ForkedRunner runner = new ForkedRunner(options, link);
            runner.run();
            gracefullyFinished = true;
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
    }

    private static void addShutdownHook(final BinaryLinkClient link) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (!gracefullyFinished) {
                    String msg = "<failure: VM prematurely exited before JMH had finished with it, explicit System.exit was called?>";
                    if (link != null) {
                        link.getOutputFormat().println(msg);
                        try {
                            link.pushException(new BenchmarkException(new IllegalStateException(msg)));
                        }
                        catch (IOException e) {
                            System.err.println(msg);
                        }
                    } else {
                        System.err.println(msg);
                    }
                }
                if (link != null) {
                    try {
                        link.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

