/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.format;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Map;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.infra.IterationParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.IterationResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.RunResult;
import org.openjdk.jmh.results.format.ResultFormatFactory;
import org.openjdk.jmh.results.format.ResultFormatType;
import org.openjdk.jmh.runner.IterationType;
import org.openjdk.jmh.runner.format.AbstractOutputFormat;
import org.openjdk.jmh.runner.options.VerboseMode;

class TextReportFormat
extends AbstractOutputFormat {
    public TextReportFormat(PrintStream out, VerboseMode verbose) {
        super(out, verbose);
    }

    @Override
    public void startBenchmark(BenchmarkParams params) {
        if (params.getWarmup().getCount() > 0) {
            this.out.println("# Warmup: " + params.getWarmup().getCount() + " iterations, " + params.getWarmup().getTime() + " each" + (params.getWarmup().getBatchSize() <= 1 ? "" : ", " + params.getWarmup().getBatchSize() + " calls per op"));
        } else {
            this.out.println("# Warmup: <none>");
        }
        if (params.getMeasurement().getCount() > 0) {
            this.out.println("# Measurement: " + params.getMeasurement().getCount() + " iterations, " + params.getMeasurement().getTime() + " each" + (params.getMeasurement().getBatchSize() <= 1 ? "" : ", " + params.getMeasurement().getBatchSize() + " calls per op"));
        } else {
            this.out.println("# Measurement: <none>");
        }
        this.out.println("# Threads: " + params.getThreads() + " " + TextReportFormat.getThreadsString(params.getThreads()) + (params.shouldSynchIterations() ? ", will synchronize iterations" : (params.getMode() == Mode.SingleShotTime ? "" : ", ***WARNING: Synchronize iterations are disabled!***")));
        this.out.println("# Benchmark mode: " + params.getMode().longLabel());
        this.out.println("# Benchmark: " + params.getBenchmark());
        if (!params.getParamsKeys().isEmpty()) {
            String s = "";
            boolean isFirst = true;
            for (String k : params.getParamsKeys()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    s = s + ", ";
                }
                s = s + k + " = " + params.getParam(k);
            }
            this.out.println("# Parameters: (" + s + ")");
        }
    }

    @Override
    public void iteration(BenchmarkParams benchmarkParams, IterationParams params, int iteration) {
        switch (params.getType()) {
            case WARMUP: {
                this.out.print(String.format("# Warmup Iteration %3d: ", iteration));
                break;
            }
            case MEASUREMENT: {
                this.out.print(String.format("Iteration %3d: ", iteration));
                break;
            }
            default: {
                throw new IllegalStateException("Unknown iteration type: " + (Object)((Object)params.getType()));
            }
        }
        this.out.flush();
    }

    protected static String getThreadsString(int t) {
        if (t > 1) {
            return "threads";
        }
        return "thread";
    }

    @Override
    public void iterationResult(BenchmarkParams benchmParams, IterationParams params, int iteration, IterationResult data) {
        StringBuilder sb = new StringBuilder();
        sb.append(data.getPrimaryResult().toString());
        if (params.getType() == IterationType.MEASUREMENT) {
            int prefixLen = String.format("Iteration %3d: ", iteration).length();
            Map<String, Result> secondary = data.getSecondaryResults();
            if (!secondary.isEmpty()) {
                sb.append("\n");
                int maxKeyLen = 0;
                for (Map.Entry<String, Result> res : secondary.entrySet()) {
                    maxKeyLen = Math.max(maxKeyLen, res.getKey().length());
                }
                for (Map.Entry<String, Result> res : secondary.entrySet()) {
                    sb.append(String.format("%" + prefixLen + "s", ""));
                    sb.append(String.format("  %-" + (maxKeyLen + 1) + "s %s", res.getKey() + ":", res.getValue()));
                    sb.append("\n");
                }
            }
        }
        this.out.print(String.format("%s%n", sb.toString()));
        this.out.flush();
    }

    @Override
    public void endBenchmark(BenchmarkResult result) {
        this.out.println();
        if (result != null) {
            this.out.println(result.getPrimaryResult().extendedInfo(null));
            for (Result r : result.getSecondaryResults().values()) {
                this.out.println(r.extendedInfo(r.getLabel()));
            }
            this.out.println();
        }
    }

    @Override
    public void startRun() {
    }

    @Override
    public void endRun(Collection<RunResult> runResults) {
        PrintWriter pw = new PrintWriter(this.out);
        ResultFormatFactory.getInstance(ResultFormatType.TEXT, pw).writeOut(runResults);
        pw.flush();
    }
}

