/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner.link;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.Socket;
import java.util.Arrays;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.runner.ActionPlan;
import org.openjdk.jmh.runner.BenchmarkException;
import org.openjdk.jmh.runner.format.OutputFormat;
import org.openjdk.jmh.runner.link.ActionPlanFrame;
import org.openjdk.jmh.runner.link.ClassConventions;
import org.openjdk.jmh.runner.link.ExceptionFrame;
import org.openjdk.jmh.runner.link.FinishingFrame;
import org.openjdk.jmh.runner.link.InfraFrame;
import org.openjdk.jmh.runner.link.OptionsFrame;
import org.openjdk.jmh.runner.link.OutputFormatFrame;
import org.openjdk.jmh.runner.link.OutputFrame;
import org.openjdk.jmh.runner.link.ResultsFrame;
import org.openjdk.jmh.runner.options.Options;
import org.openjdk.jmh.util.FileUtils;
import org.openjdk.jmh.util.Multimap;

public final class BinaryLinkClient {
    private final Object lock = new Object();
    private final Socket clientSocket;
    private final ObjectOutputStream oos;
    private final ObjectInputStream ois;
    private final ForwardingPrintStream streamErr;
    private final ForwardingPrintStream streamOut;
    private final OutputFormat outputFormat;

    public BinaryLinkClient(String hostName, int hostPort) throws IOException {
        this.clientSocket = new Socket(hostName, hostPort);
        this.oos = new ObjectOutputStream(this.clientSocket.getOutputStream());
        this.ois = new ObjectInputStream(this.clientSocket.getInputStream());
        this.streamErr = new ForwardingPrintStream(OutputFrame.Type.ERR);
        this.streamOut = new ForwardingPrintStream(OutputFrame.Type.OUT);
        this.outputFormat = (OutputFormat)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{OutputFormat.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BinaryLinkClient.this.pushFrame(new OutputFormatFrame(ClassConventions.getMethodName(method), args));
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pushFrame(Serializable frame) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.oos.writeObject(frame);
            this.oos.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        FileUtils.safelyClose(this.streamErr);
        FileUtils.safelyClose(this.streamOut);
        Object object = this.lock;
        synchronized (object) {
            this.oos.writeObject(new FinishingFrame());
            FileUtils.safelyClose(this.ois);
            FileUtils.safelyClose(this.oos);
            this.clientSocket.close();
        }
    }

    public Options requestOptions() throws IOException, ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            this.pushFrame(new InfraFrame(InfraFrame.Type.OPTIONS_REQUEST));
            Object reply = this.ois.readObject();
            if (reply instanceof OptionsFrame) {
                return ((OptionsFrame)reply).getOpts();
            }
            throw new IllegalStateException("Got the erroneous reply: " + reply);
        }
    }

    public ActionPlan requestPlan() throws IOException, ClassNotFoundException {
        Object object = this.lock;
        synchronized (object) {
            this.pushFrame(new InfraFrame(InfraFrame.Type.ACTION_PLAN_REQUEST));
            Object reply = this.ois.readObject();
            if (reply instanceof ActionPlanFrame) {
                return ((ActionPlanFrame)reply).getActionPlan();
            }
            throw new IllegalStateException("Got the erroneous reply: " + reply);
        }
    }

    public void pushResults(Multimap<BenchmarkParams, BenchmarkResult> res) throws IOException {
        this.pushFrame(new ResultsFrame(res));
    }

    public void pushException(BenchmarkException error) throws IOException {
        this.pushFrame(new ExceptionFrame(error));
    }

    public PrintStream getOutStream() {
        return this.streamOut;
    }

    public PrintStream getErrStream() {
        return this.streamErr;
    }

    public OutputFormat getOutputFormat() {
        return this.outputFormat;
    }

    class ForwardingPrintStream
    extends PrintStream {
        public ForwardingPrintStream(final OutputFrame.Type type) {
            super(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, new byte[]{(byte)(b & 0xFF)}));
                }

                @Override
                public void write(byte[] b) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, Arrays.copyOf(b, b.length)));
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                    BinaryLinkClient.this.pushFrame(new OutputFrame(type, Arrays.copyOfRange(b, off, len + off)));
                }
            });
        }
    }
}

