/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.profile;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.HelpFormatter;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.openjdk.jmh.infra.BenchmarkParams;
import org.openjdk.jmh.profile.ExternalProfiler;
import org.openjdk.jmh.profile.PerfSupport;
import org.openjdk.jmh.profile.ProfilerException;
import org.openjdk.jmh.profile.ProfilerOptionFormatter;
import org.openjdk.jmh.profile.ProfilerUtils;
import org.openjdk.jmh.results.AggregationPolicy;
import org.openjdk.jmh.results.BenchmarkResult;
import org.openjdk.jmh.results.Result;
import org.openjdk.jmh.results.ScalarResult;
import org.openjdk.jmh.util.Utils;

public class LinuxPerfNormProfiler
implements ExternalProfiler {
    private static final String[] interestingEvents = new String[]{"cycles", "instructions", "branches", "branch-misses", "bus-cycles", "ref-cycles", "context-switches", "cpu-migrations", "page-faults", "minor-faults", "major-faults", "alignment-faults", "emulation-faults", "L1-dcache-loads", "L1-dcache-load-misses", "L1-dcache-stores", "L1-dcache-store-misses", "L1-icache-loads", "L1-icache-load-misses", "LLC-loads", "LLC-stores", "dTLB-loads", "dTLB-load-misses", "dTLB-stores", "dTLB-store-misses", "iTLB-loads", "iTLB-load-misses", "stalled-cycles-frontend", "stalled-cycles-backend"};
    private final int delayMs;
    private final int lengthMs;
    private final boolean useDefaultStats;
    private final long highPassFilter;
    private final int incrementInterval;
    private final boolean isIncrementable;
    private final Collection<String> supportedEvents = new ArrayList<String>();

    public LinuxPerfNormProfiler(String initLine) throws ProfilerException {
        List userEvents;
        OptionParser parser = new OptionParser();
        parser.formatHelpWith((HelpFormatter)new ProfilerOptionFormatter("perfnorm"));
        ArgumentAcceptingOptionSpec optEvents = parser.accepts("events", "Events to gather.").withRequiredArg().ofType(String.class).withValuesSeparatedBy(",").describedAs("event+");
        ArgumentAcceptingOptionSpec optDelay = parser.accepts("delay", "Delay collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optLength = parser.accepts("length", "Do the collection for a given time, in milliseconds; -1 to detect automatically.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optIncrementInterval = parser.accepts("interval", "The interval between incremental updates from a concurrently running perf. Lower values may improve accuracy, while increasing the profiling overhead.").withRequiredArg().ofType(Integer.class).describedAs("ms").defaultsTo((Object)100, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec optHighPassFilter = parser.accepts("highPassFilter", "Ignore event increments larger that this.").withRequiredArg().ofType(Long.class).describedAs("#").defaultsTo((Object)100000000000L, (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec optDefaultStat = parser.accepts("useDefaultStat", "Use \"perf stat -d -d -d\" instead of explicit counter list.").withRequiredArg().ofType(Boolean.class).describedAs("bool").defaultsTo((Object)false, (Object[])new Boolean[0]);
        OptionSet set = ProfilerUtils.parseInitLine(initLine, parser);
        try {
            this.delayMs = (Integer)set.valueOf((OptionSpec)optDelay);
            this.lengthMs = (Integer)set.valueOf((OptionSpec)optLength);
            this.incrementInterval = (Integer)set.valueOf((OptionSpec)optIncrementInterval);
            this.highPassFilter = (Long)set.valueOf((OptionSpec)optHighPassFilter);
            this.useDefaultStats = (Boolean)set.valueOf((OptionSpec)optDefaultStat);
            userEvents = set.valuesOf((OptionSpec)optEvents);
        }
        catch (OptionException e) {
            throw new ProfilerException(e.getMessage());
        }
        Collection<String> msgs = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "echo", "1");
        if (!msgs.isEmpty()) {
            throw new ProfilerException(msgs.toString());
        }
        Collection<String> incremental = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--interval-print", String.valueOf(this.incrementInterval), "echo", "1");
        this.isIncrementable = incremental.isEmpty();
        if (userEvents != null) {
            for (String ev : userEvents) {
                if (ev.trim().isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
        if (this.supportedEvents.isEmpty()) {
            for (String ev : interestingEvents) {
                Collection<String> res = Utils.tryWith(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", "cycles,instructions," + ev, "echo", "1");
                if (!res.isEmpty()) continue;
                this.supportedEvents.add(ev);
            }
        }
    }

    @Override
    public Collection<String> addJVMInvokeOptions(BenchmarkParams params) {
        ArrayList<String> cmd = new ArrayList<String>();
        if (this.useDefaultStats) {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--detailed", "--detailed", "--detailed"));
        } else {
            cmd.addAll(Arrays.asList(PerfSupport.PERF_EXEC, "stat", "--log-fd", "2", "--field-separator", ",", "--event", Utils.join(this.supportedEvents, ",")));
        }
        if (this.isIncrementable) {
            cmd.addAll(Arrays.asList("-I", String.valueOf(this.incrementInterval)));
        }
        return cmd;
    }

    @Override
    public Collection<String> addJVMOptions(BenchmarkParams params) {
        return Collections.emptyList();
    }

    @Override
    public void beforeTrial(BenchmarkParams params) {
    }

    @Override
    public Collection<? extends Result> afterTrial(BenchmarkResult br, long pid, File stdOut, File stdErr) {
        return this.process(br, stdOut, stdErr);
    }

    @Override
    public boolean allowPrintOut() {
        return true;
    }

    @Override
    public boolean allowPrintErr() {
        return false;
    }

    @Override
    public String getDescription() {
        return "Linux perf statistics, normalized by operation count";
    }

    /*
     * Exception decompiling
     */
    private Collection<? extends Result> process(BenchmarkResult br, File stdOut, File stdErr) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class PerfResult
    extends ScalarResult {
        private static final long serialVersionUID = -1262685915873231436L;

        public PerfResult(String key, double value) {
            super(key, value, "#/op", AggregationPolicy.AVG);
        }

        @Override
        public String extendedInfo() {
            return "";
        }
    }
}

