/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmh.runner;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.openjdk.jmh.runner.AbstractResourceReader;
import org.openjdk.jmh.runner.BenchmarkListEntry;
import org.openjdk.jmh.runner.format.OutputFormat;

public class BenchmarkList
extends AbstractResourceReader {
    public static final String BENCHMARK_LIST = "/META-INF/BenchmarkList";

    public static BenchmarkList defaultList() {
        return BenchmarkList.fromResource(BENCHMARK_LIST);
    }

    public static BenchmarkList fromFile(String file) {
        return new BenchmarkList(file, null, null);
    }

    public static BenchmarkList fromResource(String resource) {
        return new BenchmarkList(null, resource, null);
    }

    public static BenchmarkList fromString(String strings) {
        return new BenchmarkList(null, null, strings);
    }

    private BenchmarkList(String file, String resource, String strings) {
        super(file, resource, strings);
    }

    public Set<BenchmarkListEntry> getAll(OutputFormat out, List<String> excludes) {
        return this.find(out, Collections.singletonList(".*"), excludes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<BenchmarkListEntry> find(OutputFormat out, List<String> includes, List<String> excludes) {
        ArrayList<String> regexps = new ArrayList<String>(includes);
        if (regexps.isEmpty()) {
            regexps.add(".*");
        }
        ArrayList<Pattern> includePatterns = new ArrayList<Pattern>(regexps.size());
        for (String string : regexps) {
            includePatterns.add(Pattern.compile(string));
        }
        ArrayList<Pattern> excludePatterns = new ArrayList<Pattern>(excludes.size());
        for (String string : excludes) {
            excludePatterns.add(Pattern.compile(string));
        }
        TreeSet<BenchmarkListEntry> treeSet = new TreeSet<BenchmarkListEntry>();
        try {
            for (Reader r : this.getReaders()) {
                BufferedReader reader = null;
                try {
                    reader = new BufferedReader(r);
                    String line = reader.readLine();
                    while (line != null) {
                        if (!line.startsWith("#") && !line.trim().isEmpty()) {
                            BenchmarkListEntry br = new BenchmarkListEntry(line);
                            for (Pattern pattern : includePatterns) {
                                if (pattern.matcher(br.getUsername()).find()) {
                                    boolean exclude = false;
                                    for (Pattern excludePattern : excludePatterns) {
                                        if (!excludePattern.matcher(br.getUsername()).find()) continue;
                                        out.verbosePrintln("Excluding " + br.getUsername() + ", matches " + excludePattern);
                                        exclude = true;
                                        break;
                                    }
                                    if (exclude) break;
                                    treeSet.add(br);
                                    break;
                                }
                                out.verbosePrintln("Excluding: " + br.getUsername() + ", does not match " + pattern);
                            }
                        }
                        line = reader.readLine();
                    }
                }
                finally {
                    if (reader == null) continue;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("Error reading benchmark list", iOException);
        }
        return treeSet;
    }
}

