/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jol.info;

import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.openjdk.jol.info.FieldData;
import org.openjdk.jol.util.ClassUtils;
import org.openjdk.jol.vm.ContendedSupport;

public class ClassData {
    private final WeakReference<Object> instance;
    private final String name;
    private final List<FieldData> fields;
    private final List<String> classNames;
    private final String arrayKlass;
    private final String arrayComponentKlass;
    private final long length;
    private final boolean isArray;
    private boolean isContended;
    private ClassData superClass;

    public static ClassData parseInstance(Object o) {
        return ClassData.parse(o, o.getClass());
    }

    public static ClassData parseClass(Class klass) {
        return ClassData.parse(null, klass);
    }

    private static int arrayLength(Object o) {
        if (o == null) {
            return 0;
        }
        Class<?> k = o.getClass();
        if (!k.isArray()) {
            throw new IllegalArgumentException(k.getName() + " is not an array class");
        }
        if (k == byte[].class) {
            return ((byte[])o).length;
        }
        if (k == boolean[].class) {
            return ((boolean[])o).length;
        }
        if (k == short[].class) {
            return ((short[])o).length;
        }
        if (k == char[].class) {
            return ((char[])o).length;
        }
        if (k == int[].class) {
            return ((int[])o).length;
        }
        if (k == float[].class) {
            return ((float[])o).length;
        }
        if (k == double[].class) {
            return ((double[])o).length;
        }
        if (k == long[].class) {
            return ((long[])o).length;
        }
        return ((Object[])o).length;
    }

    private static ClassData parse(Object o, Class klass) {
        if (klass.isArray()) {
            return new ClassData(o, klass.getName(), klass.getComponentType().getName(), ClassData.arrayLength(o));
        }
        ClassData cd = new ClassData(o, klass.getName());
        Class superKlass = klass.getSuperclass();
        cd.isContended = ContendedSupport.isContended(klass);
        if (superKlass != null) {
            cd.addSuperClassData(klass.getSuperclass());
        }
        do {
            for (Field f : klass.getDeclaredFields()) {
                if (Modifier.isStatic(f.getModifiers())) continue;
                cd.addField(FieldData.parse(f));
            }
            cd.addSuperClass(ClassUtils.getSafeName(klass));
        } while ((klass = klass.getSuperclass()) != null);
        return cd;
    }

    public ClassData(String name) {
        this(null, name);
    }

    private ClassData(Object instance, String name) {
        this.instance = this.wrapInstance(instance);
        this.name = name;
        this.fields = new ArrayList<FieldData>();
        this.classNames = new ArrayList<String>();
        this.length = -1L;
        this.arrayKlass = null;
        this.arrayComponentKlass = null;
        this.isArray = false;
        this.superClass = null;
        this.isContended = false;
    }

    public ClassData(String arrayKlass, String componentKlass, int length) {
        this(null, arrayKlass, componentKlass, length);
    }

    private ClassData(Object instance, String arrayKlass, String componentKlass, int length) {
        this.instance = this.wrapInstance(instance);
        this.name = arrayKlass;
        this.arrayKlass = arrayKlass;
        this.arrayComponentKlass = componentKlass;
        this.fields = null;
        this.classNames = null;
        this.length = length;
        this.isArray = true;
        this.superClass = null;
        this.isContended = false;
    }

    private WeakReference<Object> wrapInstance(Object instance) {
        if (instance != null) {
            try {
                return new WeakReference<Object>(instance);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return null;
    }

    public void addSuperClass(String superClass) {
        this.classNames.add(0, superClass);
    }

    public void addSuperClassData(Class superClass) {
        this.superClass = ClassData.parseClass(superClass);
    }

    public void addSuperClassData(ClassData superClassData) {
        this.superClass = superClassData;
    }

    public void addField(FieldData fieldData) {
        this.fields.add(fieldData);
    }

    public List<FieldData> fields() {
        if (this.isArray) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.fields);
    }

    public List<FieldData> ownFields() {
        return this.fieldsFor(this.classNames.get(this.classNames.size() - 1));
    }

    public int oopsCount() {
        int count = 0;
        for (FieldData f : this.fields) {
            if (f.isPrimitive()) continue;
            ++count;
        }
        return count;
    }

    public List<FieldData> fieldsFor(String klass) {
        ArrayList<FieldData> r = new ArrayList<FieldData>();
        for (FieldData f : this.fields) {
            if (!f.hostClass().equals(klass)) continue;
            r.add(f);
        }
        return r;
    }

    public List<String> classHierarchy() {
        if (this.isArray) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.classNames);
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public ClassData superClass() {
        return this.superClass;
    }

    public boolean isContended() {
        return this.isContended;
    }

    public String arrayClass() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array class for non-array ClassData");
        }
        return this.arrayKlass;
    }

    public String arrayComponentType() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array component type for non-array ClassData");
        }
        return this.arrayComponentKlass;
    }

    public long arrayLength() {
        if (!this.isArray) {
            throw new IllegalStateException("Asking array length for non-array ClassData");
        }
        return this.length;
    }

    public void merge(ClassData superClassData) {
        this.fields.addAll(superClassData.fields);
        this.classNames.addAll(0, superClassData.classNames);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassData classData = (ClassData)o;
        if (this.isArray != classData.isArray) {
            return false;
        }
        if (this.length != classData.length) {
            return false;
        }
        if (!Objects.equals(this.arrayComponentKlass, classData.arrayComponentKlass)) {
            return false;
        }
        if (!Objects.equals(this.arrayKlass, classData.arrayKlass)) {
            return false;
        }
        if (!Objects.equals(this.classNames, classData.classNames)) {
            return false;
        }
        return Objects.equals(this.fields, classData.fields);
    }

    public int hashCode() {
        int result = this.fields != null ? this.fields.hashCode() : 0;
        result = 31 * result + (this.classNames != null ? this.classNames.hashCode() : 0);
        result = 31 * result + (this.arrayKlass != null ? this.arrayKlass.hashCode() : 0);
        result = 31 * result + (this.arrayComponentKlass != null ? this.arrayComponentKlass.hashCode() : 0);
        result = 31 * result + (int)(this.length ^ this.length >>> 32);
        result = 31 * result + (this.isArray ? 1 : 0);
        return result;
    }

    public Object instance() {
        return this.instance != null ? this.instance.get() : null;
    }
}

