/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import com.sun.javafx.binding.Subscription;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;

abstract class LazyObjectBinding<T>
extends ObjectBinding<T> {
    private Subscription subscription;
    private boolean wasObserved;

    LazyObjectBinding() {
    }

    @Override
    public void addListener(ChangeListener<? super T> changeListener) {
        super.addListener(changeListener);
        this.updateSubscriptionAfterAdd();
    }

    @Override
    public void removeListener(ChangeListener<? super T> changeListener) {
        super.removeListener(changeListener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        super.addListener(invalidationListener);
        this.updateSubscriptionAfterAdd();
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        super.removeListener(invalidationListener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    protected boolean allowValidation() {
        return this.isObserved();
    }

    private void updateSubscriptionAfterAdd() {
        if (!this.wasObserved) {
            this.subscription = this.observeSources();
            this.wasObserved = true;
        }
    }

    private void updateSubscriptionAfterRemove() {
        if (this.wasObserved && !this.isObserved()) {
            this.subscription.unsubscribe();
            this.subscription = null;
            this.invalidate();
            this.wasObserved = false;
        }
    }

    protected abstract Subscription observeSources();
}

