/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.binding;

import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ChangeListener;
import javafx.util.Subscription;

abstract class LazyObjectBinding<T>
extends ObjectBinding<T> {
    private Subscription subscription;
    private boolean wasObserved;

    LazyObjectBinding() {
    }

    @Override
    public void addListener(ChangeListener<? super T> changeListener) {
        this.updateSubscriptionBeforeAdd();
        super.addListener(changeListener);
    }

    @Override
    public void removeListener(ChangeListener<? super T> changeListener) {
        super.removeListener(changeListener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    public void addListener(InvalidationListener invalidationListener) {
        this.updateSubscriptionBeforeAdd();
        super.addListener(invalidationListener);
    }

    @Override
    public void removeListener(InvalidationListener invalidationListener) {
        super.removeListener(invalidationListener);
        this.updateSubscriptionAfterRemove();
    }

    @Override
    protected boolean allowValidation() {
        return this.isObserved();
    }

    private void updateSubscriptionBeforeAdd() {
        if (!this.wasObserved) {
            this.subscription = this.observeSources();
            this.wasObserved = true;
        }
    }

    private void updateSubscriptionAfterRemove() {
        if (this.wasObserved && !this.isObserved()) {
            this.subscription.unsubscribe();
            this.subscription = null;
            this.invalidate();
            this.wasObserved = false;
        }
    }

    protected abstract Subscription observeSources();
}

