/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.gtk.screencast;

import com.sun.glass.ui.gtk.screencast.ScreencastHelper;
import com.sun.glass.ui.gtk.screencast.TokenItem;
import com.sun.glass.ui.gtk.screencast.XdgDesktopPortal;
import com.sun.javafx.geom.Dimension;
import com.sun.javafx.geom.Rectangle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;

final class TokenStorage {
    private static final String REL_NAME = ".java/robot/screencast-tokens.properties";
    private static final String REL_NAME_SECONDARY = ".awt/robot/screencast-tokens.properties";
    private static final String REL_RD_NAME = ".java/robot/remote-desktop-tokens.properties";
    private static final Properties PROPS = new Properties();
    private static final Path PROPS_PATH = TokenStorage.setupPath();
    private static final Path PROP_FILENAME;
    private static WatchService watchService;

    private TokenStorage() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Path setupPath() {
        boolean bl;
        Path path;
        Path path2;
        block21: {
            String string = System.getProperty("user.home", null);
            if (string == null) {
                return null;
            }
            path2 = null;
            if (XdgDesktopPortal.isRemoteDesktop()) {
                path = Path.of(string, REL_RD_NAME);
            } else {
                path = Path.of(string, REL_NAME);
                path2 = Path.of(string, REL_NAME_SECONDARY);
            }
            bl = !Files.isWritable(path) && path2 != null && Files.isWritable(path2);
            Path path3 = path.getParent();
            if (!Files.isWritable(path)) {
                if (!Files.exists(path3, new LinkOption[0])) {
                    try {
                        Files.createDirectories(path3, new FileAttribute[0]);
                    }
                    catch (Exception exception) {
                        if (ScreencastHelper.SCREENCAST_DEBUG) {
                            System.err.printf("Token storage: cannot create directory %s %s\n", path3, exception);
                        }
                        return null;
                    }
                }
                if (!Files.isWritable(path3)) {
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.err.printf("Token storage: %s is not writable\n", path3);
                    }
                    return null;
                }
            }
            try {
                Files.setPosixFilePermissions(path3, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE));
            }
            catch (IOException iOException) {
                if (!ScreencastHelper.SCREENCAST_DEBUG) break block21;
                System.err.printf("Token storage: cannot set permissions for directory %s %s\n", path3, iOException);
            }
        }
        if (bl) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("Token storage: copying from the secondary location " + String.valueOf(path2));
            }
            Properties properties = PROPS;
            synchronized (properties) {
                if (TokenStorage.readTokens(path2)) {
                    TokenStorage.store(path, "copy from the secondary location");
                }
            }
        } else if (Files.exists(path, new LinkOption[0])) {
            if (!TokenStorage.setFilePermission(path)) {
                return null;
            }
            TokenStorage.readTokens(path);
        }
        return path;
    }

    private static boolean setFilePermission(Path path) {
        try {
            Files.setPosixFilePermissions(path, Set.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE));
            return true;
        }
        catch (IOException iOException) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: failed to set property file permission %s %s\n", path, iOException);
            }
            return false;
        }
    }

    private static void setupWatch() {
        block3: {
            try {
                watchService = FileSystems.getDefault().newWatchService();
                PROPS_PATH.getParent().register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
            }
            catch (Exception exception) {
                if (!ScreencastHelper.SCREENCAST_DEBUG) break block3;
                System.err.printf("Token storage: failed to setup file watch %s\n", exception);
            }
        }
        if (watchService != null) {
            new WatcherThread(watchService).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeTokenFromNative(String string, String string2, int[] nArray) {
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.printf("// storeToken old: |%s| new |%s| allowed bounds %s\n", string, string2, Arrays.toString(nArray));
        }
        if (nArray == null) {
            return;
        }
        TokenItem tokenItem = new TokenItem(string2, nArray);
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.printf("// Storing TokenItem:\n%s\n", tokenItem);
        }
        Properties properties = PROPS;
        synchronized (properties) {
            String string3 = PROPS.getProperty(tokenItem.token, null);
            String string4 = tokenItem.dump();
            boolean bl = false;
            if (string3 == null || !string3.equals(string4)) {
                PROPS.setProperty(tokenItem.token, string4);
                if (ScreencastHelper.SCREENCAST_DEBUG) {
                    System.out.printf("// Writing new TokenItem:\n%s\n", tokenItem);
                }
                bl = true;
            }
            if (string != null && !string.equals(string2)) {
                if (ScreencastHelper.SCREENCAST_DEBUG) {
                    System.out.printf("// storeTokenFromNative old token |%s| is no longer valid, removing\n", string);
                }
                PROPS.remove(string);
                bl = true;
            }
            if (bl) {
                TokenStorage.store(PROPS_PATH, "save tokens");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean readTokens(Path path) {
        if (path == null) {
            return false;
        }
        try (BufferedReader bufferedReader = Files.newBufferedReader(path);){
            Properties properties = PROPS;
            synchronized (properties) {
                PROPS.clear();
                PROPS.load(bufferedReader);
            }
        }
        catch (IOException | IllegalArgumentException exception) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: failed to load property file %s\n%s\n", path, exception);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<TokenItem> getTokens(List<Rectangle> list) {
        List<TokenItem> list2;
        LinkedHashSet<TokenItem> linkedHashSet = new LinkedHashSet<TokenItem>();
        HashSet<String> hashSet = new HashSet<String>();
        List<Dimension> list3 = PROPS;
        synchronized (list3) {
            list2 = PROPS.entrySet().stream().map(entry -> {
                String string = String.valueOf(entry.getKey());
                TokenItem tokenItem = TokenItem.parse(string, entry.getValue());
                if (tokenItem == null) {
                    hashSet.add(string);
                }
                return tokenItem;
            }).filter(Objects::nonNull).sorted((tokenItem, tokenItem2) -> tokenItem2.allowedScreensBounds.size() - tokenItem.allowedScreensBounds.size()).toList();
        }
        TokenStorage.removeMalformedRecords(hashSet);
        for (TokenItem object : list2) {
            if (object == null || !object.hasAllScreensWithExactMatch(list)) continue;
            linkedHashSet.add(object);
        }
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.println("// getTokens exact matches 1. " + String.valueOf(linkedHashSet));
        }
        list3 = list.stream().map(rectangle -> new Dimension(rectangle.width, rectangle.height)).toList();
        for (TokenItem tokenItem3 : list2) {
            if (tokenItem3 == null || !tokenItem3.hasAllScreensOfSameSize(list3)) continue;
            linkedHashSet.add(tokenItem3);
        }
        if (ScreencastHelper.SCREENCAST_DEBUG) {
            System.out.println("// getTokens same sizes 2. " + String.valueOf(linkedHashSet));
        }
        list2.stream().filter(tokenItem -> tokenItem.allowedScreensBounds.size() >= list.size()).forEach(linkedHashSet::add);
        return linkedHashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeMalformedRecords(Set<String> set) {
        if (!TokenStorage.isWritable(PROPS_PATH) || set == null || set.isEmpty()) {
            return;
        }
        Properties properties = PROPS;
        synchronized (properties) {
            for (String string : set) {
                Object object = PROPS.remove(string);
                if (!ScreencastHelper.SCREENCAST_DEBUG) continue;
                System.err.println("removing malformed record\n" + String.valueOf(object));
            }
            TokenStorage.store(PROPS_PATH, "remove malformed records");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void store(Path path, String string) {
        if (!TokenStorage.isWritable(path)) {
            return;
        }
        Properties properties = PROPS;
        synchronized (properties) {
            block12: {
                try (BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);){
                    PROPS.store(bufferedWriter, null);
                }
                catch (IOException iOException) {
                    if (!ScreencastHelper.SCREENCAST_DEBUG) break block12;
                    System.err.printf("Token storage: unable to %s\n%s\n", string, iOException);
                }
            }
        }
    }

    private static boolean isWritable(Path path) {
        if (path == null || Files.exists(path, new LinkOption[0]) && !Files.isWritable(path)) {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.err.printf("Token storage: %s is not writable\n", path);
            }
            return false;
        }
        return true;
    }

    static {
        if (PROPS_PATH != null) {
            PROP_FILENAME = PROPS_PATH.getFileName();
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("Token storage: using " + String.valueOf(PROPS_PATH));
            }
            TokenStorage.setupWatch();
        } else {
            PROP_FILENAME = null;
        }
    }

    private static final class WatcherThread
    extends Thread {
        private final WatchService watcher;

        public WatcherThread(WatchService watchService) {
            this.watcher = watchService;
            this.setName("ScreencastWatcher");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ScreencastHelper.SCREENCAST_DEBUG) {
                System.out.println("ScreencastWatcher: started");
            }
            while (true) {
                WatchKey watchKey;
                try {
                    watchKey = this.watcher.take();
                }
                catch (InterruptedException interruptedException) {
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.err.println("ScreencastWatcher: interrupted");
                    }
                    return;
                }
                for (WatchEvent<?> watchEvent : watchKey.pollEvents()) {
                    WatchEvent.Kind<?> kind = watchEvent.kind();
                    if (kind == StandardWatchEventKinds.OVERFLOW || !watchEvent.context().equals(PROP_FILENAME)) continue;
                    if (ScreencastHelper.SCREENCAST_DEBUG) {
                        System.out.printf("ScreencastWatcher: %s %s\n", kind, watchEvent.context());
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_CREATE) {
                        TokenStorage.setFilePermission(PROPS_PATH);
                        continue;
                    }
                    if (kind == StandardWatchEventKinds.ENTRY_MODIFY) {
                        TokenStorage.readTokens(PROPS_PATH);
                        continue;
                    }
                    if (kind != StandardWatchEventKinds.ENTRY_DELETE) continue;
                    Properties properties = PROPS;
                    synchronized (properties) {
                        PROPS.clear();
                    }
                }
                watchKey.reset();
            }
        }
    }
}

