/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.headless;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.GlassRobot;
import com.sun.glass.ui.Window;
import com.sun.glass.ui.headless.HeadlessApplication;
import com.sun.glass.ui.headless.HeadlessView;
import com.sun.glass.ui.headless.HeadlessWindow;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javafx.scene.image.WritableImage;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.paint.Color;

public class HeadlessRobot
extends GlassRobot {
    final int multiplierX = 40;
    final int multiplierY = 40;
    private final HeadlessApplication application;
    private HeadlessWindow activeWindow = null;
    private double mouseX;
    private double mouseY;
    private final SpecialKeys specialKeys = new SpecialKeys(this);
    private final MouseState mouseState = new MouseState(this);
    private final char[] NO_CHAR = new char[0];

    public HeadlessRobot(HeadlessApplication headlessApplication) {
        this.application = headlessApplication;
    }

    void windowAdded(HeadlessWindow headlessWindow) {
        if (this.activeWindow == null) {
            this.activeWindow = headlessWindow;
        }
    }

    void windowRemoved(HeadlessWindow headlessWindow) {
        if (this.activeWindow == headlessWindow) {
            this.activeWindow = null;
        }
    }

    @Override
    public void create() {
    }

    @Override
    public void destroy() {
    }

    @Override
    public void keyPress(KeyCode keyCode) {
        this.checkWindowFocused();
        if (this.activeWindow == null) {
            return;
        }
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        int n = keyCode.getCode();
        this.processSpecialKeys(n, true);
        char[] cArray = this.getKeyChars(n);
        int n2 = this.getKeyModifiers();
        if (headlessView != null) {
            headlessView.notifyKey(111, n, cArray, n2);
            if (cArray.length > 0) {
                headlessView.notifyKey(113, 0, cArray, n2);
            }
        }
    }

    @Override
    public void keyRelease(KeyCode keyCode) {
        this.checkWindowFocused();
        if (this.activeWindow == null) {
            return;
        }
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        int n = keyCode.getCode();
        this.processSpecialKeys(n, false);
        int n2 = this.getKeyModifiers();
        char[] cArray = new char[]{(char)n};
        if (headlessView != null) {
            headlessView.notifyKey(112, n, cArray, n2);
        }
    }

    @Override
    public double getMouseX() {
        return this.mouseX;
    }

    @Override
    public double getMouseY() {
        return this.mouseY;
    }

    @Override
    public void mouseMove(double d, double d2) {
        this.mouseX = d;
        this.mouseY = d2;
        this.checkWindowEnterExit();
        if (this.activeWindow == null) {
            return;
        }
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        if (headlessView == null) {
            return;
        }
        int n = this.activeWindow.getX();
        int n2 = this.activeWindow.getY();
        int n3 = 211;
        int n4 = 224;
        if (this.mouseState.pressedButtons.size() > 0) {
            MouseButton mouseButton = (MouseButton)((Object)this.mouseState.pressedButtons.stream().findFirst().get());
            n3 = this.getGlassEventButton(mouseButton);
            n4 = 223;
        }
        int n5 = 0;
        headlessView.notifyMouse(n4, n3, (int)this.mouseX - n, (int)this.mouseY - n2, (int)this.mouseX, (int)this.mouseY, n5, false, false);
    }

    @Override
    public void mousePress(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        this.mouseState.pressedButtons.addAll(Arrays.asList(mouseButtonArray));
        this.checkWindowEnterExit();
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        if (headlessView == null && (headlessView = (HeadlessView)this.activeWindow.getView()) == null) {
            return;
        }
        int n = this.activeWindow.getX();
        int n2 = this.activeWindow.getY();
        int n3 = this.getModifiers(mouseButtonArray);
        int n4 = this.getGlassEventButton(mouseButtonArray);
        headlessView.notifyMouse(221, n4, (int)this.mouseX - n, (int)this.mouseY - n2, (int)this.mouseX, (int)this.mouseY, n3, true, true);
        if (n4 == 213) {
            headlessView.notifyMenu((int)this.mouseX - n, (int)this.mouseY - n2, (int)this.mouseX, (int)this.mouseY, false);
        }
    }

    @Override
    public void mouseRelease(MouseButton ... mouseButtonArray) {
        Application.checkEventThread();
        this.mouseState.pressedButtons.removeAll(Arrays.asList(mouseButtonArray));
        this.checkWindowEnterExit();
        if (this.activeWindow == null) {
            return;
        }
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        int n = this.activeWindow.getX();
        int n2 = this.activeWindow.getY();
        int n3 = this.getModifiers(mouseButtonArray);
        headlessView.notifyMouse(222, this.getGlassEventButton(mouseButtonArray), (int)this.mouseX - n, (int)this.mouseY - n2, (int)this.mouseX, (int)this.mouseY, n3, true, true);
    }

    @Override
    public void mouseWheel(int n) {
        this.checkWindowFocused();
        int n2 = n > 0 ? -1 : 1;
        HeadlessView headlessView = (HeadlessView)this.activeWindow.getView();
        int n3 = this.activeWindow.getX();
        int n4 = this.activeWindow.getY();
        int n5 = Math.abs(n);
        for (int i = 0; i < n5; ++i) {
            headlessView.notifyScroll((int)this.mouseX, (int)this.mouseY, n3, n4, 0.0, n2, 0, 0, 0, 0, 0, 40.0, 40.0);
        }
    }

    @Override
    public Color getPixelColor(double d, double d2) {
        HeadlessWindow headlessWindow = this.getTopWindow();
        return headlessWindow.getColor((int)d, (int)d2);
    }

    @Override
    public WritableImage getScreenCapture(WritableImage writableImage, double d, double d2, double d3, double d4, boolean bl) {
        return super.getScreenCapture(writableImage, d, d2, d3, d4, bl);
    }

    @Override
    public void getScreenCapture(int n, int n2, int n3, int n4, int[] nArray, boolean bl) {
        this.checkWindowFocused();
        this.activeWindow.getScreenCapture(n, n2, n3, n4, nArray, bl);
    }

    private void checkActiveWindowExists() {
        if (this.activeWindow != null && !this.activeWindow.isVisible()) {
            this.activeWindow = null;
        }
    }

    private void checkWindowFocused() {
        this.checkActiveWindowExists();
        this.activeWindow = this.getFocusedWindow();
    }

    private void checkWindowEnterExit() {
        this.checkActiveWindowExists();
        HeadlessWindow headlessWindow = this.activeWindow;
        this.activeWindow = this.getTargetWindow(this.mouseX, this.mouseY);
        if (this.activeWindow == null) {
            HeadlessView headlessView;
            if (headlessWindow != null && (headlessView = (HeadlessView)headlessWindow.getView()) != null) {
                headlessView.notifyMouse(226, 211, 0, 0, 0, 0, 0, true, true);
            }
            return;
        }
        int n = this.activeWindow.getX();
        int n2 = this.activeWindow.getY();
        if (this.activeWindow != headlessWindow) {
            HeadlessView headlessView;
            HeadlessView headlessView2 = (HeadlessView)this.activeWindow.getView();
            int n3 = 0;
            headlessView2.notifyMouse(225, 211, (int)this.mouseX - n, (int)this.mouseY - n2, (int)this.mouseX, (int)this.mouseY, n3, true, true);
            if (headlessWindow != null && (headlessView = (HeadlessView)headlessWindow.getView()) != null) {
                int n4 = headlessWindow.getX();
                int n5 = headlessWindow.getY();
                headlessView.notifyMouse(226, 211, (int)this.mouseX - n4, (int)this.mouseY - n5, (int)this.mouseX, (int)this.mouseY, n3, true, true);
            }
        }
    }

    private HeadlessWindow getTopWindow() {
        List<Window> list = Window.getWindows().stream().filter(window -> window.getView() != null).filter(window -> !window.isClosed()).filter(window -> !window.isMinimized()).toList();
        if (list.isEmpty()) {
            return null;
        }
        return (HeadlessWindow)list.get(list.size() - 1);
    }

    private HeadlessWindow getFocusedWindow() {
        List<Window> list = Window.getWindows().stream().filter(window -> window.getView() != null).filter(window -> !window.isClosed()).filter(window -> window.isFocused()).toList();
        if (list.isEmpty()) {
            return null;
        }
        return (HeadlessWindow)list.get(list.size() - 1);
    }

    private HeadlessWindow getTargetWindow(double d, double d2) {
        List<Window> list = Window.getWindows().stream().filter(window -> window.getView() != null).filter(window -> !window.isClosed()).filter(window -> d >= (double)window.getX() && d <= (double)(window.getX() + window.getWidth()) && d2 >= (double)window.getY() && d2 <= (double)(window.getY() + window.getHeight())).toList();
        if (list.isEmpty()) {
            return null;
        }
        if (list.size() == 1) {
            return (HeadlessWindow)list.get(0);
        }
        return (HeadlessWindow)list.get(list.size() - 1);
    }

    int getModifiers(MouseButton ... mouseButtonArray) {
        int n = 0;
        for (int i = 0; i < mouseButtonArray.length; ++i) {
            n |= (switch (mouseButtonArray[i]) {
                default -> throw new MatchException(null, null);
                case MouseButton.NONE -> 0;
                case MouseButton.PRIMARY -> 32;
                case MouseButton.MIDDLE -> 128;
                case MouseButton.SECONDARY -> 64;
                case MouseButton.BACK -> 256;
                case MouseButton.FORWARD -> 512;
            });
        }
        return n;
    }

    int getGlassEventButton(MouseButton[] mouseButtonArray) {
        if (mouseButtonArray == null || mouseButtonArray.length == 0) {
            return 0;
        }
        return this.getGlassEventButton(mouseButtonArray[0]);
    }

    int getGlassEventButton(MouseButton mouseButton) {
        return switch (mouseButton) {
            default -> throw new MatchException(null, null);
            case MouseButton.NONE -> 211;
            case MouseButton.PRIMARY -> 212;
            case MouseButton.MIDDLE -> 214;
            case MouseButton.SECONDARY -> 213;
            case MouseButton.BACK -> 215;
            case MouseButton.FORWARD -> 216;
        };
    }

    private void processSpecialKeys(int n, boolean bl) {
        if (n == 17) {
            this.specialKeys.keyControl = bl;
        }
        if (n == 16) {
            this.specialKeys.keyShift = bl;
        }
        if (n == 768) {
            this.specialKeys.keyCommand = bl;
        }
        if (n == 18) {
            this.specialKeys.keyAlt = bl;
        }
    }

    private char[] getKeyChars(int n) {
        char[] cArray;
        int n2 = 0;
        boolean bl = this.specialKeys.keyShift;
        if (n >= 65 && n <= 90) {
            n2 = (bl ^= this.specialKeys.capsLock) ? (int)((char)(n - 65 + 65)) : (int)((char)(n - 65 + 97));
        } else if (n >= 96 && n <= 105) {
            if (this.specialKeys.numLock) {
                n2 = (char)(n - 96 + 48);
            }
        } else if (n >= 48 && n <= 57) {
            if (bl) {
                switch (n) {
                    case 48: {
                        n2 = 41;
                        break;
                    }
                    case 49: {
                        n2 = 33;
                        break;
                    }
                    case 50: {
                        n2 = 64;
                        break;
                    }
                    case 51: {
                        n2 = 35;
                        break;
                    }
                    case 52: {
                        n2 = 36;
                        break;
                    }
                    case 53: {
                        n2 = 37;
                        break;
                    }
                    case 54: {
                        n2 = 94;
                        break;
                    }
                    case 55: {
                        n2 = 38;
                        break;
                    }
                    case 56: {
                        n2 = 42;
                        break;
                    }
                    case 57: {
                        n2 = 40;
                    }
                }
            } else {
                n2 = (char)(n - 48 + 48);
            }
        } else if (n == 32) {
            n2 = 32;
        } else if (n == 9) {
            n2 = 9;
        } else if (n == 10) {
            n2 = 13;
        } else if (n == 106) {
            n2 = 42;
        } else if (n == 111) {
            n2 = 47;
        } else if (bl) {
            switch (n) {
                case 192: {
                    n2 = 126;
                    break;
                }
                case 44: {
                    n2 = 60;
                    break;
                }
                case 46: {
                    n2 = 62;
                    break;
                }
                case 47: {
                    n2 = 63;
                    break;
                }
                case 59: {
                    n2 = 58;
                    break;
                }
                case 222: {
                    n2 = 34;
                    break;
                }
                case 161: {
                    n2 = 123;
                    break;
                }
                case 162: {
                    n2 = 125;
                    break;
                }
                case 92: {
                    n2 = 124;
                    break;
                }
                case 45: {
                    n2 = 95;
                    break;
                }
                case 61: {
                    n2 = 43;
                }
            }
        } else {
            switch (n) {
                case 192: {
                    n2 = 96;
                    break;
                }
                case 44: {
                    n2 = 44;
                    break;
                }
                case 46: {
                    n2 = 46;
                    break;
                }
                case 47: {
                    n2 = 47;
                    break;
                }
                case 59: {
                    n2 = 59;
                    break;
                }
                case 222: {
                    n2 = 39;
                    break;
                }
                case 161: {
                    n2 = 91;
                    break;
                }
                case 162: {
                    n2 = 93;
                    break;
                }
                case 92: {
                    n2 = 92;
                    break;
                }
                case 45: {
                    n2 = 45;
                    break;
                }
                case 61: {
                    n2 = 61;
                }
            }
        }
        if (n2 == 0) {
            cArray = this.NO_CHAR;
        } else {
            char[] cArray2 = new char[1];
            cArray = cArray2;
            cArray2[0] = n2;
        }
        return cArray;
    }

    private int getKeyModifiers() {
        int n = 0;
        if (this.specialKeys.keyControl) {
            n |= 4;
        }
        if (this.specialKeys.keyShift) {
            n |= 1;
        }
        if (this.specialKeys.keyCommand) {
            n |= 0x10;
        }
        if (this.specialKeys.keyAlt) {
            n |= 8;
        }
        return n;
    }

    class SpecialKeys {
        boolean keyControl;
        boolean keyShift;
        boolean keyCommand;
        boolean keyAlt;
        boolean capsLock;
        boolean numLock;

        SpecialKeys(HeadlessRobot headlessRobot) {
        }
    }

    class MouseState {
        final HashSet<MouseButton> pressedButtons = new HashSet();

        MouseState(HeadlessRobot headlessRobot) {
        }
    }
}

