/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.glass.ui.Screen;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec3d;
import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.javafx.geom.transform.GeneralTransform3D;
import com.sun.javafx.sg.prism.NGCamera;
import com.sun.javafx.sg.prism.NGDefaultCamera;
import com.sun.prism.CompositeMode;
import com.sun.prism.Graphics;
import com.sun.prism.MeshView;
import com.sun.prism.RTTexture;
import com.sun.prism.RenderTarget;
import com.sun.prism.Texture;
import com.sun.prism.impl.PrismSettings;
import com.sun.prism.impl.ps.BaseShaderContext;
import com.sun.prism.mtl.MTLPipeline;
import com.sun.prism.mtl.MTLRTTexture;
import com.sun.prism.mtl.MTLResourceFactory;
import com.sun.prism.mtl.MTLShader;
import com.sun.prism.mtl.MTLTexture;
import com.sun.prism.ps.Shader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

class MTLContext
extends BaseShaderContext {
    public static final int NUM_QUADS = PrismSettings.superShader ? 4096 : 256;
    private static final int MTL_COMPMODE_CLEAR = 0;
    private static final int MTL_COMPMODE_SRC = 1;
    private static final int MTL_COMPMODE_SRCOVER = 2;
    private static final int MTL_COMPMODE_DSTOUT = 3;
    private static final int MTL_COMPMODE_ADD = 4;
    private static final int MTL_SAMPLER_ADDR_MODE_NOP = -1;
    private static final int MTL_SAMPLER_ADDR_MODE_CLAMP_TO_EDGE = 0;
    private static final int MTL_SAMPLER_ADDR_MODE_MIRR_CLAMP_TO_EDGE = 1;
    private static final int MTL_SAMPLER_ADDR_MODE_REPEAT = 2;
    private static final int MTL_SAMPLER_ADDR_MODE_MIRR_REPEAT = 3;
    private static final int MTL_SAMPLER_ADDR_MODE_CLAMP_TO_ZERO = 4;
    private static final int MTL_SAMPLER_ADDR_MODE_CLAMP_TO_BORDER_COLOR = 5;
    private BaseShaderContext.State state;
    private final long pContext;
    private MTLRTTexture renderTarget;
    private MTLResourceFactory resourceFactory;
    private MTLPipeline pipeline;
    private int targetWidth;
    private int targetHeight;
    private Vec3d cameraPos = new Vec3d();
    private static float[] rawMatrix = new float[16];
    private GeneralTransform3D worldTx = new GeneralTransform3D();
    private static final Affine3D scratchAffine3DTx = new Affine3D();
    private GeneralTransform3D scratchTx = new GeneralTransform3D();
    private GeneralTransform3D projViewTx = new GeneralTransform3D();
    private static double[] tempAdjustClipSpaceMat = new double[16];
    private static final ByteBuffer shaderLibBuffer;
    public static final int CULL_BACK = 110;
    public static final int CULL_FRONT = 111;
    public static final int CULL_NONE = 112;

    public void setRenderTargetTexture(MTLRTTexture mTLRTTexture) {
        this.renderTarget = mTLRTTexture;
    }

    public MTLRTTexture getRenderTargetTexture() {
        return this.renderTarget;
    }

    MTLContext(Screen screen, MTLResourceFactory mTLResourceFactory) {
        super(screen, mTLResourceFactory, NUM_QUADS);
        this.resourceFactory = mTLResourceFactory;
        this.pContext = MTLContext.nInitialize(shaderLibBuffer);
    }

    @Override
    public MTLResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    protected void initState() {
        super.init();
        this.state = new BaseShaderContext.State();
        MTLContext.nSetCompositeMode(this.getContextHandle(), 2);
    }

    long getContextHandle() {
        return this.pContext;
    }

    private GeneralTransform3D adjustClipSpace(GeneralTransform3D generalTransform3D) {
        double[] dArray = generalTransform3D.get(tempAdjustClipSpaceMat);
        dArray[8] = (dArray[8] + dArray[12]) / 2.0;
        dArray[9] = (dArray[9] + dArray[13]) / 2.0;
        dArray[10] = (dArray[10] + dArray[14]) / 2.0;
        dArray[11] = (dArray[11] + dArray[15]) / 2.0;
        generalTransform3D.set(dArray);
        return generalTransform3D;
    }

    @Override
    protected BaseShaderContext.State updateRenderTarget(RenderTarget renderTarget, NGCamera nGCamera, boolean bl) {
        this.renderTarget = (MTLRTTexture)renderTarget;
        int n = MTLContext.nUpdateRenderTarget(this.pContext, this.renderTarget.getNativeHandle(), bl);
        if (n != -1) {
            this.resetLastClip(this.state);
        }
        this.targetWidth = renderTarget.getPhysicalWidth();
        this.targetHeight = renderTarget.getPhysicalHeight();
        if (nGCamera instanceof NGDefaultCamera) {
            NGDefaultCamera nGDefaultCamera = (NGDefaultCamera)nGCamera;
            nGDefaultCamera.validate(this.targetWidth, this.targetHeight);
            this.projViewTx = this.adjustClipSpace(nGCamera.getProjViewTx(this.projViewTx));
        } else {
            this.projViewTx = this.adjustClipSpace(nGCamera.getProjViewTx(this.projViewTx));
            double d = nGCamera.getViewWidth();
            double d2 = nGCamera.getViewHeight();
            if ((double)this.targetWidth != d || (double)this.targetHeight != d2) {
                this.projViewTx.scale(d / (double)this.targetWidth, d2 / (double)this.targetHeight, 1.0);
            }
        }
        MTLContext.nSetProjViewMatrix(this.pContext, bl, this.projViewTx.get(0), this.projViewTx.get(1), this.projViewTx.get(2), this.projViewTx.get(3), this.projViewTx.get(4), this.projViewTx.get(5), this.projViewTx.get(6), this.projViewTx.get(7), this.projViewTx.get(8), this.projViewTx.get(9), this.projViewTx.get(10), this.projViewTx.get(11), this.projViewTx.get(12), this.projViewTx.get(13), this.projViewTx.get(14), this.projViewTx.get(15));
        this.cameraPos = nGCamera.getPositionInWorld(this.cameraPos);
        return this.state;
    }

    @Override
    protected void setTexture(int n, Texture texture) {
        Texture[] textureArray;
        if (this.checkDisposed()) {
            return;
        }
        if (texture != null) {
            texture.assertLocked();
        }
        if (texture != (textureArray = this.state.getLastTextures())[n]) {
            this.flushVertexBuffer();
            textureArray[n] = texture;
        }
        this.updateTexture(n, texture);
    }

    @Override
    protected void updateTexture(int n, Texture texture) {
        if (texture != null) {
            boolean bl = texture.getLinearFiltering();
            int n2 = switch (texture.getWrapMode()) {
                default -> throw new MatchException(null, null);
                case Texture.WrapMode.CLAMP_NOT_NEEDED -> -1;
                case Texture.WrapMode.CLAMP_TO_EDGE, Texture.WrapMode.CLAMP_TO_EDGE_SIMULATED, Texture.WrapMode.CLAMP_TO_ZERO_SIMULATED -> 0;
                case Texture.WrapMode.CLAMP_TO_ZERO -> 4;
                case Texture.WrapMode.REPEAT, Texture.WrapMode.REPEAT_SIMULATED -> 2;
            };
            MTLShader.setTexture(n, texture, bl, n2);
        }
    }

    @Override
    protected void updateShaderTransform(Shader shader, BaseTransform baseTransform) {
        if (baseTransform == null) {
            baseTransform = BaseTransform.IDENTITY_TRANSFORM;
        }
        this.scratchTx.set(this.projViewTx);
        GeneralTransform3D generalTransform3D = this.getPerspectiveTransformNoClone();
        this.scratchTx = generalTransform3D.isIdentity() ? this.scratchTx.mul(baseTransform) : this.scratchTx.mul(baseTransform).mul(generalTransform3D);
        MTLContext.nSetTransform(this.pContext, this.scratchTx.get(0), this.scratchTx.get(1), this.scratchTx.get(2), this.scratchTx.get(3), this.scratchTx.get(4), this.scratchTx.get(5), this.scratchTx.get(6), this.scratchTx.get(7), this.scratchTx.get(8), this.scratchTx.get(9), this.scratchTx.get(10), this.scratchTx.get(11), this.scratchTx.get(12), this.scratchTx.get(13), this.scratchTx.get(14), this.scratchTx.get(15));
    }

    @Override
    protected void updateWorldTransform(BaseTransform baseTransform) {
        this.worldTx.setIdentity();
        if (baseTransform != null && !baseTransform.isIdentity()) {
            this.worldTx.mul(baseTransform);
        }
    }

    @Override
    protected void updateClipRect(Rectangle rectangle) {
        if (rectangle == null || rectangle.isEmpty()) {
            MTLContext.nResetClipRect(this.pContext);
        } else {
            int n = rectangle.x;
            int n2 = rectangle.y;
            int n3 = rectangle.width;
            int n4 = rectangle.height;
            MTLContext.nSetClipRect(this.pContext, n, n2, n3, n4);
        }
    }

    @Override
    protected void updateCompositeMode(CompositeMode compositeMode) {
        int n = switch (compositeMode) {
            default -> throw new MatchException(null, null);
            case CompositeMode.CLEAR -> 0;
            case CompositeMode.SRC -> 1;
            case CompositeMode.SRC_OVER -> 2;
            case CompositeMode.DST_OUT -> 3;
            case CompositeMode.ADD -> 4;
        };
        MTLContext.nSetCompositeMode(this.getContextHandle(), n);
    }

    @Override
    public void blit(RTTexture rTTexture, RTTexture rTTexture2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        long l;
        long l2;
        if (rTTexture2 instanceof MTLTexture) {
            MTLTexture mTLTexture = (MTLTexture)((Object)rTTexture2);
            v0 = mTLTexture.getNativeHandle();
        } else {
            v0 = l2 = 0L;
        }
        if (rTTexture instanceof MTLTexture) {
            MTLTexture mTLTexture = (MTLTexture)((Object)rTTexture);
            l = mTLTexture.getNativeHandle();
        } else {
            l = 0L;
        }
        long l3 = l;
        MTLContext.nBlit(this.pContext, l3, l2, n, n2, n3, n4, n5, n6, n7, n8);
    }

    @Override
    protected void renderQuads(float[] fArray, byte[] byArray, int n) {
        MTLContext.nDrawIndexedQuads(this.getContextHandle(), fArray, byArray, n);
    }

    public void commitCurrentCommandBuffer() {
        MTLContext.nCommitCurrentCommandBuffer(this.pContext);
    }

    public long getMetalCommandQueue() {
        return MTLContext.nGetCommandQueue(this.pContext);
    }

    @Override
    protected void setDeviceParametersFor2D() {
    }

    @Override
    protected void setDeviceParametersFor3D() {
    }

    long createMTLMesh() {
        if (this.checkDisposed()) {
            return 0L;
        }
        return MTLContext.nCreateMTLMesh(this.pContext);
    }

    void releaseMTLMesh(long l) {
        MTLContext.nReleaseMTLMesh(this.pContext, l);
    }

    boolean buildNativeGeometry(long l, float[] fArray, int n, short[] sArray, int n2) {
        return MTLContext.nBuildNativeGeometryShort(this.pContext, l, fArray, n, sArray, n2);
    }

    boolean buildNativeGeometry(long l, float[] fArray, int n, int[] nArray, int n2) {
        return MTLContext.nBuildNativeGeometryInt(this.pContext, l, fArray, n, nArray, n2);
    }

    long createMTLPhongMaterial() {
        return MTLContext.nCreateMTLPhongMaterial(this.pContext);
    }

    void releaseMTLPhongMaterial(long l) {
        MTLContext.nReleaseMTLPhongMaterial(this.pContext, l);
    }

    void setDiffuseColor(long l, float f, float f2, float f3, float f4) {
        MTLContext.nSetDiffuseColor(this.pContext, l, f, f2, f3, f4);
    }

    void setSpecularColor(long l, boolean bl, float f, float f2, float f3, float f4) {
        MTLContext.nSetSpecularColor(this.pContext, l, bl, f, f2, f3, f4);
    }

    void setMap(long l, int n, long l2) {
        MTLContext.nSetMap(this.pContext, l, n, l2);
    }

    long createMTLMeshView(long l) {
        return MTLContext.nCreateMTLMeshView(this.pContext, l);
    }

    void releaseMTLMeshView(long l) {
        MTLContext.nReleaseMTLMeshView(this.pContext, l);
    }

    void setCullingMode(long l, int n) {
        int n2;
        if (n == MeshView.CULL_NONE) {
            n2 = 112;
        } else if (n == MeshView.CULL_BACK) {
            n2 = 110;
        } else if (n == MeshView.CULL_FRONT) {
            n2 = 111;
        } else {
            throw new IllegalArgumentException("illegal value for CullMode: " + n);
        }
        MTLContext.nSetCullingMode(this.pContext, l, n2);
    }

    void setMaterial(long l, long l2) {
        MTLContext.nSetMaterial(this.pContext, l, l2);
    }

    void setWireframe(long l, boolean bl) {
        MTLContext.nSetWireframe(this.pContext, l, bl);
    }

    void setAmbientLight(long l, float f, float f2, float f3) {
        MTLContext.nSetAmbientLight(this.pContext, l, f, f2, f3);
    }

    void setLight(long l, int n, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18) {
        MTLContext.nSetLight(this.pContext, l, n, f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16, f17, f18);
    }

    void renderMeshView(long l, Graphics graphics) {
        float f = graphics.getPixelScaleFactorX();
        float f2 = graphics.getPixelScaleFactorY();
        if ((double)f != 1.0 || (double)f2 != 1.0) {
            this.scratchTx = this.scratchTx.set(this.projViewTx);
            this.scratchTx.scale(f, f2, 1.0);
            this.updateRawMatrix(this.scratchTx);
        } else {
            this.updateRawMatrix(this.projViewTx);
        }
        MTLContext.nSetProjViewMatrix(this.pContext, graphics.isDepthTest(), rawMatrix[0], rawMatrix[1], rawMatrix[2], rawMatrix[3], rawMatrix[4], rawMatrix[5], rawMatrix[6], rawMatrix[7], rawMatrix[8], rawMatrix[9], rawMatrix[10], rawMatrix[11], rawMatrix[12], rawMatrix[13], rawMatrix[14], rawMatrix[15]);
        MTLContext.nSetCameraPosition(this.pContext, this.cameraPos.x, this.cameraPos.y, this.cameraPos.z);
        BaseTransform baseTransform = graphics.getTransformNoClone();
        if ((double)f != 1.0 || (double)f2 != 1.0) {
            scratchAffine3DTx.setToIdentity();
            scratchAffine3DTx.scale(1.0 / (double)f, 1.0 / (double)f2);
            scratchAffine3DTx.concatenate(baseTransform);
            this.updateWorldTransform(scratchAffine3DTx);
        } else {
            this.updateWorldTransform(baseTransform);
        }
        this.updateRawMatrix(this.worldTx);
        MTLContext.nSetWorldTransform(this.pContext, rawMatrix[0], rawMatrix[1], rawMatrix[2], rawMatrix[3], rawMatrix[4], rawMatrix[5], rawMatrix[6], rawMatrix[7], rawMatrix[8], rawMatrix[9], rawMatrix[10], rawMatrix[11], rawMatrix[12], rawMatrix[13], rawMatrix[14], rawMatrix[15]);
        MTLContext.nRenderMeshView(this.pContext, l);
    }

    private void printRawMatrix(String string) {
        System.err.println(string + " = ");
        for (int i = 0; i < 4; ++i) {
            System.err.println(rawMatrix[i] + ", " + rawMatrix[i + 4] + ", " + rawMatrix[i + 8] + ", " + rawMatrix[i + 12]);
        }
    }

    private void updateRawMatrix(GeneralTransform3D generalTransform3D) {
        MTLContext.rawMatrix[0] = (float)generalTransform3D.get(0);
        MTLContext.rawMatrix[1] = (float)generalTransform3D.get(4);
        MTLContext.rawMatrix[2] = (float)generalTransform3D.get(8);
        MTLContext.rawMatrix[3] = (float)generalTransform3D.get(12);
        MTLContext.rawMatrix[4] = (float)generalTransform3D.get(1);
        MTLContext.rawMatrix[5] = (float)generalTransform3D.get(5);
        MTLContext.rawMatrix[6] = (float)generalTransform3D.get(9);
        MTLContext.rawMatrix[7] = (float)generalTransform3D.get(13);
        MTLContext.rawMatrix[8] = (float)generalTransform3D.get(2);
        MTLContext.rawMatrix[9] = (float)generalTransform3D.get(6);
        MTLContext.rawMatrix[10] = (float)generalTransform3D.get(10);
        MTLContext.rawMatrix[11] = (float)generalTransform3D.get(14);
        MTLContext.rawMatrix[12] = (float)generalTransform3D.get(3);
        MTLContext.rawMatrix[13] = (float)generalTransform3D.get(7);
        MTLContext.rawMatrix[14] = (float)generalTransform3D.get(11);
        MTLContext.rawMatrix[15] = (float)generalTransform3D.get(15);
    }

    public void disposeShader(long l) {
        MTLContext.nDisposeShader(l);
    }

    public boolean isCurrentRTT(long l) {
        return MTLContext.nIsCurrentRTT(this.pContext, l);
    }

    @Override
    public void dispose() {
        this.disposeLCDBuffer();
        MTLContext.nRelease(this.pContext);
        this.state = null;
        super.dispose();
    }

    private static native long nInitialize(ByteBuffer var0);

    private static native void nCommitCurrentCommandBuffer(long var0);

    private static native long nGetCommandQueue(long var0);

    private static native void nDrawIndexedQuads(long var0, float[] var2, byte[] var3, int var4);

    private static native int nUpdateRenderTarget(long var0, long var2, boolean var4);

    private static native void nSetProjViewMatrix(long var0, boolean var2, double var3, double var5, double var7, double var9, double var11, double var13, double var15, double var17, double var19, double var21, double var23, double var25, double var27, double var29, double var31, double var33);

    private static native void nSetTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native void nSetCompositeMode(long var0, int var2);

    private static native void nResetClipRect(long var0);

    private static native void nSetClipRect(long var0, int var2, int var3, int var4, int var5);

    private static native void nSetWorldTransformToIdentity(long var0);

    private static native void nSetWorldTransform(long var0, double var2, double var4, double var6, double var8, double var10, double var12, double var14, double var16, double var18, double var20, double var22, double var24, double var26, double var28, double var30, double var32);

    private static native void nSetCameraPosition(long var0, double var2, double var4, double var6);

    private static native long nCreateMTLMesh(long var0);

    private static native void nReleaseMTLMesh(long var0, long var2);

    private static native boolean nBuildNativeGeometryShort(long var0, long var2, float[] var4, int var5, short[] var6, int var7);

    private static native boolean nBuildNativeGeometryInt(long var0, long var2, float[] var4, int var5, int[] var6, int var7);

    private static native long nCreateMTLPhongMaterial(long var0);

    private static native void nReleaseMTLPhongMaterial(long var0, long var2);

    private static native void nSetDiffuseColor(long var0, long var2, float var4, float var5, float var6, float var7);

    private static native void nSetSpecularColor(long var0, long var2, boolean var4, float var5, float var6, float var7, float var8);

    private static native void nSetMap(long var0, long var2, int var4, long var5);

    private static native long nCreateMTLMeshView(long var0, long var2);

    private static native void nReleaseMTLMeshView(long var0, long var2);

    private static native void nSetCullingMode(long var0, long var2, int var4);

    private static native void nSetMaterial(long var0, long var2, long var4);

    private static native void nSetWireframe(long var0, long var2, boolean var4);

    private static native void nSetAmbientLight(long var0, long var2, float var4, float var5, float var6);

    private static native void nSetLight(long var0, long var2, int var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22);

    private static native void nRenderMeshView(long var0, long var2);

    private static native void nBlit(long var0, long var2, long var4, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13);

    private static native void nRelease(long var0);

    private static native boolean nIsCurrentRTT(long var0, long var2);

    private static native void nDisposeShader(long var0);

    static {
        Class<MTLContext> clazz = MTLContext.class;
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(clazz.getResourceAsStream("msl/jfxshaders.metallib"));){
            byte[] byArray = bufferedInputStream.readAllBytes();
            shaderLibBuffer = ByteBuffer.allocateDirect(byArray.length);
            shaderLibBuffer.put(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }
}

