/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.Texture;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLTexture;
import com.sun.prism.ps.Shader;
import java.lang.ref.WeakReference;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Map;

class MTLShader
implements Shader {
    private long nMetalShaderRef;
    private final MTLContext context;
    private final String fragmentFunctionName;
    private final Map<Integer, String> samplers = new HashMap<Integer, String>();
    private final Map<String, Integer> uniformNameIdMap;
    private final Map<Integer, WeakReference<Object>> textureIdRefMap = new HashMap<Integer, WeakReference<Object>>();
    private static final Map<String, MTLShader> shaderMap = new HashMap<String, MTLShader>();
    private static MTLShader currentEnabledShader;

    private MTLShader(MTLContext mTLContext, String string) {
        this.fragmentFunctionName = string;
        this.context = mTLContext;
        this.nMetalShaderRef = MTLShader.nCreateMetalShader(mTLContext.getContextHandle(), string);
        if (this.nMetalShaderRef == 0L) {
            throw new InternalError("Failed to create the Shader : " + string);
        }
        shaderMap.put(string, this);
        this.uniformNameIdMap = MTLShader.nGetUniformNameIdMap(this.nMetalShaderRef);
    }

    public static Shader createShader(MTLContext mTLContext, String string, Map<String, Integer> map, Map<String, Integer> map2, int n, boolean bl, boolean bl2) {
        if (shaderMap.containsKey(string)) {
            return shaderMap.get(string);
        }
        MTLShader mTLShader = new MTLShader(mTLContext, string);
        mTLShader.storeSamplers(map);
        return mTLShader;
    }

    public static MTLShader createShader(MTLContext mTLContext, String string) {
        if (shaderMap.containsKey(string)) {
            return shaderMap.get(string);
        }
        return new MTLShader(mTLContext, string);
    }

    private void storeSamplers(Map<String, Integer> map) {
        map.forEach((string, n) -> this.samplers.put((Integer)n, (String)string));
    }

    @Override
    public void enable() {
        currentEnabledShader = this;
        MTLShader.nEnable(this.nMetalShaderRef);
    }

    @Override
    public void disable() {
        MTLShader.nDisable(this.nMetalShaderRef);
    }

    @Override
    public boolean isValid() {
        return this.nMetalShaderRef != 0L;
    }

    public static void setTexture(int n, Texture texture, boolean bl, int n2) {
        if (MTLShader.currentEnabledShader.textureIdRefMap.get(n) != null && MTLShader.currentEnabledShader.textureIdRefMap.get(n).get() == texture) {
            return;
        }
        MTLShader.currentEnabledShader.textureIdRefMap.put(n, new WeakReference<Texture>(texture));
        MTLTexture mTLTexture = (MTLTexture)texture;
        MTLShader.nSetTexture(MTLShader.currentEnabledShader.nMetalShaderRef, n, MTLShader.currentEnabledShader.uniformNameIdMap.get(MTLShader.currentEnabledShader.samplers.get(n)), mTLTexture.getNativeHandle(), bl, n2);
    }

    @Override
    public void setConstant(String string, int n) {
        MTLShader.nSetInt(this.nMetalShaderRef, this.uniformNameIdMap.get(string), n);
    }

    @Override
    public void setConstant(String string, int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, int n, int n2, int n3, int n4) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstants(String string, IntBuffer intBuffer, int n, int n2) {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    @Override
    public void setConstant(String string, float f) {
        MTLShader.nSetFloat1(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f);
    }

    @Override
    public void setConstant(String string, float f, float f2) {
        MTLShader.nSetFloat2(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3) {
        MTLShader.nSetFloat3(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2, f3);
    }

    @Override
    public void setConstant(String string, float f, float f2, float f3, float f4) {
        MTLShader.nSetFloat4(this.nMetalShaderRef, this.uniformNameIdMap.get(string), f, f2, f3, f4);
    }

    @Override
    public void setConstants(String string, FloatBuffer floatBuffer, int n, int n2) {
        boolean bl = floatBuffer.isDirect();
        if (bl) {
            MTLShader.nSetConstantsBuf(this.nMetalShaderRef, this.uniformNameIdMap.get(string), floatBuffer, floatBuffer.position() * 4, n2 * 4);
        } else {
            n2 = 4 * n2;
            float[] fArray = new float[n2];
            floatBuffer.get(n, fArray, 0, n2);
            MTLShader.nSetConstants(this.nMetalShaderRef, this.uniformNameIdMap.get(string), fArray, n2);
        }
    }

    @Override
    public void dispose() {
        if (this.isValid()) {
            this.context.disposeShader(this.nMetalShaderRef);
            shaderMap.remove(this.fragmentFunctionName);
            this.nMetalShaderRef = 0L;
            this.textureIdRefMap.clear();
            this.uniformNameIdMap.clear();
            this.samplers.clear();
        }
    }

    private static native long nCreateMetalShader(long var0, String var2);

    private static native Map<String, Integer> nGetUniformNameIdMap(long var0);

    private static native void nEnable(long var0);

    private static native void nDisable(long var0);

    private static native void nSetTexture(long var0, int var2, int var3, long var4, boolean var6, int var7);

    private static native void nSetInt(long var0, int var2, int var3);

    private static native void nSetFloat1(long var0, int var2, float var3);

    private static native void nSetFloat2(long var0, int var2, float var3, float var4);

    private static native void nSetFloat3(long var0, int var2, float var3, float var4, float var5);

    private static native void nSetFloat4(long var0, int var2, float var3, float var4, float var5, float var6);

    private static native void nSetConstants(long var0, int var2, float[] var3, int var4);

    private static native void nSetConstantsBuf(long var0, int var2, Object var3, int var4, int var5);
}

