/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.mtl;

import com.sun.prism.impl.Disposer;
import com.sun.prism.mtl.MTLContext;
import com.sun.prism.mtl.MTLResourceFactory;
import java.util.Objects;

class MTLTextureData
implements Disposer.Record {
    protected final MTLContext mtlContext;
    protected long pTexture;
    private long size;

    MTLTextureData(MTLContext mTLContext, long l, long l2) {
        Objects.requireNonNull(mTLContext, "MTLContext must not be null");
        if (l == 0L) {
            throw new IllegalArgumentException("Texture cannot be null");
        }
        this.mtlContext = mTLContext;
        this.pTexture = l;
        this.size = l2;
    }

    public long getResource() {
        return this.pTexture;
    }

    public long getSize() {
        return this.size;
    }

    @Override
    public void dispose() {
        if (this.pTexture != 0L && !this.mtlContext.isDisposed()) {
            MTLResourceFactory.releaseTexture(this.pTexture);
            this.pTexture = 0L;
        }
    }
}

