/*
 * Decompiled with CFR 0.152.
 */
package org.openjfx;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.exec.CommandLine;
import org.apache.commons.exec.DefaultExecutor;
import org.apache.commons.exec.ExecuteException;
import org.apache.commons.exec.Executor;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.zip.ZipArchiver;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.openjfx.JavaFXBaseMojo;

@Mojo(name="jlink", requiresDependencyResolution=ResolutionScope.RUNTIME)
public class JavaFXJLinkMojo
extends JavaFXBaseMojo {
    @Parameter(property="javafx.stripDebug", defaultValue="false")
    private boolean stripDebug;
    @Parameter(property="javafx.compress", defaultValue="2")
    private Integer compress;
    @Parameter(property="javafx.noHeaderFiles", defaultValue="false")
    private boolean noHeaderFiles;
    @Parameter(property="javafx.noManPages", defaultValue="false")
    private boolean noManPages;
    @Parameter(property="javafx.bindServices", defaultValue="false")
    private boolean bindServices;
    @Parameter(property="javafx.ignoreSigningInformation", defaultValue="false")
    private boolean ignoreSigningInformation;
    @Parameter(property="javafx.jlinkVerbose", defaultValue="false")
    private boolean jlinkVerbose;
    @Parameter(property="javafx.launcher")
    private String launcher;
    @Parameter(property="javafx.jlinkImageName", defaultValue="image")
    private String jlinkImageName;
    @Parameter(property="javafx.jlinkZipName")
    private String jlinkZipName;
    @Parameter(property="javafx.jlinkExecutable", defaultValue="jlink")
    private String jlinkExecutable;
    @Parameter(property="javafx.jmodsPath")
    private String jmodsPath;
    @Component(role=Archiver.class, hint="zip")
    private ZipArchiver zipArchiver;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skipping execute as per configuration");
            return;
        }
        if (this.jlinkExecutable == null) {
            throw new MojoExecutionException("The parameter 'jlinkExecutable' is missing or invalid");
        }
        if (this.basedir == null) {
            throw new IllegalStateException("basedir is null. Should not be possible.");
        }
        Map<String, String> enviro = this.handleSystemEnvVariables();
        CommandLine commandLine = this.getExecutablePath(this.jlinkExecutable, enviro, this.workingDirectory);
        if (JavaFXJLinkMojo.isTargetUsingJava8(commandLine)) {
            this.getLog().info((CharSequence)"Jlink not supported with Java 1.8");
            return;
        }
        try {
            this.handleWorkingDirectory();
            List<String> commandArguments = this.createCommandArguments();
            String[] args = commandArguments.toArray(new String[commandArguments.size()]);
            commandLine.addArguments(args, false);
            this.getLog().debug((CharSequence)("Executing command line: " + commandLine));
            DefaultExecutor exec = new DefaultExecutor();
            exec.setWorkingDirectory(this.workingDirectory);
            try {
                int resultCode;
                block19: {
                    block18: {
                        if (this.outputFile == null) break block18;
                        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
                            this.getLog().warn((CharSequence)("Could not create non existing parent directories for log file: " + this.outputFile));
                        }
                        FileOutputStream outputStream = null;
                        try {
                            outputStream = new FileOutputStream(this.outputFile);
                            resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, outputStream);
                        }
                        catch (Throwable throwable) {
                            IOUtil.close(outputStream);
                            throw throwable;
                        }
                        IOUtil.close((OutputStream)outputStream);
                        break block19;
                    }
                    resultCode = this.executeCommandLine((Executor)exec, commandLine, enviro, System.out, System.err);
                }
                if (resultCode != 0) {
                    String message = "Result of " + commandLine.toString() + " execution is: '" + resultCode + "'.";
                    this.getLog().error((CharSequence)message);
                    throw new MojoExecutionException(message);
                }
                if (this.launcher != null && !this.launcher.isEmpty()) {
                    Path launcherPath = Paths.get(this.builddir.getAbsolutePath(), this.jlinkImageName, "bin", this.launcher);
                    if (this.options != null) {
                        String optionsString = this.options.stream().filter(Objects::nonNull).filter(String.class::isInstance).map(String.class::cast).collect(Collectors.joining(" "));
                        List lines = Files.lines(launcherPath).map(line -> {
                            if ("JLINK_VM_OPTIONS=".equals(line)) {
                                return "JLINK_VM_OPTIONS=\"" + optionsString + "\"";
                            }
                            return line;
                        }).collect(Collectors.toList());
                        Files.write(launcherPath, lines, new OpenOption[0]);
                    }
                    if (this.commandlineArgs != null) {
                        List lines = Files.lines(launcherPath).map(line -> {
                            if (line.endsWith("$@")) {
                                return line.replace("$@", this.commandlineArgs + " $@");
                            }
                            return line;
                        }).collect(Collectors.toList());
                        Files.write(launcherPath, lines, new OpenOption[0]);
                    }
                }
                if (this.jlinkZipName != null && !this.jlinkZipName.isEmpty()) {
                    this.getLog().debug((CharSequence)"Creating zip of runtime image");
                    File createZipArchiveFromImage = this.createZipArchiveFromImage();
                    this.project.getArtifact().setFile(createZipArchiveFromImage);
                }
            }
            catch (ExecuteException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                e.printStackTrace();
                throw new MojoExecutionException("Command execution failed.", (Exception)((Object)e));
            }
            catch (IOException e) {
                this.getLog().error((CharSequence)"Command execution failed.", (Throwable)e);
                throw new MojoExecutionException("Command execution failed.", (Exception)e);
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error", e);
        }
    }

    private List<String> createCommandArguments() throws MojoExecutionException, MojoFailureException {
        ArrayList<String> commandArguments = new ArrayList<String>();
        this.preparePaths(JavaFXJLinkMojo.getParent(Paths.get(this.jlinkExecutable, new String[0]), 2));
        if (this.modulepathElements != null && !this.modulepathElements.isEmpty()) {
            commandArguments.add(" --module-path");
            String modulePath = StringUtils.join(this.modulepathElements.iterator(), (String)File.pathSeparator);
            if (this.jmodsPath != null && !this.jmodsPath.isEmpty()) {
                this.getLog().debug((CharSequence)("Including jmods from local path: " + this.jmodsPath));
                modulePath = this.jmodsPath + File.pathSeparator + modulePath;
            }
            commandArguments.add(modulePath);
            commandArguments.add(" --add-modules");
            if (this.moduleDescriptor != null) {
                commandArguments.add(" " + this.moduleDescriptor.name());
            } else {
                throw new MojoExecutionException("jlink requires a module descriptor");
            }
        }
        commandArguments.add(" --output");
        File image = new File(this.builddir, this.jlinkImageName);
        this.getLog().debug((CharSequence)("image output: " + image.getAbsolutePath()));
        if (image.exists()) {
            try {
                Files.walk(image.toPath(), new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Image can't be removed " + image.getAbsolutePath(), (Exception)e);
            }
        }
        commandArguments.add(" " + image.getAbsolutePath());
        if (this.stripDebug) {
            commandArguments.add(" --strip-debug");
        }
        if (this.bindServices) {
            commandArguments.add(" --bind-services");
        }
        if (this.ignoreSigningInformation) {
            commandArguments.add(" --ignore-signing-information");
        }
        if (this.compress != null) {
            commandArguments.add(" --compress");
            if (this.compress < 0 || this.compress > 2) {
                throw new MojoFailureException("The given compress parameters " + this.compress + " is not in the valid value range from 0..2");
            }
            commandArguments.add(" " + this.compress);
        }
        if (this.noHeaderFiles) {
            commandArguments.add(" --no-header-files");
        }
        if (this.noManPages) {
            commandArguments.add(" --no-man-pages");
        }
        if (this.jlinkVerbose) {
            commandArguments.add(" --verbose");
        }
        if (this.launcher != null && !this.launcher.isEmpty()) {
            commandArguments.add(" --launcher");
            String moduleMainClass = this.mainClass.contains("/") ? this.mainClass : this.moduleDescriptor.name() + "/" + this.mainClass;
            commandArguments.add(" " + this.launcher + "=" + moduleMainClass);
        }
        return commandArguments;
    }

    private File createZipArchiveFromImage() throws MojoExecutionException {
        File imageArchive = new File(this.builddir, this.jlinkImageName);
        this.zipArchiver.addDirectory(imageArchive);
        File resultArchive = new File(this.builddir, this.jlinkZipName + ".zip");
        this.zipArchiver.setDestFile(resultArchive);
        try {
            this.zipArchiver.createArchive();
        }
        catch (IOException | ArchiverException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        return resultArchive;
    }
}

