/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server.htmlrunner;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openqa.selenium.server.htmlrunner.HTMLSuiteResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTMLTestResults {
    private final String result;
    private final String totalTime;
    private final String numTestPasses;
    private final String numTestFailures;
    private final String numCommandPasses;
    private final String numCommandFailures;
    private final String numCommandErrors;
    private final String seleniumVersion;
    private final String seleniumRevision;
    private final HTMLSuiteResult suite;
    private static final String HEADER = "<html>\n<head><style type='text/css'>\nbody, table {\n    font-family: Verdana, Arial, sans-serif;\n    font-size: 12;\n}\n\ntable {\n    border-collapse: collapse;\n    border: 1px solid #ccc;\n}\n\nth, td {\n    padding-left: 0.3em;\n    padding-right: 0.3em;\n}\n\na {\n    text-decoration: none;\n}\n\n.title {\n    font-style: italic;\n}\n\n.selected {\n    background-color: #ffffcc;\n}\n\n.status_done {\n    background-color: #eeffee;\n}\n\n.status_passed {\n    background-color: #ccffcc;\n}\n\n.status_failed {\n    background-color: #ffcccc;\n}\n\n.breakpoint {\n    background-color: #cccccc;\n    border: 1px solid black;\n}\n</style><title>Test suite results</title></head>\n<body>\n<h1>Test suite results </h1>";
    private static final String SUMMARY_HTML = "\n\n<table>\n<tr>\n<td>result:</td>\n<td>{0}</td>\n</tr>\n<tr>\n<td>totalTime:</td>\n<td>{1}</td>\n</tr>\n<tr>\n<td>numTestPasses:</td>\n<td>{2}</td>\n</tr>\n<tr>\n<td>numTestFailures:</td>\n<td>{3}</td>\n</tr>\n<tr>\n<td>numCommandPasses:</td>\n<td>{4}</td>\n</tr>\n<tr>\n<td>numCommandFailures:</td>\n<td>{5}</td>\n</tr>\n<tr>\n<td>numCommandErrors:</td>\n<td>{6}</td>\n</tr>\n<tr>\n<td>Selenium Version:</td>\n<td>{7}</td>\n</tr>\n<tr>\n<td>Selenium Revision:</td>\n<td>{8}</td>\n</tr>\n<tr>\n<td>{9}</td>\n<td>&nbsp;</td>\n</tr>\n</table>";
    private static final String SUITE_HTML = "<tr>\n<td><a name=\"testresult{0}\">{1}</a><br/>{2}</td>\n<td>&nbsp;</td>\n</tr>";
    private final List<String> testTables;

    public HTMLTestResults(String postedSeleniumVersion, String postedSeleniumRevision, String postedResult, String postedTotalTime, String postedNumTestPasses, String postedNumTestFailures, String postedNumCommandPasses, String postedNumCommandFailures, String postedNumCommandErrors, String postedSuite, List<String> postedTestTables) {
        this.result = postedResult;
        this.numCommandFailures = postedNumCommandFailures;
        this.numCommandErrors = postedNumCommandErrors;
        this.suite = new HTMLSuiteResult(postedSuite);
        this.totalTime = postedTotalTime;
        this.numTestPasses = postedNumTestPasses;
        this.numTestFailures = postedNumTestFailures;
        this.numCommandPasses = postedNumCommandPasses;
        this.testTables = postedTestTables;
        this.seleniumVersion = postedSeleniumVersion;
        this.seleniumRevision = postedSeleniumRevision;
    }

    public String getResult() {
        return this.result;
    }

    public String getNumCommandErrors() {
        return this.numCommandErrors;
    }

    public String getNumCommandFailures() {
        return this.numCommandFailures;
    }

    public String getNumCommandPasses() {
        return this.numCommandPasses;
    }

    public String getNumTestFailures() {
        return this.numTestFailures;
    }

    public String getNumTestPasses() {
        return this.numTestPasses;
    }

    public Collection getTestTables() {
        return this.testTables;
    }

    public String getTotalTime() {
        return this.totalTime;
    }

    public int getNumTotalTests() {
        return Integer.parseInt(this.numTestPasses) + Integer.parseInt(this.numTestFailures);
    }

    public void write(Writer out) throws IOException {
        out.write(HEADER);
        out.write(MessageFormat.format(SUMMARY_HTML, this.result, this.totalTime, this.numTestPasses, this.numTestFailures, this.numCommandPasses, this.numCommandFailures, this.numCommandErrors, this.seleniumVersion, this.seleniumRevision, this.suite.getUpdatedSuite()));
        for (int i = 0; i < this.testTables.size(); ++i) {
            String table = this.testTables.get(i).replace("\u00a0", "&nbsp;");
            out.write(MessageFormat.format(SUITE_HTML, i, this.suite.getHref(i), table));
        }
        out.write("</table></body></html>");
        out.flush();
    }

    class UrlDecoder {
        UrlDecoder() {
        }

        public String decode(String string) {
            try {
                return URLDecoder.decode(string, System.getProperty("file.encoding"));
            }
            catch (UnsupportedEncodingException e) {
                return string;
            }
        }

        public List decodeListOfStrings(List list) {
            LinkedList<String> decodedList = new LinkedList<String>();
            Iterator i = list.iterator();
            while (i.hasNext()) {
                decodedList.add(this.decode((String)i.next()));
            }
            return decodedList;
        }
    }
}

