/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Platform {
    WINDOWS(new String[]{""}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP || compareWith == VISTA;
        }
    }
    ,
    XP(new String[]{"xp"}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == XP;
        }
    }
    ,
    VISTA(new String[]{"vista"}){

        public String getLineEnding() {
            return "\r\n";
        }

        public boolean is(Platform compareWith) {
            return compareWith == WINDOWS || compareWith == VISTA;
        }
    }
    ,
    MAC(new String[]{"mac", "darwin"}){

        public String getLineEnding() {
            return "\r";
        }
    }
    ,
    UNIX(new String[]{"linux", "solaris", "bsd"}){

        public String getLineEnding() {
            return "\n";
        }
    }
    ,
    ANY(new String[]{""}){

        public String getLineEnding() {
            throw new UnsupportedOperationException("getLineEnding");
        }
    };

    private static Platform currentOs;
    private final String[] partOfOsName;

    private Platform(String ... partOfOsName) {
        this.partOfOsName = partOfOsName;
    }

    public static Platform getCurrent() {
        if (currentOs != null) {
            return currentOs;
        }
        Platform mostLikely = UNIX;
        String previousMatch = null;
        for (Platform os : Platform.values()) {
            for (String matcher : os.partOfOsName) {
                if ("".equals(matcher)) continue;
                if (os.isExactMatch(matcher)) {
                    currentOs = os;
                    return os;
                }
                if (!os.isCurrentPlatform(matcher) || !Platform.isBetterMatch(previousMatch, matcher)) continue;
                previousMatch = matcher;
                mostLikely = os;
            }
        }
        currentOs = mostLikely;
        return mostLikely;
    }

    private static boolean isBetterMatch(String previous, String matcher) {
        if (previous == null) {
            return true;
        }
        return matcher.length() >= previous.length();
    }

    public boolean is(Platform compareWith) {
        return this.equals((Object)compareWith);
    }

    public abstract String getLineEnding();

    private boolean isCurrentPlatform(String matchAgainst) {
        String osName = System.getProperty("os.name").toLowerCase();
        return osName.indexOf(matchAgainst) != -1;
    }

    private boolean isExactMatch(String matchAgainst) {
        String osName = System.getProperty("os.name").toLowerCase();
        return matchAgainst.equals(osName);
    }
}

