/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query;

import info.aduna.iteration.Iteration;
import info.aduna.iteration.Iterations;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.Graph;
import org.openrdf.model.Statement;
import org.openrdf.model.Value;
import org.openrdf.model.util.ModelUtil;
import org.openrdf.query.BindingSet;
import org.openrdf.query.GraphQueryResult;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.TupleQueryResult;
import org.openrdf.query.TupleQueryResultHandler;
import org.openrdf.query.TupleQueryResultHandlerException;
import org.openrdf.query.dawg.DAWGTestResultSetUtil;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;

public class QueryResultUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(TupleQueryResult tqr, TupleQueryResultHandler handler) throws TupleQueryResultHandlerException, QueryEvaluationException {
        handler.startQueryResult(tqr.getBindingNames());
        try {
            while (tqr.hasNext()) {
                BindingSet bindingSet = (BindingSet)tqr.next();
                handler.handleSolution(bindingSet);
            }
        }
        finally {
            tqr.close();
        }
        handler.endQueryResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void report(GraphQueryResult gqr, RDFHandler rdfHandler) throws RDFHandlerException, QueryEvaluationException {
        try {
            rdfHandler.startRDF();
            for (Map.Entry<String, String> entry : gqr.getNamespaces().entrySet()) {
                String prefix = entry.getKey();
                String namespace = entry.getValue();
                rdfHandler.handleNamespace(prefix, namespace);
            }
            while (gqr.hasNext()) {
                Statement st = (Statement)gqr.next();
                rdfHandler.handleStatement(st);
            }
            rdfHandler.endRDF();
        }
        finally {
            gqr.close();
        }
    }

    public static boolean equals(TupleQueryResult tqr1, TupleQueryResult tqr2) throws QueryEvaluationException {
        Graph graph1 = DAWGTestResultSetUtil.toGraph(tqr1);
        Graph graph2 = DAWGTestResultSetUtil.toGraph(tqr2);
        return ModelUtil.equals((Iterable)graph1, (Iterable)graph2);
    }

    public static boolean equals(GraphQueryResult result1, GraphQueryResult result2) throws QueryEvaluationException {
        Set graph1 = Iterations.asSet((Iteration)result1);
        Set graph2 = Iterations.asSet((Iteration)result1);
        return ModelUtil.equals((Set)graph1, (Set)graph2);
    }

    public static boolean bindingSetsCompatible(BindingSet bs1, BindingSet bs2) {
        HashSet<String> sharedBindings = new HashSet<String>(bs1.getBindingNames());
        sharedBindings.retainAll(bs2.getBindingNames());
        for (String bindingName : sharedBindings) {
            Value value2;
            Value value1 = bs1.getValue(bindingName);
            if (value1.equals(value2 = bs2.getValue(bindingName))) continue;
            return false;
        }
        return true;
    }
}

