/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository;

import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface RepositoryConnection {
    public Repository getRepository();

    public boolean isOpen() throws RepositoryException;

    public void close() throws RepositoryException;

    public Query prepareQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public Query prepareQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public TupleQuery prepareTupleQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public GraphQuery prepareGraphQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2) throws RepositoryException, MalformedQueryException;

    public BooleanQuery prepareBooleanQuery(QueryLanguage var1, String var2, String var3) throws RepositoryException, MalformedQueryException;

    public RepositoryResult<Resource> getContextIDs() throws RepositoryException;

    public RepositoryResult<Statement> getStatements(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws RepositoryException;

    public boolean hasStatement(Statement var1, boolean var2, Resource ... var3) throws RepositoryException;

    public void exportStatements(Resource var1, URI var2, Value var3, boolean var4, RDFHandler var5, Resource ... var6) throws RepositoryException, RDFHandlerException;

    public void export(RDFHandler var1, Resource ... var2) throws RepositoryException, RDFHandlerException;

    public long size(Resource ... var1) throws RepositoryException;

    public boolean isEmpty() throws RepositoryException;

    public void setAutoCommit(boolean var1) throws RepositoryException;

    public boolean isAutoCommit() throws RepositoryException;

    public void commit() throws RepositoryException;

    public void rollback() throws RepositoryException;

    public void add(InputStream var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(Reader var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(URL var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(File var1, String var2, RDFFormat var3, Resource ... var4) throws IOException, RDFParseException, RepositoryException;

    public void add(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void add(Statement var1, Resource ... var2) throws RepositoryException;

    public void add(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void add(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    public void remove(Resource var1, URI var2, Value var3, Resource ... var4) throws RepositoryException;

    public void remove(Statement var1, Resource ... var2) throws RepositoryException;

    public void remove(Iterable<? extends Statement> var1, Resource ... var2) throws RepositoryException;

    public <E extends Exception> void remove(Iteration<? extends Statement, E> var1, Resource ... var2) throws RepositoryException, E;

    public void clear(Resource ... var1) throws RepositoryException;

    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException;

    public String getNamespace(String var1) throws RepositoryException;

    public void setNamespace(String var1, String var2) throws RepositoryException;

    public void removeNamespace(String var1) throws RepositoryException;

    public void clearNamespaces() throws RepositoryException;
}

