/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.lang.reflect;

import info.aduna.lang.reflect.NoSuchTypeException;
import info.aduna.lang.reflect.TypeInstantiationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyedObjectFactory<KEY, TYPE> {
    private Map<KEY, Class<? extends TYPE>> _types = new HashMap<KEY, Class<? extends TYPE>>();
    private Map<KEY, Constructor<? extends TYPE>> _constructors = new HashMap<KEY, Constructor<? extends TYPE>>();
    private Class<?>[] _paramTypes;

    public KeyedObjectFactory(Class<?> ... paramTypes) {
        this._paramTypes = paramTypes;
    }

    public void addType(KEY key, Class<? extends TYPE> type) throws SecurityException {
        int classModifiers = type.getModifiers();
        if (Modifier.isInterface(classModifiers)) {
            throw new IllegalArgumentException("supplied type is an interface: " + type.getName());
        }
        if (Modifier.isAbstract(classModifiers)) {
            throw new IllegalArgumentException("supplied type is an abstract class: " + type.getName());
        }
        if (!Modifier.isPublic(classModifiers)) {
            throw new IllegalArgumentException("supplied type is not a public class: " + type.getName());
        }
        try {
            Constructor<TYPE> constructor = type.getConstructor(this._paramTypes);
            if (!Modifier.isPublic(constructor.getModifiers())) {
                throw new IllegalArgumentException("required constructor is not public: " + this._getConstructorString(type));
            }
            this._types.put(key, type);
            this._constructors.put(key, constructor);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("required constructor not found: " + this._getConstructorString(type));
        }
    }

    public void removeType(KEY key) {
        this._types.remove(key);
        this._constructors.remove(key);
    }

    public Class<? extends TYPE> getType(KEY key) {
        return this._types.get(key);
    }

    public TYPE createInstance(KEY key, Object ... initArgs) throws NoSuchTypeException, TypeInstantiationException {
        Constructor<TYPE> constructor = this._constructors.get(key);
        if (constructor == null) {
            throw new NoSuchTypeException("No type found for key: " + key);
        }
        try {
            return constructor.newInstance(initArgs);
        }
        catch (Exception e) {
            throw new TypeInstantiationException(e);
        }
    }

    private String _getConstructorString(Class<? extends TYPE> type) {
        StringBuilder sb = new StringBuilder(128);
        sb.append(type.getName());
        sb.append("(");
        for (int i = 0; i < this._paramTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this._paramTypes[i].getName());
        }
        sb.append(")");
        return sb.toString();
    }
}

