/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;
import org.openrdf.query.algebra.evaluation.impl.EvaluationStatistics;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class QueryJoinOptimizer
implements QueryOptimizer {
    protected final EvaluationStatistics statistics;

    public QueryJoinOptimizer() {
        this(new EvaluationStatistics());
    }

    public QueryJoinOptimizer(EvaluationStatistics statistics) {
        this.statistics = statistics;
    }

    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new JoinVisitor());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class JoinVisitor
    extends QueryModelVisitorBase<RuntimeException> {
        protected JoinVisitor() {
        }

        @Override
        public void meet(Join node) {
            List<TupleExpr> joinArgs = new LinkedList<TupleExpr>();
            this.getJoinArgs(node, joinArgs);
            for (TupleExpr joinArg : joinArgs) {
                joinArg.visit(this);
            }
            joinArgs = this.sortExpressions(joinArgs, new HashSet<String>());
            TupleExpr replacement = joinArgs.get(0);
            for (int i = 1; i < joinArgs.size(); ++i) {
                replacement = new Join(replacement, joinArgs.get(i));
            }
            node.replaceWith(replacement);
        }

        protected void getJoinArgs(TupleExpr tupleExpr, List<TupleExpr> joinArgs) {
            if (tupleExpr instanceof Join) {
                Join join = (Join)tupleExpr;
                this.getJoinArgs(join.getLeftArg(), joinArgs);
                this.getJoinArgs(join.getRightArg(), joinArgs);
            } else {
                joinArgs.add(tupleExpr);
            }
        }

        protected List<TupleExpr> sortExpressions(List<TupleExpr> expressions, Set<String> boundVars) {
            ArrayList<TupleExpr> orderedExpressions = new ArrayList<TupleExpr>(expressions.size());
            while (!expressions.isEmpty()) {
                TupleExpr tupleExpr = this.selectNextTupleExpr(expressions, boundVars);
                expressions.remove(tupleExpr);
                orderedExpressions.add(tupleExpr);
                boundVars.addAll(tupleExpr.getBindingNames());
            }
            return orderedExpressions;
        }

        protected TupleExpr selectNextTupleExpr(List<TupleExpr> expressions, Set<String> boundVars) {
            double lowestCardinality = Double.MAX_VALUE;
            TupleExpr result = null;
            for (TupleExpr tupleExpr : expressions) {
                double cardinality = QueryJoinOptimizer.this.statistics.getCardinality(tupleExpr, boundVars);
                if (!(cardinality < lowestCardinality)) continue;
                lowestCardinality = cardinality;
                result = tupleExpr;
            }
            return result;
        }
    }
}

