/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.openrewrite.gradle.toolingapi.Dependency;
import org.openrewrite.gradle.toolingapi.MavenRepository;
import org.openrewrite.gradle.toolingapi.ResolvedDependency;
import org.openrewrite.maven.tree.ResolvedGroupArtifactVersion;

class ResolvedDependencyMapper {
    private final Map<ResolvedGroupArtifactVersion, org.openrewrite.maven.tree.ResolvedDependency> resolvedCache = new HashMap<ResolvedGroupArtifactVersion, org.openrewrite.maven.tree.ResolvedDependency>();

    ResolvedDependencyMapper() {
    }

    org.openrewrite.maven.tree.ResolvedDependency toMarker(ResolvedDependency dep, int depth) {
        ResolvedGroupArtifactVersion gav = new ResolvedGroupArtifactVersion(null, dep.getGav().getGroupId(), dep.getGav().getArtifactId(), dep.getGav().getVersion(), dep.getGav().getDatedSnapshotVersion());
        org.openrewrite.maven.tree.ResolvedDependency resolvedDependency = this.resolvedCache.get(gav);
        if (resolvedDependency != null) {
            return resolvedDependency;
        }
        ArrayList deps = new ArrayList(dep.getDependencies().size());
        resolvedDependency = this.resolvedCache.computeIfAbsent(gav, k -> org.openrewrite.maven.tree.ResolvedDependency.builder().repository(MavenRepository.toMarker(dep.getRepository())).gav(gav).requested(Dependency.toMarkers(dep.getRequested())).dependencies(deps).licenses(Collections.emptyList()).depth(dep.getDepth()).build());
        dep.getDependencies().stream().map(d -> this.toMarker((ResolvedDependency)d, depth + 1)).forEach(deps::add);
        return resolvedDependency;
    }
}

