import Fix from "../../ui5Types/fix/Fix.js";
export class HtmlFix extends Fix {
    startPos;
    endPos;
    visitLinterNode(_node, _sourcePosition, _helpers) {
        // HTML fixes don't use the linter node
        return true;
    }
    getNodeSearchParameters() {
        // HTML fixes don't use the node search parameters
        return {
            nodeTypes: [],
            position: {
                line: 0,
                column: 0,
            },
        };
    }
    visitAutofixNode(_node, _position, _sourceFile) {
        // HTML fixes don't use the TypeScript node
        return true;
    }
    getAffectedSourceCodeRange() {
        if (this.startPos === undefined || this.endPos === undefined) {
            return undefined;
        }
        return {
            start: this.startPos,
            end: this.endPos,
        };
    }
}
//# sourceMappingURL=HtmlFix.js.map