export default class ManifestReporter {
    #resourcePath;
    #pointers;
    #context;
    constructor(resourcePath, context, manifest) {
        this.#resourcePath = resourcePath;
        this.#pointers = manifest.pointers;
        this.#context = context;
    }
    addMessage(id, argsOrNode, node, fix) {
        if (!argsOrNode) {
            throw new Error("Invalid arguments: Missing second argument");
        }
        let args;
        if (typeof argsOrNode === "string") {
            node = argsOrNode;
            args = null;
        }
        else if (!node) {
            throw new Error("Invalid arguments: Missing 'node'");
        }
        else {
            args = argsOrNode;
        }
        this.#context.addLintingMessage(this.#resourcePath, { id, args, position: this.#getPosition(node), fix });
    }
    addCoverageInfo({ node, message, category }) {
        const location = this.#getPositionsForNode(node);
        this.#context.addCoverageInfo(this.#resourcePath, {
            category,
            // One-based to be aligned with most IDEs
            line: location.key?.line ?? location.value.line,
            column: location.key?.column ?? location.value.column,
            endLine: location.valueEnd.line,
            endColumn: location.valueEnd.column,
            message,
        });
    }
    #getPositionsForNode(path) {
        const location = this.#pointers[path];
        return location || { key: 1, keyEnd: 1, value: 1, valueEnd: 1 };
    }
    #getPosition(path) {
        let line = 1;
        let column = 1;
        const location = this.#pointers[path];
        if (location) {
            line = (location.key?.line ?? location.value.line) + 1;
            column = (location.key?.column ?? location.value.column) + 1;
        }
        return {
            line,
            column,
        };
    }
}
//# sourceMappingURL=ManifestReporter.js.map