import ManifestLinter from "./ManifestLinter.js";
import { taskStart } from "../../utils/perf.js";
export default async function lintJson({ filePathsWorkspace, context }) {
    const lintingDone = taskStart("Linting manifest.json files");
    const jsonResources = await filePathsWorkspace.byGlob("**/manifest.json");
    await Promise.all(jsonResources.map(async (resource) => {
        const linter = new ManifestLinter(resource.getPath(), await resource.getString(), context);
        await linter.lint();
    }));
    lintingDone();
}
//# sourceMappingURL=linter.js.map