import ts from "typescript";
import { ChangeAction } from "../../../utils/textChanges.js";
import CallExpressionBaseFix from "./CallExpressionBaseFix.js";
export default class CallExpressionFix extends CallExpressionBaseFix {
    params;
    constructor(params, ui5TypeInfo) {
        super(params, ui5TypeInfo);
        this.params = params;
    }
    visitAutofixNode(node, position, sourceFile) {
        if (!super.visitAutofixNode(node, position, sourceFile)) {
            return false;
        }
        if (!ts.isCallExpression(node)) {
            return false;
        }
        let relevantNode = node;
        for (let i = 0; i < (this.params.scope ?? 1); i++) {
            if (ts.isIdentifier(relevantNode)) {
                // If the current node is an identifier, we can not go further
                return false;
            }
            if (!ts.isPropertyAccessExpression(relevantNode.expression) &&
                !ts.isElementAccessExpression(relevantNode.expression) &&
                !ts.isIdentifier(relevantNode.expression)) {
                return false;
            }
            relevantNode = relevantNode.expression;
        }
        if (!this.requestsModuleOrGlobal) {
            // If no module or global is requested, we assume the current property access should stay.
            // Therefore, ignore the expression of the "relevant node" and start at the name
            if (!ts.isPropertyAccessExpression(relevantNode)) {
                // We can't replace an element access expression like this
                return false;
            }
            this.startPos = relevantNode.name.getStart(sourceFile);
        }
        else {
            this.startPos = relevantNode.getStart(sourceFile);
        }
        this.endPos = relevantNode.getEnd();
        return true;
    }
    generateChanges() {
        if (this.startPos === undefined || this.endPos === undefined) {
            throw new Error("Start or end position is not defined");
        }
        let value;
        if (this.requestsModuleOrGlobal) {
            const identifier = this.getIdentifiersForSingleRequest(this.params.moduleName, this.params.globalName);
            if (!identifier) {
                return;
            }
            value = identifier;
            if (this.params.propertyAccess) {
                // If a property is defined, we need to access it on the identifier
                value = `${value}.${this.params.propertyAccess}`;
            }
        }
        else {
            value = this.params.propertyAccess ?? "";
        }
        if (this.params.newExpression) {
            // If the newExpression flag is set, we need to add a "new" keyword before the expression
            value = `new ${value}`;
        }
        return {
            action: ChangeAction.REPLACE,
            start: this.startPos,
            end: this.endPos,
            value,
        };
    }
}
//# sourceMappingURL=CallExpressionFix.js.map