import ts from "typescript";
import Fix from "./Fix.js";
import CallExpressionFix, { CallExpressionFixParams } from "./CallExpressionFix.js";
import AccessExpressionFix, { AccessExpressionFixParams } from "./AccessExpressionFix.js";
import type Ui5TypeInfoMatcher from "../Ui5TypeInfoMatcher.js";
import { Ui5TypeInfo } from "../Ui5TypeInfo.js";
import { AmbientModuleCache } from "../AmbientModuleCache.js";
import { GlobalFixInfo } from "./getGlobalFixInfo.js";
import CallExpressionGeneratorFix, { CallExpressionGeneratorFixParams } from "./CallExpressionGeneratorFix.js";
import AccessExpressionGeneratorFix, { AccessExpressionGeneratorFixParams } from "./AccessExpressionGeneratorFix.js";
import PropertyAssignmentFix, { PropertyAssignmentFixParams } from "./PropertyAssignmentFix.js";
import PropertyAssignmentGeneratorFix, { PropertyAssignmentGeneratorFixParams } from "./PropertyAssignmentGeneratorFix.js";
import ObsoleteImportFix, { ObsoleteImportFixParams } from "./ObsoleteImportFix.js";
import { JqueryTypeInfo } from "../getJqueryTypeInfo.js";
export type FixCallback<T extends Fix = Fix> = (ui5TypeInfo: Ui5TypeInfo) => T;
export type FixTypeInfoMatcher = Ui5TypeInfoMatcher<FixCallback>;
export default class FixFactory {
    private checker;
    private ambientModuleCache;
    private collections;
    private constructor();
    static create(checker: ts.TypeChecker, ambientModuleCache: AmbientModuleCache): Promise<FixFactory>;
    getFix(node: ts.Node, ui5TypeInfo: Ui5TypeInfo): Fix | undefined;
    getJqueryTypeInfoForFix(node: ts.AccessExpression | ts.CallExpression, ui5TypeInfo: Ui5TypeInfo): JqueryTypeInfo | undefined;
    getGlobalFixInfo(node: ts.CallExpression | ts.AccessExpression): GlobalFixInfo | undefined;
}
export declare function accessExpressionFix(params: AccessExpressionFixParams): FixCallback<AccessExpressionFix>;
export declare function accessExpressionGeneratorFix(params: AccessExpressionGeneratorFixParams): FixCallback<AccessExpressionGeneratorFix>;
export declare function callExpressionFix(params: CallExpressionFixParams): FixCallback<CallExpressionFix>;
export declare function callExpressionGeneratorFix<GeneratorContext extends object = object>(params: CallExpressionGeneratorFixParams<GeneratorContext>): FixCallback<CallExpressionGeneratorFix<GeneratorContext>>;
export declare function propertyAssignmentFix(params: PropertyAssignmentFixParams): FixCallback<PropertyAssignmentFix>;
export declare function propertyAssignmentGeneratorFix<GeneratorContext extends object = object>(params: PropertyAssignmentGeneratorFixParams<GeneratorContext>): FixCallback<PropertyAssignmentGeneratorFix<GeneratorContext>>;
export declare function obsoleteImportFix(params: ObsoleteImportFixParams): FixCallback<ObsoleteImportFix>;
