import ts from "typescript";
import Fix from "./Fix.js";
;
export default class ObsoleteImportFix extends Fix {
    params;
    sourcePosition;
    constructor(params) {
        super();
        this.params = params;
    }
    visitLinterNode(node, sourcePosition) {
        if (!ts.isImportDeclaration(node.parent) || !ts.isSourceFile(node.parent.parent)) {
            return false;
        }
        const sourceFile = node.parent.parent;
        const relevantIdentifiers = new Set();
        sourceFile.forEachChild((childNode) => {
            if (!ts.isImportDeclaration(childNode)) {
                return;
            }
            if (childNode.moduleSpecifier &&
                ts.isStringLiteral(childNode.moduleSpecifier) &&
                childNode.moduleSpecifier.text === this.params.moduleName) {
                // We found the module import
                if (childNode.importClause?.namedBindings) {
                    if (ts.isNamedImports(childNode.importClause.namedBindings)) {
                        for (const element of childNode.importClause.namedBindings.elements) {
                            relevantIdentifiers.add(element.name.text);
                        }
                    }
                    else if (ts.isNamespaceImport(childNode.importClause.namedBindings)) {
                        relevantIdentifiers.add(childNode.importClause.namedBindings.name.text);
                    }
                }
                else if (childNode.importClause?.name) {
                    // Default import
                    relevantIdentifiers.add(childNode.importClause.name.text);
                }
            }
        });
        let identifierIsUsed = false;
        const findIdentifierUsage = (node) => {
            if (identifierIsUsed) {
                return;
            }
            if (ts.isIdentifier(node) && !ts.isImportClause(node.parent) &&
                relevantIdentifiers.has(node.text)) {
                identifierIsUsed = true;
                return;
            }
            ts.forEachChild(node, findIdentifierUsage);
        };
        ts.forEachChild(sourceFile, findIdentifierUsage);
        if (identifierIsUsed) {
            return false;
        }
        this.sourcePosition = sourcePosition;
        return true;
    }
    getNodeSearchParameters() {
        if (this.sourcePosition === undefined) {
            throw new Error("Position for search is not defined");
        }
        return {
            nodeTypes: [ts.SyntaxKind.StringLiteral],
            position: this.sourcePosition,
        };
    }
    visitAutofixNode(_node, _position, _sourceFile) {
        return true;
    }
    getObsoleteModuleDependencies() {
        return {
            moduleName: this.params.moduleName,
            usagePosition: 0,
        };
    }
}
//# sourceMappingURL=ObsoleteImportFix.js.map