import path from "node:path";
import posixPath from "node:path/posix";
;
/**
 * Normalize provided virtual paths to the original file paths
 */
export function transformVirtualPathToFilePath(virtualPath, { relFsBasePath, virBasePath, relFsBasePathTest, virBasePathTest }) {
    if (virtualPath.startsWith(virBasePath)) {
        return path.join(relFsBasePath, posixPath.relative(virBasePath, virtualPath));
    }
    else if (relFsBasePathTest && virBasePathTest && virtualPath.startsWith(virBasePathTest)) {
        return path.join(relFsBasePathTest, posixPath.relative(virBasePathTest, virtualPath));
    }
    else if (virtualPath.startsWith("/")) {
        return posixPath.relative("/", virtualPath);
    }
    else {
        throw new Error(`Resource path ${virtualPath} is not located within the virtual source or test directories of the project`);
    }
}
//# sourceMappingURL=virtualPathToFilePath.js.map