// For Library Version: 1.136.6

declare module "sap/insights/library" {}

declare module "sap/insights/CardHelper" {
  /**
   * Provides functionality for Insight cards CRUD operations.
   *
   * @since 1.102
   * @experimental As of version 1.102.
   */
  interface CardHelper {}
  const CardHelper: CardHelper;
  export default CardHelper;

  /**
   * Public (experimental) interface of the sap.insights.CardHelperService
   *
   * @experimental
   */
  export interface CardHelperService {
    __implements__sap_insights_CardHelperService: boolean;
    /**
     * Show preview for Add Card With Search Dialog
     *
     * @experimental
     */
    showAddCardWithSearchDialog: undefined;

    /**
     * Updates Cards Ranking in case of Drag & Drop of Cards
     *
     * @experimental
     *
     * @returns Returns an array of updated object
     */
    handleDndCardsRanking(
      /**
       * card drag index
       */
      iDragItemIndex: number,
      /**
       * card drop index
       */
      iDropItemIndex: number,
      /**
       * array of all cards
       */
      aCards: any[]
    ): any[];
    /**
     * Show preview for a given card
     *
     * @experimental
     *
     * @returns Returns promise, which generates preview for the passed card manifest
     */
    showCardPreview(
      /**
       * card manifest for which preview will be generated
       */
      oCard: object,
      /**
       * boolean to determine whether card can be transfrormed
       */
      bTransform: boolean,
      /**
       * object which includes type and message text related to Message
       */
      oCardMessageInfo: object,
      /**
       * text for confirm button on the dialog
       */
      sConfirmButtonText: string,
      /**
       * callback event to be called when confirm button is pressed
       */
      onConfirm: Function
    ): Promise<void>;
  }
}

declare module "sap/insights/CardsChannel" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  export default class CardsChannel extends BaseObject {
    /**
     * Provides a communication between card providers and consumers in FLP and included iframes.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.insights.CardsChannel with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CardsChannel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.insights.CardsChannel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Initialize the CardsChannel either with the FLP message broker or an internal implementation for iframes.
     *
     * @experimental
     *
     * @returns .
     */
    init(): Promise<void>;
    /**
     * Checks if the broker is enabled.
     *
     * @experimental
     *
     * @returns true if the broker is enabled
     */
    isEnabled(): boolean;
    /**
     * Send a list of all available cards to a given consumer or broadcast it to all consumers.
     *
     * @experimental
     *
     * @returns .
     */
    publishAvailableCards(
      /**
       * .
       */
      providerId: string,
      /**
       * .
       */
      cardInfos: CardInfo[],
      /**
       * .
       */
      consumerId: string
    ): Promise<void>;
    /**
     * Send a card to a given consumer or broadcast it to all consumers.
     *
     * @experimental
     *
     * @returns .
     */
    publishCard(
      /**
       * .
       */
      providerId: string,
      /**
       * .
       */
      card: Card,
      /**
       * .
       */
      consumerId?: string
    ): Promise<void>;
    /**
     * Register a card consumer with a unique id. The consumer will be notified through its callback when corresponding
     * messages are received.
     *
     * @experimental
     *
     * @returns .
     */
    registerConsumer(
      /**
       * Unique id of the consumer
       */
      id: string,
      /**
       * Implementation of the consumer
       */
      consumer: ICardConsumer
    ): Promise<void>;
    /**
     * Register a card provider with a unique id. The provider will be notified if new consumers get registered.
     *
     * @experimental
     *
     * @returns .
     */
    registerProvider(
      /**
       * Unique id of the provider
       */
      id: string,
      /**
       * Object implementing the ICardProvider interface
       */
      provider: ICardProvider
    ): Promise<void>;
    /**
     * Request a card from a given provider.
     *
     * @experimental
     *
     * @returns .
     */
    requestCard(
      /**
       * .
       */
      consumerId: string,
      /**
       * .
       */
      cardId: string,
      /**
       * .
       */
      providerId: string
    ): Promise<void>;
    /**
     * Request card creation to a given provider.
     *
     * @experimental
     *
     * @returns .
     */
    requestCardCreation(
      /**
       * .
       */
      consumerId: string,
      /**
       * .
       */
      card: Card,
      /**
       * .
       */
      providerId: string
    ): Promise<void>;
    /**
     * Unregister a previously registered consumer or provider.
     *
     * @experimental
     *
     * @returns .
     */
    unregister(
      /**
       * .
       */
      id: string
    ): Promise<void>;
  }
  /**
   * The card object
   *
   * @experimental
   */
  export type Card = {
    /**
     * Unique identifier for the card.
     */
    id: string;
    /**
     * manifest of the card.
     */
    descriptorContent: Object;
  };

  /**
   * The cardInfo object
   *
   * @experimental
   */
  export type CardInfo = {
    /**
     * Unique identifier for the card.
     */
    id: string;
    /**
     * Title of the card.
     */
    title: string;
    /**
     * Id of the parent app.
     */
    parentAppId: string;
    /**
     * Subtitle of the card
     */
    description: string;
  };

  /**
   * Interface required for classes that would like to consume cards using the `sap.insights.CardsChannel`.
   *
   * @experimental
   */
  export interface ICardConsumer {
    __implements__sap_insights_ICardConsumer: boolean;

    /**
     * Callback when a card is created for this consumer.
     *
     * @experimental
     */
    onCardProvided(
      /**
       * Unique id of the ICardsProvider that offers cards
       */
      providerId: string,

      card: object
    ): void;
    /**
     * Callback when cards are available.
     *
     * @experimental
     */
    onCardsAvailable(
      /**
       * Unique id of the ICardsProvider that offers cards
       */
      providerId: string,
      /**
       * Array of simple objects with card information
       */
      cardInfos: object[]
    ): void;
  }

  /**
   * Interface required for classes that would like to provide cards using the `sap.insights.CardsChannel`.
   *
   * @experimental
   */
  export interface ICardProvider {
    __implements__sap_insights_ICardProvider: boolean;

    /**
     * Callback when a consumer requests a specific card.
     *
     * @experimental
     */
    onCardRequested(
      /**
       * Unique id of the ICardsConsumer that offers cards
       */
      consumerId: string,
      /**
       * Unique id of a card
       */
      cardId: string
    ): void;
    /**
     * Callback when a consumer is connected.
     *
     * @experimental
     */
    onConsumerConnected(
      /**
       * Unique id of the ICardsConsumer that offers cards
       */
      consumerId: string
    ): void;
    /**
     * Callback when a consumer is disconnected.
     *
     * @experimental
     */
    onConsumerDisconnected(
      /**
       * Unique id of the ICardsConsumer that offers cards
       */
      consumerId: string
    ): void;
  }
}

declare module "sap/insights/channels/ContextChannel" {
  import BaseObject from "sap/ui/base/Object";

  import Metadata from "sap/ui/base/Metadata";

  export default class ContextChannel extends BaseObject {
    /**
     * Provides a communication between card providers and consumers in FLP and included iframes.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.insights.channels.ContextChannel with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContextChannel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.insights.channels.ContextChannel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Get the context from the active provider.
     *
     * @experimental
     *
     * @returns .
     */
    getContext(): Promise<object>;
    /**
     * Initialize the ContextChannel either with the FLP message broker or an internal implementation for iframes.
     *
     * @experimental
     *
     * @returns .
     */
    init(): Promise<void>;
    /**
     * Register a card provider with a unique id. The provider will be notified if new consumers get registered.
     *
     * @experimental
     *
     * @returns .
     */
    registerProvider(
      /**
       * Object implementing the TBD interface
       */
      provider: IContextProvider
    ): Promise<void>;
    /**
     * Unregister a previously registered consumer or provider.
     *
     * @experimental
     *
     * @returns .
     */
    unregisterProvider(
      /**
       * Object implementing the TBD interface
       */
      provider: IContextProvider
    ): Promise<void>;
  }
  /**
   * Interface required for classes that would like to provide cards using the `sap.insights.CardsChannel`.
   *
   * @experimental
   */
  export interface IContextProvider {
    __implements__sap_insights_channels_IContextProvider: boolean;

    /**
     * Getter of the current context as promise.
     *
     * @experimental
     *
     * @returns returns a promise of the context
     */
    getContext(): Promise<object>;
    /**
     * Get the unique identifier of the context provider (e.g. app id)
     *
     * @experimental
     *
     * @returns unique id of the context provider
     */
    getId(): string;
  }
}

declare module "sap/insights/ManageCards" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * This control shows list of all user cards and allows perform actions like change visibility, change order.
   * It also allows user to get preview of particular card, delete or copy.
   *
   * @since 1.119
   */
  export default class ManageCards extends Control {
    /**
     * Constructor for ManageCards.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor();

    /**
     * Creates a new subclass of class sap.insights.ManageCards with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ManageCards>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.insights.ManageCards.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Function to Clear Activities like navigation, filters
     *
     * @experimental As of version 1.119.
     */
    clearPage(): void;
    /**
     * Gets current value of property {@link #getCardId cardId}.
     *
     * Sets the cardId property which decides whether to render the details page or cardlist page, if cardId
     * is provided , cardDetails page is rendered
     *
     *
     * @returns Value of property `cardId`
     */
    getCardId(): string;
    /**
     * Gets current value of property {@link #getEnableResetAllCards enableResetAllCards}.
     *
     * Sets enableResetAllCards property
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableResetAllCards`
     */
    getEnableResetAllCards(): boolean;
    /**
     * Function to navigate to the specified page, if no sPageId provided navigate to CardList by default
     */
    navigateTo(
      /**
       * oEvent object
       */
      oEvent: Object,
      /**
       * page id to which to navigate to
       */
      sPageId: String
    ): void;
    /**
     * Sets a new value for property {@link #getCardId cardId}.
     *
     * Sets the cardId property which decides whether to render the details page or cardlist page, if cardId
     * is provided , cardDetails page is rendered
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCardId(
      /**
       * New value for property `cardId`
       */
      sCardId?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEnableResetAllCards enableResetAllCards}.
     *
     * Sets enableResetAllCards property
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableResetAllCards(
      /**
       * New value for property `enableResetAllCards`
       */
      bEnableResetAllCards?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ManageCards constructor.
   */
  export interface $ManageCardsSettings extends $ControlSettings {
    /**
     * Sets enableResetAllCards property
     */
    enableResetAllCards?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the cardId property which decides whether to render the details page or cardlist page, if cardId
     * is provided , cardDetails page is rendered
     */
    cardId?: string | PropertyBindingInfo;
  }
}

declare namespace sap {
  interface IUI5DefineDependencyNames {
    "sap/insights/CardHelper": undefined;

    "sap/insights/CardsChannel": undefined;

    "sap/insights/channels/ContextChannel": undefined;

    "sap/insights/library": undefined;

    "sap/insights/ManageCards": undefined;
  }
}
