// For Library Version: 1.136.8

declare module "sap/f/library" {
  export interface IShellBar {
    __implements__sap_f_IShellBar: boolean;
  }

  export interface IDynamicPageStickyContent {
    __implements__sap_f_IDynamicPageStickyContent: boolean;
  }
}

declare module "sap/m/library" {
  import Control from "sap/ui/core/Control";

  import Locale from "sap/ui/core/Locale";

  import LocaleData from "sap/ui/core/LocaleData";

  import RenderManager from "sap/ui/core/RenderManager";

  import { CSSColor, URI } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import Slider from "sap/m/Slider";

  import RangeSlider from "sap/m/RangeSlider";

  /**
   * Hide the soft keyboard.
   *
   * @since 1.20
   */
  export function closeKeyboard(): void;
  /**
   * Returns invalid date value of UI5.
   *
   * @since 1.10
   * @deprecated As of version 1.12. UI5 returns null for invalid date
   *
   * @returns `null` as value for an invalid date
   */
  export function getInvalidDate(): null;
  /**
   * Search given control's parents and try to find iScroll.
   *
   * @since 1.11
   *
   * @returns iScroll reference or `undefined` if cannot find
   */
  export function getIScroll(
    /**
     * Control to start the search at
     */
    oControl: Control
  ): Object | undefined;
  /**
   * Finds default locale settings once and returns always the same.
   *
   * We should not need to create new instance to get same locale settings This method keeps the locale instance
   * in the scope and returns the same after first run
   *
   * @since 1.10
   *
   * @returns Locale instance
   */
  export function getLocale(): Locale;
  /**
   * Finds default locale data once and returns always the same.
   *
   * @since 1.10
   *
   * @returns LocaleData instance
   */
  export function getLocaleData(): LocaleData;
  /**
   * Search given control's parents and try to find a ScrollDelegate.
   *
   * @since 1.11
   *
   * @returns ScrollDelegate or `undefined` if it cannot be found
   */
  export function getScrollDelegate(
    /**
     * Starting point for the search
     */
    oControl: Control,
    /**
     * Whether the search should stop on component level (`false`) or not
     */
    bGlobal: boolean
  ): Object | undefined;
  /**
   * Checks if the given parameter is a valid JsDate Object.
   *
   * @since 1.10
   *
   * @returns Whether the given parameter is a valid JsDate Object.
   */
  export function isDate(
    /**
     * Any variable to test.
     */
    value: any
  ): boolean;
  /**
   * Available Background Design.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BackgroundDesign'.
   */
  export enum BackgroundDesign {
    /**
     * A solid background color dependent on the theme.
     */
    Solid = "Solid",
    /**
     * A translucent background depending on the opacity value of the theme.
     */
    Translucent = "Translucent",
    /**
     * Transparent background.
     */
    Transparent = "Transparent",
  }
  /**
   * Helper for rendering themable background.
   *
   * @since 1.12
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  interface BackgroundHelper {
    /**
     * Adds CSS classes and styles to the given RenderManager, depending on the given configuration for background
     * color and background image. To be called by control renderers supporting the global themable background
     * image within their root tag, before they call openEnd, voidEnd, writeClasses() and writeStyles().
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    addBackgroundColorStyles(
      /**
       * The RenderManager
       */
      rm: RenderManager,
      /**
       * A configured custom background color for the control, if any
       */
      sBgColor?: CSSColor,
      /**
       * The configured custom background image for the control, if any
       */
      sBgImgUrl?: URI
    ): void;
    /**
     * Renders an HTML tag into the given RenderManager which carries the background image which is either configured
     * and given or coming from the current theme. Should be called right after the opening root tag has been
     * completed, so this is the first child element inside the control.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    renderBackgroundImageTag(
      /**
       * The RenderManager
       */
      rm: RenderManager,
      /**
       * Control within which the tag will be rendered; its ID will be used to generate the element ID
       */
      oControl: Control,
      /**
       * A CSS class or an array of CSS classes to add to the element
       */
      vCssClass: string | string[],
      /**
       * The image of a configured background image; if this is not given, the theme background will be used and
       * also the other settings are ignored.
       */
      sBgImgUrl?: URI,
      /**
       * Whether the background image should be repeated/tiled (or stretched)
       */
      bRepeat?: boolean,
      /**
       * The background image opacity, if any
       */
      fOpacity?: float
    ): void;
  }
  export const BackgroundHelper: BackgroundHelper;

  /**
   * Types of animation performed by {@link sap.m.BadgeEnabler}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeAnimationType'.
   *
   * @since 1.87
   */
  export enum BadgeAnimationType {
    /**
     * Badge indicator will perform Appear,Update,and Disappear animation.
     */
    Full = "Full",
    /**
     * No animation is performed.
     */
    None = "None",
    /**
     * Badge indicator will perform only Update animation (suitable for controls, which invalidate often).
     */
    Update = "Update",
  }
  /**
   * Types of state of {@link sap.m.BadgeEnabler} to expose its current state.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeState'.
   *
   * @since 1.81
   */
  export enum BadgeState {
    /**
     * Informing interested parties that the badge has appeared.
     */
    Appear = "Appear",
    /**
     * Informing interested parties that the badge has disappeared.
     */
    Disappear = "Disappear",
    /**
     * Informing interested parties that the badge has been updated.
     */
    Updated = "Updated",
  }
  /**
   * Types of badge rendering style.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BadgeStyle'.
   */
  export enum BadgeStyle {
    /**
     * Attention style. This badge is rendered as a single dot meant to grab attention.
     */
    Attention = "Attention",
    /**
     * Default style. Use for badges which contain text or numbers.
     */
    Default = "Default",
  }
  /**
   * Types of the Bar design.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BarDesign'.
   *
   * @since 1.20
   */
  export enum BarDesign {
    /**
     * The Bar can be inserted into other controls and if the design is "Auto" then it inherits the design from
     * parent control.
     */
    Auto = "Auto",
    /**
     * The bar will be styled like a footer of the page.
     */
    Footer = "Footer",
    /**
     * The bar will be styled like a header of the page.
     */
    Header = "Header",
    /**
     * The bar will be styled like a subheader of the page.
     */
    SubHeader = "SubHeader",
  }
  /**
   * Available Border Design.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BorderDesign'.
   */
  export enum BorderDesign {
    /**
     * Specifies no border.
     */
    None = "None",
    /**
     * A solid border color dependent on the theme.
     */
    Solid = "Solid",
  }
  /**
   * Variations of the {@link sap.m.Breadcrumbs} separators.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'BreadcrumbsSeparatorStyle'.
   *
   * @since 1.69
   */
  export enum BreadcrumbsSeparatorStyle {
    /**
     * The separator will appear as "\"
     */
    BackSlash = "BackSlash",
    /**
     * The separator will appear as "\\"
     */
    DoubleBackSlash = "DoubleBackSlash",
    /**
     * The separator will appear as ">>"
     */
    DoubleGreaterThan = "DoubleGreaterThan",
    /**
     * The separator will appear as "//"
     */
    DoubleSlash = "DoubleSlash",
    /**
     * The separator will appear as ">"
     */
    GreaterThan = "GreaterThan",
    /**
     * The separator will appear as "/"
     */
    Slash = "Slash",
  }
  /**
   * Enumeration for possible Button accessibility roles.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ButtonAccessibleRole'.
   *
   * @since 1.114.0
   */
  export enum ButtonAccessibleRole {
    /**
     * Default mode.
     */
    Default = "Default",
    /**
     * Button will receive `role="Link"` attibute.
     */
    Link = "Link",
  }
  /**
   * Different predefined button types for the {@link sap.m.Button sap.m.Button}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ButtonType'.
   */
  export enum ButtonType {
    /**
     * Accept type
     */
    Accept = "Accept",
    /**
     * Attention type
     *
     * @since 1.77
     */
    Attention = "Attention",
    /**
     * Back type (back navigation button for header)
     */
    Back = "Back",
    /**
     * Critical type
     *
     * **Note:** To be used only in controls of type `sap.m.Button`. When the button opens a `sap.m.MessagePopover`
     * list, use this `ButtonType` if the message with the highest severity is `Warning` type.
     *
     * @since 1.73
     */
    Critical = "Critical",
    /**
     * Default type (no special styling)
     */
    Default = "Default",
    /**
     * Emphasized type
     */
    Emphasized = "Emphasized",
    /**
     * Ghost type
     */
    Ghost = "Ghost",
    /**
     * Negative type
     *
     * **Note:** To be used only in controls of type `sap.m.Button`. When the button opens a `sap.m.MessagePopover`
     * list, use this `ButtonType` if the message with the highest severity is `Error` type.
     *
     * @since 1.73
     */
    Negative = "Negative",
    /**
     * Neutral type
     *
     * **Note:** To be used only in controls of type `sap.m.Button`. When the button opens a `sap.m.MessagePopover`
     * list, use this `ButtonType` if the message with the highest severity is `Information` type.
     *
     * @since 1.73
     */
    Neutral = "Neutral",
    /**
     * Reject style
     */
    Reject = "Reject",
    /**
     * Success type
     *
     * **Note:** To be used only in controls of type `sap.m.Button`. When the button opens a `sap.m.MessagePopover`
     * list, use this `ButtonType` if the message with the highest severity is `Success` type.
     *
     * @since 1.73
     */
    Success = "Success",
    /**
     * Transparent type
     */
    Transparent = "Transparent",
    /**
     * Unstyled type (no styling)
     */
    Unstyled = "Unstyled",
    /**
     * Up type (up navigation button for header)
     */
    Up = "Up",
  }
  /**
   * Carousel arrows align.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselArrowsPlacement'.
   */
  export enum CarouselArrowsPlacement {
    /**
     * Carousel arrows are placed on the sides of the current Carousel page.
     */
    Content = "Content",
    /**
     * Carousel arrows are placed on the sides of the page indicator of the Carousel.
     */
    PageIndicator = "PageIndicator",
  }
  /**
   * Types for the placement of the page indicator of the Carousel control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselPageIndicatorPlacementType'.
   */
  export enum CarouselPageIndicatorPlacementType {
    /**
     * Page indicator will be placed at the bottom of the Carousel.
     */
    Bottom = "Bottom",
    /**
     * Page indicator will be placed over the Carousel content, bottom aligned.
     */
    OverContentBottom = "OverContentBottom",
    /**
     * Page indicator will be placed over the Carousel content, top aligned.
     */
    OverContentTop = "OverContentTop",
    /**
     * Page indicator will be placed at the top of the Carousel.
     */
    Top = "Top",
  }
  /**
   * Defines how pages will be scrolled, when clicking the arrow.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'CarouselScrollMode'.
   */
  export enum CarouselScrollMode {
    /**
     * Pages will be scrolled one at a time
     */
    SinglePage = "SinglePage",
    /**
     * Pages will be scrolled, depending on the value of `visiblePagesCount`
     */
    VisiblePages = "VisiblePages",
  }
  /**
   * Defines the rendering type of the TileAttribute
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ContentConfigType'.
   *
   * @since 1.122
   * @experimental As of version 1.122.
   */
  export enum ContentConfigType {
    /**
     * Renders a link inside the TileAttribute
     */
    Link = "Link",
    /**
     * Renders a text inside the TileAttribute
     */
    Text = "Text",
  }
  /**
   * A subset of DateTimeInput types that fit to a simple API returning one string.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DateTimeInputType'.
   *
   * @deprecated As of version 1.32.8. Instead, use dedicated `sap.m.DatePicker` and/or `sap.m.TimePicker`
   * controls.
   */
  export enum DateTimeInputType {
    /**
     * An input control for specifying a date value. The user can select a month, day of the month, and year.
     *
     * @deprecated As of version 1.22.0. Instead, use dedicated `sap.m.DatePicker` control.
     */
    Date = "Date",
    /**
     * An input control for specifying a date and time value. The user can select a month, day of the month,
     * year, and time of day.
     *
     * @deprecated As of version 1.32.8. Instead, use dedicated `sap.m.DatePicker` and `sap.m.TimePicker` controls.
     */
    DateTime = "DateTime",
    /**
     * An input control for specifying a time value. The user can select the hour, minute, and optionally AM
     * or PM.
     *
     * @deprecated As of version 1.32.8. Instead, use dedicated `sap.m.TimePicker` control.
     */
    Time = "Time",
  }
  /**
   * Enum of the available deviation markers for the NumericContent control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DeviationIndicator'.
   *
   * @since 1.34
   */
  export enum DeviationIndicator {
    /**
     * The actual value is less than the target value.
     */
    Down = "Down",
    /**
     * No value.
     */
    None = "None",
    /**
     * The actual value is more than the target value.
     */
    Up = "Up",
  }
  /**
   * Enum for the ARIA role of {@link sap.m.Dialog} control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DialogRoleType'.
   *
   * @since 1.65
   */
  export enum DialogRoleType {
    /**
     * Represents the ARIA role `alertdialog`.
     */
    AlertDialog = "alertdialog",
    /**
     * Represents the ARIA role `dialog`.
     */
    Dialog = "dialog",
  }
  /**
   * Enum for the type of {@link sap.m.Dialog} control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DialogType'.
   */
  export enum DialogType {
    /**
     * Dialog with type Message looks the same as the Standard Dialog in Android. It puts the Left and the Right
     * buttons at the bottom of the Dialog in iOS.
     */
    Message = "Message",
    /**
     * This is the default value for Dialog type.
     *
     * The Standard Dialog in iOS has a header on the top. The Left and the Right buttons are put inside the
     * header. In Android, the Left and the Right buttons are put at the bottom of the Dialog.
     */
    Standard = "Standard",
  }
  /**
   * Enum for the state of {@link sap.m.DraftIndicator} control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DraftIndicatorState'.
   */
  export enum DraftIndicatorState {
    /**
     * This is the default value for DraftIndicatorState type. This state has no visual information displayed.
     */
    Clear = "Clear",
    /**
     * Indicates that the draft is already saved
     */
    Saved = "Saved",
    /**
     * Indicates that the draft currently is being saved
     */
    Saving = "Saving",
  }
  /**
   * Defines the groups in {@link sap.m.DynamicDateRange}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'DynamicDateRangeGroups'.
   *
   * @since 1.118
   */
  export enum DynamicDateRangeGroups {
    /**
     * Group of options that provide selection of date ranges.
     */
    DateRanges = "DateRanges",
    /**
     * Group of options that provide selection of month related ranges.
     */
    Month = "Month",
    /**
     * Group of options that provide selection of quarter related ranges.
     */
    Quarters = "Quarters",
    /**
     * Group of options that provide selection of single dates.
     */
    SingleDates = "SingleDates",
    /**
     * Group of options that provide selection of week related ranges.
     */
    Weeks = "Weeks",
    /**
     * Group of options that provide selection of year related ranges.
     */
    Years = "Years",
  }
  /**
   * Defines the `value` property of the DynamicDateRange control. The object has two properties: 'operator'
   * - a string, the key of a DynamicDateOption 'values' - an array of parameters for the same option see
   * {@link sap.m.DynamicDateRange}
   *
   * @since 1.111
   */
  export type DynamicDateRangeValue = {
    /**
     * The key of a DynamicDateOption.
     */
    operator: string;
    /**
     * An array of parameters for the same option.
     */
    values: Array<Date | int | string | any>;
  };

  /**
   * Modes in which a control will render empty indicator if its content is empty.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'EmptyIndicatorMode'.
   *
   * @since 1.87
   */
  export enum EmptyIndicatorMode {
    /**
     * Empty indicator will be rendered depending on the context in which the control is placed. If one of the
     * parents has the context class sapMShowEmpty-CTX then the empty indicator will be shown.
     */
    Auto = "Auto",
    /**
     * Empty indicator is never rendered.
     */
    Off = "Off",
    /**
     * Empty indicator is rendered always when the control's content is empty.
     */
    On = "On",
  }
  /**
   * Expandable text overflow mode
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ExpandableTextOverflowMode'.
   */
  export enum ExpandableTextOverflowMode {
    /**
     * InPlace
     */
    InPlace = "InPlace",
    /**
     * Popover
     */
    Popover = "Popover",
  }
  /**
   * FacetFilterList data types.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FacetFilterListDataType'.
   */
  export enum FacetFilterListDataType {
    /**
     * An input control for specifying a Boolean value
     */
    Boolean = "Boolean",
    /**
     * An input control for specifying a date value. The user can select a month, day of the month, and year.
     */
    Date = "Date",
    /**
     * An input control for specifying a date and time value. The user can select a month, day of the month,
     * year, and time of day.
     */
    DateTime = "DateTime",
    /**
     * An input control for specifying a Float value
     */
    Float = "Float",
    /**
     * >An input control for specifying an Integer value
     */
    Integer = "Integer",
    /**
     * An input control for specifying a String value
     */
    String = "String",
    /**
     * An input control for specifying a time value. The user can select the hour, minute, and optionally AM
     * or PM.
     */
    Time = "Time",
  }
  /**
   * Used by the FacetFilter control to adapt its design according to type.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FacetFilterType'.
   */
  export enum FacetFilterType {
    /**
     * Forces FacetFilter to display in light mode.
     */
    Light = "Light",
    /**
     * Forces FacetFilter to display facet lists as a row of buttons, one button per facet.
     *
     * The FacetFilter will automatically adapt to the Light type when it detects smart phone sized displays.
     */
    Simple = "Simple",
  }
  /**
   * An object type that represents sap.m.upload.FilterPanel fields properties.
   */
  export type FilterPanelField = {
    /**
     * field name.
     */
    label: string;
    /**
     * model path.
     */
    path: string;
  };

  /**
   * Available options for the layout of container lines along the cross axis of the flexbox layout.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignContent'.
   */
  export enum FlexAlignContent {
    /**
     * Line are packed toward the center of the line.
     */
    Center = "Center",
    /**
     * Lines are packed toward the end of the line.
     */
    End = "End",
    /**
     * Inherits the value from its parent.
     */
    Inherit = "Inherit",
    /**
     * Lines are evenly distributed in the line, with half-size spaces on either end.
     */
    SpaceAround = "SpaceAround",
    /**
     * Lines are evenly distributed in the line.
     */
    SpaceBetween = "SpaceBetween",
    /**
     * Lines are packed toward the start of the line.
     */
    Start = "Start",
    /**
     * Lines stretch to take up the remaining space.
     */
    Stretch = "Stretch",
  }
  /**
   * Available options for the layout of all elements along the cross axis of the flexbox layout.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignItems'.
   */
  export enum FlexAlignItems {
    /**
     * If the flex item`s inline axes are the same as the cross axis, this value is identical to "Start".
     *
     * Otherwise, it participates in baseline alignment: all participating box items on the line are aligned
     * such that their baselines align, and the item with the largest distance between its baseline and its
     * cross-start margin edge is placed flush against the cross-start edge of the line.
     */
    Baseline = "Baseline",
    /**
     * The flex item's margin boxes are centered in the cross axis within the line.
     */
    Center = "Center",
    /**
     * The cross-start margin edges of the flex items are placed flush with the cross-end edge of the line.
     */
    End = "End",
    /**
     * Inherits the value from its parent.
     */
    Inherit = "Inherit",
    /**
     * The cross-start margin edges of the flex items are placed flush with the cross-start edge of the line.
     */
    Start = "Start",
    /**
     * Make the cross size of the item's margin boxes as close to the same size as the line as possible.
     */
    Stretch = "Stretch",
  }
  /**
   * Available options for the layout of individual elements along the cross axis of the flexbox layout overriding
   * the default alignment.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexAlignSelf'.
   */
  export enum FlexAlignSelf {
    /**
     * Takes up the value of alignItems from the parent FlexBox
     */
    Auto = "Auto",
    /**
     * If the flex item's inline axis is the same as the cross axis, this value is identical to "Start".
     *
     * Otherwise, it participates in baseline alignment: all participating box items on the line are aligned
     * such that their baselines align, and the item with the largest distance between its baseline and its
     * cross-start margin edge is placed flush against the cross-start edge of the line.
     */
    Baseline = "Baseline",
    /**
     * The flex item's margin box is centered in the cross axis within the line.
     */
    Center = "Center",
    /**
     * The cross-start margin edges of the flex item is placed flush with the cross-end edge of the line.
     */
    End = "End",
    /**
     * Inherits the value from its parent.
     */
    Inherit = "Inherit",
    /**
     * The cross-start margin edges of the flex item is placed flush with the cross-start edge of the line.
     */
    Start = "Start",
    /**
     * Make the cross size of the item's margin box as close to the same size as the line as possible.
     */
    Stretch = "Stretch",
  }
  /**
   * Available directions for flex layouts.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexDirection'.
   */
  export enum FlexDirection {
    /**
     * Flex items are laid out along the direction of the block axis (usually top to bottom).
     */
    Column = "Column",
    /**
     * Flex items are laid out along the reverse direction of the block axis (usually bottom to top).
     */
    ColumnReverse = "ColumnReverse",
    /**
     * Inherits the value from its parent.
     */
    Inherit = "Inherit",
    /**
     * Flex items are laid out along the direction of the inline axis (text direction).
     */
    Row = "Row",
    /**
     * Flex items are laid out along the reverse direction of the inline axis (against the text direction).
     */
    RowReverse = "RowReverse",
  }
  /**
   * Available options for the layout of elements along the main axis of the flexbox layout.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexJustifyContent'.
   */
  export enum FlexJustifyContent {
    /**
     * Flex items are packed toward the center of the line.
     */
    Center = "Center",
    /**
     * Flex items are packed toward the end of the line.
     */
    End = "End",
    /**
     * Inherits the value from its parent.
     */
    Inherit = "Inherit",
    /**
     * Flex items are evenly distributed in the line, with half-size spaces on either end.
     */
    SpaceAround = "SpaceAround",
    /**
     * Flex items are evenly distributed in the line.
     */
    SpaceBetween = "SpaceBetween",
    /**
     * Flex items are packed toward the start of the line.
     */
    Start = "Start",
  }
  /**
   * Determines the type of HTML elements used for rendering controls.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexRendertype'.
   */
  export enum FlexRendertype {
    /**
     * The UI5 controls are not wrapped in an additional HTML element, the surrounding Flex Box is a DIV element.
     *
     * @since 1.42.1
     */
    Bare = "Bare",
    /**
     * The UI5 controls are wrapped in DIV elements.
     */
    Div = "Div",
    /**
     * The UI5 controls are wrapped in LI elements, the surrounding Flex Box is an unordered list (UL).
     */
    List = "List",
  }
  /**
   * Available options for the wrapping behavior of a flex container.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FlexWrap'.
   */
  export enum FlexWrap {
    /**
     * The flex container is single-line.
     */
    NoWrap = "NoWrap",
    /**
     * The flex container is multi-line.
     */
    Wrap = "Wrap",
    /**
     * The flex container is multi-line with the cross-axis start and end being swapped.
     */
    WrapReverse = "WrapReverse",
  }
  /**
   * Enum for possible frame size types for sap.m.TileContent and sap.m.GenericTile control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'FrameType'.
   *
   * @since 1.34.0
   */
  export enum FrameType {
    /**
     * The Auto frame type that adjusts the size of the control to the content. Support for this type in sap.m.GenericTile
     * is deprecated since 1.48.0.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    Auto = "Auto",
    /**
     * The 2x1 frame type. **Note:** The 2x1 frame type is currently only supported for Generic tile.
     *
     * @since 1.83
     */
    OneByHalf = "OneByHalf",
    /**
     * The 2x2 frame type.
     */
    OneByOne = "OneByOne",
    /**
     * The 4x1 frame type. **Note:** The 4x1 frame type is currently only supported for Generic tile.
     *
     * @since 1.83
     */
    TwoByHalf = "TwoByHalf",
    /**
     * The 4x2 frame type.
     */
    TwoByOne = "TwoByOne",
    /**
     * The 2/3 frame type.
     *
     * @deprecated As of version 1.48.0.
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    TwoThirds = "TwoThirds",
  }
  /**
   * Design modes for the `GenericTag` control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTagDesign'.
   *
   * @since 1.62.0
   */
  export enum GenericTagDesign {
    /**
     * Everything from the control is rendered.
     */
    Full = "Full",
    /**
     * Everything from the control is rendered except the status icon.
     */
    StatusIconHidden = "StatusIconHidden",
  }
  /**
   * Value states for the `GenericTag` control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTagValueState'.
   *
   * @since 1.62.0
   */
  export enum GenericTagValueState {
    /**
     * Warning icon is rendered that overrides the control set in the `value` aggregation of the `GenericTag`
     * control.
     */
    Error = "Error",
    /**
     * The value is rendered in its normal state.
     */
    None = "None",
  }
  /**
   * Defines the mode of GenericTile.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTileMode'.
   *
   * @since 1.38.0
   */
  export enum GenericTileMode {
    /**
     * Action Mode (Two lines for the header).
     *
     * Generic Tile renders buttons that are specified under 'actionButtons' aggregation
     *
     * @experimental As of version 1.96.
     */
    ActionMode = "ActionMode",
    /**
     * Article Mode (Two lines for the header and one line for the subtitle).
     *
     * Enables Article Mode.
     *
     * @experimental As of version 1.96.
     */
    ArticleMode = "ArticleMode",
    /**
     * Default mode (Two lines for the header and one line for the subtitle).
     */
    ContentMode = "ContentMode",
    /**
     * Header mode (Four lines for the header and one line for the subtitle).
     */
    HeaderMode = "HeaderMode",
    /**
     * Icon mode.
     *
     * GenericTile displays a combination of icon and header title.
     *
     * It is applicable only for the OneByOne FrameType and TwoByHalf FrameType.
     *
     * @since 1.96
     * @experimental As of version 1.96.
     */
    IconMode = "IconMode",
    /**
     * Line mode (Implemented for both, cozy and compact densities).
     *
     * Generic Tile is displayed as in-line element, header and subheader are displayed in one line. In case
     * the texts need more than one line, the representation depends on the used density. **Cozy:** The text
     * will be truncated and the full text is shown in a tooltip as soon as the tile is hovered (desktop only).
     * **Compact:** Header and subheader are rendered continuously spanning multiple lines, no tooltip is provided).
     *
     * @since 1.44.0
     */
    LineMode = "LineMode",
  }
  /**
   * Defines the scopes of GenericTile enabling the developer to implement different "flavors" of tiles.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'GenericTileScope'.
   *
   * @since 1.46.0
   */
  export enum GenericTileScope {
    /**
     * More action scope (Only the More icon is added to the tile)
     *
     * @since 1.76
     */
    ActionMore = "ActionMore",
    /**
     * Remove action scope (Only the Remove icon is added to the tile)
     *
     * @since 1.76
     */
    ActionRemove = "ActionRemove",
    /**
     * Action scope (Possible footer and Error State information is overlaid, "Remove" and "More" icons are
     * added to the tile).
     */
    Actions = "Actions",
    /**
     * Default scope (The default scope of the tile, no action icons are rendered).
     */
    Display = "Display",
  }
  /**
   * Different levels for headers.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'HeaderLevel'.
   */
  export enum HeaderLevel {
    /**
     * Header level 1
     */
    H1 = "H1",
    /**
     * Header level 2
     */
    H2 = "H2",
    /**
     * Header level 3
     */
    H3 = "H3",
    /**
     * Header level 4
     */
    H4 = "H4",
    /**
     * Header level 5
     */
    H5 = "H5",
    /**
     * Header level 6
     */
    H6 = "H6",
  }
  /**
   * Interface for controls which implement the notification badge concept.
   *
   * @since 1.80
   */
  export interface IBadge {
    __implements__sap_m_IBadge: boolean;
  }

  /**
   * Interface for controls which are suitable as a Header, Subheader or Footer of a Page. If the control
   * does not want to get a context base style class, it has to implement the isContextSensitive method and
   * return false
   *
   * @since 1.22
   */
  export interface IBar {
    __implements__sap_m_IBar: boolean;
  }

  /**
   * Allowed tags for the implementation of the IBar interface.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IBarHTMLTag'.
   *
   * @since 1.22
   */
  export enum IBarHTMLTag {
    /**
     * Renders as a div element.
     */
    Div = "Div",
    /**
     * Renders as a footer element.
     */
    Footer = "Footer",
    /**
     * Renders as a header element.
     */
    Header = "Header",
  }
  /**
   * Interface for controls which have the meaning of a breadcrumbs navigation.
   *
   * @since 1.52
   */
  export interface IBreadcrumbs {
    __implements__sap_m_IBreadcrumbs: boolean;
  }

  /**
   * Represents an interface for controls, which are suitable as items for the sap.m.IconTabBar.
   */
  export interface IconTab {
    __implements__sap_m_IconTab: boolean;
  }

  /**
   * Specifies `IconTabBar` tab density mode.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabDensityMode'.
   */
  export enum IconTabDensityMode {
    /**
     * Compact. In this mode the tabs will be set explicitly to compact mode independent of what mode is applied
     * globally.
     */
    Compact = "Compact",
    /**
     * Cozy. In this mode the tabs will be set explicitly to compact mode independent of what mode is applied
     * globally.
     */
    Cozy = "Cozy",
    /**
     * Inherit. In this mode the global configuration of the density mode will be applied.
     */
    Inherit = "Inherit",
  }
  /**
   * Available Filter Item Design.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabFilterDesign'.
   */
  export enum IconTabFilterDesign {
    /**
     * A horizontally layouted design providing more space for texts.
     */
    Horizontal = "Horizontal",
    /**
     * A vertically layouted design using minimum horizontal space.
     */
    Vertical = "Vertical",
  }
  /**
   * Available Interaction Modes.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabFilterInteractionMode'.
   *
   * @experimental As of version 1.121. Behavior might change.
   */
  export enum IconTabFilterInteractionMode {
    /**
     * The item is selectable if it has own content. Select event will not be fired if it has no own content.
     * Note: When IconTabHeader is placed in ToolHeader the items will act as selectable items even if they
     * don’t explicitly have content.
     */
    Auto = "Auto",
    /**
     * The item is selectable and select event will be fired.
     */
    Select = "Select",
    /**
     * The item is selectable (and select event is fired) only if it doesn't have any sub items. Select event
     * will not be fired if it has sub items.
     */
    SelectLeavesOnly = "SelectLeavesOnly",
  }
  /**
   * Specifies `IconTabBar` header mode.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'IconTabHeaderMode'.
   */
  export enum IconTabHeaderMode {
    /**
     * Inline. In this mode when the `count` and the `text` are set, they are displayed in one line.
     */
    Inline = "Inline",
    /**
     * Standard. In this mode when the `count` and the `text` are set, they are displayed in two separate lines.
     */
    Standard = "Standard",
  }
  /**
   * Determines how the source image is used on the output DOM element.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ImageMode'.
   *
   * @since 1.30.0
   */
  export enum ImageMode {
    /**
     * The image is rendered with 'span' tag and the 'src' property is set to the 'background-image' CSS style
     * on the output DOM element
     */
    Background = "Background",
    /**
     * The image is rendered with 'img' tag and the 'src' property is set to the src attribute on the output
     * DOM element.
     */
    Image = "Image",
    /**
     * The image is rendered with 'div' tag, containing the inline 'svg' **Note:** Please, be aware that this
     * feature works under the Browser's Cross-Origin Resource Sharing (CORS) policy. This means that a web
     * application using those APIs can only request resources from the same origin the application was loaded
     * from unless the response from other origins includes the right CORS headers.
     *
     * @experimental As of version 1.106.
     */
    InlineSvg = "InlineSvg",
  }
  /**
   * Interface for controls which are suitable to be added as items of sap.m.Menu.
   *
   * @since 1.127.0
   */
  export interface IMenuItem {
    __implements__sap_m_IMenuItem: boolean;
  }

  /**
   * The object contains accessibility state for a control.
   *
   * @since 1.111
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type InputBaseAccessibilityState = {
    /**
     * The WAI-ARIA role which is implemented by the control.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    role?: string;
    /**
     * Whether the control is invalid.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    invalid?: boolean;
    /**
     * The errormessage property.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    errormessage?: string;
    /**
     * The labelledby property.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    labelledby?: {
      value: string;

      append: boolean;
    };
    /**
     * The describedby property.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    describedby?: {
      value: string;

      append: boolean;
    };
    /**
     * Whether the control is disabled. If not relevant, it shouldn`t be set or set as `null`.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    disabled?: boolean | null;
    /**
     * Whether the control is readonly. If not relevant, it shouldn`t be set or set as `null`.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    readonly?: boolean | null;
  };

  /**
   * Defines the available content sizes for the `InputListItem` control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputListItemContentSize'.
   */
  export enum InputListItemContentSize {
    /**
     * Large: Recommended for larger input controls, such as {@link sap.m.Input} or {@link sap.m.RatingIndicator}.
     * If there is limited space, the input control moves to a new line below the label.
     */
    L = "L",
    /**
     * Small: Recommended for smaller controls, such as {@link sap.m.Switch} or {@link sap.m.Checkbox}. If there
     * is limited space, only the label is wrapped. The input control is always right-aligned horizontally and
     * middle-aligned vertically.
     */
    S = "S",
  }
  /**
   * Suggestion helper for `sap.m.Input` fields when used with an OData model.
   *
   * Creates a multi-column suggest list for an `sap.m.Input` field based on a `ValueList` annotation. The
   * `ValueList` annotation will be resolved via the binding information of the input field.
   *
   * If the annotation describes multiple input parameters, the suggest provider will resolve all of these
   * relative to the context of the input field and use them for the suggest query. The suggest provider will
   * write all values that are described as output parameters back to the model (relative to the context of
   * the input field). This can only be done if the model runs in "TwoWay" binding mode. Both features can
   * be switched off via the `bResolveInput/bResolveOutput` parameter of the suggest function.
   *
   * @since 1.21.2
   * @deprecated As of version 1.120. In case of SAPUI5, see demokit sample 'Smart Field with ValueList Annotation'.
   * In case of OpenUI5, see demokit sample 'Input - Suggestions - Dynamic'.
   */
  interface InputODataSuggestProvider {
    suggest(
      oEvent: Event,
      /**
       * SuggestProvider resolves all input parameters for the data query
       */
      bResolveInput: boolean,
      /**
       * SuggestProvider writes back all output parameters.
       */
      bResolveOutput: boolean,
      /**
       * If iLength is provided only these number of entries will be requested.
       */
      iLength: int
    ): void;
  }
  export const InputODataSuggestProvider: InputODataSuggestProvider;

  /**
   * Defines how the input display text should be formatted.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputTextFormatMode'.
   *
   * @since 1.44.0
   */
  export enum InputTextFormatMode {
    /**
     * Key
     */
    Key = "Key",
    /**
     * A key-value pair formatted like "(key) text"
     */
    KeyValue = "KeyValue",
    /**
     * Text
     */
    Value = "Value",
    /**
     * A value-key pair formatted like "text (key)"
     */
    ValueKey = "ValueKey",
  }
  /**
   * A subset of input types that fits to a simple API returning one string.
   *
   * Not available on purpose: button, checkbox, hidden, image, password, radio, range, reset, search, submit.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'InputType'.
   */
  export enum InputType {
    /**
     * An input control for specifying a date value. The user can select a month, day of the month, and year.
     *
     * @deprecated As of version 1.9.1. Please use dedicated {@link sap.m.DatePicker} to create date input.
     */
    Date = "Date",
    /**
     * An input control for specifying a date and time value. The user can select a month, day of the month,
     * year, and time of day.
     *
     * @deprecated As of version 1.9.1. Please use dedicated {@link sap.m.DateTimePicker} control to create
     * date-time input.
     */
    Datetime = "Datetime",
    /**
     * An input control for specifying a date and time value where the format depends on the locale.
     *
     * @deprecated As of version 1.9.1. Please use dedicated {@link sap.m.DateTimePicker} control create date-time
     * input.
     */
    DatetimeLocale = "DatetimeLocale",
    /**
     * A text field for specifying an email address. Brings up a keyboard optimized for email address entry.
     */
    Email = "Email",
    /**
     * An input control for selecting a month.
     *
     * @deprecated As of version 1.9.1. There is no cross-platform support. Please do not use this Input type.
     */
    Month = "Month",
    /**
     * A text field for specifying a number. Brings up a number pad keyboard. Specifying an input type of \d*
     * or [0-9]* is equivalent to using this type.
     */
    Number = "Number",
    /**
     * Password input where the user entry cannot be seen.
     */
    Password = "Password",
    /**
     * A text field for specifying a phone number. Brings up a phone pad keyboard.
     */
    Tel = "Tel",
    /**
     * default (text)
     */
    Text = "Text",
    /**
     * An input control for specifying a time value. The user can select the hour, minute, and optionally AM
     * or PM.
     *
     * @deprecated As of version 1.9.1. Please use dedicated {@link sap.m.TimePicker} control to create time
     * input.
     */
    Time = "Time",
    /**
     * A text field for specifying a URL. Brings up a keyboard optimized for URL entry.
     */
    Url = "Url",
    /**
     * An input control for selecting a week.
     *
     * @deprecated As of version 1.9.1. There is no cross-platform support. Please do not use this Input type.
     */
    Week = "Week",
  }
  /**
   * Interface for controls which can have special behavior inside `sap.m.OverflowToolbar`. Controls that
   * implement this interface must provide a `getOverflowToolbarConfig` method that accepts no arguments and
   * returns an object of type `sap.m.OverflowToolbarConfig`.
   *
   * **Important:** In addition, the control can implement a CSS class, scoped with the `.sapMOverflowToolbarMenu-CTX`
   * context selector, that will be applied whenever the control is inside the overflow menu. For example,
   * to make your control take up the whole width of the overflow menu, you can add a context class to your
   * control's base CSS file like this:
   *
   *
   * ```javascript
   *
   *       .sapMOverflowToolbarMenu-CTX .sapMyControlClass {
   *       	width: 100%;
   *       }
   *   ```
   *
   *
   * @since 1.52
   */
  export interface IOverflowToolbarContent {
    __implements__sap_m_IOverflowToolbarContent: boolean;
  }

  /**
   * Interface for controls which are suitable as a Scale for the Slider/RangeSlider. Implementation of this
   * interface should implement the following methods:
   * 	 - `getTickmarksBetweenLabels`
   * 	 - `calcNumberOfTickmarks`
   * 	 - `handleResize`
   * 	 - `getLabel`
   *
   * @since 1.46
   */
  export interface IScale {
    __implements__sap_m_IScale: boolean;

    /**
     * Returns how many tickmarks would be drawn on the screen. The start and the end tickmark should be specified
     * in this method.
     *
     *
     * @returns The number of tickmarks
     */
    calcNumberOfTickmarks(
      /**
       * Size of the scale. This is the distance between the start and end point i.e. 0..100
       */
      fSize: float,
      /**
       * The step walking from start to end.
       */
      fStep: float,
      /**
       * Limits the number of tickmarks.
       */
      iTickmarksThreshold: int
    ): int;
    /**
     * Provides a custom tickmark label.
     *
     * This method is optional. If it is not provided, the slider values will be placed as labels. If provided,
     * the value of the tickmark labels and accessibility attributes (aria-valuenow and aria-valuetext) of the
     * slider are changed accordingly.
     *
     *
     * @returns The label that should be placed in the current position.
     */
    getLabel?(
      /**
       * Value represented by the tickmark
       */
      fValue: float,
      /**
       * Slider control that asks for a label
       */
      oSlider: Slider | RangeSlider
    ): string | number;
    /**
     * Returns the number of tickmarks, which should be placed between labels.
     *
     *
     * @returns The number of tickmarks
     */
    getTickmarksBetweenLabels(): int;
    /**
     * Called, when the slider is getting resized.
     *
     * The Slider/RangeSlider control could be accessed via the oEvent.control parameter.
     *
     * Implementing this method is optional.
     */
    handleResize?(
      /**
       * The event object passed.
       */
      oEvent: jQuery.Event
    ): void;
  }

  /**
   * Common interface for sap.m.ColumnListItem and sap.m.GroupHeaderListItem
   *
   * @since 1.119
   */
  export interface ITableItem {
    __implements__sap_m_ITableItem: boolean;
  }

  /**
   * Interface for controls placed in the `content` aggregation of `{@link sap.m.Toolbar}` or `{@link sap.m.OverflowToolbar}`,
   * which need to indicate whether they are interactive or not.
   *
   * Controls that implement this interface should have the following method: `_getToolbarInteractive` - returns
   * boolean value that shows whether the control is interactive or not
   */
  export interface IToolbarInteractiveControl {
    __implements__sap_m_IToolbarInteractiveControl: boolean;
  }

  /**
   * Available label display modes.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LabelDesign'.
   */
  export enum LabelDesign {
    /**
     * Displays the label in bold.
     */
    Bold = "Bold",
    /**
     * Displays the label in normal mode.
     */
    Standard = "Standard",
  }
  /**
   * Types of LightBox loading stages.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LightBoxLoadingStates'.
   *
   * @since 1.40
   */
  export enum LightBoxLoadingStates {
    /**
     * The LightBox image could not load.
     */
    Error = "ERROR",
    /**
     * The LightBox image has loaded.
     */
    Loaded = "LOADED",
    /**
     * The LightBox image is still loading.
     */
    Loading = "LOADING",
    /**
     * The LightBox image has timed out, could not load.
     */
    TimeOutError = "TIME_OUT_ERROR",
  }
  /**
   * Enumeration for possible Link accessibility roles.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LinkAccessibleRole'.
   *
   * @since 1.104.0
   */
  export enum LinkAccessibleRole {
    /**
     * Link will receive `role="Button"` attibute.
     */
    Button = "Button",
    /**
     * Default mode.
     */
    Default = "Default",
  }
  /**
   * Enumeration for possible link-to-anchor conversion strategy.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LinkConversion'.
   *
   * @since 1.45.5
   */
  export enum LinkConversion {
    /**
     * Valid links with protocols, such as http, https, ftp and those starting with the string "www".
     */
    All = "All",
    /**
     * Default mode (no conversion).
     */
    None = "None",
    /**
     * Valid links with protocols, such as http, https, ftp.
     */
    ProtocolOnly = "ProtocolOnly",
  }
  /**
   * Defines the growing direction of the `sap.m.List` or `sap.m.Table`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListGrowingDirection'.
   *
   * @since 1.40.0
   */
  export enum ListGrowingDirection {
    /**
     * User has to scroll down to load more items or the growing button is displayed at the bottom.
     */
    Downwards = "Downwards",
    /**
     * User has to scroll up to load more items or the growing button is displayed at the top.
     *
     * **Note:** If this option is active, there should not be any other control than `sap.m.List` inside its
     * `ScollContainer`.
     */
    Upwards = "Upwards",
  }
  /**
   * Defines the different header styles.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListHeaderDesign'.
   *
   * @deprecated As of version 1.16. Has no functionality since 1.16.
   */
  export enum ListHeaderDesign {
    /**
     * Plain header style
     */
    Plain = "Plain",
    /**
     * Standard header style
     */
    Standard = "Standard",
  }
  /**
   * Defines the keyboard handling behavior of the `sap.m.List` or `sap.m.Table`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListKeyboardMode'.
   *
   * @since 1.38.0
   */
  export enum ListKeyboardMode {
    /**
     * This mode is suitable if there are only editable fields within the item.
     *
     * In this mode, the first focus goes to the first interactive element within the first item and this is
     * the only difference between the `Edit` and `Navigation` mode.
     */
    Edit = "Edit",
    /**
     * This default mode is suitable if the List or Table contains editable and/or non-editable fields.
     *
     * In this mode, the first focus goes to the first item. If the focus is on the item, or cell, pressing
     * tab/shift+tab moves the focus to the next/previous element in the tab chain after/before the `sap.m.List`
     * or `sap.m.Table` control. If the focus is on the interactive element, pressing tab/shift+tab moves the
     * focus to the next/previous element in the tab chain after/before the focused interactive element.
     */
    Navigation = "Navigation",
  }
  /**
   * Defines the mode of the list.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListMode'.
   */
  export enum ListMode {
    /**
     * Delete mode (only one list item can be deleted via provided delete button)
     */
    Delete = "Delete",
    /**
     * Multi selection mode (more than one list item can be selected).
     */
    MultiSelect = "MultiSelect",
    /**
     * Default mode (no selection).
     */
    None = "None",
    /**
     * Right-positioned single selection mode (only one list item can be selected).
     */
    SingleSelect = "SingleSelect",
    /**
     * Left-positioned single selection mode (only one list item can be selected).
     */
    SingleSelectLeft = "SingleSelectLeft",
    /**
     * Selected item is highlighted but no selection control is visible (only one list item can be selected).
     */
    SingleSelectMaster = "SingleSelectMaster",
  }
  /**
   * Defines which separator style will be applied for the items.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListSeparators'.
   */
  export enum ListSeparators {
    /**
     * Separators between the items including the last and the first one.
     */
    All = "All",
    /**
     * Separators between the items. **Note:** This enumeration depends on the theme.
     */
    Inner = "Inner",
    /**
     * No item separators.
     */
    None = "None",
  }
  /**
   * Defines the visual indication and behaviour of the list items.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ListType'.
   */
  export enum ListType {
    /**
     * Indicates that the item is clickable via active feedback when item is pressed.
     */
    Active = "Active",
    /**
     * Enables detail button of the list item that fires `detailPress` event. Also see {@link sap.m.ListItemBase#attachDetailPress}.
     */
    Detail = "Detail",
    /**
     * Enables {@link sap.m.ListType.Detail} and {@link sap.m.ListType.Active} enumerations together.
     */
    DetailAndActive = "DetailAndActive",
    /**
     * Indicates the list item does not have any active feedback when item is pressed. **Note:** `Inactive`
     * type cannot be used to disable list items.
     */
    Inactive = "Inactive",
    /**
     * Indicates the list item is navigable to show extra information about the item.
     */
    Navigation = "Navigation",
  }
  /**
   * Enumeration of possible load statuses.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'LoadState'.
   *
   * @since 1.34.0
   */
  export enum LoadState {
    /**
     * The control is disabled.
     */
    Disabled = "Disabled",
    /**
     * The control failed to load.
     */
    Failed = "Failed",
    /**
     * The control has loaded.
     */
    Loaded = "Loaded",
    /**
     * The control is loading.
     */
    Loading = "Loading",
  }
  /**
   * Different modes for a MenuButton (predefined types).
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'MenuButtonMode'.
   *
   * @since 1.38.0
   */
  export enum MenuButtonMode {
    /**
     * Default Regular type - MenuButton appears as a regular button, pressing it opens a menu.
     */
    Regular = "Regular",
    /**
     * Split type - MenuButton appears as a split button separated into two areas: the text and the arrow button.
     * Pressing the text area fires the default (or last) action, pressing the arrow part opens a menu.
     */
    Split = "Split",
  }
  /**
   * Enumeration of the `multiSelectMode>/code> in ListBase`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'MultiSelectMode'.
   *
   * @since 1.93
   */
  export enum MultiSelectMode {
    /**
     * The Select All functionality is not available. Instead, it is only possible to remove the selection of
     * all items. For a `sap.m.Table`, a Deselect All icon is rendered.
     */
    ClearAll = "ClearAll",
    /**
     * The Select All functionality is available (default behavior). For a `sap.m.Table`, a Select All checkbox
     * is rendered.
     */
    Default = "Default",
    /**
     * The Select All functionality is available. For a `sap.m.Table`, a Select All checkbox with a warning
     * popover is rendered if not all items could be selected (for example, because of growing).
     *
     * @since 1.109
     */
    SelectAll = "SelectAll",
  }
  /**
   * Marker interface for controls which are suitable as items for the ObjectHeader.
   */
  export interface ObjectHeaderContainer {
    __implements__sap_m_ObjectHeaderContainer: boolean;
  }

  /**
   * Used by the `ObjectHeader` control to define which shape to use for the image.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectHeaderPictureShape'.
   *
   * @since 1.61
   */
  export enum ObjectHeaderPictureShape {
    /**
     * Circle shape for the images in the `ObjectHeader`.
     */
    Circle = "Circle",
    /**
     * Square shape for the images in the `ObjectHeader`.
     */
    Square = "Square",
  }
  /**
   * Predefined types for ObjectMarker.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectMarkerType'.
   */
  export enum ObjectMarkerType {
    /**
     * Draft type
     */
    Draft = "Draft",
    /**
     * Favorite type
     */
    Favorite = "Favorite",
    /**
     * Flagged type
     */
    Flagged = "Flagged",
    /**
     * Locked type
     */
    Locked = "Locked",
    /**
     * LockedBy type Use when you need to display the name of the user who locked the object.
     */
    LockedBy = "LockedBy",
    /**
     * Unsaved type
     */
    Unsaved = "Unsaved",
    /**
     * UnsavedBy type Use when you need to display the name of the user whose changes were unsaved.
     */
    UnsavedBy = "UnsavedBy",
  }
  /**
   * Predefined visibility for ObjectMarker.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ObjectMarkerVisibility'.
   */
  export enum ObjectMarkerVisibility {
    /**
     * Shows icon and text
     */
    IconAndText = "IconAndText",
    /**
     * Shows only icon
     */
    IconOnly = "IconOnly",
    /**
     * Shows only text
     */
    TextOnly = "TextOnly",
  }
  /**
   * The object contains configuration information for the {@link sap.m.IOverflowToolbarContent} interface.
   *
   * @since 1.110
   */
  export type OverflowToolbarConfig = {
    /**
     * A boolean that tells whether the control can move to the overflow menu or not. **Notes:**
     * 	 - Even if `canOverflow` is set to `false`, the `propsUnrelatedToSize` field is taken into account,
     *     allowing to optimize the behavior of controls that do not need to overflow, but are used in an `sap.m.OverflowToolbar`
     *     regardless.
     * 	 - If `canOverflow` is not provided, its default value is `false`. In this case, the control is shown
     *     in the content of the `sap.m.OverflowToolbar` but it's not possible to enter the overflow area.
     */
    canOverflow?: boolean;
    /**
     * An array of strings, listing all of the control's events that should trigger the closing of the overflow
     * menu, when fired.
     */
    autoCloseEvents?: string[];
    /**
     * An array of strings, listing all of the control's events that should trigger the invalidation of the
     * `sap.m.OverflowToolbar`, when fired. **Note:** By default `sap.m.OverflowToolbar` invalidates whenever
     * any property of a child control changes. This is to ensure that whenever the size of a child control
     * changes, the overflow toolbar's layout is recalculated. Some properties however do not affect control
     * size, making it unnecessary to invalidate the overflow toolbar when they change. You can list them here
     * for optimization purposes.
     */
    invalidationEvents?: string[];
    /**
     * An array of strings, listing all of the control's properties that, when changed, should not cause the
     * overflow toolbar to invalidate.
     */
    propsUnrelatedToSize?: string[];
    /**
     * A callback function that will be invoked before moving the control into the overflow menu. The control
     * instance will be passed as an argument. **Note:** The context of the function is not the control instance
     * (use the `oControl` parameter for this purpose), but rather an internal helper object, associated with
     * the current `sap.m.OverflowToolbar` instance. This object only needs to be manipulated in special cases
     * (e.g. when you want to store state on it, rather than on the control instance).
     */
    onBeforeEnterOverflow?: Function;
    /**
     * A callback function that will be invoked after taking the control out of the overflow menu (before moving
     * it back to the toolbar itself). The control instance will be passed as an argument. **Note:** See: `onBeforeEnterOverflow`
     * for details about the function's context.
     */
    onAfterExitOverflow?: Function;
    /**
     * A function that, if provided, will be called to determine the priority of the control. This function
     * must return a value of type `sap.m.OverflowToolbarPriority`. The string "Medium" is also accepted and
     * interpreted as priority between `Low` and `High`. **Note:** Normally priority in `sap.m.OverflowToolbar`
     * is managed with the `priority` property of `sap.m.OverflowToolbarLayoutData`. However, some controls
     * may have other means of defining priority, such as dedicated properties or other types of layout data
     * for that purpose. In summary, implementing this function allows a control to override the default priority
     * logic (`sap.m.OverflowToolbarLayoutData`) by providing its own.
     */
    getCustomImportance?: Function;
  };

  /**
   * Defines the priorities of the controls within {@link sap.m.OverflowToolbar}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'OverflowToolbarPriority'.
   *
   * @since 1.32
   */
  export enum OverflowToolbarPriority {
    /**
     * Deprecated - Use `sap.m.OverflowToolbarPriority.AlwaysOverflow` instead
     *
     * @deprecated As of version 1.48.
     */
    Always = "Always",
    /**
     * Forces `OverflowToolbar` items to remain always in the overflow area.
     */
    AlwaysOverflow = "AlwaysOverflow",
    /**
     * Items with priority `Disappear` overflow before the items with higher priority, such as `Low` and `High`,
     * and remain hidden in the overflow area.
     */
    Disappear = "Disappear",
    /**
     * Items with priority `High` overflow after the items with lower priority.
     */
    High = "High",
    /**
     * Items with priority `Low` overflow before the items with higher priority, such as `High` priority items.
     */
    Low = "Low",
    /**
     * Deprecated - Use `sap.m.OverflowToolbarPriority.NeverOverflow` instead.
     *
     * @deprecated As of version 1.48.
     */
    Never = "Never",
    /**
     * Forces `OverflowToolbar` items to remain always in the toolbar.
     */
    NeverOverflow = "NeverOverflow",
  }
  /**
   * undefined
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nConditionOperation'.
   */
  export enum P13nConditionOperation {
    Ascending = "Ascending",

    Average = "Average",

    BT = "BT",

    Contains = "Contains",

    Descending = "Descending",

    Empty = "Empty",

    EndsWith = "EndsWith",

    EQ = "EQ",

    GE = "GE",

    GroupAscending = "GroupAscending",

    GroupDescending = "GroupDescending",

    GT = "GT",

    Initial = "Initial",

    LE = "LE",

    LT = "LT",

    Maximum = "Maximum",

    Minimum = "Minimum",

    NotBT = "NotBT",

    NotContains = "NotContains",

    NotEmpty = "NotEmpty",

    NotEndsWith = "NotEndsWith",

    NotEQ = "NotEQ",

    NotGE = "NotGE",

    NotGT = "NotGT",

    NotInitial = "NotInitial",

    NotLE = "NotLE",

    NotLT = "NotLT",

    NotStartsWith = "NotStartsWith",

    StartsWith = "StartsWith",

    Total = "Total",
  }
  /**
   * Type of panels used in the personalization dialog.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nPanelType'.
   */
  export enum P13nPanelType {
    /**
     * Panel type for column settings.
     */
    columns = "columns",
    /**
     * Panel type for dimension and measure settings.
     */
    dimeasure = "dimeasure",
    /**
     * Panel type for filtering.
     */
    filter = "filter",
    /**
     * Panel type for grouping.
     */
    group = "group",
    /**
     * Panel type for sorting.
     */
    sort = "sort",
  }
  /**
   * Type of popup used in the `sap.m.p13n.Popup`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'P13nPopupMode'.
   */
  export enum P13nPopupMode {
    /**
     * Dialog type as popup type.
     */
    Dialog = "Dialog",
    /**
     * ResponsivePopover type as popup type.
     */
    ResponsivePopover = "ResponsivePopover",
  }
  /**
   * Available Page Background Design.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PageBackgroundDesign'.
   */
  export enum PageBackgroundDesign {
    /**
     * Page background color when a List is set as the Page content.
     */
    List = "List",
    /**
     * A solid background color dependent on the theme.
     */
    Solid = "Solid",
    /**
     * Standard Page background color.
     */
    Standard = "Standard",
    /**
     * Transparent background for the page.
     */
    Transparent = "Transparent",
  }
  /**
   * Available Panel Accessible Landmark Roles.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PanelAccessibleRole'.
   */
  export enum PanelAccessibleRole {
    /**
     * Represents the ARIA role `complementary`. A section of the page, designed to be complementary to the
     * main content at a similar level in the DOM hierarchy.
     */
    Complementary = "Complementary",
    /**
     * Represents the ARIA role `Form`. A landmark region that contains a collection of items and objects that,
     * as a whole, create a form.
     */
    Form = "Form",
    /**
     * Represents the ARIA role `Region`. A section of a page, that is important enough to be included in a
     * page summary or table of contents.
     */
    Region = "Region",
  }
  /**
   * PDF viewer display types.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PDFViewerDisplayType'.
   */
  export enum PDFViewerDisplayType {
    /**
     * The PDF viewer switches between the `Link` display type and the `Embedded` display type, depending on
     * the device being used.
     */
    Auto = "Auto",
    /**
     * The PDF viewer appears embedded in the parent container and displays the PDF file.
     */
    Embedded = "Embedded",
    /**
     * The PDF viewer appears as a toolbar with a download button that can be used to download the PDF file
     * or open it in a new tab.
     */
    Link = "Link",
  }
  /**
   * Types for the placement of Popover control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlacementType'.
   */
  export enum PlacementType {
    /**
     * Popover will be placed automatically at the reference control.
     */
    Auto = "Auto",
    /**
     * Popover will be placed at the bottom of the reference control.
     */
    Bottom = "Bottom",
    /**
     * Popover will be placed at the right or left side of the reference control.
     */
    Horizontal = "Horizontal",
    /**
     * Deprecated - use `sap.m.PlacementType.HorizontalPreferredLeft` type.
     *
     * @since 1.29
     * @deprecated As of version 1.36. Instead, use `sap.m.PlacementType.HorizontalPreferredLeft` type.
     */
    HorizontalPreferedLeft = "HorizontalPreferedLeft",
    /**
     * Deprecated - use `sap.m.PlacementType.HorizontalPreferredRight` type.
     *
     * @since 1.29
     * @deprecated As of version 1.36. Instead, use `sap.m.PlacementType.HorizontalPreferredRight` type.
     */
    HorizontalPreferedRight = "HorizontalPreferedRight",
    /**
     * Popover will be placed at the right or left side of the reference control but will try to position on
     * the left side if the space is greater than the Popover's width.
     *
     * @since 1.36
     */
    HorizontalPreferredLeft = "HorizontalPreferredLeft",
    /**
     * Popover will be placed at the right or left side of the reference control but will try to position on
     * the right side if the space is greater than the Popover's width.
     *
     * @since 1.36
     */
    HorizontalPreferredRight = "HorizontalPreferredRight",
    /**
     * Popover will be placed at the left side of the reference control.
     */
    Left = "Left",
    /**
     * Popover will be placed to the bottom of the reference control. If the available space is less than the
     * Popover's height, it will appear to the top of the same reference control bottom border.
     *
     * @since 1.38
     */
    PreferredBottomOrFlip = "PreferredBottomOrFlip",
    /**
     * Popover will be placed to the left of the reference control. If the available space is less than the
     * Popover's width, it will appear to the right of the same reference control left border.
     *
     * @since 1.38
     */
    PreferredLeftOrFlip = "PreferredLeftOrFlip",
    /**
     * Popover will be placed to the right of the reference control. If the available space is less than the
     * Popover's width, it will appear to the left of the same reference control right border.
     *
     * @since 1.38
     */
    PreferredRightOrFlip = "PreferredRightOrFlip",
    /**
     * Popover will be placed to the top of the reference control. If the available space is less than the Popover's
     * height, it will appear to the bottom of the same reference control top border.
     *
     * @since 1.38
     */
    PreferredTopOrFlip = "PreferredTopOrFlip",
    /**
     * Popover will be placed at the right side of the reference control.
     */
    Right = "Right",
    /**
     * Popover will be placed at the top of the reference control.
     */
    Top = "Top",
    /**
     * Popover will be placed at the top or bottom of the reference control.
     */
    Vertical = "Vertical",
    /**
     * Deprecated - use `sap.m.PlacementType.VerticalPreferredBottom` type.
     *
     * @since 1.29
     * @deprecated As of version 1.36. Instead, use `sap.m.PlacementType.VerticalPreferredBottom` type.
     */
    VerticalPreferedBottom = "VerticalPreferedBottom",
    /**
     * Deprecated - use `sap.m.PlacementType.VerticalPreferredTop` type.
     *
     * @since 1.29
     * @deprecated As of version 1.36. Instead, use `sap.m.PlacementType.VerticalPreferredTop` type.
     */
    VerticalPreferedTop = "VerticalPreferedTop",
    /**
     * Popover will be placed at the top or bottom of the reference control but will try to position on the
     * bottom side if the space is greater than the Popover's height.
     *
     * @since 1.36
     */
    VerticalPreferredBottom = "VerticalPreferredBottom",
    /**
     * Popover will be placed at the top or bottom of the reference control but will try to position on the
     * top side if the space is greater than the Popover's height.
     *
     * @since 1.36
     */
    VerticalPreferredTop = "VerticalPreferredTop",
  }
  /**
   * A list of the default built-in views in a {@link sap.m.PlanningCalendar}, described by their keys.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlanningCalendarBuiltInView'.
   *
   * @since 1.50
   */
  export enum PlanningCalendarBuiltInView {
    /**
     * Represents the key of the built-in view, in which the intervals have the size of one day.
     */
    Day = "Day",
    /**
     * Represents the key of the built-in view, in which the intervals have the size of one hour.
     */
    Hour = "Hour",
    /**
     * Represents the key of the built-in view, in which the intervals have the size of one month.
     */
    Month = "Month",
    /**
     * Represents the key of the built-in view, in which the intervals have the size of one day where 31 days
     * are displayed, starting with the first day of the month.
     */
    OneMonth = "One Month",
    /**
     * Represents the key of the built-in view, in which the intervals have the size of one day where 7 days
     * are displayed, starting with the first day of the week.
     */
    Week = "Week",
  }
  /**
   * Available sticky modes for the {@link sap.m.SinglePlanningCalendar}
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PlanningCalendarStickyMode'.
   *
   * @since 1.62
   */
  export enum PlanningCalendarStickyMode {
    /**
     * Actions toolbar, navigation toolbar and the column headers will be sticky.
     */
    All = "All",
    /**
     * Only the navigation toolbar and column headers will be sticky.
     */
    NavBarAndColHeaders = "NavBarAndColHeaders",
    /**
     * Nothing will stick at the top.
     */
    None = "None",
  }
  /**
   * Defines the display of table pop-ins.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PopinDisplay'.
   *
   * @since 1.13.2
   */
  export enum PopinDisplay {
    /**
     * Inside the table popin, header is displayed at the first line and cell content is displayed at the next
     * line.
     */
    Block = "Block",
    /**
     * Inside the table popin, cell content is displayed next to the header in the same line. **Note:** If there
     * is not enough space for the cell content then it jumps to the next line.
     */
    Inline = "Inline",
    /**
     * Inside the table popin, only the cell content will be visible.
     *
     * @since 1.28
     */
    WithoutHeader = "WithoutHeader",
  }
  /**
   * Defines the layout options of the table popins.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'PopinLayout'.
   *
   * @since 1.52
   */
  export enum PopinLayout {
    /**
     * Sets block layout for rendering the table popins. The elements inside the popin container are rendered
     * one below the other. **Note:** This option enables the former rendering behavior of the table popins.
     *
     * @since 1.52
     */
    Block = "Block",
    /**
     * Sets grid layout for rendering the table popins. The grid width for each table popin is comparatively
     * larger than `GridSmall`, hence this allows less content to be rendered in a single popin row.
     *
     * **Note:** This feature is currently not supported with Internet Explorer and Edge (version lower than
     * 16) browsers.
     *
     * @since 1.52
     */
    GridLarge = "GridLarge",
    /**
     * Sets grid layout for rendering the table popins. The grid width for each table popin is small, hence
     * this allows more content to be rendered in a single popin row. This value defines small grid width for
     * the table popins.
     *
     * **Note:** This feature is currently not supported with Internet Explorer and Edge (version lower than
     * 16) browsers.
     *
     * @since 1.52
     */
    GridSmall = "GridSmall",
  }
  /**
   * Helper for Popups.
   *
   * @since 1.16.7
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  interface PopupHelper {
    /**
     * Converts the given percentage value to an absolute number based on the given base size.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The calculated size string with "px" as unit or `null` when the format of given parameter is
     * wrong.
     */
    calcPercentageSize(
      /**
       * A percentage value in string format, for example "25%"
       */
      sPercentage: string,
      /**
       * A float number which the calculation is based on.
       */
      fBaseSize: float
    ): string | null;
  }
  export const PopupHelper: PopupHelper;

  /**
   * Defines the priority for the TileContent in ActionMode
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Priority'.
   */
  export enum Priority {
    /**
     * It displays high priority color for the GenericTag
     */
    High = "High",
    /**
     * It displays low priority color for the GenericTag
     */
    Low = "Low",
    /**
     * It displays medium priority color for the GenericTag
     */
    Medium = "Medium",
    /**
     * The priority is not set
     */
    None = "None",
    /**
     * It displays very high priority color for the GenericTag
     */
    VeryHigh = "VeryHigh",
  }
  /**
   * QuickViewGroupElement is a combination of one label and another control (Link or Text) associated to
   * this label.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'QuickViewGroupElementType'.
   */
  export enum QuickViewGroupElementType {
    /**
     * Displays an e-mail link
     */
    email = "email",
    /**
     * Displays a regular HTML link
     */
    link = "link",
    /**
     * Displays a phone number link for direct dialing and an icon for sending a text message
     */
    mobile = "mobile",
    /**
     * Displays a link for navigating to another QuickViewPage
     */
    pageLink = "pageLink",
    /**
     * Displays a phone number link for direct dialing
     */
    phone = "phone",
    /**
     * Displays text
     */
    text = "text",
  }
  /**
   * Possible values for the visualization of float values in the RatingIndicator control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'RatingIndicatorVisualMode'.
   */
  export enum RatingIndicatorVisualMode {
    /**
     * Values are rounded to the nearest integer value (e.g. 1.7 -> 2).
     */
    Full = "Full",
    /**
     * Values are rounded to the nearest half value (e.g. 1.7 -> 1.5).
     */
    Half = "Half",
  }
  /**
   * Reactive area modes of interactable elements.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ReactiveAreaMode'.
   */
  export enum ReactiveAreaMode {
    /**
     * The target element is displayed as part of a sentence.
     */
    Inline = "Inline",
    /**
     * The target element is displayed as on overlay on top of other interactive parts of the page.
     */
    Overlay = "Overlay",
  }
  /**
   * Enumeration of the `ResetAllMode` that can be used in a `TablePersoController`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ResetAllMode'.
   */
  export enum ResetAllMode {
    /**
     * Default behavior of the `TablePersoDialog` Reset All button.
     */
    Default = "Default",
    /**
     * Resets the table to the default of the attached `PersoService`.
     */
    ServiceDefault = "ServiceDefault",
    /**
     * Resets the table to the result of `getResetPersData` of the attached `PersoService`.
     */
    ServiceReset = "ServiceReset",
  }
  /**
   * Breakpoint names for different screen sizes.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ScreenSize'.
   */
  export enum ScreenSize {
    /**
     * 1024px wide
     */
    Desktop = "Desktop",
    /**
     * 768px wide
     */
    Large = "Large",
    /**
     * 560px wide
     */
    Medium = "Medium",
    /**
     * 240px wide
     */
    Phone = "Phone",
    /**
     * 480px wide
     */
    Small = "Small",
    /**
     * 600px wide
     */
    Tablet = "Tablet",
    /**
     * 960px wide
     */
    XLarge = "XLarge",
    /**
     * 320px wide
     */
    XSmall = "XSmall",
    /**
     * 1120px wide
     */
    XXLarge = "XXLarge",
    /**
     * 240px wide
     */
    XXSmall = "XXSmall",
  }
  /**
   * A string type that represents column ratio.
   *
   * Allowed values are strings that follow the number:number (3:2) format.
   *
   * @since 1.86
   */
  export type SelectColumnRatio = string;

  /**
   * Defines the control that will receive the initial focus in the `sap.m.SelectDialog` or `sap.m.TableSelectDialog`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectDialogInitialFocus'.
   *
   * @since 1.117.0
   */
  export enum SelectDialogInitialFocus {
    /**
     * Content list.
     */
    List = "List",
    /**
     * SearchField control
     */
    SearchField = "SearchField",
  }
  /**
   * Enumeration for different action levels in sap.m.SelectionDetails control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectionDetailsActionLevel'.
   *
   * @since 1.48
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export enum SelectionDetailsActionLevel {
    /**
     * ActionGroup on SelectionDetails list level.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    Group = "Group",
    /**
     * Action on SelectionDetailsItem level.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    Item = "Item",
    /**
     * Action on SelectionDetails list level.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    List = "List",
  }
  /**
   * Defines the keyboard navigation mode.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectListKeyboardNavigationMode'.
   *
   * @since 1.38
   */
  export enum SelectListKeyboardNavigationMode {
    /**
     * Keyboard navigation is delimited at the last item or first item of the list.
     */
    Delimited = "Delimited",
    /**
     * Keyboard navigation is disabled.
     */
    None = "None",
  }
  /**
   * Enumeration for different Select types.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SelectType'.
   *
   * @since 1.16
   */
  export enum SelectType {
    /**
     * Will show the text.
     */
    Default = "Default",
    /**
     * Will show only the specified icon.
     */
    IconOnly = "IconOnly",
  }
  /**
   * Enumeration of the `SharingMode` that can be used in a `VariantItem`.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SharingMode'.
   */
  export enum SharingMode {
    /**
     * Private mode of the `VariantItem`.
     */
    Private = "private",
    /**
     * Public mode of the `VariantItem`.
     */
    Public = "public",
  }
  /**
   * Available selection modes for the {@link sap.m.SinglePlanningCalendar}
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SinglePlanningCalendarSelectionMode'.
   *
   * @since 1.113
   */
  export enum SinglePlanningCalendarSelectionMode {
    /**
     * Мore than one date will be available to selection.
     */
    MultiSelect = "MultiSelect",
    /**
     * Single date selection.
     */
    SingleSelect = "SingleSelect",
  }
  /**
   * Enumeration of possible size settings.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Size'.
   *
   * @since 1.34.0
   */
  export enum Size {
    /**
     * The size depends on the device it is running on. It is medium size for desktop and tablet and small size
     * for phone.
     */
    Auto = "Auto",
    /**
     * Large size.
     */
    L = "L",
    /**
     * Medium size.
     */
    M = "M",
    /**
     * The width and height of the control are determined by the width and height of the container the control
     * is placed in. Please note: it is decided by the control whether or not sap.m.Size.Responsive is supported.
     *
     * @since 1.44.0
     */
    Responsive = "Responsive",
    /**
     * Small size.
     */
    S = "S",
    /**
     * Extra small size.
     */
    XS = "XS",
  }
  /**
   * The mode of SplitContainer or SplitApp control to show/hide the master area.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SplitAppMode'.
   */
  export enum SplitAppMode {
    /**
     * Master area is hidden initially both in portrait and landscape.
     *
     * Master area can be opened by clicking on the top left corner button or swiping right. Swipe is only enabled
     * on mobile devices. Master will keep the open state when changing the orientation of the device.
     */
    HideMode = "HideMode",
    /**
     * Master will be shown inside a Popover when in portrait mode
     */
    PopoverMode = "PopoverMode",
    /**
     * Master will automatically be hidden in portrait mode.
     */
    ShowHideMode = "ShowHideMode",
    /**
     * Master will always be shown but in a compressed version when in portrait mode.
     */
    StretchCompressMode = "StretchCompressMode",
  }
  /**
   * The option keys of all the standard options of a DynamicDateRange control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StandardDynamicDateRangeKeys'.
   */
  export enum StandardDynamicDateRangeKeys {
    /**
     * The date will be selected from a calendar.
     */
    DATE = "DATE",
    /**
     * The range will be selected from a calendar.
     */
    DATERANGE = "DATERANGE",
    /**
     * The date and time will be selected from a calendar and time picker.
     */
    DATETIME = "DATETIME",
    /**
     * The range will be selected from two DateTimePicker controls.
     */
    DATETIMERANGE = "DATETIMERANGE",
    /**
     * The range will start from the date selected from a calendar and ends with the last day of the current
     * year.
     */
    DATETOYEAR = "DATETOYEAR",
    /**
     * The date will be the first day of the current month.
     */
    FIRSTDAYMONTH = "FIRSTDAYMONTH",
    /**
     * The date will be the first day of the current quarter.
     */
    FIRSTDAYQUARTER = "FIRSTDAYQUARTER",
    /**
     * The date will be the first day of the current week.
     */
    FIRSTDAYWEEK = "FIRSTDAYWEEK",
    /**
     * The date will be the first day of the current year.
     */
    FIRSTDAYYEAR = "FIRSTDAYYEAR",
    /**
     * The range will start from a date selected from a calendar.
     */
    FROM = "FROM",
    /**
     * The range will start from a date and time selected from a calendar and time picker.
     */
    FROMDATETIME = "FROMDATETIME",
    /**
     * The date will be the last day of the current month.
     */
    LASTDAYMONTH = "LASTDAYMONTH",
    /**
     * The date will be the last day of the current quarter.
     */
    LASTDAYQUARTER = "LASTDAYQUARTER",
    /**
     * The range will contain the last X days. The count of the days is selected from a StepInput.
     */
    LASTDAYS = "LASTDAYS",
    /**
     * The range will contain the last X days including the current one. The count of the days is selected from
     * a StepInput.
     */
    LASTDAYSINCLUDED = "LASTDAYSINCLUDED",
    /**
     * The date will be the last day of the current week.
     */
    LASTDAYWEEK = "LASTDAYWEEK",
    /**
     * The date will be the last day of the current year.
     */
    LASTDAYYEAR = "LASTDAYYEAR",
    /**
     * The range will contain the last X hours. The count of the hours is selected from a StepInput.
     */
    LASTHOURS = "LASTHOURS",
    /**
     * The range will contain the last X hours including the current one. The count of the hours is selected
     * from a StepInput.
     */
    LASTHOURSINCLUDED = "LASTHOURSINCLUDED",
    /**
     * The range will contain the last X minutes. The count of the minutes is selected from a StepInput.
     */
    LASTMINUTES = "LASTMINUTES",
    /**
     * The range will contain the last X minutes including the current one. The count of the minutes is selected
     * from a StepInput.
     */
    LASTMINUTESINCLUDED = "LASTMINUTESINCLUDED",
    /**
     * The range will contain the days in the last month.
     */
    LASTMONTH = "LASTMONTH",
    /**
     * The range will contain the last X months. The count of the months is selected from a StepInput.
     */
    LASTMONTHS = "LASTMONTHS",
    /**
     * The range will contain the last X months including the current one. The count of the months is selected
     * from a StepInput.
     */
    LASTMONTHSINCLUDED = "LASTMONTHSINCLUDED",
    /**
     * The range will contain the days in the last quarter.
     */
    LASTQUARTER = "LASTQUARTER",
    /**
     * The range will contain the last X quarters. The count of the quarters is selected from a StepInput.
     */
    LASTQUARTERS = "LASTQUARTERS",
    /**
     * The range will contain the last X quarters including the current one. The count of the quarters is selected
     * from a StepInput.
     */
    LASTQUARTERSINCLUDED = "LASTQUARTERSINCLUDED",
    /**
     * The range will contain the days of the last week.
     */
    LASTWEEK = "LASTWEEK",
    /**
     * The range will contain the last X weeks. The count of the weeks is selected from a StepInput.
     */
    LASTWEEKS = "LASTWEEKS",
    /**
     * The range will contain the last X weeks including the current one. The count of the weeks is selected
     * from a StepInput.
     */
    LASTWEEKSINCLUDED = "LASTWEEKSINCLUDED",
    /**
     * The range will contain the days in the last year.
     */
    LASTYEAR = "LASTYEAR",
    /**
     * The range will contain the last X years. The count of the years is selected from a StepInput.
     */
    LASTYEARS = "LASTYEARS",
    /**
     * The range will contain the last X years including the current one. The count of the years is selected
     * from a StepInput.
     */
    LASTYEARSINCLUDED = "LASTYEARSINCLUDED",
    /**
     * The range will contain the next X days. The count of the days is selected from a StepInput.
     */
    NEXTDAYS = "NEXTDAYS",
    /**
     * The range will contain the next X days including the current one. The count of the days is selected from
     * a StepInput.
     */
    NEXTDAYSINCLUDED = "NEXTDAYSINCLUDED",
    /**
     * The range will contain the next X hours. The count of the hours is selected from a StepInput.
     */
    NEXTHOURS = "NEXTHOURS",
    /**
     * The range will contain the next X hours including the current one. The count of the hours is selected
     * from a StepInput.
     */
    NEXTHOURSINCLUDED = "NEXTHOURSINCLUDED",
    /**
     * The range will contain the next X minutes. The count of the minutes is selected from a StepInput.
     */
    NEXTMINUTES = "NEXTMINUTES",
    /**
     * The range will contain the next X minutes including the current one. The count of the minutes is selected
     * from a StepInput.
     */
    NEXTMINUTESINCLUDED = "NEXTMINUTESINCLUDED",
    /**
     * The range will contain the days in the next month.
     */
    NEXTMONTH = "NEXTMONTH",
    /**
     * The range will contain the next X months. The count of the months is selected from a StepInput.
     */
    NEXTMONTHS = "NEXTMONTHS",
    /**
     * The range will contain the next X months including the current one. The count of the months is selected
     * from a StepInput.
     */
    NEXTMONTHSINCLUDED = "NEXTMONTHSINCLUDED",
    /**
     * The range will contain the days in the next quarter.
     */
    NEXTQUARTER = "NEXTQUARTER",
    /**
     * The range will contain the next X quarters. The count of the quarters is selected from a StepInput.
     */
    NEXTQUARTERS = "NEXTQUARTERS",
    /**
     * The range will contain the next X quarters including the current one. The count of the quarters is selected
     * from a StepInput.
     */
    NEXTQUARTERSINCLUDED = "NEXTQUARTERSINCLUDED",
    /**
     * The range will contain the days of the next week.
     */
    NEXTWEEK = "NEXTWEEK",
    /**
     * The range will contain the next X weeks. The count of the weeks is selected from a StepInput.
     */
    NEXTWEEKS = "NEXTWEEKS",
    /**
     * The range will contain the next X weeks including the current one. The count of the weeks is selected
     * from a StepInput.
     */
    NEXTWEEKSINCLUDED = "NEXTWEEKSINCLUDED",
    /**
     * The range will contain the days in the next year.
     */
    NEXTYEAR = "NEXTYEAR",
    /**
     * The range will contain the next X years. The count of the years is selected from a StepInput.
     */
    NEXTYEARS = "NEXTYEARS",
    /**
     * The range will contain the next X years including the current one. The count of the years is selected
     * from a StepInput.
     */
    NEXTYEARSINCLUDED = "NEXTYEARSINCLUDED",
    /**
     * The range will contain the days in the first quarter.
     */
    QUARTER1 = "QUARTER1",
    /**
     * The range will contain the days in the second quarter.
     */
    QUARTER2 = "QUARTER2",
    /**
     * The range will contain the days in the third quarter.
     */
    QUARTER3 = "QUARTER3",
    /**
     * The range will contain the days in the fourth quarter.
     */
    QUARTER4 = "QUARTER4",
    /**
     * The range will contain a month selected from a MonthPicker.
     */
    SPECIFICMONTH = "SPECIFICMONTH",
    /**
     * The range will contain a month in exact year selected from a MonthPicker.
     */
    SPECIFICMONTHINYEAR = "SPECIFICMONTHINYEAR",
    /**
     * The range will contain the days in the current month.
     */
    THISMONTH = "THISMONTH",
    /**
     * The range will contain the days in the current quarter.
     */
    THISQUARTER = "THISQUARTER",
    /**
     * The range will contain the days of the current week.
     */
    THISWEEK = "THISWEEK",
    /**
     * The range will contain the days in the current year.
     */
    THISYEAR = "THISYEAR",
    /**
     * The range will end in a date selected from a calendar.
     */
    TO = "TO",
    /**
     * The range will end in a date and time selected from a calendar and time picker.
     */
    TODATETIME = "TODATETIME",
    /**
     * The date will be the day of selection.
     */
    TODAY = "TODAY",
    /**
     * The range will contain the last X days and the next Y days. The count of the days is selected from a
     * StepInput.
     */
    TODAYFROMTO = "TODAYFROMTO",
    /**
     * The date will be the day after the day of selection.
     */
    TOMORROW = "TOMORROW",
    /**
     * The range will start from the first day of the current year and ends with the date selected from a calendar.
     */
    YEARTODATE = "YEARTODATE",
    /**
     * The date will be the day before the day of selection.
     */
    YESTERDAY = "YESTERDAY",
  }
  /**
   * Types for StandardTile.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StandardTileType'.
   */
  export enum StandardTileType {
    /**
     * Tile representing that something needs to be created
     */
    Create = "Create",
    /**
     * Monitor tile
     */
    Monitor = "Monitor",
    /**
     * Default type
     */
    None = "None",
  }
  /**
   * Available step modes for {@link sap.m.StepInput}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StepInputStepModeType'.
   *
   * @since 1.54
   */
  export enum StepInputStepModeType {
    /**
     * Choosing increase/decrease button will add/subtract the `step` value to/from the current value. For example,
     * if `step` is 5, current `value` is 17 and increase button is chosen, the result will be 22 (5+17).
     *
     * **Note:** Using keyboard PageUp/PageDown will add/subtract the `step` multiplied by the `largerStep`
     * values to/from the current `value`. For example, if `step` is 5, `largerStep` is 3, current `value` is
     * 17 and PageUp is chosen, the result would be 32 (5*3+17).
     *
     * For more information, see {@link sap.m.StepInput}'s `step`, `largerStep` and `stepMode` properties.
     */
    AdditionAndSubtraction = "AdditionAndSubtraction",
    /**
     * Pressing increase/decrease button will increase/decrease the current `value` to the closest number that
     * is divisible by the `step`.
     *
     * For example, if `step` is 5, current `value` is 17 and increase button is chosen, the result will be
     * 20 as it is the closest larger number that is divisible by 5.
     *
     * **Note:** Using keyboard PageUp/PageDown will increase/decrease the current `value` to the closest number
     * that is divisible by the multiplication of the `step` and the `largerStep` values. For example, if `step`
     * is 5, `largerStep` is 3, current `value` is 17 and PageUp is chosen, the result would be 30 as it is
     * the closest larger number that is divisible by 15.
     *
     * The logic above will work only if both `step` and `largerStep` are integers.
     *
     * For more information, see {@link sap.m.StepInput}'s `step`, `largerStep` and `stepMode` properties.
     */
    Multiple = "Multiple",
  }
  /**
   * Available validation modes for {@link sap.m.StepInput}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StepInputValidationMode'.
   */
  export enum StepInputValidationMode {
    /**
     * Validation happens on `FocusOut`.
     */
    FocusOut = "FocusOut",
    /**
     * Validation happens on `LiveChange`.
     */
    LiveChange = "LiveChange",
  }
  /**
   * Defines which area of the control remains fixed at the top of the page during vertical scrolling as long
   * as the control is in the viewport.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'Sticky'.
   *
   * @since 1.54
   */
  export enum Sticky {
    /**
     * The column headers remain in a fixed position.
     */
    ColumnHeaders = "ColumnHeaders",
    /**
     * The group headers remain in a fixed position at the top of the page during vertical scrolling.
     *
     * @since 1.128
     */
    GroupHeaders = "GroupHeaders",
    /**
     * The header toolbar remains in a fixed position.
     *
     * @since 1.56
     */
    HeaderToolbar = "HeaderToolbar",
    /**
     * The info toolbar remains in a fixed position.
     *
     * @since 1.56
     */
    InfoToolbar = "InfoToolbar",
  }
  /**
   * Types of string filter operators.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'StringFilterOperator'.
   *
   * @since 1.42
   */
  export enum StringFilterOperator {
    /**
     * Checks if any word in the text starts with the search string.
     */
    AnyWordStartsWith = "AnyWordStartsWith",
    /**
     * Checks if the text contains the search string.
     */
    Contains = "Contains",
    /**
     * Checks if the text is equal with the search string.
     */
    Equals = "Equals",
    /**
     * Checks if the text starts with the search string.
     */
    StartsWith = "StartsWith",
  }
  /**
   * Directions for swipe event.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SwipeDirection'.
   */
  export enum SwipeDirection {
    /**
     * Swipe from the beginning to the end - left to right in LTR languages and right to left in RTL languages.
     *
     * @since 1.72
     */
    BeginToEnd = "BeginToEnd",
    /**
     * Both directions (left to right or right to left)
     */
    Both = "Both",
    /**
     * Swipe from the end to the beginning - right to left in LTR languages and left to right in RTL languages.
     *
     * @since 1.72
     */
    EndToBegin = "EndToBegin",
    /**
     * Swipe from left to right
     *
     * @deprecated As of version 1.72. replaced by {@link BeginToEnd}
     */
    LeftToRight = "LeftToRight",
    /**
     * Swipe from right to left.
     *
     * @deprecated As of version 1.72. replaced by {@link EndToBegin}
     */
    RightToLeft = "RightToLeft",
  }
  /**
   * Enumeration for different switch types.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'SwitchType'.
   */
  export enum SwitchType {
    /**
     * Switch with accept and reject icons
     */
    AcceptReject = "AcceptReject",
    /**
     * Will show "ON" and "OFF" translated to the current language or the custom text if provided
     */
    Default = "Default",
  }
  /**
   * Specifies `IconTabBar` tab overflow mode.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TabsOverflowMode'.
   *
   * @since 1.90.0
   */
  export enum TabsOverflowMode {
    /**
     * Default behavior: One overflow tab at the end of the header.
     */
    End = "End",
    /**
     * Two overflow tabs at both ends of the header to keep tabs order intact.
     */
    StartAndEnd = "StartAndEnd",
  }
  /**
   * Colors to highlight certain UI elements.
   *
   * In contrast to the `ValueState`, the semantic meaning must be defined by the application.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TileInfoColor'.
   * See:
   * 	{@link fiori:/how-to-use-semantic-colors/ Semantic Colors}
   *
   * @since 1.124
   */
  export enum TileInfoColor {
    /**
     * SAP Brand Color
     */
    BrandColor = "BrandColor",
    /**
     * Critical Text Color
     */
    CriticalTextColor = "CriticalTextColor",
    /**
     * Indication Color 1
     */
    Indication1 = "Indication1",
    /**
     * Indication Color 10
     */
    Indication10 = "Indication10",
    /**
     * Indication Color 2
     */
    Indication2 = "Indication2",
    /**
     * Indication Color 3
     */
    Indication3 = "Indication3",
    /**
     * Indication Color 4
     */
    Indication4 = "Indication4",
    /**
     * Indication Color 5
     */
    Indication5 = "Indication5",
    /**
     * Indication Color 6
     */
    Indication6 = "Indication6",
    /**
     * Indication Color 7
     */
    Indication7 = "Indication7",
    /**
     * Indication Color 8
     */
    Indication8 = "Indication8",
    /**
     * Indication Color 9
     */
    Indication9 = "Indication9",
    /**
     * Information Background Color
     */
    InformationBackgroundColor = "InformationBackgroundColor",
    /**
     * Information Border Color
     */
    InformationBorderColor = "InformationBorderColor",
    /**
     * Neutral Background Color
     */
    NeutralBackgroundColor = "NeutralBackgroundColor",
    /**
     * Neutral Border Color
     */
    NeutralBorderColor = "NeutralBorderColor",
    /**
     * Neutral Element Color
     */
    NeutralElementColor = "NeutralElementColor",
    /**
     * Warning Background Color
     */
    WarningBackground = "WarningBackground",
    /**
     * Warning Border Color
     */
    WarningBorderColor = "WarningBorderColor",
  }
  /**
   * Describes the behavior of tiles when displayed on a small-screened phone (374px wide and lower).
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TileSizeBehavior'.
   *
   * @since 1.56.0
   */
  export enum TileSizeBehavior {
    /**
     * Default behavior: Tiles adapt to the size of the screen, getting smaller on small screens.
     */
    Responsive = "Responsive",
    /**
     * Tiles are small all the time, regardless of the actual screen size.
     */
    Small = "Small",
  }
  /**
   * Different modes for the `sap.m.TimePicker` mask.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TimePickerMaskMode'.
   *
   * @since 1.54
   */
  export enum TimePickerMaskMode {
    /**
     * The mask is disabled for the `sap.m.TimePicker`.
     */
    Off = "Off",
    /**
     * The mask is automatically enabled for all valid fixed-length time patterns, and it is disabled when the
     * time format does not have a fixed length.
     */
    On = "On",
  }
  /**
   * Declares the type of title alignment for some controls
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TitleAlignment'.
   */
  export enum TitleAlignment {
    /**
     * The default type (if specified in the theme)
     */
    Auto = "Auto",
    /**
     * Explicitly sets the alignment to the center
     */
    Center = "Center",
    /**
     * Disables an automatic title alignment depending on theme Mostly used in sap.m.Bar
     */
    None = "None",
    /**
     * Explicitly sets the alignment to the start (left or right depending on LTR/RTL)
     */
    Start = "Start",
  }
  /**
   * Types of the `sap.m.Tokenizer` responsive modes.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'TokenizerRenderMode'.
   *
   * @since 1.80
   */
  export enum TokenizerRenderMode {
    /**
     * In `Loose` mode, the `sap.m.Tokenizer` will show all its tokens, even if this means that scrolling needs
     * to be used.
     */
    Loose = "Loose",
    /**
     * In `Narrow` mode, the `sap.m.Tokenizer` will show as many tokens as its width allows, as well as an n-More
     * indicator with the count of the hidden tokens. The rest tokens will be hidden.
     */
    Narrow = "Narrow",
  }
  /**
   * Types of the Toolbar Design.
   *
   * To preview the different combinations of `sap.m.ToolbarDesign` and `sap.m.ToolbarStyle`, see the **OverflowToolbar
   * - Design and styling** sample of the {@link sap.m.OverflowToolbar} control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ToolbarDesign'.
   *
   * @since 1.16.8
   */
  export enum ToolbarDesign {
    /**
     * The toolbar can be inserted into other controls and if the design is "Auto" then it inherits the design
     * from parent control.
     */
    Auto = "Auto",
    /**
     * The toolbar appears smaller than the regular size to show information(e.g: text, icon).
     */
    Info = "Info",
    /**
     * The toolbar has a solid background. Its content will be rendered in a standard way.
     *
     * @since 1.22
     */
    Solid = "Solid",
    /**
     * The toolbar and its content will be displayed transparent.
     */
    Transparent = "Transparent",
  }
  /**
   * Types of visual styles for the {@link sap.m.Toolbar}.
   *
   * **Note:** Keep in mind that the styles are theme-dependent and can differ based on the currently used
   * theme.
   *
   * To preview the different combinations of `sap.m.ToolbarDesign` and `sap.m.ToolbarStyle`, see the **OverflowToolbar
   * - Design and styling** sample of the {@link sap.m.OverflowToolbar} control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ToolbarStyle'.
   *
   * @since 1.54
   */
  export enum ToolbarStyle {
    /**
     * Simplified visual style dependent on the used theme.
     *
     * **Note:** For the Belize themes, the `sap.m.Toolbar` is displayed with no border.
     */
    Clear = "Clear",
    /**
     * Default visual style dependent on the used theme.
     */
    Standard = "Standard",
  }
  /**
   * Defines the placeholder type for the control to be replaced.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadSetwithTableActionPlaceHolder'.
   *
   * @since 1.120
   */
  export enum UploadSetwithTableActionPlaceHolder {
    /**
     * Placeholder for cloud file picker button.
     */
    CloudFilePickerButtonPlaceholder = "CloudFilePickerButtonPlaceholder",
    /**
     * Placeholder for personalization settings button.
     *
     * @deprecated As of version 1.124. the concept has been discarded.
     */
    PersonalizationSettingsPlaceholder = "PersonalizationSettingsPlaceholder",
    /**
     * Placeholder for upload button control.
     */
    UploadButtonPlaceholder = "UploadButtonPlaceholder",
    /**
     * Placeholder for variant management.
     *
     * @deprecated As of version 1.124. the concept has been discarded.
     */
    VariantManagementPlaceholder = "VariantManagementPlaceholder",
  }
  /**
   * States of the upload process of {@link sap.m.UploadCollectionItem}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadState'.
   */
  export enum UploadState {
    /**
     * The file has been uploaded successfully.
     */
    Complete = "Complete",
    /**
     * The file cannot be uploaded due to an error.
     */
    Error = "Error",
    /**
     * The file is awaiting an explicit command to start being uploaded.
     */
    Ready = "Ready",
    /**
     * The file is currently being uploaded.
     */
    Uploading = "Uploading",
  }
  /**
   * Type of the upload {@link sap.m.UploadSetItem}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'UploadType'.
   */
  export enum UploadType {
    /**
     * The file has been uploaded from cloud.
     */
    Cloud = "Cloud",
    /**
     * The file has been uploaded from your system.
     */
    Native = "Native",
  }
  /**
   * URL (Uniform Resource Locator) Helper.
   *
   * This helper can be used to trigger a native application (e.g. email, sms, phone) from the browser. That
   * means we are restricted of browser or application implementation. e.g.
   * 	 - Some browsers do not let you pass more than 2022 characters in the URL
   * 	 - MAPI (Outlook) limit is 2083, max. path under Internet Explorer is 2048
   * 	 - Different Internet Explorer versions have a different URL length limits (IE9 approximately 1000 characters)
   *
   * 	 - MS mail app under Windows 8 cuts mail links after approximately 100 characters
   * 	 - Safari gets a confirmation from user before opening a native application and can block other triggers
   *     if the user cancels it
   * 	 - Some mail applications(Outlook) do not respect all encodings (e.g. Cyrillic texts are not encoded
   *     correctly)
   *
   * **Note:** all the given maximum lengths are for URL encoded text (e.g a space character will be encoded
   * as "%20").
   *
   * It has been reported by some users that the content send through the `URLHelper` is not correctly displayed
   * by the native applications (e.g. a native mail application).
   *
   * After sending the body to the application, `URLHelper` cannot affect its rendering and the application
   * takes responsibility to correctly display the content. Inconsistencies between different native applications
   * or operative systems (OS) can lead to different behaviors and differences in the displayed content.
   *
   * **Example:**
   *
   * What happens with a link added to the content of an email using the `URLHelper` ?
   *
   * Apart from the correct generation of URL, everything else is outside of the scope of `URLHelper` as responsibility
   * from then on is passed to the browser and the native applications handling the URL. For instance, clicking
   * on an email link should result in triggering an action in the default mail application for the user's
   * OS and it is this application's responsibility to correctly handle the URL, given it is generated correctly.
   * See:
   * 	{@link https://ui5.sap.com/#/topic/4f1c1075d88c41a5904389fa12b28f6b URL Helper}
   *
   * @since 1.10
   */
  interface URLHelper {
    /**
     * Adds an event listener for the `redirect` event.
     *
     *
     * @returns The URLHelper instance
     */
    attachRedirect(
      /**
       * The function to call, when the event occurs.
       */
      fnFunction: Function,
      /**
       * The object that wants to be notified when the event occurs.
       */
      oListener?: Object
    ): URLHelper;
    /**
     * Detach an already registered listener of the `redirect` event.
     *
     *
     * @returns The URLHelper instance
     */
    detachRedirect(
      /**
       * The function to call, when the event occurs.
       */
      fnFunction: Function,
      /**
       * The object, that wants to be notified, when the event occurs.
       */
      oListener?: Object
    ): URLHelper;
    /**
     * Builds Email URI from given parameter. Trims spaces from email addresses.
     *
     *
     * @returns Email URI using the `mailto:` scheme
     */
    normalizeEmail(
      /**
       * Destination email address
       */
      sEmail?: string,
      /**
       * Subject of the email address
       */
      sSubject?: string,
      /**
       * Default message text
       */
      sBody?: string,
      /**
       * Carbon Copy email address
       */
      sCC?: string,
      /**
       * Blind carbon copy email address
       */
      sBCC?: string
    ): string;
    /**
     * Sanitizes the given telephone number and returns a URI using the `sms:` scheme.
     *
     *
     * @returns SMS URI using the `sms:` scheme
     */
    normalizeSms(
      /**
       * Telephone number
       */
      sTel?: string
    ): string;
    /**
     * Sanitizes the given telephone number and returns a URI using the `tel:` scheme.
     *
     *
     * @returns Telephone URI using the `tel:` scheme
     */
    normalizeTel(
      /**
       * Telephone number
       */
      sTel?: string
    ): string;
    /**
     * Redirects to the given URL.
     *
     * This method fires "redirect" event before opening the URL.
     */
    redirect(
      /**
       * Uniform resource locator
       */
      sURL: string,
      /**
       * Opens URL in a new browser window or tab. Please note that, opening a new window/tab can be ignored by
       * browsers (e.g. on Windows Phone) or by popup blockers. NOTE: On Windows Phone the URL will be enforced
       * to open in the same window if opening in a new window/tab fails (because of a known system restriction
       * on cross-window communications). Use sap.m.Link instead (with blank target) if you necessarily need to
       * open URL in a new window.
       */
      bNewWindow?: boolean
    ): void;
    /**
     * Trigger email application to send email. Trims spaces from email addresses.
     */
    triggerEmail(
      /**
       * Destination email address
       */
      sEmail?: string,
      /**
       * Subject of the email address
       */
      sSubject?: string,
      /**
       * Default message text
       */
      sBody?: string,
      /**
       * Carbon Copy email address
       */
      sCC?: string,
      /**
       * Blind carbon copy email address
       */
      sBCC?: string,
      /**
       * Opens email template in a new browser window or tab.
       */
      bNewWindow?: boolean
    ): void;
    /**
     * Trigger SMS application to send SMS to given telephone number.
     */
    triggerSms(
      /**
       * Telephone number
       */
      sTel?: string
    ): void;
    /**
     * Trigger telephone app to call the given telephone number.
     */
    triggerTel(
      /**
       * Telephone number
       */
      sTel?: string
    ): void;
  }
  export const URLHelper: URLHelper;

  /**
   * Enumeration of possible value color settings.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'ValueColor'.
   */
  export enum ValueColor {
    /**
     * Critical value color.
     */
    Critical = "Critical",
    /**
     * Error value color.
     */
    Error = "Error",
    /**
     * Good value color.
     */
    Good = "Good",
    /**
     * Neutral value color.
     */
    Neutral = "Neutral",
    /**
     * None value color.
     *
     * **Note:** The None value color is set to prevent the display of tooltip 'Neutral' for numeric content.
     *
     * @since 1.84
     */
    None = "None",
  }
  /**
   * A string type that represents CSS color values, sap.m.ValueColor or less parameter values.
   *
   * Allowed values are {@link sap.ui.core.CSSColor}, {@link sap.m.ValueColor} or a less parameter name (string).
   * In case the less parameter color cannot be determined, the validation fails. You need to check if less
   * parameters are supported on control level. An empty string is also allowed and has the same effect as
   * setting no color.
   *
   * @deprecated As of version 1.135. the concept has been discarded.
   */
  export type ValueCSSColor = string;

  /**
   * An object type that represents the {@link sap.m.VariantManagement} `manage`-event property `exe`.
   */
  export type VariantManagementExe = {
    /**
     * the variant key.
     */
    key: string;
    /**
     * flag describing the associated Appy Automatically indicator.
     */
    exe: boolean;
  };

  /**
   * An object type that represents the {@link sap.m.VariantManagement} `manage`-event property `fav`.
   */
  export type VariantManagementFav = {
    /**
     * the variant key.
     */
    key: string;
    /**
     * flag describing the associated Favorite indicator.
     */
    visible: boolean;
  };

  /**
   * An object type that represents the {@link sap.m.VariantManagement} `manage`-event property `rename`.
   */
  export type VariantManagementRename = {
    /**
     * the variant key.
     */
    key: string;
    /**
     * the new title of the variant.
     */
    name: string;
  };

  /**
   * Types for the placement of message Popover control.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'VerticalPlacementType'.
   */
  export enum VerticalPlacementType {
    /**
     * Popover will be placed at the bottom of the reference control.
     */
    Bottom = "Bottom",
    /**
     * Popover will be placed at the top of the reference control.
     */
    Top = "Top",
    /**
     * Popover will be placed at the top or bottom of the reference control.
     */
    Vertical = "Vertical",
  }
  /**
   * Wizard rendering mode.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'WizardRenderMode'.
   *
   * @since 1.83
   */
  export enum WizardRenderMode {
    /**
     * Display steps as separate, single pages.
     */
    Page = "Page",
    /**
     * Display all steps into a scroll section.
     */
    Scroll = "Scroll",
  }
  /**
   * Available wrapping types for text controls that can be wrapped that enable you to display the text as
   * hyphenated.
   *
   * For more information about text hyphenation, see {@link sap.ui.core.hyphenation.Hyphenation} and {@link https://ui5.sap.com/#/topic/6322164936f047de941ec522b95d7b70 Text Controls Hyphenation}.
   *
   * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'WrappingType'.
   *
   * @since 1.60
   */
  export enum WrappingType {
    /**
     * Hyphenation will be used to break words on syllables where possible.
     */
    Hyphenated = "Hyphenated",
    /**
     * Normal text wrapping will be used. Words won't break based on hyphenation.
     */
    Normal = "Normal",
  }

  export namespace p13n {
    /**
     * Interface for P13nPopup which are suitable as content for the `sap.m.p13n.Popup`. Implementation of this
     * interface should include the following methods:
     *
     *
     * 	 - `getTitle`
     *
     * Implementation of this interface can optionally provide the following methods:
     *
     *
     * 	 - `getVerticalScrolling`
     * 	 - `onReset`
     *
     * @since 1.97
     */
    interface IContent {
      __implements__sap_m_p13n_IContent: boolean;

      /**
       * Returns the title, which should be displayed in the P13nPopup to describe related content.
       *
       *
       * @returns The title for the corresponding content to be displayed in the `sap.m.p13n.Popup`.
       */
      getTitle(): string;
      /**
       * Optionally returns the enablement of the contents vertical scrolling in case only one panel is used to
       * determine if the content provides its own scrolling capabilites.
       *
       *
       * @returns The enablement of the vertical scrolling enablement for the `sap.m.p13n.Popup`.
       */
      getVerticalScrolling?(): boolean;
      /**
       * Optional hook that will be executed when the panel is used by a `sap.m.p13n.Popup` that may trigger a
       * reset on the panel
       */
      onReset?(): void;
    }
  }

  export namespace plugins {
    /**
     * Defines the states of list items when the context menu is opened.
     *
     * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'plugins.ContextMenuScope'.
     *
     * @since 1.121
     */
    enum ContextMenuScope {
      /**
       * The scope is set to the default value where the focus is unaffected by the opening of the context menu.
       */
      Default = "Default",
      /**
       * The focus will be on the clicked item and also on other selected items, if the clicked item is selected.
       */
      Selection = "Selection",
    }
    /**
     * Enumeration of the `copyPreference` in `CopyProvider`. Determines what is copied during a copy operation.
     *
     * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'plugins.CopyPreference'.
     *
     * @since 1.119
     */
    enum CopyPreference {
      /**
       * If cells are selected, only the content of the selected cells is copied, regardless of any other rows
       * or elements that might also be selected. If no cells are selected, the copy operation will default to
       * copying the selected rows.
       */
      Cells = "Cells",
      /**
       * The entire selected scope is copied, including both row and cell selection.
       */
      Full = "Full",
    }
  }

  export namespace semantic {
    /**
     * Marker interface for controls which are suitable as items of the filter aggregation of sap.m.Semantic.MasterPage.
     */
    interface IFilter {
      __implements__sap_m_semantic_IFilter: boolean;
    }

    /**
     * Marker interface for controls which are suitable as items of the group aggregation of sap.m.Semantic.MasterPage.
     */
    interface IGroup {
      __implements__sap_m_semantic_IGroup: boolean;
    }

    /**
     * Marker interface for controls which are suitable as items of the sort aggregation of sap.m.Semantic.MasterPage.
     */
    interface ISort {
      __implements__sap_m_semantic_ISort: boolean;
    }

    /**
     * Declares the type of semantic ruleset that will govern the styling and positioning of semantic content.
     *
     * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'semantic.SemanticRuleSetType'.
     *
     * @since 1.44
     */
    enum SemanticRuleSetType {
      /**
       * The default ruleset type, for which the Share Menu is always in the footer of the page.
       */
      Classic = "Classic",
      /**
       * Offers an optimized user experience, with displaying the Share Menu in the header, rather than the footer,
       * for Fullscreen mode.
       */
      Optimized = "Optimized",
    }
  }

  export namespace table {
    namespace columnmenu {
      /**
       * Categories of column menu entries.
       *
       * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'table.columnmenu.Category'.
       *
       * @since 1.110
       */
      enum Category {
        /**
         * Aggregate category
         */
        Aggregate = "Aggregate",
        /**
         * Filter category
         */
        Filter = "Filter",
        /**
         * Generic category
         */
        Generic = "Generic",
        /**
         * Group category
         */
        Group = "Group",
        /**
         * Sort category
         */
        Sort = "Sort",
      }
      /**
       * Defines the available content sizes for the `sap.m.table.columnmenu.QuickAction` control.
       *
       * This enum is part of the 'sap/m/library' module export and must be accessed by the property 'table.columnmenu.QuickActionContentSize'.
       */
      enum QuickActionContentSize {
        /**
         * Large: Recommended for larger input controls, such as {@link sap.m.Input} or {@link sap.m.RatingIndicator}.
         * If there is limited space, the input control moves to a new line below the label.
         */
        L = "L",
        /**
         * Small: Recommended for smaller controls, such as {@link sap.m.Switch} or {@link sap.m.Checkbox}. If there
         * is limited space, only the label is wrapped. The input control is always right-aligned horizontally and
         * middle-aligned vertically.
         */
        S = "S",
      }
    }
  }

  export namespace touch {
    /**
     * Given a list of touches, count the number of touches related with the given element.
     *
     *
     * @returns The number of touches related with the given element.
     */
    function countContained(
      /**
       * The list of touch objects to search.
       */
      oTouchList: TouchList,
      /**
       * A jQuery element or an element reference or an element id.
       */
      vElement: jQuery | Element | string
    ): number;
    /**
     * Given a list of touch objects, find the touch that matches the given one.
     *
     *
     * @returns The touch matching if any.
     */
    function find(
      /**
       * The list of touch objects to search.
       */
      oTouchList: TouchList,
      /**
       * A touch object to find or a Touch.identifier that uniquely identifies the current finger in the touch
       * session.
       */
      oTouch: Touch | number
    ): object | undefined;
  }
}

declare module "sap/m/Support" {
  /**
   *
   * ```javascript
   *
   * `sap.m.Support` shows the technical information for SAPUI5 Mobile Applications.
   * This technical information includes:
   *    * SAPUI5 Version
   *    * User Agent
   *    * Configurations (Bootstrap and Computed)
   *    * URI parameters
   *    * All loaded module names
   *
   * In order to show the device information, the user must follow the following gestures.
   *    1 - Hold two fingers for 3 seconds minimum.
   *    2 - Tab with a third finger while holding the first two fingers.
   *
   * NOTE: This class is internal and all its functions must not be used by an application
   *
   * Enable Support:
   * --------------------------------------------------
   * //import
   * sap.ui.require("sap/m/Support", function (Support) {
   *   // Support is initialized and is listening for fingers gestures combination
   * });
   *
   * //By default after require, support is enabled but implicitly we can call
   * Support.on();
   *
   * Disable Support:
   * --------------------------------------------------
   * Support.off();
   * ```
   *
   *
   * @since 1.11.0
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  const Support: undefined;

  export default Support;
}

declare module "sap/m/ActionListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { ListMode } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.m.ActionListItem` can be used like a `button` to fire actions when pressed. **Note:** The inherited
   * `selected` property of the `sap.m.ListItemBase` is not supported.
   */
  export default class ActionListItem extends ListItemBase {
    /**
     * Constructor for a new ActionListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:/action-list-item/ Action List Item}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ActionListItemSettings
    );
    /**
     * Constructor for a new ActionListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:/action-list-item/ Action List Item}
     */
    constructor(
      /**
       * Id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ActionListItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.ActionListItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ActionListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Determines item specific mode.
     *
     * ActionListItems are not selectable because they are command controls (like Button or Link), so triggering
     * the associated command, rather than selection is appropriate to happen upon user action on these items.
     *
     * By overwriting `getMode` (inherited from `ListItemBase`), we exclude the item from processing steps that
     * are specific for selectable list-items.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Mode of the list item.
     */
    getMode(): ListMode | "";
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text that appears in the control.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text that appears in the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ActionListItem constructor.
   */
  export interface $ActionListItemSettings extends $ListItemBaseSettings {
    /**
     * Defines the text that appears in the control.
     */
    text?: string | PropertyBindingInfo;
  }
}

declare module "sap/m/ActionSelect" {
  import { default as Select, $SelectSettings } from "sap/m/Select";

  import { ID } from "sap/ui/core/library";

  import Button from "sap/m/Button";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The ActionSelect control provides a list of predefined items that allows end users to choose options
   * and additionally trigger some actions.
   *
   * @since 1.16
   * @deprecated As of version 1.111. with no replacement. The control is no longer considered part of the
   * Fiori concept.
   */
  export default class ActionSelect extends Select {
    /**
     * Constructor for a new ActionSelect.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionSelectSettings
    );
    /**
     * Constructor for a new ActionSelect.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionSelectSettings
    );

    /**
     * Creates a new subclass of class sap.m.ActionSelect with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Select.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionSelect>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ActionSelect.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some button into the association {@link #getButtons buttons}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addButton(
      /**
       * The buttons to add; if empty, nothing is inserted
       */
      vButton: ID | Button
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getButtons buttons}.
     */
    getButtons(): ID[];
    /**
     * Remove all buttons from the ActionSelect.
     *
     *
     * @returns An array with the ids of the removed elements (might be empty).
     */
    removeAllButtons(): string[];
    /**
     * Removes the given button from the `ActionSelect` content.
     *
     *
     * @returns The ID of the removed button or `null`.
     */
    removeButton(
      /**
       * The button to remove or its index or ID.
       */
      vButton: int | ID | Button
    ): string | null;
  }
  /**
   * Describes the settings that can be provided to the ActionSelect constructor.
   *
   * @deprecated As of version 1.111. with no replacement. The control is no longer considered part of the
   * Fiori concept.
   */
  export interface $ActionSelectSettings extends $SelectSettings {
    /**
     * Buttons to be added to the ActionSelect content.
     */
    buttons?: Array<Button | string>;
  }
}

declare module "sap/m/ActionSheet" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Button from "sap/m/Button";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PlacementType } from "sap/m/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * The action sheet holds a list of options from which the user can select to complete an action. Overview:
   * The options of the action sheet are represented as {@link sap.m.Button buttons} with icons. Elements
   * in the action sheet are left-aligned. Actions should be arranged in order of importance, from top to
   * bottom. Guidelines:
   * 	 - Always display text or text and icons for the actions. Do not use icons only.
   * 	 - Always provide a Cancel button on mobile phones.
   * 	 - Avoid scrolling on action sheets.  Responsive Behavior: On mobile phones the action sheet is
   *     displayed in a {@link sap.m.Dialog dialog}.
   *
   * On tablets and desktop the action sheet is displayed in a {@link sap.m.Popover popover}.
   *
   * When an action is triggered, the action sheet closes and you can display a confirmation as a {@link sap.m.MessageToast message toast}.
   *
   * @since 1.9.1
   */
  export default class ActionSheet extends Control {
    /**
     * Constructor for a new ActionSheet.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/action-sheet/ Action Sheet}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ActionSheetSettings
    );
    /**
     * Constructor for a new ActionSheet.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/action-sheet/ Action Sheet}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ActionSheetSettings
    );

    /**
     * Creates a new subclass of class sap.m.ActionSheet with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionSheet>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ActionSheet.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some button to the aggregation {@link #getButtons buttons}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addButton(
      /**
       * The button to add; if empty, nothing is inserted
       */
      oButton: Button
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired after the ActionSheet is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionSheet$AfterCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired after the ActionSheet is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionSheet$AfterCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired after the ActionSheet is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired after the ActionSheet is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired before the ActionSheet is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionSheet$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired before the ActionSheet is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionSheet$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired before the ActionSheet is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event will be fired before the ActionSheet is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelButtonPress cancelButtonPress} event of
     * this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event is fired when the cancelButton is clicked.
     *
     * **Note: ** For any device other than phones, this event would be fired always when the Popover closes.
     * To prevent this behavior, the `showCancelButton` property needs to be set to `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelButtonPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelButtonPress cancelButtonPress} event of
     * this `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event is fired when the cancelButton is clicked.
     *
     * **Note: ** For any device other than phones, this event would be fired always when the Popover closes.
     * To prevent this behavior, the `showCancelButton` property needs to be set to `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelButtonPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelButtonTap cancelButtonTap} event of this
     * `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event is fired when the cancelButton is tapped. For iPad, this event is also fired when showCancelButton
     * is set to true, and Popover is closed by tapping outside.
     *
     * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelButtonTap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:cancelButtonTap cancelButtonTap} event of this
     * `sap.m.ActionSheet`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionSheet` itself.
     *
     * This event is fired when the cancelButton is tapped. For iPad, this event is also fired when showCancelButton
     * is set to true, and Popover is closed by tapping outside.
     *
     * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachCancelButtonTap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionSheet` itself
       */
      oListener?: object
    ): this;
    /**
     * Calling this method will make the ActionSheet disappear from the screen.
     */
    close(): void;
    /**
     * Destroys all the buttons in the aggregation {@link #getButtons buttons}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyButtons(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterClose afterClose} event of this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ActionSheet$AfterCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterOpen afterOpen} event of this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeClose beforeClose} event of this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ActionSheet$BeforeCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeOpen beforeOpen} event of this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancelButtonPress cancelButtonPress} event
     * of this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancelButtonPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:cancelButtonTap cancelButtonTap} event of
     * this `sap.m.ActionSheet`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachCancelButtonTap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterClose afterClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ActionSheet$AfterCloseEventParameters
    ): this;
    /**
     * Fires event {@link #event:afterOpen afterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeClose beforeClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ActionSheet$BeforeCloseEventParameters
    ): this;
    /**
     * Fires event {@link #event:beforeOpen beforeOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:cancelButtonPress cancelButtonPress} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancelButtonPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:cancelButtonTap cancelButtonTap} to attached listeners.
     *
     * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireCancelButtonTap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getButtons buttons}.
     *
     * These buttons are added to the content area in ActionSheet control. When button is tapped, the ActionSheet
     * is closed before the tap event listener is called.
     */
    getButtons(): Button[];
    /**
     * Gets current value of property {@link #getCancelButtonText cancelButtonText}.
     *
     * This is the text displayed in the cancelButton. Default value is "Cancel", and it's translated according
     * to the current locale setting. This property will be ignored when running either in iPad or showCancelButton
     * is set to false.
     *
     *
     * @returns Value of property `cancelButtonText`
     */
    getCancelButtonText(): string;
    /**
     * Gets current value of property {@link #getPlacement placement}.
     *
     * The ActionSheet behaves as an sap.m.Popover in iPad and this property is the information about on which
     * side will the popover be placed at.
     *
     * Possible values are sap.m.PlacementType.Left, sap.m.PlacementType.Right, sap.m.PlacementType.Top, sap.m.PlacementType.Bottom,
     * sap.m.PlacementType.Horizontal, sap.m.PlacementType.HorizontalPreferredLeft, sap.m.PlacementType.HorizontalPreferredRight,
     * sap.m.PlacementType.Vertical, sap.m.PlacementType.VerticalPreferredTop, sap.m.PlacementType.VerticalPreferredBottom.
     * The default value is sap.m.PlacementType.Bottom.
     *
     * Default value is `Bottom`.
     *
     *
     * @returns Value of property `placement`
     */
    getPlacement(): PlacementType;
    /**
     * Gets the ID of the hidden label
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns ID of hidden text
     */
    getPopupHiddenLabelId(): string;
    /**
     * Gets current value of property {@link #getShowCancelButton showCancelButton}.
     *
     * If this is set to true, there will be a cancel button shown below the action buttons. There won't be
     * any cancel button shown in iPad regardless of this property. The default value is set to true.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showCancelButton`
     */
    getShowCancelButton(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title will be shown in the header area in iPhone and every Android devices. This property will be ignored
     * in tablets and desktop browser.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Checks for the provided `sap.m.Button` in the aggregation {@link #getButtons buttons}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfButton(
      /**
       * The button whose index is looked for
       */
      oButton: Button
    ): int;
    /**
     * Inserts a button into the aggregation {@link #getButtons buttons}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertButton(
      /**
       * The button to insert; if empty, nothing is inserted
       */
      oButton: Button,
      /**
       * The `0`-based index the button should be inserted at; for a negative value of `iIndex`, the button is
       * inserted at position 0; for a value greater than the current size of the aggregation, the button is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * The method checks if the ActionSheet is open. It returns true when the ActionSheet is currently open
     * (this includes opening and closing animations), otherwise it returns false.
     *
     *
     * @returns Whether the ActionSheet is open.
     */
    isOpen(): boolean;
    /**
     * Calling this method will make the ActionSheet visible on the screen. The control parameter is the object
     * to which the ActionSheet will be placed. It can be not only a UI5 control, but also an existing DOM reference.
     * The side of the placement depends on the `placement` property set in the Popover (on tablet and desktop).
     * On other platforms, ActionSheet behaves as a standard dialog and this parameter is ignored because dialog
     * is aligned to the screen.
     */
    openBy(
      /**
       * The control to which the ActionSheet is opened
       */
      oControl: Control | HTMLElement
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getButtons buttons}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllButtons(): Button[];
    /**
     * Removes a button from the aggregation {@link #getButtons buttons}.
     *
     *
     * @returns The removed button or `null`
     */
    removeButton(
      /**
       * The button to remove or its index or id
       */
      vButton: int | string | Button
    ): Button | null;
    /**
     * Sets a new value for property {@link #getCancelButtonText cancelButtonText}.
     *
     * This is the text displayed in the cancelButton. Default value is "Cancel", and it's translated according
     * to the current locale setting. This property will be ignored when running either in iPad or showCancelButton
     * is set to false.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCancelButtonText(
      /**
       * New value for property `cancelButtonText`
       */
      sCancelButtonText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlacement placement}.
     *
     * The ActionSheet behaves as an sap.m.Popover in iPad and this property is the information about on which
     * side will the popover be placed at.
     *
     * Possible values are sap.m.PlacementType.Left, sap.m.PlacementType.Right, sap.m.PlacementType.Top, sap.m.PlacementType.Bottom,
     * sap.m.PlacementType.Horizontal, sap.m.PlacementType.HorizontalPreferredLeft, sap.m.PlacementType.HorizontalPreferredRight,
     * sap.m.PlacementType.Vertical, sap.m.PlacementType.VerticalPreferredTop, sap.m.PlacementType.VerticalPreferredBottom.
     * The default value is sap.m.PlacementType.Bottom.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Bottom`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlacement(
      /**
       * New value for property `placement`
       */
      sPlacement?: PlacementType | keyof typeof PlacementType
    ): this;
    /**
     * Sets a new value for property {@link #getShowCancelButton showCancelButton}.
     *
     * If this is set to true, there will be a cancel button shown below the action buttons. There won't be
     * any cancel button shown in iPad regardless of this property. The default value is set to true.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCancelButton(
      /**
       * New value for property `showCancelButton`
       */
      bShowCancelButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title will be shown in the header area in iPhone and every Android devices. This property will be ignored
     * in tablets and desktop browser.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ActionSheet constructor.
   */
  export interface $ActionSheetSettings extends $ControlSettings {
    /**
     * The ActionSheet behaves as an sap.m.Popover in iPad and this property is the information about on which
     * side will the popover be placed at.
     *
     * Possible values are sap.m.PlacementType.Left, sap.m.PlacementType.Right, sap.m.PlacementType.Top, sap.m.PlacementType.Bottom,
     * sap.m.PlacementType.Horizontal, sap.m.PlacementType.HorizontalPreferredLeft, sap.m.PlacementType.HorizontalPreferredRight,
     * sap.m.PlacementType.Vertical, sap.m.PlacementType.VerticalPreferredTop, sap.m.PlacementType.VerticalPreferredBottom.
     * The default value is sap.m.PlacementType.Bottom.
     */
    placement?:
      | (PlacementType | keyof typeof PlacementType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If this is set to true, there will be a cancel button shown below the action buttons. There won't be
     * any cancel button shown in iPad regardless of this property. The default value is set to true.
     */
    showCancelButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This is the text displayed in the cancelButton. Default value is "Cancel", and it's translated according
     * to the current locale setting. This property will be ignored when running either in iPad or showCancelButton
     * is set to false.
     */
    cancelButtonText?: string | PropertyBindingInfo;

    /**
     * Title will be shown in the header area in iPhone and every Android devices. This property will be ignored
     * in tablets and desktop browser.
     */
    title?: string | PropertyBindingInfo;

    /**
     * These buttons are added to the content area in ActionSheet control. When button is tapped, the ActionSheet
     * is closed before the tap event listener is called.
     */
    buttons?: Button[] | Button | AggregationBindingInfo | `{${string}}`;

    /**
     * This event is fired when the cancelButton is tapped. For iPad, this event is also fired when showCancelButton
     * is set to true, and Popover is closed by tapping outside.
     *
     * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
     */
    cancelButtonTap?: (oEvent: Event) => void;

    /**
     * This event will be fired before the ActionSheet is opened.
     */
    beforeOpen?: (oEvent: Event) => void;

    /**
     * This event will be fired after the ActionSheet is opened.
     */
    afterOpen?: (oEvent: Event) => void;

    /**
     * This event will be fired before the ActionSheet is closed.
     */
    beforeClose?: (oEvent: ActionSheet$BeforeCloseEvent) => void;

    /**
     * This event will be fired after the ActionSheet is closed.
     */
    afterClose?: (oEvent: ActionSheet$AfterCloseEvent) => void;

    /**
     * This event is fired when the cancelButton is clicked.
     *
     * **Note: ** For any device other than phones, this event would be fired always when the Popover closes.
     * To prevent this behavior, the `showCancelButton` property needs to be set to `false`.
     */
    cancelButtonPress?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ActionSheet#afterClose event.
   */
  export interface ActionSheet$AfterCloseEventParameters {
    /**
     * This indicates the trigger of closing the control. If dialog is closed by either selection or closeButton
     * (on mobile device), the button that closes the dialog is set to this parameter. Otherwise this parameter
     * is set to null.
     */
    origin?: Button;
  }

  /**
   * Event object of the ActionSheet#afterClose event.
   */
  export type ActionSheet$AfterCloseEvent = Event<
    ActionSheet$AfterCloseEventParameters,
    ActionSheet
  >;

  /**
   * Parameters of the ActionSheet#afterOpen event.
   */
  export interface ActionSheet$AfterOpenEventParameters {}

  /**
   * Event object of the ActionSheet#afterOpen event.
   */
  export type ActionSheet$AfterOpenEvent = Event<
    ActionSheet$AfterOpenEventParameters,
    ActionSheet
  >;

  /**
   * Parameters of the ActionSheet#beforeClose event.
   */
  export interface ActionSheet$BeforeCloseEventParameters {
    /**
     * This indicates the trigger of closing the dialog. If dialog is closed by either leftButton or rightButton,
     * the button that closes the dialog is set to this parameter. Otherwise this parameter is set to null.
     * This is valid only for Phone mode of the ActionSheet
     */
    origin?: Button;
  }

  /**
   * Event object of the ActionSheet#beforeClose event.
   */
  export type ActionSheet$BeforeCloseEvent = Event<
    ActionSheet$BeforeCloseEventParameters,
    ActionSheet
  >;

  /**
   * Parameters of the ActionSheet#beforeOpen event.
   */
  export interface ActionSheet$BeforeOpenEventParameters {}

  /**
   * Event object of the ActionSheet#beforeOpen event.
   */
  export type ActionSheet$BeforeOpenEvent = Event<
    ActionSheet$BeforeOpenEventParameters,
    ActionSheet
  >;

  /**
   * Parameters of the ActionSheet#cancelButtonPress event.
   */
  export interface ActionSheet$CancelButtonPressEventParameters {}

  /**
   * Event object of the ActionSheet#cancelButtonPress event.
   */
  export type ActionSheet$CancelButtonPressEvent = Event<
    ActionSheet$CancelButtonPressEventParameters,
    ActionSheet
  >;

  /**
   * Parameters of the ActionSheet#cancelButtonTap event.
   *
   * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
   */
  export interface ActionSheet$CancelButtonTapEventParameters {}

  /**
   * Event object of the ActionSheet#cancelButtonTap event.
   *
   * @deprecated As of version 1.20.0. This event is deprecated, use the cancelButtonPress event instead.
   */
  export type ActionSheet$CancelButtonTapEvent = Event<
    ActionSheet$CancelButtonTapEventParameters,
    ActionSheet
  >;
}

declare module "sap/m/ActionTile" {
  import {
    default as GenericTile,
    $GenericTileSettings,
  } from "sap/m/GenericTile";

  import { URI, ValueState } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Priority } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Used to create a customizable tile for your todos and situations within the new My Home in SAP S/4HANA
   * cloud
   *
   * @since 1.122
   */
  export default class ActionTile extends GenericTile {
    /**
     * Constructor for a new sap.m.ActionTile control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionTileSettings
    );
    /**
     * Constructor for a new sap.m.ActionTile control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionTileSettings
    );

    /**
     * Creates a new subclass of class sap.m.ActionTile with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.GenericTile.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ActionTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getBadgeIcon badgeIcon}.
     *
     * Defines what type of icon is displayed as visual affordance for the icon frame badge.
     *
     * Default value is `empty string`.
     *
     * @since 1.124
     *
     * @returns Value of property `badgeIcon`
     */
    getBadgeIcon(): URI;
    /**
     * Gets current value of property {@link #getBadgeValueState badgeValueState}.
     *
     * Visualizes the validation state of the icon frame badge, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * Default value is `None`.
     *
     * @since 1.124
     *
     * @returns Value of property `badgeValueState`
     */
    getBadgeValueState(): ValueState;
    /**
     * Gets current value of property {@link #getEnableDynamicHeight enableDynamicHeight}.
     *
     * The height of the tile changes dynamically to accommodate the content inside it
     *
     * Default value is `false`.
     *
     * @since 1.124
     *
     * @returns Value of property `enableDynamicHeight`
     */
    getEnableDynamicHeight(): boolean;
    /**
     * Gets current value of property {@link #getEnableIconFrame enableIconFrame}.
     *
     * Decides whether the headerImage should have a frame or not.
     *
     * Default value is `false`.
     *
     * @since 1.124
     *
     * @returns Value of property `enableIconFrame`
     */
    getEnableIconFrame(): boolean;
    /**
     * Gets current value of property {@link #getPriority priority}.
     *
     * Adds a priority indicator for the Action Tile.
     *
     * Default value is `None`.
     *
     * @since 1.124
     *
     * @returns Value of property `priority`
     */
    getPriority(): Priority;
    /**
     * Gets current value of property {@link #getPriorityText priorityText}.
     *
     * Sets the text inside the priority indicator for the Action Tile.
     *
     * @since 1.124
     *
     * @returns Value of property `priorityText`
     */
    getPriorityText(): string;
    /**
     * Sets the badgeIcon property of the ActionTile.
     *
     *
     * @returns The reference to the ActionTile instance.
     */
    setBadgeIcon(
      /**
       * The URI of the icon to be displayed as a badge.
       */
      sIcon: string
    ): ActionTile;
    /**
     * Sets the badgeValueState property of the ActionTile.
     *
     *
     * @returns The reference to the ActionTile instance.
     */
    setBadgeValueState(
      /**
       * The value state of the badge.
       */
      sValueState: ValueState | keyof typeof ValueState
    ): ActionTile;
    /**
     * Sets a new value for property {@link #getEnableDynamicHeight enableDynamicHeight}.
     *
     * The height of the tile changes dynamically to accommodate the content inside it
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.124
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableDynamicHeight(
      /**
       * New value for property `enableDynamicHeight`
       */
      bEnableDynamicHeight?: boolean
    ): this;
    /**
     * Sets the enableIconFrame property of the ActionTile.
     *
     *
     * @returns The reference to the ActionTile instance.
     */
    setEnableIconFrame(
      /**
       * Determines whether the icon frame should be enabled or not.
       */
      bValue: boolean
    ): ActionTile;
    /**
     * Sets a new value for property {@link #getPriority priority}.
     *
     * Adds a priority indicator for the Action Tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.124
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPriority(
      /**
       * New value for property `priority`
       */
      sPriority?: Priority | keyof typeof Priority
    ): this;
    /**
     * Sets a new value for property {@link #getPriorityText priorityText}.
     *
     * Sets the text inside the priority indicator for the Action Tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.124
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPriorityText(
      /**
       * New value for property `priorityText`
       */
      sPriorityText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ActionTile constructor.
   */
  export interface $ActionTileSettings extends $GenericTileSettings {
    /**
     * The height of the tile changes dynamically to accommodate the content inside it
     *
     * @since 1.124
     */
    enableDynamicHeight?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Decides whether the headerImage should have a frame or not.
     *
     * @since 1.124
     */
    enableIconFrame?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Adds a priority indicator for the Action Tile.
     *
     * @since 1.124
     */
    priority?:
      | (Priority | keyof typeof Priority)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Sets the text inside the priority indicator for the Action Tile.
     *
     * @since 1.124
     */
    priorityText?: string | PropertyBindingInfo;

    /**
     * Defines what type of icon is displayed as visual affordance for the icon frame badge.
     *
     * @since 1.124
     */
    badgeIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Visualizes the validation state of the icon frame badge, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * @since 1.124
     */
    badgeValueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/ActionTileContent" {
  import {
    default as TileContent,
    $TileContentSettings,
  } from "sap/m/TileContent";

  import TileAttribute from "sap/m/TileAttribute";

  import Link from "sap/m/Link";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * This control is used within the ActionTile control and it renders the values from the custom attribute
   *
   * @since 1.122
   */
  export default class ActionTileContent extends TileContent {
    /**
     * Constructor for a new sap.m.ActionTileContent control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionTileContentSettings
    );
    /**
     * Constructor for a new sap.m.ActionTileContent control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ActionTileContentSettings
    );

    /**
     * Creates a new subclass of class sap.m.ActionTileContent with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.TileContent.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ActionTileContent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ActionTileContent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some attribute to the aggregation {@link #getAttributes attributes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAttribute(
      /**
       * The attribute to add; if empty, nothing is inserted
       */
      oAttribute: TileAttribute
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:linkPress linkPress} event of this `sap.m.ActionTileContent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionTileContent` itself.
     *
     * The event is triggered when the user clicks on the link
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLinkPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionTileContent$LinkPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionTileContent` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:linkPress linkPress} event of this `sap.m.ActionTileContent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ActionTileContent` itself.
     *
     * The event is triggered when the user clicks on the link
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLinkPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ActionTileContent$LinkPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ActionTileContent` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the attributes in the aggregation {@link #getAttributes attributes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyAttributes(): this;
    /**
     * Destroys the headerLink in the aggregation {@link #getHeaderLink headerLink}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeaderLink(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:linkPress linkPress} event of this `sap.m.ActionTileContent`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLinkPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ActionTileContent$LinkPressEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:linkPress linkPress} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireLinkPress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ActionTileContent$LinkPressEventParameters
    ): boolean;
    /**
     * Gets content of aggregation {@link #getAttributes attributes}.
     *
     * Holds detail of an attribute used in the ActionTile.
     */
    getAttributes(): TileAttribute[];
    /**
     * Gets content of aggregation {@link #getHeaderLink headerLink}.
     *
     * Adds header link for the tile content.
     */
    getHeaderLink(): Link;
    /**
     * Checks for the provided `sap.m.TileAttribute` in the aggregation {@link #getAttributes attributes}. and
     * returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfAttribute(
      /**
       * The attribute whose index is looked for
       */
      oAttribute: TileAttribute
    ): int;
    /**
     * Inserts a attribute into the aggregation {@link #getAttributes attributes}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertAttribute(
      /**
       * The attribute to insert; if empty, nothing is inserted
       */
      oAttribute: TileAttribute,
      /**
       * The `0`-based index the attribute should be inserted at; for a negative value of `iIndex`, the attribute
       * is inserted at position 0; for a value greater than the current size of the aggregation, the attribute
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getAttributes attributes}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAttributes(): TileAttribute[];
    /**
     * Removes a attribute from the aggregation {@link #getAttributes attributes}.
     *
     *
     * @returns The removed attribute or `null`
     */
    removeAttribute(
      /**
       * The attribute to remove or its index or id
       */
      vAttribute: int | string | TileAttribute
    ): TileAttribute | null;
    /**
     * Sets the aggregated {@link #getHeaderLink headerLink}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderLink(
      /**
       * The headerLink to set
       */
      oHeaderLink: Link
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ActionTileContent constructor.
   */
  export interface $ActionTileContentSettings extends $TileContentSettings {
    /**
     * Adds header link for the tile content.
     */
    headerLink?: Link;

    /**
     * Holds detail of an attribute used in the ActionTile.
     */
    attributes?:
      | TileAttribute[]
      | TileAttribute
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * The event is triggered when the user clicks on the link
     */
    linkPress?: (oEvent: ActionTileContent$LinkPressEvent) => void;
  }

  /**
   * Parameters of the ActionTileContent#linkPress event.
   */
  export interface ActionTileContent$LinkPressEventParameters {
    /**
     * Indicates whether the CTRL key was pressed when the link was selected.
     */
    ctrlKey?: boolean;

    /**
     * Indicates whether the "meta" key was pressed when the link was selected.
     *
     * On Macintosh keyboards, this is the command key (⌘). On Windows keyboards, this is the windows key (⊞).
     */
    metaKey?: boolean;

    /**
     * Returns the TileAttribute instance of the clicked link
     */
    attribute?: TileAttribute;

    /**
     * Returns the link instance
     */
    link?: Link;
  }

  /**
   * Event object of the ActionTileContent#linkPress event.
   */
  export type ActionTileContent$LinkPressEvent = Event<
    ActionTileContent$LinkPressEventParameters,
    ActionTileContent
  >;
}

declare module "sap/m/App" {
  import {
    default as NavContainer,
    $NavContainerSettings,
  } from "sap/m/NavContainer";

  import { URI } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The root element of a UI5 mobile app.
   *
   * Overview:
   *
   * The `App` inherits from {@link sap.m.NavContainer} and thus provides its navigation capabilities. It
   * adds certain header tags to the HTML page which are considered useful for mobile apps.
   *
   * Usage:
   *
   * You can configure the home icon of the `App`. For more information, see the `homeIcon` property.
   *
   * There are options for setting the background color and a background image with the use of the `backgroundColor`
   * and `backgroundImage` properties.
   *
   * **Note**: Keep in mind that by default (`isTopLevel` is set to `true`) `sap.m.App` traverses its parent
   * elements and automatically sets their height to 100%.
   */
  export default class App extends NavContainer {
    /**
     * Constructor for a new `App`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/a4afb138acf64a61a038aa5b91a4f082 App}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AppSettings
    );
    /**
     * Constructor for a new `App`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/a4afb138acf64a61a038aa5b91a4f082 App}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AppSettings
    );

    /**
     * Creates a new subclass of class sap.m.App with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.NavContainer.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, App>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.App.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:orientationChange orientationChange} event of
     * this `sap.m.App`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.App` itself.
     *
     * Fired when the orientation (portrait/landscape) of the device is changed.
     *
     * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOrientationChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: App$OrientationChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.App` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:orientationChange orientationChange} event of
     * this `sap.m.App`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.App` itself.
     *
     * Fired when the orientation (portrait/landscape) of the device is changed.
     *
     * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachOrientationChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: App$OrientationChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.App` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:orientationChange orientationChange} event
     * of this `sap.m.App`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachOrientationChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: App$OrientationChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:orientationChange orientationChange} to attached listeners.
     *
     * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireOrientationChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: App$OrientationChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of the App. If set, this color will override the default background defined by the theme.
     * So this should only be set when really required. Any configured background image will be placed above
     * this colored background. But any theme adaptation in the Theme Designer will override this setting. Use
     * the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * @since 1.11.2
     *
     * @returns Value of property `backgroundColor`
     */
    getBackgroundColor(): string;
    /**
     * Gets current value of property {@link #getBackgroundImage backgroundImage}.
     *
     * Background image of the App. If set, this image will override the default background defined by the theme.
     * So this should only be set when really required. This background image will be placed above any color
     * set for the background. But any theme adaptation in the Theme Designer will override this image setting.
     * Use the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * @since 1.11.2
     *
     * @returns Value of property `backgroundImage`
     */
    getBackgroundImage(): URI;
    /**
     * Gets current value of property {@link #getBackgroundOpacity backgroundOpacity}.
     *
     * Opacity of the background image. The opacity can be set between 0 (fully transparent) and 1 fully opaque).
     * This can be used to make the application content better readable by making the background image partly
     * transparent.
     *
     * Default value is `1`.
     *
     * @since 1.11.2
     *
     * @returns Value of property `backgroundOpacity`
     */
    getBackgroundOpacity(): float;
    /**
     * Gets current value of property {@link #getBackgroundRepeat backgroundRepeat}.
     *
     * Whether the background image (if configured) should be proportionally stretched to cover the whole App
     * (false) or whether it should be tiled (true).
     *
     * Default value is `false`.
     *
     * @since 1.11.2
     *
     * @returns Value of property `backgroundRepeat`
     */
    getBackgroundRepeat(): boolean;
    /**
     * Gets current value of property {@link #getHomeIcon homeIcon}.
     *
     * The icon to be displayed on the home screen of iOS devices after the user does "add to home screen".
     *
     * Note that only the first attempt to set the homeIcon will be executed, subsequent settings are ignored.
     *
     * This icon must be in PNG format. The property can either hold the URL of one single icon which is used
     * for all devices (and possibly scaled, which looks not perfect), or an object holding icon URLs for the
     * different required sizes.
     *
     * A desktop icon (used for bookmarks and overriding the favicon) can also be configured. This requires
     * an object to be given and the "icon" property of this object then defines the desktop bookmark icon.
     * The ICO format is supported by all browsers. ICO is also preferred for this desktop icon setting because
     * the file can contain different images for different resolutions.
     *
     * One example is:
     *
     * app.setHomeIcon({ 'phone':'phone-icon.png', 'phone@2':'phone-retina.png', 'tablet':'tablet-icon.png',
     * 'tablet@2':'tablet-retina.png', 'icon':'desktop.ico' });
     *
     * The respective image sizes are 57/114 px for the phone and 72/144 px for the tablet. If an object is
     * given but one of the sizes is not given, the largest given icon will be used for this size.
     *
     * On Android these icons may or may not be used by the device. Apparently chances can be improved by adding
     * glare effect and rounded corners, setting the file name so it ends with "-precomposed.png" and setting
     * the "homeIconPrecomposed" property to "true".
     *
     *
     * @returns Value of property `homeIcon`
     */
    getHomeIcon(): any;
    /**
     * Gets current value of property {@link #getIsTopLevel isTopLevel}.
     *
     * Determines whether `sap.m.App` is used as a top level control.
     *
     * **Note**: When the `isTopLevel` property set to `true`, `sap.m.App` traverses its parent DOM elements
     * and sets their height to 100%.
     *
     * Default value is `true`.
     *
     * @since 1.91
     *
     * @returns Value of property `isTopLevel`
     */
    getIsTopLevel(): boolean;
    /**
     * Gets current value of property {@link #getMobileWebAppCapable mobileWebAppCapable}.
     *
     * Determines whether the `App` is displayed without address bar when opened from an exported home screen
     * icon on a mobile device.
     *
     * Keep in mind that if enabled, there is no back button provided by the browser and the app must provide
     * own navigation on all displayed pages to avoid dead ends.
     *
     * **Note** The property can be toggled, but it doesn't take effect in real time. It takes the set value
     * at the moment when the home screen icon is exported by the user. For example, if the icon is exported
     * while the property is set to `true`, the `App` will have no address bar when opened from that same icon
     * regardless of a changed property value to `false` at a later time.
     *
     * Default value is `true`.
     *
     * @since 1.58.0
     *
     * @returns Value of property `mobileWebAppCapable`
     */
    getMobileWebAppCapable(): boolean;
    /**
     * Sets a new value for property {@link #getBackgroundColor backgroundColor}.
     *
     * Background color of the App. If set, this color will override the default background defined by the theme.
     * So this should only be set when really required. Any configured background image will be placed above
     * this colored background. But any theme adaptation in the Theme Designer will override this setting. Use
     * the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.11.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundColor(
      /**
       * New value for property `backgroundColor`
       */
      sBackgroundColor?: string
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundImage backgroundImage}.
     *
     * Background image of the App. If set, this image will override the default background defined by the theme.
     * So this should only be set when really required. This background image will be placed above any color
     * set for the background. But any theme adaptation in the Theme Designer will override this image setting.
     * Use the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.11.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundImage(
      /**
       * New value for property `backgroundImage`
       */
      sBackgroundImage?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundOpacity backgroundOpacity}.
     *
     * Opacity of the background image. The opacity can be set between 0 (fully transparent) and 1 fully opaque).
     * This can be used to make the application content better readable by making the background image partly
     * transparent.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @since 1.11.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundOpacity(
      /**
       * New value for property `backgroundOpacity`
       */
      fBackgroundOpacity?: float
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundRepeat backgroundRepeat}.
     *
     * Whether the background image (if configured) should be proportionally stretched to cover the whole App
     * (false) or whether it should be tiled (true).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.11.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundRepeat(
      /**
       * New value for property `backgroundRepeat`
       */
      bBackgroundRepeat?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getHomeIcon homeIcon}.
     *
     * The icon to be displayed on the home screen of iOS devices after the user does "add to home screen".
     *
     * Note that only the first attempt to set the homeIcon will be executed, subsequent settings are ignored.
     *
     * This icon must be in PNG format. The property can either hold the URL of one single icon which is used
     * for all devices (and possibly scaled, which looks not perfect), or an object holding icon URLs for the
     * different required sizes.
     *
     * A desktop icon (used for bookmarks and overriding the favicon) can also be configured. This requires
     * an object to be given and the "icon" property of this object then defines the desktop bookmark icon.
     * The ICO format is supported by all browsers. ICO is also preferred for this desktop icon setting because
     * the file can contain different images for different resolutions.
     *
     * One example is:
     *
     * app.setHomeIcon({ 'phone':'phone-icon.png', 'phone@2':'phone-retina.png', 'tablet':'tablet-icon.png',
     * 'tablet@2':'tablet-retina.png', 'icon':'desktop.ico' });
     *
     * The respective image sizes are 57/114 px for the phone and 72/144 px for the tablet. If an object is
     * given but one of the sizes is not given, the largest given icon will be used for this size.
     *
     * On Android these icons may or may not be used by the device. Apparently chances can be improved by adding
     * glare effect and rounded corners, setting the file name so it ends with "-precomposed.png" and setting
     * the "homeIconPrecomposed" property to "true".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHomeIcon(
      /**
       * New value for property `homeIcon`
       */
      oHomeIcon?: any
    ): this;
    /**
     * Sets a new value for property {@link #getIsTopLevel isTopLevel}.
     *
     * Determines whether `sap.m.App` is used as a top level control.
     *
     * **Note**: When the `isTopLevel` property set to `true`, `sap.m.App` traverses its parent DOM elements
     * and sets their height to 100%.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIsTopLevel(
      /**
       * New value for property `isTopLevel`
       */
      bIsTopLevel?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMobileWebAppCapable mobileWebAppCapable}.
     *
     * Determines whether the `App` is displayed without address bar when opened from an exported home screen
     * icon on a mobile device.
     *
     * Keep in mind that if enabled, there is no back button provided by the browser and the app must provide
     * own navigation on all displayed pages to avoid dead ends.
     *
     * **Note** The property can be toggled, but it doesn't take effect in real time. It takes the set value
     * at the moment when the home screen icon is exported by the user. For example, if the icon is exported
     * while the property is set to `true`, the `App` will have no address bar when opened from that same icon
     * regardless of a changed property value to `false` at a later time.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.58.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMobileWebAppCapable(
      /**
       * New value for property `mobileWebAppCapable`
       */
      bMobileWebAppCapable?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the App constructor.
   */
  export interface $AppSettings extends $NavContainerSettings {
    /**
     * The icon to be displayed on the home screen of iOS devices after the user does "add to home screen".
     *
     * Note that only the first attempt to set the homeIcon will be executed, subsequent settings are ignored.
     *
     * This icon must be in PNG format. The property can either hold the URL of one single icon which is used
     * for all devices (and possibly scaled, which looks not perfect), or an object holding icon URLs for the
     * different required sizes.
     *
     * A desktop icon (used for bookmarks and overriding the favicon) can also be configured. This requires
     * an object to be given and the "icon" property of this object then defines the desktop bookmark icon.
     * The ICO format is supported by all browsers. ICO is also preferred for this desktop icon setting because
     * the file can contain different images for different resolutions.
     *
     * One example is:
     *
     * app.setHomeIcon({ 'phone':'phone-icon.png', 'phone@2':'phone-retina.png', 'tablet':'tablet-icon.png',
     * 'tablet@2':'tablet-retina.png', 'icon':'desktop.ico' });
     *
     * The respective image sizes are 57/114 px for the phone and 72/144 px for the tablet. If an object is
     * given but one of the sizes is not given, the largest given icon will be used for this size.
     *
     * On Android these icons may or may not be used by the device. Apparently chances can be improved by adding
     * glare effect and rounded corners, setting the file name so it ends with "-precomposed.png" and setting
     * the "homeIconPrecomposed" property to "true".
     */
    homeIcon?: any | PropertyBindingInfo | `{${string}}`;

    /**
     * Background color of the App. If set, this color will override the default background defined by the theme.
     * So this should only be set when really required. Any configured background image will be placed above
     * this colored background. But any theme adaptation in the Theme Designer will override this setting. Use
     * the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * @since 1.11.2
     */
    backgroundColor?: string | PropertyBindingInfo;

    /**
     * Background image of the App. If set, this image will override the default background defined by the theme.
     * So this should only be set when really required. This background image will be placed above any color
     * set for the background. But any theme adaptation in the Theme Designer will override this image setting.
     * Use the "backgroundRepeat" property to define whether this image should be stretched to cover the complete
     * App or whether it should be tiled.
     *
     * @since 1.11.2
     */
    backgroundImage?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether the background image (if configured) should be proportionally stretched to cover the whole App
     * (false) or whether it should be tiled (true).
     *
     * @since 1.11.2
     */
    backgroundRepeat?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Opacity of the background image. The opacity can be set between 0 (fully transparent) and 1 fully opaque).
     * This can be used to make the application content better readable by making the background image partly
     * transparent.
     *
     * @since 1.11.2
     */
    backgroundOpacity?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the `App` is displayed without address bar when opened from an exported home screen
     * icon on a mobile device.
     *
     * Keep in mind that if enabled, there is no back button provided by the browser and the app must provide
     * own navigation on all displayed pages to avoid dead ends.
     *
     * **Note** The property can be toggled, but it doesn't take effect in real time. It takes the set value
     * at the moment when the home screen icon is exported by the user. For example, if the icon is exported
     * while the property is set to `true`, the `App` will have no address bar when opened from that same icon
     * regardless of a changed property value to `false` at a later time.
     *
     * @since 1.58.0
     */
    mobileWebAppCapable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether `sap.m.App` is used as a top level control.
     *
     * **Note**: When the `isTopLevel` property set to `true`, `sap.m.App` traverses its parent DOM elements
     * and sets their height to 100%.
     *
     * @since 1.91
     */
    isTopLevel?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the orientation (portrait/landscape) of the device is changed.
     *
     * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
     */
    orientationChange?: (oEvent: App$OrientationChangeEvent) => void;
  }

  /**
   * Parameters of the App#orientationChange event.
   *
   * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
   */
  export interface App$OrientationChangeEventParameters {
    /**
     * Whether the device is in landscape orientation.
     */
    landscape?: boolean;
  }

  /**
   * Event object of the App#orientationChange event.
   *
   * @deprecated As of version 1.20.0. use {@link sap.ui.Device.orientation.attachHandler} instead.
   */
  export type App$OrientationChangeEvent = Event<
    App$OrientationChangeEventParameters,
    App
  >;
}

declare module "sap/m/Avatar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, aria, URI, ValueState, CSSSize } from "sap/ui/core/library";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import AvatarColor from "sap/m/AvatarColor";

  import AvatarBadgeColor from "sap/m/AvatarBadgeColor";

  import LightBox from "sap/m/LightBox";

  import AvatarShape from "sap/m/AvatarShape";

  import AvatarSize from "sap/m/AvatarSize";

  import AvatarImageFitType from "sap/m/AvatarImageFitType";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * An image-like control that has different display options for representing images, initials, and icons.
   *
   * Overview:
   *
   * The `Avatar` control allows the usage of different content, shapes, and sizes depending on the use case.
   *
   * The content types that can be displayed are either images, icons, or initials. The shape can be circular
   * or square. There are several predefined sizes, as well as an option to set a custom size.
   *
   * Usage:
   *
   * Up to three Latin letters can be displayed as initials in an `Avatar`. If there are more than three letters,
   * or if there's a non-Latin character present, a default image placeholder will be created.
   *
   * There are two options for how the displayed image can fit inside the available area:
   * 	 - Cover - the image is scaled to cover all of the available area
   * 	 - Contain - the image is scaled as large as possible while both its height and width fit inside the
   *     avalable area  **Note:** To set a custom size for the `Avatar`, you have to choose the `Custom`
   *     value for the `displaySize` property. Then, you have to set both the `customDisplaySize` and `customFontSize`
   *     properties.
   *
   * @since 1.73
   */
  export default class Avatar extends Control {
    /**
     * Constructor for a new `Avatar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/avatar/ Avatar}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarSettings
    );
    /**
     * Constructor for a new `Avatar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/avatar/ Avatar}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $AvatarSettings
    );

    /**
     * Creates a new subclass of class sap.m.Avatar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Avatar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Avatar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.Avatar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Avatar` itself.
     *
     * Fired when the user selects the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Avatar` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.Avatar`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Avatar` itself.
     *
     * Fired when the user selects the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Avatar` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getDetailBox detailBox} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindDetailBox(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys the `detailBox` aggregation.
     *
     *
     * @returns `this` for chaining
     */
    destroyDetailBox(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.m.Avatar`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getActive active}.
     *
     * Determines whether the `Avatar` is active/toggled (default is set to `false`). Active state is meant
     * to be toggled when user clicks on the `Avatar`. The Active state is only applied, when the `Avatar` has
     * `press` listeners.
     *
     * Default value is `false`.
     *
     * @since 1.120.0
     *
     * @returns Value of property `active`
     */
    getActive(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Gets current value of property {@link #getAriaHasPopup ariaHasPopup}.
     *
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when an avatar is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * Default value is `None`.
     *
     * @since 1.99.0
     *
     * @returns Value of property `ariaHasPopup`
     */
    getAriaHasPopup(): aria.HasPopup;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getBackgroundColor backgroundColor}.
     *
     * Determines the background color of the control.
     *
     * Default value is `Accent6`.
     *
     *
     * @returns Value of property `backgroundColor`
     */
    getBackgroundColor(): AvatarColor;
    /**
     * Gets current value of property {@link #getBadgeIcon badgeIcon}.
     *
     * Defines what type of icon is displayed as visual affordance. It can be predefined or custom.
     *
     * The predefined icons are recommended for:
     * 	 - Suggesting a zooming action: `sap-icon://zoom-in`
     * 	 - Suggesting an image change: `sap-icon://camera`
     * 	 - Suggesting an editing action: `sap-icon://edit`  **Notes:**
     * 	 - Use `sap-icon://avatar-icon-none` to show the badge without an icon.
     * 	 - When using avatar-icon-none, the badge remains visible and can display background color or tooltip.
     *
     *
     * Default value is `empty string`.
     *
     * @since 1.77
     *
     * @returns Value of property `badgeIcon`
     */
    getBadgeIcon(): URI;
    /**
     * Gets current value of property {@link #getBadgeIconColor badgeIconColor}.
     *
     * Defines the color of the badge icon. This color is used to style the badge, indicating different statuses
     * or categories. Acceptable values include predefined `sap.m.AvatarBadgeColor` options.
     *
     * Default value is `Accent6`.
     *
     * @since 1.132.0
     *
     * @returns Value of property `badgeIconColor`
     */
    getBadgeIconColor(): AvatarBadgeColor;
    /**
     * Gets current value of property {@link #getBadgeTooltip badgeTooltip}.
     *
     * Defines a custom tooltip for the `badgeIcon`. If set, it overrides the available default values.
     *
     * If not set, default tooltips are used as follows:
     * 	 - Specific default tooltips are displayed for each of the predefined `badgeIcons`.
     * 	 - For any other icons, the displayed tooltip is the same as the main control tooltip.
     *
     * @since 1.77
     *
     * @returns Value of property `badgeTooltip`
     */
    getBadgeTooltip(): string;
    /**
     * Gets current value of property {@link #getBadgeValueState badgeValueState}.
     *
     * Visualizes the validation state of the badge, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * Default value is `None`.
     *
     * @since 1.116.0
     *
     * @returns Value of property `badgeValueState`
     */
    getBadgeValueState(): ValueState;
    /**
     * Gets current value of property {@link #getCustomDisplaySize customDisplaySize}.
     *
     * Specifies custom display size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     *
     * Default value is `"3rem"`.
     *
     *
     * @returns Value of property `customDisplaySize`
     */
    getCustomDisplaySize(): CSSSize;
    /**
     * Gets current value of property {@link #getCustomFontSize customFontSize}.
     *
     * Specifies custom font size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     *
     * Default value is `"1.125rem"`.
     *
     *
     * @returns Value of property `customFontSize`
     */
    getCustomFontSize(): CSSSize;
    /**
     * Gets current value of property {@link #getDecorative decorative}.
     *
     * Defines whether the `sap.m.Avatar` is used for decorative purposes and is ignored by accessibility tools.
     *
     * **Note:** This property doesn't take effect if `sap.m.Avatar` has a `press` handler.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Value of property `decorative`
     */
    getDecorative(): boolean;
    /**
     * Gets content of aggregation {@link #getDetailBox detailBox}.
     *
     * A `sap.m.LightBox` instance, that will be opened automatically when the user interacts with the `Avatar`
     * control.
     *
     * The `press` event will still be fired.
     */
    getDetailBox(): LightBox;
    /**
     * Gets current value of property {@link #getDisplayShape displayShape}.
     *
     * Defines the shape of the `Avatar`.
     *
     * Default value is `Circle`.
     *
     *
     * @returns Value of property `displayShape`
     */
    getDisplayShape(): AvatarShape;
    /**
     * Gets current value of property {@link #getDisplaySize displaySize}.
     *
     * Sets a predefined display size of the `Avatar`.
     *
     * Default value is `S`.
     *
     *
     * @returns Value of property `displaySize`
     */
    getDisplaySize(): AvatarSize;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Determines whether the `Avatar` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.AvatarColor AvatarColor}.
     *
     * Default value is `true`.
     *
     * @since 1.117.0
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getFallbackIcon fallbackIcon}.
     *
     * Defines the fallback icon displayed in case of wrong image src and no initials set.
     *
     * **Notes:**
     * 	 - If not set, a default fallback icon is displayed depending on the set `displayShape` property.
     * 	 - Accepted values are only icons from the SAP icon font.
     *
     *
     * @returns Value of property `fallbackIcon`
     */
    getFallbackIcon(): string;
    /**
     * Gets current value of property {@link #getImageFitType imageFitType}.
     *
     * Specifies how an image would fit in the `Avatar`.
     *
     * Default value is `Cover`.
     *
     *
     * @returns Value of property `imageFitType`
     */
    getImageFitType(): AvatarImageFitType;
    /**
     * Gets current value of property {@link #getInitials initials}.
     *
     * Defines the displayed initials. They should consist of only 1,2 or 3 latin letters.
     *
     *
     * @returns Value of property `initials`
     */
    getInitials(): string;
    /**
     * Gets current value of property {@link #getShowBorder showBorder}.
     *
     * Determines whether the control is displayed with border.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showBorder`
     */
    getShowBorder(): boolean;
    /**
     * Gets current value of property {@link #getSrc src}.
     *
     * Determines the path to the desired image or icon.
     *
     *
     * @returns Value of property `src`
     */
    getSrc(): URI;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getActive active}.
     *
     * Determines whether the `Avatar` is active/toggled (default is set to `false`). Active state is meant
     * to be toggled when user clicks on the `Avatar`. The Active state is only applied, when the `Avatar` has
     * `press` listeners.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.120.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActive(
      /**
       * New value for property `active`
       */
      bActive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAriaHasPopup ariaHasPopup}.
     *
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when an avatar is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.99.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaHasPopup(
      /**
       * New value for property `ariaHasPopup`
       */
      sAriaHasPopup?: aria.HasPopup | keyof typeof aria.HasPopup
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundColor backgroundColor}.
     *
     * Determines the background color of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Accent6`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundColor(
      /**
       * New value for property `backgroundColor`
       */
      sBackgroundColor?: AvatarColor | keyof typeof AvatarColor
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeIcon badgeIcon}.
     *
     * Defines what type of icon is displayed as visual affordance. It can be predefined or custom.
     *
     * The predefined icons are recommended for:
     * 	 - Suggesting a zooming action: `sap-icon://zoom-in`
     * 	 - Suggesting an image change: `sap-icon://camera`
     * 	 - Suggesting an editing action: `sap-icon://edit`  **Notes:**
     * 	 - Use `sap-icon://avatar-icon-none` to show the badge without an icon.
     * 	 - When using avatar-icon-none, the badge remains visible and can display background color or tooltip.
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.77
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeIcon(
      /**
       * New value for property `badgeIcon`
       */
      sBadgeIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeIconColor badgeIconColor}.
     *
     * Defines the color of the badge icon. This color is used to style the badge, indicating different statuses
     * or categories. Acceptable values include predefined `sap.m.AvatarBadgeColor` options.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Accent6`.
     *
     * @since 1.132.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeIconColor(
      /**
       * New value for property `badgeIconColor`
       */
      sBadgeIconColor?: AvatarBadgeColor | keyof typeof AvatarBadgeColor
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeTooltip badgeTooltip}.
     *
     * Defines a custom tooltip for the `badgeIcon`. If set, it overrides the available default values.
     *
     * If not set, default tooltips are used as follows:
     * 	 - Specific default tooltips are displayed for each of the predefined `badgeIcons`.
     * 	 - For any other icons, the displayed tooltip is the same as the main control tooltip.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.77
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeTooltip(
      /**
       * New value for property `badgeTooltip`
       */
      sBadgeTooltip?: string
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeValueState badgeValueState}.
     *
     * Visualizes the validation state of the badge, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.116.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeValueState(
      /**
       * New value for property `badgeValueState`
       */
      sBadgeValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getCustomDisplaySize customDisplaySize}.
     *
     * Specifies custom display size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"3rem"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomDisplaySize(
      /**
       * New value for property `customDisplaySize`
       */
      sCustomDisplaySize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getCustomFontSize customFontSize}.
     *
     * Specifies custom font size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"1.125rem"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomFontSize(
      /**
       * New value for property `customFontSize`
       */
      sCustomFontSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getDecorative decorative}.
     *
     * Defines whether the `sap.m.Avatar` is used for decorative purposes and is ignored by accessibility tools.
     *
     * **Note:** This property doesn't take effect if `sap.m.Avatar` has a `press` handler.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDecorative(
      /**
       * New value for property `decorative`
       */
      bDecorative?: boolean
    ): this;
    /**
     * Sets the `detailBox` aggregation.
     *
     *
     * @returns `this` for chaining
     */
    setDetailBox(
      /**
       * Instance of the `LightBox` control or undefined
       */
      oLightBox: LightBox | undefined
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayShape displayShape}.
     *
     * Defines the shape of the `Avatar`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Circle`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayShape(
      /**
       * New value for property `displayShape`
       */
      sDisplayShape?: AvatarShape | keyof typeof AvatarShape
    ): this;
    /**
     * Sets a new value for property {@link #getDisplaySize displaySize}.
     *
     * Sets a predefined display size of the `Avatar`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `S`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplaySize(
      /**
       * New value for property `displaySize`
       */
      sDisplaySize?: AvatarSize | keyof typeof AvatarSize
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Determines whether the `Avatar` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.AvatarColor AvatarColor}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.117.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getFallbackIcon fallbackIcon}.
     *
     * Defines the fallback icon displayed in case of wrong image src and no initials set.
     *
     * **Notes:**
     * 	 - If not set, a default fallback icon is displayed depending on the set `displayShape` property.
     * 	 - Accepted values are only icons from the SAP icon font.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFallbackIcon(
      /**
       * New value for property `fallbackIcon`
       */
      sFallbackIcon?: string
    ): this;
    /**
     * Sets a new value for property {@link #getImageFitType imageFitType}.
     *
     * Specifies how an image would fit in the `Avatar`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Cover`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImageFitType(
      /**
       * New value for property `imageFitType`
       */
      sImageFitType?: AvatarImageFitType | keyof typeof AvatarImageFitType
    ): this;
    /**
     * Sets a new value for property {@link #getInitials initials}.
     *
     * Defines the displayed initials. They should consist of only 1,2 or 3 latin letters.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitials(
      /**
       * New value for property `initials`
       */
      sInitials?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowBorder showBorder}.
     *
     * Determines whether the control is displayed with border.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowBorder(
      /**
       * New value for property `showBorder`
       */
      bShowBorder?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSrc src}.
     *
     * Determines the path to the desired image or icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSrc(
      /**
       * New value for property `src`
       */
      sSrc?: URI
    ): this;
    /**
     * Unbinds aggregation {@link #getDetailBox detailBox} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindDetailBox(): this;
  }
  /**
   * Describes the settings that can be provided to the Avatar constructor.
   */
  export interface $AvatarSettings extends $ControlSettings {
    /**
     * Determines the path to the desired image or icon.
     */
    src?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the displayed initials. They should consist of only 1,2 or 3 latin letters.
     */
    initials?: string | PropertyBindingInfo;

    /**
     * Defines the shape of the `Avatar`.
     */
    displayShape?:
      | (AvatarShape | keyof typeof AvatarShape)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Sets a predefined display size of the `Avatar`.
     */
    displaySize?:
      | (AvatarSize | keyof typeof AvatarSize)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies custom display size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     */
    customDisplaySize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies custom font size of the `Avatar`.
     *
     * **Note:** It takes effect if the `displaySize` property is set to `Custom`.
     */
    customFontSize?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies how an image would fit in the `Avatar`.
     */
    imageFitType?:
      | (AvatarImageFitType | keyof typeof AvatarImageFitType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the fallback icon displayed in case of wrong image src and no initials set.
     *
     * **Notes:**
     * 	 - If not set, a default fallback icon is displayed depending on the set `displayShape` property.
     * 	 - Accepted values are only icons from the SAP icon font.
     */
    fallbackIcon?: string | PropertyBindingInfo;

    /**
     * Determines the background color of the control.
     */
    backgroundColor?:
      | (AvatarColor | keyof typeof AvatarColor)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the control is displayed with border.
     */
    showBorder?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines what type of icon is displayed as visual affordance. It can be predefined or custom.
     *
     * The predefined icons are recommended for:
     * 	 - Suggesting a zooming action: `sap-icon://zoom-in`
     * 	 - Suggesting an image change: `sap-icon://camera`
     * 	 - Suggesting an editing action: `sap-icon://edit`  **Notes:**
     * 	 - Use `sap-icon://avatar-icon-none` to show the badge without an icon.
     * 	 - When using avatar-icon-none, the badge remains visible and can display background color or tooltip.
     *
     *
     * @since 1.77
     */
    badgeIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines a custom tooltip for the `badgeIcon`. If set, it overrides the available default values.
     *
     * If not set, default tooltips are used as follows:
     * 	 - Specific default tooltips are displayed for each of the predefined `badgeIcons`.
     * 	 - For any other icons, the displayed tooltip is the same as the main control tooltip.
     *
     * @since 1.77
     */
    badgeTooltip?: string | PropertyBindingInfo;

    /**
     * Defines whether the `sap.m.Avatar` is used for decorative purposes and is ignored by accessibility tools.
     *
     * **Note:** This property doesn't take effect if `sap.m.Avatar` has a `press` handler.
     *
     * @since 1.97
     */
    decorative?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when an avatar is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * @since 1.99.0
     */
    ariaHasPopup?:
      | (aria.HasPopup | keyof typeof aria.HasPopup)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Visualizes the validation state of the badge, e.g. `Error`, `Warning`, `Success`, `Information`.
     *
     * @since 1.116.0
     */
    badgeValueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the color of the badge icon. This color is used to style the badge, indicating different statuses
     * or categories. Acceptable values include predefined `sap.m.AvatarBadgeColor` options.
     *
     * @since 1.132.0
     */
    badgeIconColor?:
      | (AvatarBadgeColor | keyof typeof AvatarBadgeColor)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the `Avatar` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.AvatarColor AvatarColor}.
     *
     * @since 1.117.0
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the `Avatar` is active/toggled (default is set to `false`). Active state is meant
     * to be toggled when user clicks on the `Avatar`. The Active state is only applied, when the `Avatar` has
     * `press` listeners.
     *
     * @since 1.120.0
     */
    active?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * A `sap.m.LightBox` instance, that will be opened automatically when the user interacts with the `Avatar`
     * control.
     *
     * The `press` event will still be fired.
     */
    detailBox?: LightBox;

    /**
     * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledBy).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the user selects the control.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Avatar#press event.
   */
  export interface Avatar$PressEventParameters {}

  /**
   * Event object of the Avatar#press event.
   */
  export type Avatar$PressEvent = Event<Avatar$PressEventParameters, Avatar>;
}

declare module "sap/m/AvatarBadgeColor" {
  /**
   * Possible badge color options for the {@link sap.m.Avatar} control.
   *
   * **Notes:**
   * 	 - Keep in mind that the colors are theme-dependent and can differ based on the currently used theme.
   *
   *
   * @since 1.132.0
   */
  enum AvatarBadgeColor {
    /**
     * Accent 1
     */
    Accent1 = "Accent1",
    /**
     * Accent 10
     */
    Accent10 = "Accent10",
    /**
     * Accent 2
     */
    Accent2 = "Accent2",
    /**
     * Accent 3
     */
    Accent3 = "Accent3",
    /**
     * Accent 4
     */
    Accent4 = "Accent4",
    /**
     * Accent 5
     */
    Accent5 = "Accent5",
    /**
     * Accent 6
     */
    Accent6 = "Accent6",
    /**
     * Accent 7
     */
    Accent7 = "Accent7",
    /**
     * Accent 8
     */
    Accent8 = "Accent8",
    /**
     * Accent 9
     */
    Accent9 = "Accent9",
  }
  export default AvatarBadgeColor;
}

declare module "sap/m/AvatarColor" {
  /**
   * Possible background color options for the {@link sap.m.Avatar} control.
   *
   * **Notes:**
   * 	 - Keep in mind that the colors are theme-dependent and can differ based on the currently used theme.
   *
   * 	 -  If the `Random` value is assigned, a random color is chosen from the accent options (Accent1 to
   *     Accent10).
   *
   * @since 1.73
   */
  enum AvatarColor {
    /**
     * Accent 1
     */
    Accent1 = "Accent1",
    /**
     * Accent 10
     */
    Accent10 = "Accent10",
    /**
     * Accent 2
     */
    Accent2 = "Accent2",
    /**
     * Accent 3
     */
    Accent3 = "Accent3",
    /**
     * Accent 4
     */
    Accent4 = "Accent4",
    /**
     * Accent 5
     */
    Accent5 = "Accent5",
    /**
     * Accent 6
     */
    Accent6 = "Accent6",
    /**
     * Accent 7
     */
    Accent7 = "Accent7",
    /**
     * Accent 8
     */
    Accent8 = "Accent8",
    /**
     * Accent 9
     */
    Accent9 = "Accent9",
    /**
     * Recommended when used as a placeholder (no image or initials are provided).
     */
    Placeholder = "Placeholder",
    /**
     * Random color, chosen from the accent options (Accent1 to Accent10)
     */
    Random = "Random",
    /**
     * Recommended when used as an icon in a tile.
     */
    TileIcon = "TileIcon",
    /**
     * Transparent
     */
    Transparent = "Transparent",
  }
  export default AvatarColor;
}

declare module "sap/m/AvatarImageFitType" {
  /**
   * Types of image size and position that determine how an image fits in the {@link sap.m.Avatar} control
   * area.
   *
   * @since 1.73
   */
  enum AvatarImageFitType {
    /**
     * The image is scaled to the largest size so that both its width and height can fit in the control area.
     */
    Contain = "Contain",
    /**
     * The image is scaled to be large enough so that the control area is completely covered.
     */
    Cover = "Cover",
  }
  export default AvatarImageFitType;
}

declare module "sap/m/AvatarShape" {
  /**
   * Types of shape for the {@link sap.m.Avatar} control.
   *
   * @since 1.73
   */
  enum AvatarShape {
    /**
     * Circular shape.
     */
    Circle = "Circle",
    /**
     * Square shape.
     */
    Square = "Square",
  }
  export default AvatarShape;
}

declare module "sap/m/AvatarSize" {
  /**
   * Predefined sizes for the {@link sap.m.Avatar} control.
   *
   * @since 1.73
   */
  enum AvatarSize {
    /**
     * Custom size
     */
    Custom = "Custom",
    /**
     * Control size - 5rem Font size - 2rem
     */
    L = "L",
    /**
     * Control size - 4rem Font size - 1.625rem
     */
    M = "M",
    /**
     * Control size - 3rem Font size - 1.125rem
     */
    S = "S",
    /**
     * Control size - 7rem Font size - 2.75rem
     */
    XL = "XL",
    /**
     * Control size - 2rem Font size - 0.75rem
     */
    XS = "XS",
  }
  export default AvatarSize;
}

declare module "sap/m/AvatarType" {
  /**
   * Types of {@link sap.m.Avatar} based on the displayed content.
   *
   * @since 1.73
   */
  enum AvatarType {
    /**
     * The displayed content is an icon.
     */
    Icon = "Icon",
    /**
     * The displayed content is an image.
     */
    Image = "Image",
    /**
     * The displayed content is initials.
     */
    Initials = "Initials",
  }
  export default AvatarType;
}

declare module "sap/m/BadgeCustomData" {
  import {
    default as CustomData,
    $CustomDataSettings,
  } from "sap/ui/core/CustomData";

  import { BadgeAnimationType } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Contains a single key/value pair of custom data attached to an `Element`.
   *
   * For more information, see {@link sap.ui.core.Element#data Element.prototype.data} and {@link https://ui5.sap.com/#/topic/91f0c3ee6f4d1014b6dd926db0e91070 Custom Data - Attaching Data Objects to Controls}.
   *
   * @since 1.80
   */
  export default class BadgeCustomData extends CustomData {
    /**
     * Constructor for a new `BadgeCustomData` element.
     */
    constructor(
      /**
       * Initial settings for the new element
       */
      mSettings?: $BadgeCustomDataSettings
    );
    /**
     * Constructor for a new `BadgeCustomData` element.
     */
    constructor(
      /**
       * ID for the new element, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new element
       */
      mSettings?: $BadgeCustomDataSettings
    );

    /**
     * Creates a new subclass of class sap.m.BadgeCustomData with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.CustomData.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BadgeCustomData>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.BadgeCustomData.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAnimation animation}.
     *
     * Determines the type of animation to be performed by the Badge DOM element.
     *
     * Default value is `Full`.
     *
     * @since 1.87
     *
     * @returns Value of property `animation`
     */
    getAnimation(): BadgeAnimationType;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Sets a new value for property {@link #getAnimation animation}.
     *
     * Determines the type of animation to be performed by the Badge DOM element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Full`.
     *
     * @since 1.87
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAnimation(
      /**
       * New value for property `animation`
       */
      sAnimation?: BadgeAnimationType | keyof typeof BadgeAnimationType
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BadgeCustomData constructor.
   */
  export interface $BadgeCustomDataSettings extends $CustomDataSettings {
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the type of animation to be performed by the Badge DOM element.
     *
     * @since 1.87
     */
    animation?:
      | (BadgeAnimationType | keyof typeof BadgeAnimationType)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/BadgeEnabler" {
  /**
   * A helper class for implementing the {@link sap.m.IBadge} interface.
   *
   * The class represents a utility for visualising and updating the `badge` indicator for `sap.ui.core.Control`
   * instances. It should be created once per `IBadge` instance.
   *
   * On its initialization,  can accept a settings object. The settings object contains
   * the following properties:
   *
   *
   * 	 - `position` - accepts three predefined string values which add relative CSS classes to the badge element
   *     and position it accordingly: `topLeft`, `topRight` and `inline`
   *
   *
   * 	 - `accentColor` - accepts string values equal to theme-specific accent colors. For more information,
   *     see the {@link https://experience.sap.com/fiori-design-web/quartz-light-colors/#accent-colors SAP Fiori Design Guidelines}.
   *
   *
   * 	 - `selector` - accepts Object, containing one property which is named either `selector` or `suffix`.
   *     If no selector is passed, the main ID of the control is automatically set as selector value.
   *
   * @since 1.80
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class BadgeEnabler {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();
  }
}

declare module "sap/m/Bar" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { IBar, BarDesign, IBarHTMLTag, TitleAlignment } from "sap/m/library";

  import { ID } from "sap/ui/core/library";

  import { BarContexts } from "sap/m/BarInPageEnabler";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Used as a header, sub-header and a footer of a page.
   *
   * Overview:
   *
   * The `Bar` control consists of three areas to hold its content. It has the capability to center content,
   * such as a title, while having other controls on the left and right side.
   *
   * Usage:
   *
   * With the use of the `design` property, you can set the style of the `Bar` to appear as a header, sub-header
   * and footer.
   *
   * **Note:** Do not place a `sap.m.Bar` inside another `sap.m.Bar` or inside any bar-like control. Doing
   * so causes unpredictable behavior.
   *
   * Responsive Behavior:
   *
   * The content in the middle area is centrally positioned if there is enough space. If the right or left
   * content overlaps the middle content, the middle content will be centered in the space between.
   */
  export default class Bar extends Control implements IBar {
    __implements__sap_m_IBar: boolean;
    /**
     * Constructor for a new `Bar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BarSettings
    );
    /**
     * Constructor for a new `Bar`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BarSettings
    );

    /**
     * Creates a new subclass of class sap.m.Bar with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Bar>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Bar.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Sets classes according to the context of the page. Possible contexts are header, footer and subheader.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` for chaining
     */
    _applyContextClassFor(): IBar;
    /**
     * Sets HTML tag according to the context of the page. Possible contexts are header, footer and subheader.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` for chaining
     */
    _applyTag(): IBar;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some contentLeft to the aggregation {@link #getContentLeft contentLeft}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContentLeft(
      /**
       * The contentLeft to add; if empty, nothing is inserted
       */
      oContentLeft: Control
    ): this;
    /**
     * Adds some contentMiddle to the aggregation {@link #getContentMiddle contentMiddle}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContentMiddle(
      /**
       * The contentMiddle to add; if empty, nothing is inserted
       */
      oContentMiddle: Control
    ): this;
    /**
     * Adds some contentRight to the aggregation {@link #getContentRight contentRight}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContentRight(
      /**
       * The contentRight to add; if empty, nothing is inserted
       */
      oContentRight: Control
    ): this;
    /**
     * Sets classes and HTML tag according to the context of the page. Possible contexts are header, footer
     * and subheader.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` for chaining
     */
    applyTagAndContextClassFor(): IBar;
    /**
     * Destroys all the contentLeft in the aggregation {@link #getContentLeft contentLeft}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentLeft(): this;
    /**
     * Destroys all the contentMiddle in the aggregation {@link #getContentMiddle contentMiddle}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentMiddle(): this;
    /**
     * Destroys all the contentRight in the aggregation {@link #getContentRight contentRight}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContentRight(): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getContentLeft contentLeft}.
     *
     * Represents the left content area, usually containing a button or an app icon. If it is overlapped by
     * the right content, its content will disappear and the text will show an ellipsis.
     */
    getContentLeft(): Control[];
    /**
     * Gets content of aggregation {@link #getContentMiddle contentMiddle}.
     *
     * Represents the middle content area. Controls such as label, segmented buttons or select can be placed
     * here. The content is centrally positioned if there is enough space. If the right or left content overlaps
     * the middle content, the middle content will be centered in the space between the left and the right content.
     */
    getContentMiddle(): Control[];
    /**
     * Gets content of aggregation {@link #getContentRight contentRight}.
     *
     * Represents the right content area. Controls such as action buttons or search field can be placed here.
     */
    getContentRight(): Control[];
    /**
     * Gets the available Bar contexts.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns with all available contexts
     */
    getContext(): BarContexts;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Determines the design of the bar. If set to auto, it becomes dependent on the place where the bar is
     * placed.
     *
     * Default value is `Auto`.
     *
     * @since 1.22
     *
     * @returns Value of property `design`
     */
    getDesign(): BarDesign;
    /**
     * Gets current value of property {@link #getEnableFlexBox enableFlexBox}.
     *
     * If this flag is set to true, contentMiddle will be rendered as a HBox and layoutData can be used to allocate
     * available space.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.16. replaced by `contentMiddle` aggregation. `contentMiddle` will always
     * occupy of the 100% width when no `contentLeft` and `contentRight` are being set.
     *
     * @returns Value of property `enableFlexBox`
     */
    getEnableFlexBox(): boolean;
    /**
     * Gets the HTML tag of the root element.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The HTML-tag
     */
    getHTMLTag(): IBarHTMLTag;
    /**
     * Gets current value of property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.None`, the automatic title
     * alignment depending on the theme settings will be disabled. If set to `TitleAlignment.Auto`, the Title
     * will be aligned as it is set in the theme (if not set, the default value is `center`); Other possible
     * values are `TitleAlignment.Start` (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * Default value is `None`.
     *
     * @since 1.85
     *
     * @returns Value of property `titleAlignment`
     */
    getTitleAlignment(): TitleAlignment;
    /**
     * Gets current value of property {@link #getTranslucent translucent}.
     *
     * Indicates whether the Bar is partially translucent. It is only applied for touch devices.
     *
     * Default value is `false`.
     *
     * @since 1.12
     * @deprecated As of version 1.18.6. This property has no effect since release 1.18.6 and should not be
     * used. Translucent bar may overlay an input and make it difficult to edit.
     *
     * @returns Value of property `translucent`
     */
    getTranslucent(): boolean;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContentLeft contentLeft}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContentLeft(
      /**
       * The contentLeft whose index is looked for
       */
      oContentLeft: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContentMiddle contentMiddle}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContentMiddle(
      /**
       * The contentMiddle whose index is looked for
       */
      oContentMiddle: Control
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContentRight contentRight}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContentRight(
      /**
       * The contentRight whose index is looked for
       */
      oContentRight: Control
    ): int;
    /**
     * Inserts a contentLeft into the aggregation {@link #getContentLeft contentLeft}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContentLeft(
      /**
       * The contentLeft to insert; if empty, nothing is inserted
       */
      oContentLeft: Control,
      /**
       * The `0`-based index the contentLeft should be inserted at; for a negative value of `iIndex`, the contentLeft
       * is inserted at position 0; for a value greater than the current size of the aggregation, the contentLeft
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a contentMiddle into the aggregation {@link #getContentMiddle contentMiddle}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContentMiddle(
      /**
       * The contentMiddle to insert; if empty, nothing is inserted
       */
      oContentMiddle: Control,
      /**
       * The `0`-based index the contentMiddle should be inserted at; for a negative value of `iIndex`, the contentMiddle
       * is inserted at position 0; for a value greater than the current size of the aggregation, the contentMiddle
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a contentRight into the aggregation {@link #getContentRight contentRight}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContentRight(
      /**
       * The contentRight to insert; if empty, nothing is inserted
       */
      oContentRight: Control,
      /**
       * The `0`-based index the contentRight should be inserted at; for a negative value of `iIndex`, the contentRight
       * is inserted at position 0; for a value greater than the current size of the aggregation, the contentRight
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Determines whether the Bar is sensitive to the container context.
     *
     * Implementation of the IBar interface.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns isContextSensitive
     */
    isContextSensitive(): boolean;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getContentLeft contentLeft}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContentLeft(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getContentMiddle contentMiddle}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContentMiddle(): Control[];
    /**
     * Removes all the controls from the aggregation {@link #getContentRight contentRight}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContentRight(): Control[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a contentLeft from the aggregation {@link #getContentLeft contentLeft}.
     *
     *
     * @returns The removed contentLeft or `null`
     */
    removeContentLeft(
      /**
       * The contentLeft to remove or its index or id
       */
      vContentLeft: int | string | Control
    ): Control | null;
    /**
     * Removes a contentMiddle from the aggregation {@link #getContentMiddle contentMiddle}.
     *
     *
     * @returns The removed contentMiddle or `null`
     */
    removeContentMiddle(
      /**
       * The contentMiddle to remove or its index or id
       */
      vContentMiddle: int | string | Control
    ): Control | null;
    /**
     * Removes a contentRight from the aggregation {@link #getContentRight contentRight}.
     *
     *
     * @returns The removed contentRight or `null`
     */
    removeContentRight(
      /**
       * The contentRight to remove or its index or id
       */
      vContentRight: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Determines the design of the bar. If set to auto, it becomes dependent on the place where the bar is
     * placed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.22
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: BarDesign | keyof typeof BarDesign
    ): this;
    /**
     * Sets a new value for property {@link #getEnableFlexBox enableFlexBox}.
     *
     * If this flag is set to true, contentMiddle will be rendered as a HBox and layoutData can be used to allocate
     * available space.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @deprecated As of version 1.16. replaced by `contentMiddle` aggregation. `contentMiddle` will always
     * occupy of the 100% width when no `contentLeft` and `contentRight` are being set.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableFlexBox(
      /**
       * New value for property `enableFlexBox`
       */
      bEnableFlexBox?: boolean
    ): this;
    /**
     * Sets the HTML tag of the root element.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns this for chaining
     */
    setHTMLTag(
      /**
       * The HTML tag of the root element
       */
      sTag: IBarHTMLTag | keyof typeof IBarHTMLTag
    ): IBar;
    /**
     * Sets a new value for property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.None`, the automatic title
     * alignment depending on the theme settings will be disabled. If set to `TitleAlignment.Auto`, the Title
     * will be aligned as it is set in the theme (if not set, the default value is `center`); Other possible
     * values are `TitleAlignment.Start` (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitleAlignment(
      /**
       * New value for property `titleAlignment`
       */
      sTitleAlignment?: TitleAlignment | keyof typeof TitleAlignment
    ): this;
    /**
     * Sets a new value for property {@link #getTranslucent translucent}.
     *
     * Indicates whether the Bar is partially translucent. It is only applied for touch devices.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.12
     * @deprecated As of version 1.18.6. This property has no effect since release 1.18.6 and should not be
     * used. Translucent bar may overlay an input and make it difficult to edit.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTranslucent(
      /**
       * New value for property `translucent`
       */
      bTranslucent?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Bar constructor.
   */
  export interface $BarSettings extends $ControlSettings {
    /**
     * If this flag is set to true, contentMiddle will be rendered as a HBox and layoutData can be used to allocate
     * available space.
     *
     * @deprecated As of version 1.16. replaced by `contentMiddle` aggregation. `contentMiddle` will always
     * occupy of the 100% width when no `contentLeft` and `contentRight` are being set.
     */
    enableFlexBox?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the Bar is partially translucent. It is only applied for touch devices.
     *
     * @since 1.12
     * @deprecated As of version 1.18.6. This property has no effect since release 1.18.6 and should not be
     * used. Translucent bar may overlay an input and make it difficult to edit.
     */
    translucent?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the design of the bar. If set to auto, it becomes dependent on the place where the bar is
     * placed.
     *
     * @since 1.22
     */
    design?:
      | (BarDesign | keyof typeof BarDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.None`, the automatic title
     * alignment depending on the theme settings will be disabled. If set to `TitleAlignment.Auto`, the Title
     * will be aligned as it is set in the theme (if not set, the default value is `center`); Other possible
     * values are `TitleAlignment.Start` (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * @since 1.85
     */
    titleAlignment?:
      | (TitleAlignment | keyof typeof TitleAlignment)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Represents the left content area, usually containing a button or an app icon. If it is overlapped by
     * the right content, its content will disappear and the text will show an ellipsis.
     */
    contentLeft?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Represents the middle content area. Controls such as label, segmented buttons or select can be placed
     * here. The content is centrally positioned if there is enough space. If the right or left content overlaps
     * the middle content, the middle content will be centered in the space between the left and the right content.
     */
    contentMiddle?:
      | Control[]
      | Control
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Represents the right content area. Controls such as action buttons or search field can be placed here.
     */
    contentRight?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
     *
     * **Note:**The aria-labelledby attribute will not be rendered when there are less than two interactive
     * elements inside the Bar (for example, one Button).
     */
    ariaLabelledBy?: Array<Control | string>;
  }
}

declare module "sap/m/BarInPageEnabler" {
  import BaseObject from "sap/ui/base/Object";

  import Control from "sap/ui/core/Control";

  import { IBar } from "sap/m/library";

  import Metadata from "sap/ui/base/Metadata";

  import RenderManager from "sap/ui/core/RenderManager";

  /**
   * The object contains the available parameters for Bar`s context (footer, header or subheader).
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type BarContext = {
    contextClass?: string;

    internalAriaLabel?: string;

    tag?: string;
  };

  /**
   * The object contains the Bar contexts inside page.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export type BarContexts = {
    footer?: BarContext;

    header?: BarContext;

    subheader?: BarContext;
  };

  /**
   * Helper Class for implementing the IBar interface. Should be created once per IBar instance.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  export default class BarInPageEnabler extends BaseObject {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Adds the sapMBarChildClass to a control.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    static addChildClassTo(
      /**
       * The sap.ui.core.Control to which the sapMBarChildClass will be added
       */
      oControl: Control
    ): void;
    /**
     * Creates a new subclass of class sap.m.BarInPageEnabler with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.Object.extend}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BarInPageEnabler>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.BarInPageEnabler.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Renders the tooltip for the given control
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    static renderTooltip(
      /**
       * the RenderManager that can be used for writing to the render output buffer.
       */
      oRM: RenderManager,
      /**
       * an object representation of the control that should be rendered.
       */
      oControl: Control
    ): void;
    /**
     * Sets classes and HTML tag according to the context of the page.
     *
     * Possible contexts are header, footer, subheader.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` for chaining
     */
    applyTagAndContextClassFor(
      /**
       * allowed values are header, footer, subheader.
       */
      sContext: string
    ): IBar;
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns with all available contexts.
     */
    getContext(): BarContexts;
    /**
     * Gets the HTML tag of the root domref.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns the HTML-tag
     */
    getHTMLTag(): string;
    /**
     * Determines whether the bar is sensitive to the container context.
     *
     * Implementation of the IBar interface.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns isContextSensitive
     */
    isContextSensitive(): boolean;
    /**
     * Renders the HTML for the given control, using the provided {@link sap.ui.core.RenderManager}.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    render(
      /**
       * the RenderManager that can be used for writing to the render output buffer.
       */
      oRM: RenderManager,
      /**
       * an object representation of the control that should be rendered.
       */
      oControl: Control
    ): void;
    /**
     * Sets the HTML tag of the root element.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining
     */
    setHTMLTag(
      /**
       * The new root element
       */
      sNewTag: string
    ): IBar;
  }
}

declare module "sap/m/Breadcrumbs" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    IBreadcrumbs,
    IOverflowToolbarContent,
    IToolbarInteractiveControl,
    BreadcrumbsSeparatorStyle,
  } from "sap/m/library";

  import { IShrinkable, ID } from "sap/ui/core/library";

  import Link from "sap/m/Link";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Enables users to navigate between items by providing a list of links to previous steps in the user's
   * navigation path. The last three steps can be accessed as links directly, while the remaining links prior
   * to them are available in a drop-down menu.
   *
   * @since 1.34
   */
  export default class Breadcrumbs
    extends Control
    implements
      IBreadcrumbs,
      IOverflowToolbarContent,
      IShrinkable,
      IToolbarInteractiveControl
  {
    __implements__sap_m_IBreadcrumbs: boolean;
    __implements__sap_m_IOverflowToolbarContent: boolean;
    __implements__sap_ui_core_IShrinkable: boolean;
    __implements__sap_m_IToolbarInteractiveControl: boolean;
    /**
     * Constructor for a new `Breadcrumbs`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/breadcrumb/ Breadcrumbs}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsSettings
    );
    /**
     * Constructor for a new `Breadcrumbs`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/breadcrumb/ Breadcrumbs}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BreadcrumbsSettings
    );

    /**
     * Creates a new subclass of class sap.m.Breadcrumbs with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Breadcrumbs>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Breadcrumbs.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some link to the aggregation {@link #getLinks links}.
     *
     * @since 1.34
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addLink(
      /**
       * The link to add; if empty, nothing is inserted
       */
      oLink: Link
    ): this;
    /**
     * Destroys the currentLocation in the aggregation {@link #getCurrentLocation currentLocation}.
     *
     * @since 1.123
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCurrentLocation(): this;
    /**
     * Destroys all the links in the aggregation {@link #getLinks links}.
     *
     * @since 1.34
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLinks(): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getCurrentLocation currentLocation}.
     *
     * Link determing the current/last element in the Breadcrumbs path.
     *
     * @since 1.123
     */
    getCurrentLocation(): Link;
    /**
     * Gets current value of property {@link #getCurrentLocationText currentLocationText}.
     *
     * Determines the text of current/last element in the Breadcrumbs path.
     *
     * @since 1.34
     *
     * @returns Value of property `currentLocationText`
     */
    getCurrentLocationText(): string;
    /**
     * Gets content of aggregation {@link #getLinks links}.
     *
     * A list of all the active link elements in the Breadcrumbs control. **Note:** Enabling the property `wrapping`
     * of the link will not work since it's incompatible with the concept of the control. The other properties
     * will work, but their effect may be undesirable.
     *
     * @since 1.34
     */
    getLinks(): Link[];
    /**
     * Gets current value of property {@link #getSeparatorStyle separatorStyle}.
     *
     * Determines the visual style of the separator between the `Breadcrumbs` elements.
     *
     * Default value is `Slash`.
     *
     * @since 1.69
     *
     * @returns Value of property `separatorStyle`
     */
    getSeparatorStyle(): BreadcrumbsSeparatorStyle;
    /**
     * Checks for the provided `sap.m.Link` in the aggregation {@link #getLinks links}. and returns its index
     * if found or -1 otherwise.
     *
     * @since 1.34
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfLink(
      /**
       * The link whose index is looked for
       */
      oLink: Link
    ): int;
    /**
     * Inserts a link into the aggregation {@link #getLinks links}.
     *
     * @since 1.34
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertLink(
      /**
       * The link to insert; if empty, nothing is inserted
       */
      oLink: Link,
      /**
       * The `0`-based index the link should be inserted at; for a negative value of `iIndex`, the link is inserted
       * at position 0; for a value greater than the current size of the aggregation, the link is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getLinks links}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.34
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllLinks(): Link[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a link from the aggregation {@link #getLinks links}.
     *
     * @since 1.34
     *
     * @returns The removed link or `null`
     */
    removeLink(
      /**
       * The link to remove or its index or id
       */
      vLink: int | string | Link
    ): Link | null;
    /**
     * Sets the aggregated {@link #getCurrentLocation currentLocation}.
     *
     * @since 1.123
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCurrentLocation(
      /**
       * The currentLocation to set
       */
      oCurrentLocation: Link
    ): this;
    /**
     * Sets a new value for property {@link #getCurrentLocationText currentLocationText}.
     *
     * Determines the text of current/last element in the Breadcrumbs path.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.34
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCurrentLocationText(
      /**
       * New value for property `currentLocationText`
       */
      sCurrentLocationText?: string
    ): this;
    /**
     * Custom setter for the `Breadcrumbs` separator style.
     *
     * @since 1.71
     *
     * @returns this
     */
    setSeparatorStyle(
      sSeparatorStyle:
        | BreadcrumbsSeparatorStyle
        | keyof typeof BreadcrumbsSeparatorStyle
    ): Breadcrumbs;
  }
  /**
   * Describes the settings that can be provided to the Breadcrumbs constructor.
   */
  export interface $BreadcrumbsSettings extends $ControlSettings {
    /**
     * Determines the text of current/last element in the Breadcrumbs path.
     *
     * @since 1.34
     */
    currentLocationText?: string | PropertyBindingInfo;

    /**
     * Determines the visual style of the separator between the `Breadcrumbs` elements.
     *
     * @since 1.69
     */
    separatorStyle?:
      | (BreadcrumbsSeparatorStyle | keyof typeof BreadcrumbsSeparatorStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Link determing the current/last element in the Breadcrumbs path.
     *
     * @since 1.123
     */
    currentLocation?: Link;

    /**
     * A list of all the active link elements in the Breadcrumbs control. **Note:** Enabling the property `wrapping`
     * of the link will not work since it's incompatible with the concept of the control. The other properties
     * will work, but their effect may be undesirable.
     *
     * @since 1.34
     */
    links?: Link[] | Link | AggregationBindingInfo | `{${string}}`;

    /**
     * Association to controls / IDs which label this control (see WAI-ARIA attribute `aria-labelledby`).
     *
     * @since 1.92
     */
    ariaLabelledBy?: Array<Control | string>;
  }
}

declare module "sap/m/BusyDialog" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, URI, CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { TitleAlignment } from "sap/m/library";

  import TooltipBase from "sap/ui/core/TooltipBase";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * BusyDialog is used to indicate that the system is busy. Overview: When the busy dialog is displayed,
   * the whole application is blocked. Structure: The busy dialog can hold several elements, most of which
   * are optional.
   * 	 - `title` - A title for the dialog. By default, there is no title.
   * 	 - `text` - A text displayed above the busy animation.
   * 	 - `showCancelButton` - An optional Cancel button to stop the execution.
   * 	 - `customIcon` - An optional alternative icon to use as a busy animation.  Usage: When to use:
   *
   * 	 - The operation lasts more than one second.
   * 	 - You want to indicate loading in a page-to-page navigation (lightweight version).
   * 	 - Offer a Cancel button if you expect the process to run more than 10 seconds.
   * 	 -  If you do not show a title or text, use the {@link sap.ui.core.InvisibleText invisible text} control
   *     to provide the reason for users with assistive technologies.  When not to use:
   * 	 - The screen is not supposed to be blocked. Use a {@link sap.m.BusyIndicator} for the specific application
   *     part.
   * 	 - Do not use the title of the busy dialog. Provide a precise text describing the operation in `text`.
   */
  export default class BusyDialog extends Control {
    /**
     * Constructor for a new BusyDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/busydialog Busy Dialog}
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $BusyDialogSettings
    );
    /**
     * Constructor for a new BusyDialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/busydialog Busy Dialog}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $BusyDialogSettings
    );

    /**
     * Creates a new subclass of class sap.m.BusyDialog with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BusyDialog>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.BusyDialog.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:close close} event of this `sap.m.BusyDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.BusyDialog` itself.
     *
     * Fires when the busy dialog is closed. Note: the BusyDialog will not be closed by the InstanceManager.closeAllDialogs
     * method
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: BusyDialog$CloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.BusyDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:close close} event of this `sap.m.BusyDialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.BusyDialog` itself.
     *
     * Fires when the busy dialog is closed. Note: the BusyDialog will not be closed by the InstanceManager.closeAllDialogs
     * method
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: BusyDialog$CloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.BusyDialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the BusyDialog.
     *
     *
     * @returns The modified BusyDialog.
     */
    close(
      /**
       * Indicates if the BusyDialog is closed from a user interaction.
       */
      isClosedFromUserInteraction?: boolean
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:close close} event of this `sap.m.BusyDialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: BusyDialog$CloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:close close} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: BusyDialog$CloseEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getCancelButtonText cancelButtonText}.
     *
     * The text of the cancel button. The default text is "Cancel" (translated to the respective language).
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `cancelButtonText`
     */
    getCancelButtonText(): string;
    /**
     * Gets current value of property {@link #getCustomIcon customIcon}.
     *
     * Icon, used from the BusyIndicator. This icon is invisible in iOS platform and it is density aware. You
     * can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density
     * screens.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `customIcon`
     */
    getCustomIcon(): URI;
    /**
     * Gets current value of property {@link #getCustomIconDensityAware customIconDensityAware}.
     *
     * If this is set to `false`, the source image will be loaded directly without attempting to fetch the density
     * perfect image for high density devices. By default, this is set to `true` but then one or more requests
     * are sent trying to get the density perfect version of the image.
     *
     * If bandwidth is the key for the application, set this value to `false`.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `customIconDensityAware`
     */
    getCustomIconDensityAware(): boolean;
    /**
     * Gets current value of property {@link #getCustomIconHeight customIconHeight}.
     *
     * Height of the provided icon with default value "44px".
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Value of property `customIconHeight`
     */
    getCustomIconHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getCustomIconRotationSpeed customIconRotationSpeed}.
     *
     * Defines the rotation speed of the given image. If GIF file is used, the speed has to be set to 0. The
     * value is in milliseconds.
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `customIconRotationSpeed`
     */
    getCustomIconRotationSpeed(): int;
    /**
     * Gets current value of property {@link #getCustomIconWidth customIconWidth}.
     *
     * Width of the provided icon with default value "44px".
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Value of property `customIconWidth`
     */
    getCustomIconWidth(): CSSSize;
    /**
     * Gets the DOM reference for the BusyDialog.
     *
     *
     * @returns Dom reference.
     */
    getDomRef(): Element;
    /**
     * Gets current value of property {@link #getShowCancelButton showCancelButton}.
     *
     * Indicates if the cancel button will be rendered inside the busy dialog. The default value is set to `false`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showCancelButton`
     */
    getShowCancelButton(): boolean;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Optional text displayed inside the dialog.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Sets the title of the BusyDialog. The default value is an empty string.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * Default value is `Auto`.
     *
     * @since 1.72
     *
     * @returns Value of property `titleAlignment`
     */
    getTitleAlignment(): TitleAlignment;
    /**
     * Gets the tooltip of the BusyDialog.
     *
     *
     * @returns The tooltip of the BusyDialog.
     */
    getTooltip(): string | TooltipBase;
    /**
     * Opens the BusyDialog.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    open(): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Shows the text for the cancel button.
     *
     *
     * @returns The modified BusyDialog.
     */
    setCancelButtonText(
      /**
       * Text for the cancel button.
       */
      sText: string
    ): this;
    /**
     * Sets custom icon.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setCustomIcon(
      /**
       * Icon to use as a busy animation.
       */
      sIcon: URI
    ): this;
    /**
     * Sets the density of the custom icon.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setCustomIconDensityAware(
      /**
       * Determines if the source image will be loaded directly without attempting to fetch the density for high
       * density devices.
       */
      bIsDensityAware: boolean
    ): this;
    /**
     * Sets the height of the custom icon.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setCustomIconHeight(
      /**
       * Height of the provided icon in CSSSize.
       */
      sHeight: CSSSize
    ): this;
    /**
     * Sets the rotation speed of the custom icon.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setCustomIconRotationSpeed(
      /**
       * Defines the rotation speed of the given image.
       */
      iSpeed: int
    ): this;
    /**
     * Sets the width of the custom icon.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setCustomIconWidth(
      /**
       * Width of the provided icon in CSSSize.
       */
      sWidth: CSSSize
    ): this;
    /**
     * Shows the cancel button.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setShowCancelButton(
      /**
       * Determines if the Cancel button is shown.
       */
      bIsCancelButtonShown: boolean
    ): this;
    /**
     * Sets the text for the BusyDialog.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setText(
      /**
       * The text for the BusyDialog.
       */
      sText: string
    ): this;
    /**
     * Sets the title for the BusyDialog.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setTitle(
      /**
       * The title for the BusyDialog.
       */
      sTitle: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.72
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitleAlignment(
      /**
       * New value for property `titleAlignment`
       */
      sTitleAlignment?: TitleAlignment | keyof typeof TitleAlignment
    ): this;
    /**
     * Sets the tooltip for the BusyDialog.
     *
     *
     * @returns BusyDialog reference for chaining.
     */
    setTooltip(
      /**
       * The tooltip for the BusyDialog.
       */
      sTooltip: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BusyDialog constructor.
   */
  export interface $BusyDialogSettings extends $ControlSettings {
    /**
     * Optional text displayed inside the dialog.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Sets the title of the BusyDialog. The default value is an empty string.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Icon, used from the BusyIndicator. This icon is invisible in iOS platform and it is density aware. You
     * can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density
     * screens.
     */
    customIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the rotation speed of the given image. If GIF file is used, the speed has to be set to 0. The
     * value is in milliseconds.
     */
    customIconRotationSpeed?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to `false`, the source image will be loaded directly without attempting to fetch the density
     * perfect image for high density devices. By default, this is set to `true` but then one or more requests
     * are sent trying to get the density perfect version of the image.
     *
     * If bandwidth is the key for the application, set this value to `false`.
     */
    customIconDensityAware?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the provided icon with default value "44px".
     */
    customIconWidth?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the provided icon with default value "44px".
     */
    customIconHeight?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The text of the cancel button. The default text is "Cancel" (translated to the respective language).
     */
    cancelButtonText?: string | PropertyBindingInfo;

    /**
     * Indicates if the cancel button will be rendered inside the busy dialog. The default value is set to `false`.
     */
    showCancelButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * @since 1.72
     */
    titleAlignment?:
      | (TitleAlignment | keyof typeof TitleAlignment)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Association to controls / IDs which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fires when the busy dialog is closed. Note: the BusyDialog will not be closed by the InstanceManager.closeAllDialogs
     * method
     */
    close?: (oEvent: BusyDialog$CloseEvent) => void;
  }

  /**
   * Parameters of the BusyDialog#close event.
   */
  export interface BusyDialog$CloseEventParameters {
    /**
     * Indicates if the close events are triggered by a user, pressing a cancel button or because the operation
     * was terminated. This parameter is set to true if the close event is fired by user interaction.
     */
    cancelPressed?: boolean;
  }

  /**
   * Event object of the BusyDialog#close event.
   */
  export type BusyDialog$CloseEvent = Event<
    BusyDialog$CloseEventParameters,
    BusyDialog
  >;
}

declare module "sap/m/BusyIndicator" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, URI, CSSSize, TextDirection } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Informs the user about an ongoing operation. Overview: The busy indicator implies that an action is taking
   * place within a single control. You can set the size of the icon, the text, but also define a custom icon
   * to be used instead. Usage: When to use:
   * 	 - The user needs to be able to cancel the operation.
   * 	 - Only part of the application or a particular control is affected.  When not to use:
   * 	 - The operation takes less than one second.
   * 	 - You need to block the screen and prevent the user from starting another activity. In this case, use
   *     the {@link sap.m.BusyDialog busy dialog}.
   * 	 - Do not change the mouse cursor to indicate the ongoing operation.
   * 	 - Do not show multiple busy indicators at once
   */
  export default class BusyIndicator extends Control {
    /**
     * Constructor for a new BusyIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/busy-indicator/ Busy Indicator}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $BusyIndicatorSettings
    );
    /**
     * Constructor for a new BusyIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/busy-indicator/ Busy Indicator}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $BusyIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.m.BusyIndicator with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, BusyIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.BusyIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getCustomIcon customIcon}.
     *
     * Icon URL if an icon is used as the busy indicator.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `customIcon`
     */
    getCustomIcon(): URI;
    /**
     * Gets current value of property {@link #getCustomIconDensityAware customIconDensityAware}.
     *
     * If this is set to false, the src image will be loaded directly without attempting to fetch the density
     * perfect image for high density device. By default, this is set to true but then one or more requests
     * are sent to the server, trying to get the density perfect version of the specified image. If bandwidth
     * is the key for the application, set this value to false.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `customIconDensityAware`
     */
    getCustomIconDensityAware(): boolean;
    /**
     * Gets current value of property {@link #getCustomIconHeight customIconHeight}.
     *
     * Height of the provided icon. By default 44px are used.
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Value of property `customIconHeight`
     */
    getCustomIconHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getCustomIconRotationSpeed customIconRotationSpeed}.
     *
     * Defines the rotation speed of the given image. If a .gif is used, the speed has to be set to 0. The unit
     * is in ms. **Note:** Values are considered valid when greater than or equal to 0. If invalid value is
     * provided the speed defaults to 0.
     *
     * Default value is `1000`.
     *
     *
     * @returns Value of property `customIconRotationSpeed`
     */
    getCustomIconRotationSpeed(): int;
    /**
     * Gets current value of property {@link #getCustomIconWidth customIconWidth}.
     *
     * Width of the provided icon. By default 44px are used.
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Value of property `customIconWidth`
     */
    getCustomIconWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getDesign design}.
     *
     * Setting this property will not have any effect on the appearance of the BusyIndicator in versions greater
     * than or equal to 1.32.1
     *
     * Default value is `"auto"`.
     *
     * @deprecated As of version 1.32.1. the concept has been discarded.
     *
     * @returns Value of property `design`
     */
    getDesign(): string;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Defines the size of the busy indicator. The animation consists of three circles, each of which will be
     * this size. Therefore the total width of the control amounts to three times the given size.
     *
     * Default value is `"1rem"`.
     *
     *
     * @returns Value of property `size`
     */
    getSize(): CSSSize;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines text to be displayed below the busy indicator. It can be used to inform the user of the current
     * operation.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getCustomIcon customIcon}.
     *
     * Icon URL if an icon is used as the busy indicator.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomIcon(
      /**
       * New value for property `customIcon`
       */
      sCustomIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getCustomIconDensityAware customIconDensityAware}.
     *
     * If this is set to false, the src image will be loaded directly without attempting to fetch the density
     * perfect image for high density device. By default, this is set to true but then one or more requests
     * are sent to the server, trying to get the density perfect version of the specified image. If bandwidth
     * is the key for the application, set this value to false.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomIconDensityAware(
      /**
       * New value for property `customIconDensityAware`
       */
      bCustomIconDensityAware?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getCustomIconHeight customIconHeight}.
     *
     * Height of the provided icon. By default 44px are used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomIconHeight(
      /**
       * New value for property `customIconHeight`
       */
      sCustomIconHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getCustomIconRotationSpeed customIconRotationSpeed}.
     *
     * Defines the rotation speed of the given image. If a .gif is used, the speed has to be set to 0. The unit
     * is in ms. **Note:** Values are considered valid when greater than or equal to 0. If invalid value is
     * provided the speed defaults to 0.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1000`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomIconRotationSpeed(
      /**
       * New value for property `customIconRotationSpeed`
       */
      iCustomIconRotationSpeed?: int
    ): this;
    /**
     * Sets a new value for property {@link #getCustomIconWidth customIconWidth}.
     *
     * Width of the provided icon. By default 44px are used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"44px"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomIconWidth(
      /**
       * New value for property `customIconWidth`
       */
      sCustomIconWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getDesign design}.
     *
     * Setting this property will not have any effect on the appearance of the BusyIndicator in versions greater
     * than or equal to 1.32.1
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"auto"`.
     *
     * @deprecated As of version 1.32.1. the concept has been discarded.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDesign(
      /**
       * New value for property `design`
       */
      sDesign?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * Defines the size of the busy indicator. The animation consists of three circles, each of which will be
     * this size. Therefore the total width of the control amounts to three times the given size.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"1rem"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines text to be displayed below the busy indicator. It can be used to inform the user of the current
     * operation.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
  }
  /**
   * Describes the settings that can be provided to the BusyIndicator constructor.
   */
  export interface $BusyIndicatorSettings extends $ControlSettings {
    /**
     * Defines text to be displayed below the busy indicator. It can be used to inform the user of the current
     * operation.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Icon URL if an icon is used as the busy indicator.
     */
    customIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the rotation speed of the given image. If a .gif is used, the speed has to be set to 0. The unit
     * is in ms. **Note:** Values are considered valid when greater than or equal to 0. If invalid value is
     * provided the speed defaults to 0.
     */
    customIconRotationSpeed?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * If this is set to false, the src image will be loaded directly without attempting to fetch the density
     * perfect image for high density device. By default, this is set to true but then one or more requests
     * are sent to the server, trying to get the density perfect version of the specified image. If bandwidth
     * is the key for the application, set this value to false.
     */
    customIconDensityAware?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Width of the provided icon. By default 44px are used.
     */
    customIconWidth?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Height of the provided icon. By default 44px are used.
     */
    customIconHeight?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the size of the busy indicator. The animation consists of three circles, each of which will be
     * this size. Therefore the total width of the control amounts to three times the given size.
     */
    size?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Setting this property will not have any effect on the appearance of the BusyIndicator in versions greater
     * than or equal to 1.32.1
     *
     * @deprecated As of version 1.32.1. the concept has been discarded.
     */
    design?: string | PropertyBindingInfo;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
     *
     * @since 1.27.0
     */
    ariaLabelledBy?: Array<Control | string>;
  }
}

declare module "sap/m/Button" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    IFormContent,
    IAccessKeySupport,
    ID,
    AccessibilityInfo,
    URI,
    aria,
    TextDirection,
    CSSSize,
  } from "sap/ui/core/library";

  import {
    IToolbarInteractiveControl,
    ButtonAccessibleRole,
    BadgeStyle,
    ButtonType,
  } from "sap/m/library";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Enables users to trigger actions.
   *
   * Overview:
   *
   * The user triggers an action by clicking or tapping the `Button` or by pressing certain keyboard keys,
   * such as Enter.
   *
   * Usage:
   *
   * For the `Button` UI, you can define text, icon, or both. You can also specify whether the text or the
   * icon is displayed first.
   *
   * You can choose from a set of predefined {@link sap.m.ButtonType ButtonTypes} that offer different styling
   * to correspond to the triggered action.
   *
   * You can set the `Button` as enabled or disabled. An enabled `Button` can be pressed by clicking or tapping
   * it and it changes its style to provide visual feedback to the user that it is pressed or hovered over
   * with the mouse cursor. A disabled `Button` appears inactive and cannot be pressed.
   */
  export default class Button
    extends Control
    implements IFormContent, IAccessKeySupport, IToolbarInteractiveControl
  {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_IAccessKeySupport: boolean;
    __implements__sap_m_IToolbarInteractiveControl: boolean;
    /**
     * Constructor for a new `Button`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/button/ Button}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ButtonSettings
    );
    /**
     * Constructor for a new `Button`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/button/ Button}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ButtonSettings
    );

    /**
     * Creates a new subclass of class sap.m.Button with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Button>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Button.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Button` itself.
     *
     * Fired when the user clicks or taps on the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Button` itself.
     *
     * Fired when the user clicks or taps on the control.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.m.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Button` itself.
     *
     * Fired when the user taps the control.
     *
     * @deprecated As of version 1.20. replaced by `press` event
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:tap tap} event of this `sap.m.Button`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Button` itself.
     *
     * Fired when the user taps the control.
     *
     * @deprecated As of version 1.20. replaced by `press` event
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachTap(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Button` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.m.Button`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:tap tap} event of this `sap.m.Button`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.20. replaced by `press` event
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachTap(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:tap tap} to attached listeners.
     *
     * @deprecated As of version 1.20. replaced by `press` event
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireTap(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Describes the accessibility role of the button:
     * 	`ButtonAccessibleRole.Default` - The accessibility semantics is derived from the button tag and no role
     * attribute is rendered. `ButtonAccessibleRole.Link` - The accessibility semantics is derived from
     * a custom role attribute with "link" value.
     *
     * NOTE: Use link role only with a press handler, which performs a navigation. In all other scenarios the
     * default button semantics is recommended.
     *
     * Default value is `Default`.
     *
     * @since 1.114.0
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): ButtonAccessibleRole;
    /**
     * Gets current value of property {@link #getActiveIcon activeIcon}.
     *
     * The source property of an alternative icon for the active (depressed) state of the button. Both active
     * and default icon properties should be defined and have the same type: image or icon font. If the `icon`
     * property is not set or has a different type, the active icon is not displayed.
     *
     *
     * @returns Value of property `activeIcon`
     */
    getActiveIcon(): URI;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Gets current value of property {@link #getAriaHasPopup ariaHasPopup}.
     *
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when a button is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * Default value is `None`.
     *
     * @since 1.84.0
     *
     * @returns Value of property `ariaHasPopup`
     */
    getAriaHasPopup(): aria.HasPopup;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getBadgeStyle badgeStyle}.
     *
     * Determines the style in which the badge notification will be represented:
     * 	 - `BadgeStyle.Default` Use for badges that contain numbers
     * 	 - `BadgeStyle.Attention` This badge is rendered as a single dot designed to capture user attention
     *
     *
     * Default value is `Default`.
     *
     * @since 1.132.0
     *
     * @returns Value of property `badgeStyle`
     */
    getBadgeStyle(): BadgeStyle;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Determines whether the `Button` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.ButtonType ButtonType}.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Defines the icon to be displayed as graphical element within the `Button`. It can be an image or an icon
     * from the icon font.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getIconDensityAware iconDensityAware}.
     *
     * By default, this is set to true but then one or more requests are sent trying to get the density perfect
     * version of image if this version of image doesn't exist on the server.
     *
     * If only one version of image is provided, set this value to false to avoid the attempt of fetching density
     * perfect image.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `iconDensityAware`
     */
    getIconDensityAware(): boolean;
    /**
     * Gets current value of property {@link #getIconFirst iconFirst}.
     *
     * Determines whether the icon is displayed before the text.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `iconFirst`
     */
    getIconFirst(): boolean;
    /**
     * Defines to which DOM reference the Popup should be docked
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns the DOM reference that Popup should dock to
     */
    getPopupAnchorDomRef(): Element;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Determines the text of the `Button`.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the `Button` type.
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ButtonType;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the `Button` width.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Describes the accessibility role of the button:
     * 	`ButtonAccessibleRole.Default` - The accessibility semantics is derived from the button tag and no role
     * attribute is rendered. `ButtonAccessibleRole.Link` - The accessibility semantics is derived from
     * a custom role attribute with "link" value.
     *
     * NOTE: Use link role only with a press handler, which performs a navigation. In all other scenarios the
     * default button semantics is recommended.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     * @since 1.114.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: ButtonAccessibleRole | keyof typeof ButtonAccessibleRole
    ): this;
    /**
     * Sets a new value for property {@link #getActiveIcon activeIcon}.
     *
     * The source property of an alternative icon for the active (depressed) state of the button. Both active
     * and default icon properties should be defined and have the same type: image or icon font. If the `icon`
     * property is not set or has a different type, the active icon is not displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveIcon(
      /**
       * New value for property `activeIcon`
       */
      sActiveIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getAriaHasPopup ariaHasPopup}.
     *
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when a button is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.84.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaHasPopup(
      /**
       * New value for property `ariaHasPopup`
       */
      sAriaHasPopup?: aria.HasPopup | keyof typeof aria.HasPopup
    ): this;
    /**
     * Badge maximum value setter - called when someone wants to change the value above which the badge value
     * is displayed with + after the value (ex. 999+)
     *
     *
     * @returns this to allow method chaining
     */
    setBadgeMaxValue(
      /**
       * maximum visible value of the badge (not greater than maximum Badge value - 9999)
       */
      iMax: number
    ): this;
    /**
     * Badge minimum value setter - called when someone wants to change the value below which the badge is hidden.
     *
     *
     * @returns this to allow method chaining
     */
    setBadgeMinValue(
      /**
       * minimum visible value of the badge (not less than minimum Badge value - 1)
       */
      iMin: number
    ): this;
    /**
     * Sets a new value for property {@link #getBadgeStyle badgeStyle}.
     *
     * Determines the style in which the badge notification will be represented:
     * 	 - `BadgeStyle.Default` Use for badges that contain numbers
     * 	 - `BadgeStyle.Attention` This badge is rendered as a single dot designed to capture user attention
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     * @since 1.132.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBadgeStyle(
      /**
       * New value for property `badgeStyle`
       */
      sBadgeStyle?: BadgeStyle | keyof typeof BadgeStyle
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Determines whether the `Button` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.ButtonType ButtonType}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Defines the icon to be displayed as graphical element within the `Button`. It can be an image or an icon
     * from the icon font.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getIconDensityAware iconDensityAware}.
     *
     * By default, this is set to true but then one or more requests are sent trying to get the density perfect
     * version of image if this version of image doesn't exist on the server.
     *
     * If only one version of image is provided, set this value to false to avoid the attempt of fetching density
     * perfect image.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconDensityAware(
      /**
       * New value for property `iconDensityAware`
       */
      bIconDensityAware?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIconFirst iconFirst}.
     *
     * Determines whether the icon is displayed before the text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconFirst(
      /**
       * New value for property `iconFirst`
       */
      bIconFirst?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Determines the text of the `Button`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the `Button` type.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ButtonType | keyof typeof ButtonType
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the `Button` width.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Button constructor.
   */
  export interface $ButtonSettings extends $ControlSettings {
    /**
     * Determines the text of the `Button`.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the `Button` type.
     */
    type?:
      | (ButtonType | keyof typeof ButtonType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the `Button` width.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the `Button` is enabled (default is set to `true`). A disabled `Button` has different
     * colors depending on the {@link sap.m.ButtonType ButtonType}.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the icon to be displayed as graphical element within the `Button`. It can be an image or an icon
     * from the icon font.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the icon is displayed before the text.
     */
    iconFirst?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The source property of an alternative icon for the active (depressed) state of the button. Both active
     * and default icon properties should be defined and have the same type: image or icon font. If the `icon`
     * property is not set or has a different type, the active icon is not displayed.
     */
    activeIcon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * By default, this is set to true but then one or more requests are sent trying to get the density perfect
     * version of image if this version of image doesn't exist on the server.
     *
     * If only one version of image is provided, set this value to false to avoid the attempt of fetching density
     * perfect image.
     */
    iconDensityAware?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the element's text directionality with enumerated options. By default, the control inherits
     * text direction from the DOM.
     *
     * @since 1.28.0
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies the value of the `aria-haspopup` attribute
     *
     * If the value is `None`, the attribute will not be rendered. Otherwise it will be rendered with the selected
     * value.
     *
     * NOTE: Use this property only when a button is related to a popover/popup. The value needs to be equal
     * to the main/root role of the popup - e.g. dialog, menu or list (examples: if you have dialog -> dialog,
     * if you have menu -> menu; if you have list -> list; if you have dialog containing a list -> dialog).
     * Do not use it, if you open a standard sap.m.Dialog, MessageBox or other type of dialogs displayed as
     * on overlay over the application.
     *
     * @since 1.84.0
     */
    ariaHasPopup?:
      | (aria.HasPopup | keyof typeof aria.HasPopup)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Describes the accessibility role of the button:
     * 	`ButtonAccessibleRole.Default` - The accessibility semantics is derived from the button tag and no role
     * attribute is rendered. `ButtonAccessibleRole.Link` - The accessibility semantics is derived from
     * a custom role attribute with "link" value.
     *
     * NOTE: Use link role only with a press handler, which performs a navigation. In all other scenarios the
     * default button semantics is recommended.
     *
     * @since 1.114.0
     */
    accessibleRole?:
      | (ButtonAccessibleRole | keyof typeof ButtonAccessibleRole)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines the style in which the badge notification will be represented:
     * 	 - `BadgeStyle.Default` Use for badges that contain numbers
     * 	 - `BadgeStyle.Attention` This badge is rendered as a single dot designed to capture user attention
     *
     *
     * @since 1.132.0
     */
    badgeStyle?:
      | (BadgeStyle | keyof typeof BadgeStyle)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Association to controls / ids which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / ids which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Fired when the user taps the control.
     *
     * @deprecated As of version 1.20. replaced by `press` event
     */
    tap?: (oEvent: Event) => void;

    /**
     * Fired when the user clicks or taps on the control.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the Button#press event.
   */
  export interface Button$PressEventParameters {}

  /**
   * Event object of the Button#press event.
   */
  export type Button$PressEvent = Event<Button$PressEventParameters, Button>;

  /**
   * Parameters of the Button#tap event.
   *
   * @deprecated As of version 1.20. replaced by `press` event
   */
  export interface Button$TapEventParameters {}

  /**
   * Event object of the Button#tap event.
   *
   * @deprecated As of version 1.20. replaced by `press` event
   */
  export type Button$TapEvent = Event<Button$TapEventParameters, Button>;
}

declare module "sap/m/Carousel" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, CSSSize } from "sap/ui/core/library";

  import {
    CarouselArrowsPlacement,
    BackgroundDesign,
    BorderDesign,
    CarouselPageIndicatorPlacementType,
  } from "sap/m/library";

  import CarouselLayout from "sap/m/CarouselLayout";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The carousel allows the user to browse through a set of items by swiping right or left. Overview: The
   * control is mostly used for showing a gallery of images, but can hold any sap.m control. Structure: The
   * carousel consists of a the following elements:
   * 	 - Content area - displays the different items.
   * 	 - Navigation - arrows to the left and right for switching between items.
   * 	 - (optional) Paging - indicator at the bottom to show the current position in the set.  The paging
   *     indicator can be configured as follows:
   * 	 - `showPageIndicator` - determines if the indicator is displayed.
   * 	 - If the pages are less than 9, the page indicator is represented with bullets.
   * 	 - If the pages are 9 or more, the page indicator is numeric.
   * 	 - `pageIndicatorPlacement` - determines where the indicator is located. Default (`sap.m.CarouselPageIndicatorPlacementType.Bottom`)
   *     - below the content.  Additionally, you can also change the location of the navigation arrows. By
   *     setting `arrowsPlacement` to `sap.m.CarouselArrowsPlacement.PageIndicator`, the arrows will be located
   *     at the bottom by the paging indicator. Note: When the content is of type `sap.m.Image` add "Image" text
   *     at the end of the `"alt"` description in order to provide accessibility info for the UI element. Usage:
   *      When to use:
   * 	 - The items you want to display are very different from each other.
   * 	 - You want to display the items one after the other.   When not to use:
   * 	 - The items you want to display need to be visible at the same time.
   * 	 - The items you want to display are uniform and very similar  Responsive Behavior:
   * 	 - On touch devices, navigation is performed with swipe gestures (swipe right or swipe left) or with
   *     the navigation arrows.
   * 	 - On desktop, navigation is done with the navigation arrows.
   * 	 - The paging indicator (when activated) is visible on each form factor.
   */
  export default class Carousel extends Control {
    /**
     * Constructor for a new Carousel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/carousel/ Carousel}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselSettings
    );
    /**
     * Constructor for a new Carousel.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/carousel/ Carousel}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselSettings
    );

    /**
     * Creates a new subclass of class sap.m.Carousel with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Carousel>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Carousel.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.125
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some page to the aggregation {@link #getPages pages}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addPage(
      /**
       * The page to add; if empty, nothing is inserted
       */
      oPage: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePageChanged beforePageChanged} event of
     * this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * This event is fired before a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePageChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$BeforePageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforePageChanged beforePageChanged} event of
     * this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * This event is fired before a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforePageChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$BeforePageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadPage loadPage} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * Carousel requires a new page to be loaded. This event may be used to fill the content of that page
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadPage(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$LoadPageEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadPage loadPage} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * Carousel requires a new page to be loaded. This event may be used to fill the content of that page
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadPage(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$LoadPageEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageChanged pageChanged} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageChanged(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$PageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:pageChanged pageChanged} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPageChanged(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$PageChangedEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:unloadPage unloadPage} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content
     * of that page.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUnloadPage(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$UnloadPageEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:unloadPage unloadPage} event of this `sap.m.Carousel`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Carousel` itself.
     *
     * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content
     * of that page.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachUnloadPage(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Carousel$UnloadPageEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Carousel` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys the customLayout in the aggregation {@link #getCustomLayout customLayout}.
     *
     * @since 1.62
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomLayout(): this;
    /**
     * Destroys all the pages in the aggregation {@link #getPages pages}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyPages(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforePageChanged beforePageChanged} event
     * of this `sap.m.Carousel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforePageChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Carousel$BeforePageChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:loadPage loadPage} event of this `sap.m.Carousel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLoadPage(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Carousel$LoadPageEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:pageChanged pageChanged} event of this `sap.m.Carousel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPageChanged(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Carousel$PageChangedEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:unloadPage unloadPage} event of this `sap.m.Carousel`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachUnloadPage(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Carousel$UnloadPageEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:beforePageChanged beforePageChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireBeforePageChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Carousel$BeforePageChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:loadPage loadPage} to attached listeners.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLoadPage(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Carousel$LoadPageEventParameters
    ): this;
    /**
     * Fires event {@link #event:pageChanged pageChanged} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePageChanged(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Carousel$PageChangedEventParameters
    ): this;
    /**
     * Fires event {@link #event:unloadPage unloadPage} to attached listeners.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireUnloadPage(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Carousel$UnloadPageEventParameters
    ): this;
    /**
     * ID of the element which is the current target of the association {@link #getActivePage activePage}, or
     * `null`.
     */
    getActivePage(): ID | null;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.125
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getArrowsPlacement arrowsPlacement}.
     *
     * Defines where the carousel's arrows are placed. Default is `sap.m.CarouselArrowsPlacement.Content` used
     * to place the arrows on the sides of the carousel. Alternatively `sap.m.CarouselArrowsPlacement.PageIndicator`
     * can be used to place the arrows on the sides of the page indicator.
     *
     * Default value is `Content`.
     *
     *
     * @returns Value of property `arrowsPlacement`
     */
    getArrowsPlacement(): CarouselArrowsPlacement;
    /**
     * Gets current value of property {@link #getBackgroundDesign backgroundDesign}.
     *
     * Defines the carousel's background design. Default is `sap.m.BackgroundDesign.Translucent`.
     *
     * Default value is `Translucent`.
     *
     * @since 1.110
     *
     * @returns Value of property `backgroundDesign`
     */
    getBackgroundDesign(): BackgroundDesign;
    /**
     * Gets content of aggregation {@link #getCustomLayout customLayout}.
     *
     * Defines how many pages are displayed in the visible area of the `Carousel` control.
     *
     * **Note:** When this property is used, the `loop` property is ignored.
     *
     * @since 1.62
     */
    getCustomLayout(): CarouselLayout;
    /**
     * Gets current value of property {@link #getHeight height}.
     *
     * The height of the carousel. Note that when a percentage value is used, the height of the surrounding
     * container must be defined.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `height`
     */
    getHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getLoop loop}.
     *
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `loop`
     */
    getLoop(): boolean;
    /**
     * Gets current value of property {@link #getPageIndicatorBackgroundDesign pageIndicatorBackgroundDesign}.
     *
     * Defines the carousel page indicator background design. Default is `sap.m.BackgroundDesign.Solid`.
     *
     * Default value is `Solid`.
     *
     * @since 1.115
     *
     * @returns Value of property `pageIndicatorBackgroundDesign`
     */
    getPageIndicatorBackgroundDesign(): BackgroundDesign;
    /**
     * Gets current value of property {@link #getPageIndicatorBorderDesign pageIndicatorBorderDesign}.
     *
     * Defines the carousel page indicator border design. Default is `sap.m.BorderDesign.Solid`.
     *
     * Default value is `Solid`.
     *
     * @since 1.115
     *
     * @returns Value of property `pageIndicatorBorderDesign`
     */
    getPageIndicatorBorderDesign(): BorderDesign;
    /**
     * Gets current value of property {@link #getPageIndicatorPlacement pageIndicatorPlacement}.
     *
     * Defines where the carousel's page indicator is displayed. Possible values are sap.m.CarouselPageIndicatorPlacementType.Top,
     * sap.m.CarouselPageIndicatorPlacementType.Bottom, CarouselPageIndicatorPlacementType.OverContentTop and
     * CarouselPageIndicatorPlacementType.OverContentBottom.
     *
     * **Note:** When the page indicator is placed over the carousel's content (values "OverContentBottom" and
     * "OverContentTop"), the properties `pageIndicatorBackgroundDesign` and `pageIndicatorBorderDesign` will
     * not take effect.
     *
     * **Note:** We recommend using a page indicator placed over the carousel's content (values "OverContentBottom"
     * and "OverContentTop") only if the content consists of images.
     *
     * Default value is `Bottom`.
     *
     *
     * @returns Value of property `pageIndicatorPlacement`
     */
    getPageIndicatorPlacement(): CarouselPageIndicatorPlacementType;
    /**
     * Gets content of aggregation {@link #getPages pages}.
     *
     * The content which the carousel displays.
     */
    getPages(): Control[];
    /**
     * Gets current value of property {@link #getShowBusyIndicator showBusyIndicator}.
     *
     * Show or hide busy indicator in the carousel when loading pages after swipe.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy
     * indicator is not necessary any longer.
     *
     * @returns Value of property `showBusyIndicator`
     */
    getShowBusyIndicator(): boolean;
    /**
     * Gets current value of property {@link #getShowPageIndicator showPageIndicator}.
     *
     * Show or hide carousel's page indicator.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showPageIndicator`
     */
    getShowPageIndicator(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * The width of the carousel. Note that when a percentage value is used, the height of the surrounding container
     * must be defined.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getPages pages}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfPage(
      /**
       * The page whose index is looked for
       */
      oPage: Control
    ): int;
    /**
     * Inserts a page into the aggregation {@link #getPages pages}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertPage(
      /**
       * The page to insert; if empty, nothing is inserted
       */
      oPage: Control,
      /**
       * The `0`-based index the page should be inserted at; for a negative value of `iIndex`, the page is inserted
       * at position 0; for a value greater than the current size of the aggregation, the page is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Call this method to display the next page (corresponds to a swipe right).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    next(): this;
    /**
     * Call this method to display the previous page (corresponds to a swipe left).
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    previous(): this;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.125
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getPages pages}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllPages(): Control[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.125
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a page from the aggregation {@link #getPages pages}.
     *
     *
     * @returns The removed page or `null`
     */
    removePage(
      /**
       * The page to remove or its index or id
       */
      vPage: int | string | Control
    ): Control | null;
    /**
     * Sets the associated {@link #getActivePage activePage}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActivePage(
      /**
       * ID of an element which becomes the new target of this activePage association; alternatively, an element
       * instance may be given
       */
      oActivePage: ID | Control
    ): this;
    /**
     * Sets a new value for property {@link #getArrowsPlacement arrowsPlacement}.
     *
     * Defines where the carousel's arrows are placed. Default is `sap.m.CarouselArrowsPlacement.Content` used
     * to place the arrows on the sides of the carousel. Alternatively `sap.m.CarouselArrowsPlacement.PageIndicator`
     * can be used to place the arrows on the sides of the page indicator.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Content`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setArrowsPlacement(
      /**
       * New value for property `arrowsPlacement`
       */
      sArrowsPlacement?:
        | CarouselArrowsPlacement
        | keyof typeof CarouselArrowsPlacement
    ): this;
    /**
     * Sets a new value for property {@link #getBackgroundDesign backgroundDesign}.
     *
     * Defines the carousel's background design. Default is `sap.m.BackgroundDesign.Translucent`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Translucent`.
     *
     * @since 1.110
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBackgroundDesign(
      /**
       * New value for property `backgroundDesign`
       */
      sBackgroundDesign?: BackgroundDesign | keyof typeof BackgroundDesign
    ): this;
    /**
     * Sets the aggregated {@link #getCustomLayout customLayout}.
     *
     * @since 1.62
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomLayout(
      /**
       * The customLayout to set
       */
      oCustomLayout: CarouselLayout
    ): this;
    /**
     * Sets a new value for property {@link #getHeight height}.
     *
     * The height of the carousel. Note that when a percentage value is used, the height of the surrounding
     * container must be defined.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeight(
      /**
       * New value for property `height`
       */
      sHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getLoop loop}.
     *
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLoop(
      /**
       * New value for property `loop`
       */
      bLoop?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorBackgroundDesign pageIndicatorBackgroundDesign}.
     *
     * Defines the carousel page indicator background design. Default is `sap.m.BackgroundDesign.Solid`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Solid`.
     *
     * @since 1.115
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorBackgroundDesign(
      /**
       * New value for property `pageIndicatorBackgroundDesign`
       */
      sPageIndicatorBackgroundDesign?:
        | BackgroundDesign
        | keyof typeof BackgroundDesign
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorBorderDesign pageIndicatorBorderDesign}.
     *
     * Defines the carousel page indicator border design. Default is `sap.m.BorderDesign.Solid`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Solid`.
     *
     * @since 1.115
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorBorderDesign(
      /**
       * New value for property `pageIndicatorBorderDesign`
       */
      sPageIndicatorBorderDesign?: BorderDesign | keyof typeof BorderDesign
    ): this;
    /**
     * Sets a new value for property {@link #getPageIndicatorPlacement pageIndicatorPlacement}.
     *
     * Defines where the carousel's page indicator is displayed. Possible values are sap.m.CarouselPageIndicatorPlacementType.Top,
     * sap.m.CarouselPageIndicatorPlacementType.Bottom, CarouselPageIndicatorPlacementType.OverContentTop and
     * CarouselPageIndicatorPlacementType.OverContentBottom.
     *
     * **Note:** When the page indicator is placed over the carousel's content (values "OverContentBottom" and
     * "OverContentTop"), the properties `pageIndicatorBackgroundDesign` and `pageIndicatorBorderDesign` will
     * not take effect.
     *
     * **Note:** We recommend using a page indicator placed over the carousel's content (values "OverContentBottom"
     * and "OverContentTop") only if the content consists of images.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Bottom`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPageIndicatorPlacement(
      /**
       * New value for property `pageIndicatorPlacement`
       */
      sPageIndicatorPlacement?:
        | CarouselPageIndicatorPlacementType
        | keyof typeof CarouselPageIndicatorPlacementType
    ): this;
    /**
     * Sets a new value for property {@link #getShowBusyIndicator showBusyIndicator}.
     *
     * Show or hide busy indicator in the carousel when loading pages after swipe.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy
     * indicator is not necessary any longer.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowBusyIndicator(
      /**
       * New value for property `showBusyIndicator`
       */
      bShowBusyIndicator?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPageIndicator showPageIndicator}.
     *
     * Show or hide carousel's page indicator.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPageIndicator(
      /**
       * New value for property `showPageIndicator`
       */
      bShowPageIndicator?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * The width of the carousel. Note that when a percentage value is used, the height of the surrounding container
     * must be defined.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'100%'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Carousel constructor.
   */
  export interface $CarouselSettings extends $ControlSettings {
    /**
     * The height of the carousel. Note that when a percentage value is used, the height of the surrounding
     * container must be defined.
     */
    height?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * The width of the carousel. Note that when a percentage value is used, the height of the surrounding container
     * must be defined.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the carousel should loop, i.e show the first page after the last page is reached and
     * vice versa.
     */
    loop?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Show or hide carousel's page indicator.
     */
    showPageIndicator?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines where the carousel's page indicator is displayed. Possible values are sap.m.CarouselPageIndicatorPlacementType.Top,
     * sap.m.CarouselPageIndicatorPlacementType.Bottom, CarouselPageIndicatorPlacementType.OverContentTop and
     * CarouselPageIndicatorPlacementType.OverContentBottom.
     *
     * **Note:** When the page indicator is placed over the carousel's content (values "OverContentBottom" and
     * "OverContentTop"), the properties `pageIndicatorBackgroundDesign` and `pageIndicatorBorderDesign` will
     * not take effect.
     *
     * **Note:** We recommend using a page indicator placed over the carousel's content (values "OverContentBottom"
     * and "OverContentTop") only if the content consists of images.
     */
    pageIndicatorPlacement?:
      | (
          | CarouselPageIndicatorPlacementType
          | keyof typeof CarouselPageIndicatorPlacementType
        )
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Show or hide busy indicator in the carousel when loading pages after swipe.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded. Therefore busy
     * indicator is not necessary any longer.
     */
    showBusyIndicator?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines where the carousel's arrows are placed. Default is `sap.m.CarouselArrowsPlacement.Content` used
     * to place the arrows on the sides of the carousel. Alternatively `sap.m.CarouselArrowsPlacement.PageIndicator`
     * can be used to place the arrows on the sides of the page indicator.
     */
    arrowsPlacement?:
      | (CarouselArrowsPlacement | keyof typeof CarouselArrowsPlacement)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the carousel's background design. Default is `sap.m.BackgroundDesign.Translucent`.
     *
     * @since 1.110
     */
    backgroundDesign?:
      | (BackgroundDesign | keyof typeof BackgroundDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the carousel page indicator background design. Default is `sap.m.BackgroundDesign.Solid`.
     *
     * @since 1.115
     */
    pageIndicatorBackgroundDesign?:
      | (BackgroundDesign | keyof typeof BackgroundDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the carousel page indicator border design. Default is `sap.m.BorderDesign.Solid`.
     *
     * @since 1.115
     */
    pageIndicatorBorderDesign?:
      | (BorderDesign | keyof typeof BorderDesign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The content which the carousel displays.
     */
    pages?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * Defines how many pages are displayed in the visible area of the `Carousel` control.
     *
     * **Note:** When this property is used, the `loop` property is ignored.
     *
     * @since 1.62
     */
    customLayout?: CarouselLayout;

    /**
     * Provides getter and setter for the currently displayed page. For the setter, argument may be the control
     * itself, which must be member of the carousel's page list, or the control's id. The getter will return
     * the control id
     */
    activePage?: Control | string;

    /**
     * Association to controls / IDs which label this control (see WAI-ARIA attribute `aria-labelledby`).
     *
     * @since 1.125
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Carousel requires a new page to be loaded. This event may be used to fill the content of that page
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     */
    loadPage?: (oEvent: Carousel$LoadPageEvent) => void;

    /**
     * Carousel does not display a page any longer and unloads it. This event may be used to clean up the content
     * of that page.
     *
     * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
     */
    unloadPage?: (oEvent: Carousel$UnloadPageEvent) => void;

    /**
     * This event is fired after a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     */
    pageChanged?: (oEvent: Carousel$PageChangedEvent) => void;

    /**
     * This event is fired before a carousel swipe has been completed. It is triggered both by physical swipe
     * events and through API carousel manipulations such as calling 'next', 'previous' or 'setActivePage' functions.
     */
    beforePageChanged?: (oEvent: Carousel$BeforePageChangedEvent) => void;
  }

  /**
   * Parameters of the Carousel#beforePageChanged event.
   */
  export interface Carousel$BeforePageChangedEventParameters {
    /**
     * Indexes of all active pages after the page change.
     */
    activePages?: any[];
  }

  /**
   * Event object of the Carousel#beforePageChanged event.
   */
  export type Carousel$BeforePageChangedEvent = Event<
    Carousel$BeforePageChangedEventParameters,
    Carousel
  >;

  /**
   * Parameters of the Carousel#loadPage event.
   *
   * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
   */
  export interface Carousel$LoadPageEventParameters {
    /**
     * Id of the page which will be loaded
     */
    pageId?: string;
  }

  /**
   * Event object of the Carousel#loadPage event.
   *
   * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
   */
  export type Carousel$LoadPageEvent = Event<
    Carousel$LoadPageEventParameters,
    Carousel
  >;

  /**
   * Parameters of the Carousel#pageChanged event.
   */
  export interface Carousel$PageChangedEventParameters {
    /**
     * ID of the page which was active before the page change.
     */
    oldActivePageId?: string;

    /**
     * ID of the page which will be active after the page change.
     */
    newActivePageId?: string;

    /**
     * Indexes of all active pages after the page change.
     */
    activePages?: any[];
  }

  /**
   * Event object of the Carousel#pageChanged event.
   */
  export type Carousel$PageChangedEvent = Event<
    Carousel$PageChangedEventParameters,
    Carousel
  >;

  /**
   * Parameters of the Carousel#unloadPage event.
   *
   * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
   */
  export interface Carousel$UnloadPageEventParameters {
    /**
     * Id of the page which will be unloaded
     */
    pageId?: string;
  }

  /**
   * Event object of the Carousel#unloadPage event.
   *
   * @deprecated As of version 1.18.7. Since 1.18.7 pages are no longer loaded or unloaded
   */
  export type Carousel$UnloadPageEvent = Event<
    Carousel$UnloadPageEventParameters,
    Carousel
  >;
}

declare module "sap/m/CarouselLayout" {
  import {
    default as ManagedObject,
    $ManagedObjectSettings,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ManagedObjectMetadata from "sap/ui/base/ManagedObjectMetadata";

  import { CarouselScrollMode } from "sap/m/library";

  /**
   * Applies a `sap.m.CarouselLayout` to a provided DOM element or Control.
   *
   * @since 1.62
   */
  export default class CarouselLayout extends ManagedObject {
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselLayoutSettings
    );
    /**
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CarouselLayoutSettings
    );

    /**
     * Creates a new subclass of class sap.m.CarouselLayout with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.base.ManagedObject.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CarouselLayout>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.CarouselLayout.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ManagedObjectMetadata;
    /**
     * Gets current value of property {@link #getScrollMode scrollMode}.
     *
     * Defines how the items will be scrolled through in `Carousel` control. One at a time or depending on the
     * `visiblePagesCount`
     *
     * NOTE: `visiblePagesCount` must be set a value larger than 1, to be able to use `scrollMode` with value
     * "VisiblePages"
     *
     * Default value is `SinglePage`.
     *
     * @since 1.121
     *
     * @returns Value of property `scrollMode`
     */
    getScrollMode(): CarouselScrollMode;
    /**
     * Gets current value of property {@link #getVisiblePagesCount visiblePagesCount}.
     *
     * Defines how many pages are displayed in the visible area of the `Carousel` control. Value should be a
     * positive number.
     *
     * **Note:** When this property is set to something different than the default value, the `loop` property
     * of `Carousel` is ignored.
     *
     * Default value is `1`.
     *
     *
     * @returns Value of property `visiblePagesCount`
     */
    getVisiblePagesCount(): int;
    /**
     * Sets a new value for property {@link #getScrollMode scrollMode}.
     *
     * Defines how the items will be scrolled through in `Carousel` control. One at a time or depending on the
     * `visiblePagesCount`
     *
     * NOTE: `visiblePagesCount` must be set a value larger than 1, to be able to use `scrollMode` with value
     * "VisiblePages"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `SinglePage`.
     *
     * @since 1.121
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setScrollMode(
      /**
       * New value for property `scrollMode`
       */
      sScrollMode?: CarouselScrollMode | keyof typeof CarouselScrollMode
    ): this;
    /**
     * Sets a new value for property {@link #getVisiblePagesCount visiblePagesCount}.
     *
     * Defines how many pages are displayed in the visible area of the `Carousel` control. Value should be a
     * positive number.
     *
     * **Note:** When this property is set to something different than the default value, the `loop` property
     * of `Carousel` is ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisiblePagesCount(
      /**
       * New value for property `visiblePagesCount`
       */
      iVisiblePagesCount?: int
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CarouselLayout constructor.
   */
  export interface $CarouselLayoutSettings extends $ManagedObjectSettings {
    /**
     * Defines how many pages are displayed in the visible area of the `Carousel` control. Value should be a
     * positive number.
     *
     * **Note:** When this property is set to something different than the default value, the `loop` property
     * of `Carousel` is ignored.
     */
    visiblePagesCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines how the items will be scrolled through in `Carousel` control. One at a time or depending on the
     * `visiblePagesCount`
     *
     * NOTE: `visiblePagesCount` must be set a value larger than 1, to be able to use `scrollMode` with value
     * "VisiblePages"
     *
     * @since 1.121
     */
    scrollMode?:
      | (CarouselScrollMode | keyof typeof CarouselScrollMode)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/CheckBox" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    IFormContent,
    ISemanticFormContent,
    IAccessKeySupport,
    ID,
    AccessibilityInfo,
    TextAlign,
    TextDirection,
    ValueState,
    CSSSize,
  } from "sap/ui/core/library";

  import { IToolbarInteractiveControl } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Allows the user to set a binary value, such as true/false or yes/no for an item.
   *
   * Overview:
   *
   * The `CheckBox` control consists of a box and a label that describes its purpose. If it's checked, an
   * indicator is displayed inside the box.
   *
   * To select/deselect the `CheckBox`, the user has to click or tap the square box or its label. Clicking
   * or tapping toggles the `CheckBox` between checked and unchecked state. The `CheckBox` control only has
   * 3 states - checked, unchecked and partially selected.
   *
   * Usage:
   *
   * You can set the width of the element containing the box and the label manually with the use of the `width`
   * property. If the text exceeds the available width, it is truncated.
   *
   * **Note:** When `useEntireWidth` property is set to `true`, the value of the `width` property is applied
   * to the control as a whole (box and label). If `useEntireWidth` is set to `false`, the `width` is applied
   * to the label only.
   *
   * The touchable area for toggling the `CheckBox` ends where the text ends.
   *
   * If the width allows more space than the text requires, white space is added. The text can be positioned
   * manually in this space using the `textAlign` property.
   *
   * **Note:** Keep in mind that setting the `textAlign` property to `Right` can result in a large amount
   * of white space between the box and the text.
   *
   * You can disable the `CheckBox` by setting the `enabled` property to `false`, or use the `CheckBox` in
   * read-only mode by setting the `editable` property to false.
   *
   * **Note:** Disabled and read-only states shouldn't be used together.
   */
  export default class CheckBox
    extends Control
    implements
      IFormContent,
      ISemanticFormContent,
      IAccessKeySupport,
      IToolbarInteractiveControl
  {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_ISemanticFormContent: boolean;
    __implements__sap_ui_core_IAccessKeySupport: boolean;
    __implements__sap_m_IToolbarInteractiveControl: boolean;
    /**
     * Constructor for a new `CheckBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/checkbox/ Check Box}
     */
    constructor(
      /**
       * The Initial settings for the new control
       */
      mSettings?: $CheckBoxSettings
    );
    /**
     * Constructor for a new `CheckBox`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/checkbox/ Check Box}
     */
    constructor(
      /**
       * The ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * The Initial settings for the new control
       */
      mSettings?: $CheckBoxSettings
    );

    /**
     * Creates a new subclass of class sap.m.CheckBox with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CheckBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.CheckBox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.m.CheckBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.CheckBox` itself.
     *
     * Event is triggered when the control status is changed by the user by selecting or deselecting the checkbox.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CheckBox$SelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.CheckBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:select select} event of this `sap.m.CheckBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.CheckBox` itself.
     *
     * Event is triggered when the control status is changed by the user by selecting or deselecting the checkbox.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: CheckBox$SelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.CheckBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:select select} event of this `sap.m.CheckBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: CheckBox$SelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:select select} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: CheckBox$SelectEventParameters
    ): this;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The object contains the accessibility information of `sap.m.CheckBox`
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Gets current value of property {@link #getActiveHandling activeHandling}.
     *
     * Flag to switch on activeHandling, when it is switched off, there will be no visual changes on active
     * state. Default value is 'true'
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `activeHandling`
     */
    getActiveHandling(): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDisplayOnly displayOnly}.
     *
     * Determines whether the `CheckBox` is in display only state.
     *
     * When set to `true`, the `CheckBox` is not interactive, not editable, not focusable and not in the tab
     * chain. This setting is used for forms in review mode.
     *
     *  When the property `enabled` is set to `false` this property has no effect.
     *
     * Default value is `false`.
     *
     * @since 1.54
     *
     * @returns Value of property `displayOnly`
     */
    getDisplayOnly(): boolean;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Specifies whether the user shall be allowed to edit the state of the checkbox
     *
     * Default value is `true`.
     *
     * @since 1.25
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Whether the `CheckBox` is enabled.
     *
     * **Note:** Disabled `CheckBox` is not interactive and is rendered differently according to the theme.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server
     * via submit.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPartiallySelected partiallySelected}.
     *
     * Determines whether the `CheckBox` is displayed as partially selected.
     *
     * **Note:** This property leads only to visual change of the checkbox and the state cannot be achieved
     * by user interaction. The visual state depends on the value of the `selected` property:
     * 	 - If `selected` = `true` and `partiallySelected` = `true`, the control is displayed as partially selected
     *
     * 	 - If `selected` = `true` and `partiallySelected` = `false`, the control is displayed as selected
     * 	 - If `selected` = `false`, the control is displayed as not selected regardless of what is set for `partiallySelected`
     *
     *
     * Default value is `false`.
     *
     * @since 1.58
     *
     * @returns Value of property `partiallySelected`
     */
    getPartiallySelected(): boolean;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Sets the `required` state of the `CheckBox`.
     *
     * **Note:** Use this property only when a single relationship between this field and a Label cannot be
     * established. For example, with the assistance of the `labelFor` property of `sap.m.Label`.
     *
     * **Note:** This property won't work as expected without setting a value to the `text` property of the
     * `CheckBox`. The `text` property acts as a label for the `CheckBox` and is crucial for assistive technologies,
     * like screen readers, to provide a meaningful context.
     *
     * Default value is `false`.
     *
     * @since 1.121
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getSelected selected}.
     *
     * Determines whether the `CheckBox` is selected (checked).
     *
     * When this property is set to `true`, the control is displayed as selected, unless the value of the `partiallySelected`
     * property is also set to `true`. In this case, the control is displayed as partially selected.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `selected`
     */
    getSelected(): boolean;
    /**
     * Returns the CheckBox`s tab index.
     *
     * @since 1.22
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns iTabIndex for Checkbox
     */
    getTabIndex(): int;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the text displayed next to the checkbox
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getTextAlign textAlign}.
     *
     * Aligns the text of the checkbox. Available alignment settings are "Begin", "Center", "End", "Left", and
     * "Right".
     *
     * Default value is `Begin`.
     *
     *
     * @returns Value of property `textAlign`
     */
    getTextAlign(): TextAlign;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Gets current value of property {@link #getUseEntireWidth useEntireWidth}.
     *
     * Indicates if the given width will be applied to the control as a whole or to its label only.
     *
     * **Note:** by default the width is set to the label
     *
     * Default value is `false`.
     *
     * @since 1.52
     *
     * @returns Value of property `useEntireWidth`
     */
    getUseEntireWidth(): boolean;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Accepts the core enumeration ValueState.type that supports 'None', 'Error', 'Warning', 'Success' and
     * 'Information'.
     *
     * Default value is `None`.
     *
     * @since 1.38
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Determines the total width of the control or the width of its label only, depending on the value of `useEntireWidth`.
     *
     * **Note:** When `useEntireWidth` is set to `true`, `width` is applied to the control as a whole (checkbox
     * and label). Otherwise, `width` is applied to the label only.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getWrapping wrapping}.
     *
     * Determines whether the label's text is wrapped.
     *
     * When set to `false` (default), the label's text is truncated with ellipsis at the end.
     *
     * Default value is `false`.
     *
     * @since 1.54
     *
     * @returns Value of property `wrapping`
     */
    getWrapping(): boolean;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Sets a new value for property {@link #getActiveHandling activeHandling}.
     *
     * Flag to switch on activeHandling, when it is switched off, there will be no visual changes on active
     * state. Default value is 'true'
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActiveHandling(
      /**
       * New value for property `activeHandling`
       */
      bActiveHandling?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayOnly displayOnly}.
     *
     * Determines whether the `CheckBox` is in display only state.
     *
     * When set to `true`, the `CheckBox` is not interactive, not editable, not focusable and not in the tab
     * chain. This setting is used for forms in review mode.
     *
     *  When the property `enabled` is set to `false` this property has no effect.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.54
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayOnly(
      /**
       * New value for property `displayOnly`
       */
      bDisplayOnly?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Specifies whether the user shall be allowed to edit the state of the checkbox
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.25
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Whether the `CheckBox` is enabled.
     *
     * **Note:** Disabled `CheckBox` is not interactive and is rendered differently according to the theme.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server
     * via submit.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPartiallySelected partiallySelected}.
     *
     * Determines whether the `CheckBox` is displayed as partially selected.
     *
     * **Note:** This property leads only to visual change of the checkbox and the state cannot be achieved
     * by user interaction. The visual state depends on the value of the `selected` property:
     * 	 - If `selected` = `true` and `partiallySelected` = `true`, the control is displayed as partially selected
     *
     * 	 - If `selected` = `true` and `partiallySelected` = `false`, the control is displayed as selected
     * 	 - If `selected` = `false`, the control is displayed as not selected regardless of what is set for `partiallySelected`
     *
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.58
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPartiallySelected(
      /**
       * New value for property `partiallySelected`
       */
      bPartiallySelected?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Sets the `required` state of the `CheckBox`.
     *
     * **Note:** Use this property only when a single relationship between this field and a Label cannot be
     * established. For example, with the assistance of the `labelFor` property of `sap.m.Label`.
     *
     * **Note:** This property won't work as expected without setting a value to the `text` property of the
     * `CheckBox`. The `text` property acts as a label for the `CheckBox` and is crucial for assistive technologies,
     * like screen readers, to provide a meaningful context.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.121
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getSelected selected}.
     *
     * Determines whether the `CheckBox` is selected (checked).
     *
     * When this property is set to `true`, the control is displayed as selected, unless the value of the `partiallySelected`
     * property is also set to `true`. In this case, the control is displayed as partially selected.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelected(
      /**
       * New value for property `selected`
       */
      bSelected?: boolean
    ): this;
    /**
     * Sets the tab index of the control
     *
     * @since 1.16
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The `sap.m.CheckBox` instance
     */
    setTabIndex(
      /**
       * The tab index should be greater than or equal -1
       */
      iTabIndex: int
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the text displayed next to the checkbox
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextAlign textAlign}.
     *
     * Aligns the text of the checkbox. Available alignment settings are "Begin", "Center", "End", "Left", and
     * "Right".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Begin`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextAlign(
      /**
       * New value for property `textAlign`
       */
      sTextAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getUseEntireWidth useEntireWidth}.
     *
     * Indicates if the given width will be applied to the control as a whole or to its label only.
     *
     * **Note:** by default the width is set to the label
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.52
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setUseEntireWidth(
      /**
       * New value for property `useEntireWidth`
       */
      bUseEntireWidth?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Accepts the core enumeration ValueState.type that supports 'None', 'Error', 'Warning', 'Success' and
     * 'Information'.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Determines the total width of the control or the width of its label only, depending on the value of `useEntireWidth`.
     *
     * **Note:** When `useEntireWidth` is set to `true`, `width` is applied to the control as a whole (checkbox
     * and label). Otherwise, `width` is applied to the label only.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getWrapping wrapping}.
     *
     * Determines whether the label's text is wrapped.
     *
     * When set to `false` (default), the label's text is truncated with ellipsis at the end.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.54
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrapping(
      /**
       * New value for property `wrapping`
       */
      bWrapping?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CheckBox constructor.
   */
  export interface $CheckBoxSettings extends $ControlSettings {
    /**
     * Determines whether the `CheckBox` is selected (checked).
     *
     * When this property is set to `true`, the control is displayed as selected, unless the value of the `partiallySelected`
     * property is also set to `true`. In this case, the control is displayed as partially selected.
     */
    selected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the `CheckBox` is displayed as partially selected.
     *
     * **Note:** This property leads only to visual change of the checkbox and the state cannot be achieved
     * by user interaction. The visual state depends on the value of the `selected` property:
     * 	 - If `selected` = `true` and `partiallySelected` = `true`, the control is displayed as partially selected
     *
     * 	 - If `selected` = `true` and `partiallySelected` = `false`, the control is displayed as selected
     * 	 - If `selected` = `false`, the control is displayed as not selected regardless of what is set for `partiallySelected`
     *
     *
     * @since 1.58
     */
    partiallySelected?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether the `CheckBox` is enabled.
     *
     * **Note:** Disabled `CheckBox` is not interactive and is rendered differently according to the theme.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the `required` state of the `CheckBox`.
     *
     * **Note:** Use this property only when a single relationship between this field and a Label cannot be
     * established. For example, with the assistance of the `labelFor` property of `sap.m.Label`.
     *
     * **Note:** This property won't work as expected without setting a value to the `text` property of the
     * `CheckBox`. The `text` property acts as a label for the `CheckBox` and is crucial for assistive technologies,
     * like screen readers, to provide a meaningful context.
     *
     * @since 1.121
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The 'name' property to be used in the HTML code, for example for HTML forms that send data to the server
     * via submit.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines the text displayed next to the checkbox
     */
    text?: string | PropertyBindingInfo;

    /**
     * Options for the text direction are RTL and LTR. Alternatively, the control can inherit the text direction
     * from its parent container.
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Aligns the text of the checkbox. Available alignment settings are "Begin", "Center", "End", "Left", and
     * "Right".
     */
    textAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines the total width of the control or the width of its label only, depending on the value of `useEntireWidth`.
     *
     * **Note:** When `useEntireWidth` is set to `true`, `width` is applied to the control as a whole (checkbox
     * and label). Otherwise, `width` is applied to the label only.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the given width will be applied to the control as a whole or to its label only.
     *
     * **Note:** by default the width is set to the label
     *
     * @since 1.52
     */
    useEntireWidth?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Flag to switch on activeHandling, when it is switched off, there will be no visual changes on active
     * state. Default value is 'true'
     */
    activeHandling?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether the user shall be allowed to edit the state of the checkbox
     *
     * @since 1.25
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Accepts the core enumeration ValueState.type that supports 'None', 'Error', 'Warning', 'Success' and
     * 'Information'.
     *
     * @since 1.38
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the `CheckBox` is in display only state.
     *
     * When set to `true`, the `CheckBox` is not interactive, not editable, not focusable and not in the tab
     * chain. This setting is used for forms in review mode.
     *
     *  When the property `enabled` is set to `false` this property has no effect.
     *
     * @since 1.54
     */
    displayOnly?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the label's text is wrapped.
     *
     * When set to `false` (default), the label's text is truncated with ellipsis at the end.
     *
     * @since 1.54
     */
    wrapping?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Association to controls / IDs which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls / IDs which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Event is triggered when the control status is changed by the user by selecting or deselecting the checkbox.
     */
    select?: (oEvent: CheckBox$SelectEvent) => void;
  }

  /**
   * Parameters of the CheckBox#select event.
   */
  export interface CheckBox$SelectEventParameters {
    /**
     * Checks whether the CheckBox is marked or not .
     */
    selected?: boolean;
  }

  /**
   * Event object of the CheckBox#select event.
   */
  export type CheckBox$SelectEvent = Event<
    CheckBox$SelectEventParameters,
    CheckBox
  >;
}

declare module "sap/m/ColorPalette" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSColor } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * Represents a predefined range of colors for easier selection.
   *
   * Overview: The `ColorPalette` provides the users with a range of predefined colors.
   *
   * You can customize them with the use of the `colors` property. You can specify a `defaultColor` and display
   * a "Default color" button for the user to choose directly. You can display a "More colors..." button that
   * opens an additional color picker for the user to choose specific colors that are not present in the predefined
   * range.
   *
   * Usage:
   *
   * The palette is intended for users, who don't want to check and remember the different values of the colors
   * and spend large amount of time to configure the right color through the color picker.
   *
   * The control can be embedded in a form or can be opened as popover (by use of thin wrapper control `sap.m.ColorPalettePopover`).
   *
   * @since 1.54
   */
  export default class ColorPalette extends Control {
    /**
     * Constructor for a new `ColorPalette`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link sap.m.ColorPalettePopover}
     *
     * **Note:** The application developers should add dependency to `sap.ui.unified` library
     * on application level to ensure that the library is loaded before the module dependencies will be required.
     * The {@link sap.ui.unified.ColorPicker} is used internally only if the `ColorPicker`
     * is opened (not used for the initial rendering). If the `sap.ui.unified` library is not loaded
     * before the `ColorPicker` is opened, it will be loaded upon opening. This could lead to CSP compliance
     * issues and adds an additional waiting time when the `ColorPicker` is opened for the first time.
     * To prevent this, apps using the `ColorPalette` should also load the `sap.ui.unified` library in advance.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteSettings
    );
    /**
     * Constructor for a new `ColorPalette`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link sap.m.ColorPalettePopover}
     *
     * **Note:** The application developers should add dependency to `sap.ui.unified` library
     * on application level to ensure that the library is loaded before the module dependencies will be required.
     * The {@link sap.ui.unified.ColorPicker} is used internally only if the `ColorPicker`
     * is opened (not used for the initial rendering). If the `sap.ui.unified` library is not loaded
     * before the `ColorPicker` is opened, it will be loaded upon opening. This could lead to CSP compliance
     * issues and adds an additional waiting time when the `ColorPicker` is opened for the first time.
     * To prevent this, apps using the `ColorPalette` should also load the `sap.ui.unified` library in advance.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPaletteSettings
    );

    /**
     * Creates a new subclass of class sap.m.ColorPalette with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPalette>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ColorPalette.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalette` itself.
     *
     * Fired when the user selects a color. Note: The `selectedColor` property is updated after the event is
     * fired. Use the event parameter `value` to retrieve the new value for `selectedColor`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachColorSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$ColorSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalette` itself.
     *
     * Fired when the user selects a color. Note: The `selectedColor` property is updated after the event is
     * fired. Use the event parameter `value` to retrieve the new value for `selectedColor`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachColorSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$ColorSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalette` itself.
     *
     * Fired when the value is changed by user interaction in the internal ColorPicker
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalette`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalette` itself.
     *
     * Fired when the value is changed by user interaction in the internal ColorPicker
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalette$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalette` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalette`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachColorSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalette$ColorSelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalette`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLiveChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalette$LiveChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:colorSelect colorSelect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireColorSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalette$ColorSelectEventParameters
    ): this;
    /**
     * Fires event {@link #event:liveChange liveChange} to attached listeners.
     *
     * @since 1.85
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLiveChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalette$LiveChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getColors colors}.
     *
     * Defines the List of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     *
     * Default value is `["gold", "darkorange", "indianred", "darkmagenta", "cornflowerblue", "deepskyblue",
     * "darkcyan", "olivedrab", "darkslategray", "azure", "white", "lightgray", "darkgray", "dimgray", "black"]`.
     *
     *
     * @returns Value of property `colors`
     */
    getColors(): CSSColor[];
    /**
     * Gets current value of property {@link #getSelectedColor selectedColor}.
     *
     * The last selected color in the ColorPalette.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     *
     * @returns Value of property `selectedColor`
     */
    getSelectedColor(): CSSColor;
    /**
     * Sets a selected color for the ColorPicker control.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setColorPickerSelectedColor(
      /**
       * the selected color
       */
      sColor: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getColors colors}.
     *
     * Defines the List of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `["gold", "darkorange", "indianred", "darkmagenta", "cornflowerblue", "deepskyblue",
     * "darkcyan", "olivedrab", "darkslategray", "azure", "white", "lightgray", "darkgray", "dimgray", "black"]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColors(
      /**
       * New value for property `colors`
       */
      sColors?: CSSColor[]
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedColor selectedColor}.
     *
     * The last selected color in the ColorPalette.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedColor(
      /**
       * New value for property `selectedColor`
       */
      sSelectedColor?: CSSColor
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColorPalette constructor.
   */
  export interface $ColorPaletteSettings extends $ControlSettings {
    /**
     * Defines the List of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     */
    colors?: CSSColor[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The last selected color in the ColorPalette.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     */
    selectedColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the user selects a color. Note: The `selectedColor` property is updated after the event is
     * fired. Use the event parameter `value` to retrieve the new value for `selectedColor`.
     */
    colorSelect?: (oEvent: ColorPalette$ColorSelectEvent) => void;

    /**
     * Fired when the value is changed by user interaction in the internal ColorPicker
     *
     * @since 1.85
     */
    liveChange?: (oEvent: ColorPalette$LiveChangeEvent) => void;
  }

  /**
   * Parameters of the ColorPalette#colorSelect event.
   */
  export interface ColorPalette$ColorSelectEventParameters {
    /**
     * The color that is returned when user chooses the "Default color" button.
     */
    value?: CSSColor;

    /**
     * Denotes if the color has been chosen by selecting the "Default Color" button (true or false)
     */
    defaultAction?: boolean;
  }

  /**
   * Event object of the ColorPalette#colorSelect event.
   */
  export type ColorPalette$ColorSelectEvent = Event<
    ColorPalette$ColorSelectEventParameters,
    ColorPalette
  >;

  /**
   * Parameters of the ColorPalette#liveChange event.
   */
  export interface ColorPalette$LiveChangeEventParameters {
    /**
     * Parameter containing the RED value (0-255).
     */
    r?: int;

    /**
     * Parameter containing the GREEN value (0-255).
     */
    g?: int;

    /**
     * Parameter containing the BLUE value (0-255).
     */
    b?: int;

    /**
     * Parameter containing the HUE value (0-360).
     */
    h?: int;

    /**
     * Parameter containing the SATURATION value (0-100).
     */
    s?: int;

    /**
     * Parameter containing the VALUE value (0-100).
     */
    v?: int;

    /**
     * Parameter containing the LIGHTNESS value (0-100).
     */
    l?: int;

    /**
     * Parameter containing the Hexadecimal string (#FFFFFF).
     */
    hex?: string;

    /**
     * Parameter containing the alpha value (transparency).
     */
    alpha?: string;
  }

  /**
   * Event object of the ColorPalette#liveChange event.
   */
  export type ColorPalette$LiveChangeEvent = Event<
    ColorPalette$LiveChangeEventParameters,
    ColorPalette
  >;
}

declare module "sap/m/ColorPalettePopover" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { CSSColor } from "sap/ui/core/library";

  import ColorPickerDisplayMode from "sap/ui/unified/ColorPickerDisplayMode";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * A thin wrapper over {@link sap.m.ColorPalette} allowing the latter to be used in a popover.
   *
   * @since 1.54
   */
  export default class ColorPalettePopover extends Control {
    /**
     * Constructor for a new `ColorPalettePopover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPalettePopoverSettings
    );
    /**
     * Constructor for a new `ColorPalettePopover`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColorPalettePopoverSettings
    );

    /**
     * Creates a new subclass of class sap.m.ColorPalettePopover with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColorPalettePopover>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ColorPalettePopover.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalettePopover` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachColorSelect(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ColorSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalettePopover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalettePopover` itself.
     *
     * Fired when the user selects a color.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachColorSelect(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ColorSelectEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalettePopover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalettePopover` itself.
     *
     * Fired when the value is changed by user interaction in the internal ColorPicker of the ColorPalette
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalettePopover` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalettePopover`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ColorPalettePopover` itself.
     *
     * Fired when the value is changed by user interaction in the internal ColorPicker of the ColorPalette
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ColorPalettePopover` itself
       */
      oListener?: object
    ): this;
    /**
     * Closes the `ColorPalettePopover`.
     *
     *
     * @returns Reference to the closed control
     */
    close(): Control;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:colorSelect colorSelect} event of this `sap.m.ColorPalettePopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachColorSelect(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$ColorSelectEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:liveChange liveChange} event of this `sap.m.ColorPalettePopover`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.85
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLiveChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ColorPalettePopover$LiveChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:colorSelect colorSelect} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireColorSelect(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalettePopover$ColorSelectEventParameters
    ): this;
    /**
     * Fires event {@link #event:liveChange liveChange} to attached listeners.
     *
     * @since 1.85
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLiveChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ColorPalettePopover$LiveChangeEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getColors colors}.
     *
     * Defines the list of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     *
     * Default value is `["gold", "darkorange", "indianred", "darkmagenta", "cornflowerblue", "deepskyblue",
     * "darkcyan", "olivedrab", "darkslategray", "azure", "white", "lightgray", "darkgray", "dimgray", "black"]`.
     *
     *
     * @returns Value of property `colors`
     */
    getColors(): CSSColor[];
    /**
     * Gets current value of property {@link #getDefaultColor defaultColor}.
     *
     * The color, which the app developer will receive when end-user chooses the "Default color" button. See
     * event {@link #event:colorSelect colorSelect}.
     *
     *
     * @returns Value of property `defaultColor`
     */
    getDefaultColor(): CSSColor;
    /**
     * Gets current value of property {@link #getDisplayMode displayMode}.
     *
     * Determines the `displayMode` of the `ColorPicker` among three types - Default, Large and Simplified
     *
     * Default value is `Default`.
     *
     * @since 1.70
     *
     * @returns Value of property `displayMode`
     */
    getDisplayMode(): ColorPickerDisplayMode;
    /**
     * Gets current value of property {@link #getSelectedColor selectedColor}.
     *
     * The last selected color in the ColorPalette.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     *
     * @returns Value of property `selectedColor`
     */
    getSelectedColor(): CSSColor;
    /**
     * Gets current value of property {@link #getShowDefaultColorButton showDefaultColorButton}.
     *
     * Indicates if the button for default color selection is available.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showDefaultColorButton`
     */
    getShowDefaultColorButton(): boolean;
    /**
     * Gets current value of property {@link #getShowMoreColorsButton showMoreColorsButton}.
     *
     * Whether the popover shows a "More colors..." button that opens an additional color picker for the user
     * to choose specific colors, not present in the predefined range.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showMoreColorsButton`
     */
    getShowMoreColorsButton(): boolean;
    /**
     * Gets current value of property {@link #getShowRecentColorsSection showRecentColorsSection}.
     *
     * Indicates if the Recent Colors section is available
     *
     * Default value is `true`.
     *
     * @since 1.74
     *
     * @returns Value of property `showRecentColorsSection`
     */
    getShowRecentColorsSection(): boolean;
    /**
     * Opens the `ColorPalettePopover`.
     *
     * On table or desktop devices, the popover is positioned relative to the given `oControl` parameter. On
     * phones, it is shown full screen, the `oControl` parameter is ignored.
     *
     *
     * @returns Reference to the opened control
     */
    openBy(
      /**
       * When displayed on a tablet or desktop device, the `ColorPalettePopover` is positioned relative to this
       * control
       */
      oControl: Control
    ): Control;
    /**
     * Sets a selected color for the ColorPicker control.
     *
     *
     * @returns `this` for method chaining
     */
    setColorPickerSelectedColor(
      /**
       * the selected color
       */
      color: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getColors colors}.
     *
     * Defines the list of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `["gold", "darkorange", "indianred", "darkmagenta", "cornflowerblue", "deepskyblue",
     * "darkcyan", "olivedrab", "darkslategray", "azure", "white", "lightgray", "darkgray", "dimgray", "black"]`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setColors(
      /**
       * New value for property `colors`
       */
      sColors?: CSSColor[]
    ): this;
    /**
     * Sets a new value for property {@link #getDefaultColor defaultColor}.
     *
     * The color, which the app developer will receive when end-user chooses the "Default color" button. See
     * event {@link #event:colorSelect colorSelect}.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDefaultColor(
      /**
       * New value for property `defaultColor`
       */
      sDefaultColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayMode displayMode}.
     *
     * Determines the `displayMode` of the `ColorPicker` among three types - Default, Large and Simplified
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     * @since 1.70
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayMode(
      /**
       * New value for property `displayMode`
       */
      sDisplayMode?:
        | ColorPickerDisplayMode
        | keyof typeof ColorPickerDisplayMode
    ): this;
    /**
     * Sets a new value for property {@link #getSelectedColor selectedColor}.
     *
     * The last selected color in the ColorPalette.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSelectedColor(
      /**
       * New value for property `selectedColor`
       */
      sSelectedColor?: CSSColor
    ): this;
    /**
     * Sets a new value for property {@link #getShowDefaultColorButton showDefaultColorButton}.
     *
     * Indicates if the button for default color selection is available.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowDefaultColorButton(
      /**
       * New value for property `showDefaultColorButton`
       */
      bShowDefaultColorButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowMoreColorsButton showMoreColorsButton}.
     *
     * Whether the popover shows a "More colors..." button that opens an additional color picker for the user
     * to choose specific colors, not present in the predefined range.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowMoreColorsButton(
      /**
       * New value for property `showMoreColorsButton`
       */
      bShowMoreColorsButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowRecentColorsSection showRecentColorsSection}.
     *
     * Indicates if the Recent Colors section is available
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.74
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRecentColorsSection(
      /**
       * New value for property `showRecentColorsSection`
       */
      bShowRecentColorsSection?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ColorPalettePopover constructor.
   */
  export interface $ColorPalettePopoverSettings extends $ControlSettings {
    /**
     * The color, which the app developer will receive when end-user chooses the "Default color" button. See
     * event {@link #event:colorSelect colorSelect}.
     */
    defaultColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the list of colors displayed in the palette. Minimum is 2 colors, maximum is 15 colors.
     */
    colors?: CSSColor[] | PropertyBindingInfo | `{${string}}`;

    /**
     * The last selected color in the ColorPalette.
     *
     * @since 1.122
     * @experimental As of version 1.122. this property is in a beta state.
     */
    selectedColor?: CSSColor | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the button for default color selection is available.
     */
    showDefaultColorButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Whether the popover shows a "More colors..." button that opens an additional color picker for the user
     * to choose specific colors, not present in the predefined range.
     */
    showMoreColorsButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the Recent Colors section is available
     *
     * @since 1.74
     */
    showRecentColorsSection?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the `displayMode` of the `ColorPicker` among three types - Default, Large and Simplified
     *
     * @since 1.70
     */
    displayMode?:
      | (ColorPickerDisplayMode | keyof typeof ColorPickerDisplayMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Fired when the user selects a color.
     */
    colorSelect?: (oEvent: ColorPalettePopover$ColorSelectEvent) => void;

    /**
     * Fired when the value is changed by user interaction in the internal ColorPicker of the ColorPalette
     *
     * @since 1.85
     */
    liveChange?: (oEvent: ColorPalettePopover$LiveChangeEvent) => void;
  }

  /**
   * Parameters of the ColorPalettePopover#colorSelect event.
   */
  export interface ColorPalettePopover$ColorSelectEventParameters {
    /**
     * The selected color value.
     */
    value?: CSSColor;

    /**
     * Denotes if the color has been chosen by selecting the "Default Color" button (true or false).
     */
    defaultAction?: boolean;
  }

  /**
   * Event object of the ColorPalettePopover#colorSelect event.
   */
  export type ColorPalettePopover$ColorSelectEvent = Event<
    ColorPalettePopover$ColorSelectEventParameters,
    ColorPalettePopover
  >;

  /**
   * Parameters of the ColorPalettePopover#liveChange event.
   */
  export interface ColorPalettePopover$LiveChangeEventParameters {
    /**
     * Parameter containing the RED value (0-255).
     */
    r?: int;

    /**
     * Parameter containing the GREEN value (0-255).
     */
    g?: int;

    /**
     * Parameter containing the BLUE value (0-255).
     */
    b?: int;

    /**
     * Parameter containing the HUE value (0-360).
     */
    h?: int;

    /**
     * Parameter containing the SATURATION value (0-100).
     */
    s?: int;

    /**
     * Parameter containing the VALUE value (0-100).
     */
    v?: int;

    /**
     * Parameter containing the LIGHTNESS value (0-100).
     */
    l?: int;

    /**
     * Parameter containing the Hexadecimal string (#FFFFFF).
     */
    hex?: string;

    /**
     * Parameter containing the alpha value (transparency).
     */
    alpha?: string;
  }

  /**
   * Event object of the ColorPalettePopover#liveChange event.
   */
  export type ColorPalettePopover$LiveChangeEvent = Event<
    ColorPalettePopover$LiveChangeEventParameters,
    ColorPalettePopover
  >;
}

declare module "sap/m/Column" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import Control from "sap/ui/core/Control";

  import {
    TextAlign,
    ID,
    Priority,
    SortOrder,
    VerticalAlign,
    CSSSize,
    IColumnHeaderMenu,
  } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PopinDisplay } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.m.Column` allows to define column specific properties that will be applied when rendering the
   * `sap.m.Table`.
   *
   * See section "{@link https://ui5.sap.com/#/topic/6f778a805bc3453dbb66e246d8271839 Defining Column Width}"
   * in the documentation to understand how to define the `width` property of the `sap.m.Column` to render
   * a `sap.m.Table` control properly.
   *
   * @since 1.12
   */
  export default class Column extends UI5Element {
    /**
     * Constructor for a new Column.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );
    /**
     * Constructor for a new Column.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $ColumnSettings
    );

    /**
     * Creates a new subclass of class sap.m.Column with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Column>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Column.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Clears the last value of the column if mergeDuplicates property is true
     *
     * @since 1.20.4
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    clearLastValue(): this;
    /**
     * Destroys the footer in the aggregation {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFooter(): this;
    /**
     * Destroys the header in the aggregation {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyHeader(): this;
    /**
     * Gets current value of property {@link #getAutoPopinWidth autoPopinWidth}.
     *
     * Defines the auto pop-in width for the column.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the `autoPopinWidth` property
     * is used to calculate the `minScreenWidth` property of the column in case a fixed width is not set for
     * the column. See {@link sap.m.Column#getWidth} and {@link sap.m.Table#getAutoPopinMode}. **Note:** A float
     * value is set for the `autoPopinWidth` property which is internally treated as a rem value.
     *
     * Default value is `8`.
     *
     * @since 1.76
     *
     * @returns Value of property `autoPopinWidth`
     */
    getAutoPopinWidth(): float;
    /**
     * Returns CSS alignment according to column hAlign setting or given parameter for Begin/End values checks
     * the locale settings
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns left|center|right
     */
    getCssAlign(
      /**
       * TextAlign enumeration
       */
      sAlign?: string
    ): string;
    /**
     * Gets current value of property {@link #getDemandPopin demandPopin}.
     *
     * According to your minScreenWidth settings, the column can be hidden in different screen sizes. Setting
     * this property to true, shows this column as pop-in instead of hiding it. **Note:** This property gets
     * overwritten if the `sap.m.Table` control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `demandPopin`
     */
    getDemandPopin(): boolean;
    /**
     * Gets content of aggregation {@link #getFooter footer}.
     *
     * Control to be displayed in the column footer.
     */
    getFooter(): Control;
    /**
     * Gets current value of property {@link #getHAlign hAlign}.
     *
     * Defines the horizontal alignment of the column content.
     *
     * **Note:** Text controls with a `textAlign` property inherits the horizontal alignment.
     *
     * Default value is `Begin`.
     *
     *
     * @returns Value of property `hAlign`
     */
    getHAlign(): TextAlign;
    /**
     * Gets content of aggregation {@link #getHeader header}.
     *
     * Control to be displayed in the column header.
     */
    getHeader(): Control;
    /**
     * ID of the element which is the current target of the association {@link #getHeaderMenu headerMenu}, or
     * `null`.
     *
     * @since 1.98.0
     */
    getHeaderMenu(): ID | null;
    /**
     * Gets current value of property {@link #getImportance importance}.
     *
     * Defines the column importance.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the column importance is taken
     * into consideration for calculating the `minScreenWidth` property and for setting the `demandPopin` property
     * of the column. See {@link sap.m.Table#getAutoPopinMode}
     *
     * Default value is `"None"`.
     *
     * @since 1.76
     *
     * @returns Value of property `importance`
     */
    getImportance(): Priority;
    /**
     * Gets the rendering index of the column
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getIndex(): void;
    /**
     * Gets the initial order of the column
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns initial order of the column
     */
    getInitialOrder(): int;
    /**
     * Gets the last value of the column
     *
     * @since 1.16
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getLastValue(): void;
    /**
     * Gets current value of property {@link #getMergeDuplicates mergeDuplicates}.
     *
     * Set `true` to merge repeating/duplicate cells into one cell block. See `mergeFunctionName` property to
     * customize.
     *
     * **Note:** Merging only happens when rendering the `sap.m.Table` control, subsequent changes on the cell
     * or item do not have any effect on the merged state of the cells, therefore this feature should not be
     * used together with two-way binding. This property is ignored if any column is configured to be shown
     * as a pop-in. Don't set this property for cells for which the content provides a user interaction, such
     * as `sap.m.Link`.
     *
     * Default value is `false`.
     *
     * @since 1.16
     *
     * @returns Value of property `mergeDuplicates`
     */
    getMergeDuplicates(): boolean;
    /**
     * Gets current value of property {@link #getMergeFunctionName mergeFunctionName}.
     *
     * Defines the control serialization function if `mergeDuplicates` property is set to `true`. The control
     * itself uses this function to compare values of two repeating cells. Default value "getText" is suitable
     * for `sap.m.Label` and `sap.m.Text` controls but for the `sap.ui.core.Icon` control "getSrc" function
     * should be used to merge icons. **Note:** You can pass one string parameter to given function after "#"
     * sign. e.g. "data#myparameter"
     *
     * Default value is `'getText'`.
     *
     * @since 1.16
     *
     * @returns Value of property `mergeFunctionName`
     */
    getMergeFunctionName(): string;
    /**
     * Gets current value of property {@link #getMinScreenWidth minScreenWidth}.
     *
     * Defines the minimum screen width to show or hide this column. By default column is always shown. The
     * responsive behavior of the `sap.m.Table` is determined by this property. As an example by setting `minScreenWidth`
     * property to "40em" (or "640px" or "Tablet") shows this column on tablet (and desktop) but hides on mobile.
     * As you can give specific CSS sizes (e.g: "480px" or "40em"), you can also use the {@link sap.m.ScreenSize }
     * enumeration (e.g: "Phone", "Tablet", "Desktop", "Small", "Medium", "Large", ....). Please also see `demandPopin`
     * property for further responsive design options. **Note:** This property gets overwritten if the `sap.m.Table`
     * control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     *
     *
     * @returns Value of property `minScreenWidth`
     */
    getMinScreenWidth(): string;
    /**
     * Gets the order of the column
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns nOrder order of the column
     */
    getOrder(): int;
    /**
     * Gets current value of property {@link #getPopinDisplay popinDisplay}.
     *
     * Defines enumerated display options for the pop-in.
     *
     * Default value is `Block`.
     *
     * @since 1.13.2
     *
     * @returns Value of property `popinDisplay`
     */
    getPopinDisplay(): PopinDisplay;
    /**
     * Gets current value of property {@link #getPopinHAlign popinHAlign}.
     *
     * Horizontal alignment of the pop-in content. Available alignment settings are "Begin", "Center", "End",
     * "Left", and "Right".
     *
     * **Note:** Controls with a text align do not inherit the horizontal alignment.
     *
     * Default value is `Begin`.
     *
     * @deprecated As of version 1.14. Use popinDisplay property instead.
     *
     * @returns Value of property `popinHAlign`
     */
    getPopinHAlign(): TextAlign;
    /**
     * Gets current value of property {@link #getSortIndicator sortIndicator}.
     *
     * Defines if a column is sorted by setting the sort indicator for this column.
     *
     * **Note:** Defining this property does not trigger the sorting.
     *
     * Default value is `None`.
     *
     * @since 1.61
     *
     * @returns Value of property `sortIndicator`
     */
    getSortIndicator(): SortOrder;
    /**
     * Gets current value of property {@link #getStyleClass styleClass}.
     *
     * CSS class name for column contents(header, cells and footer of column). This property can be used for
     * different column styling. If column is shown as pop-in then this class name is applied to related pop-in
     * row.
     *
     *
     * @returns Value of property `styleClass`
     */
    getStyleClass(): string;
    /**
     * Gets current value of property {@link #getVAlign vAlign}.
     *
     * Defines the vertical alignment of the cells in a column. This property does not affect the vertical alignment
     * of header and footer.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `vAlign`
     */
    getVAlign(): VerticalAlign;
    /**
     * Gets current value of property {@link #getVisible visible}.
     *
     * Specifies whether or not the column is visible. Invisible columns are not rendered.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `visible`
     */
    getVisible(): boolean;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the column. If you leave it empty then this column covers the remaining space. **Note:**
     * When setting `autoPopinMode=true` on the table, the columns with a fixed width must either be in px,
     * rem, or em as the table internally calculates the `minScreenWidth` property for the column. If a column
     * has a fixed width, then this width is used to calculate the `minScreenWidth` for the `autoPopinMode`.
     * If a column has a flexible width, such as % or auto, the `autoPopinWidth` property is used to calculate
     * the `minScreenWidth`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Determines whether the column is hidden without being in the popin area
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    isHidden(): void;
    /**
     * Determines whether the column is shown as pop-in or not
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    isPopin(): void;
    /**
     * Gets called from the Table when the all items are removed
     *
     * @since 1.16
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onItemsRemoved(): void;
    /**
     * Sets a new value for property {@link #getAutoPopinWidth autoPopinWidth}.
     *
     * Defines the auto pop-in width for the column.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the `autoPopinWidth` property
     * is used to calculate the `minScreenWidth` property of the column in case a fixed width is not set for
     * the column. See {@link sap.m.Column#getWidth} and {@link sap.m.Table#getAutoPopinMode}. **Note:** A float
     * value is set for the `autoPopinWidth` property which is internally treated as a rem value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `8`.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAutoPopinWidth(
      /**
       * New value for property `autoPopinWidth`
       */
      fAutoPopinWidth?: float
    ): this;
    /**
     * Sets a new value for property {@link #getDemandPopin demandPopin}.
     *
     * According to your minScreenWidth settings, the column can be hidden in different screen sizes. Setting
     * this property to true, shows this column as pop-in instead of hiding it. **Note:** This property gets
     * overwritten if the `sap.m.Table` control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDemandPopin(
      /**
       * New value for property `demandPopin`
       */
      bDemandPopin?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getFooter footer}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFooter(
      /**
       * The footer to set
       */
      oFooter: Control
    ): this;
    /**
     * Sets a new value for property {@link #getHAlign hAlign}.
     *
     * Defines the horizontal alignment of the column content.
     *
     * **Note:** Text controls with a `textAlign` property inherits the horizontal alignment.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Begin`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHAlign(
      /**
       * New value for property `hAlign`
       */
      sHAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets the aggregated {@link #getHeader header}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeader(
      /**
       * The header to set
       */
      oHeader: Control
    ): this;
    /**
     * Sets the associated {@link #getHeaderMenu headerMenu}.
     *
     * @since 1.98.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHeaderMenu(
      /**
       * ID of an element which becomes the new target of this headerMenu association; alternatively, an element
       * instance may be given
       */
      oHeaderMenu: ID | IColumnHeaderMenu
    ): this;
    /**
     * Sets a new value for property {@link #getImportance importance}.
     *
     * Defines the column importance.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the column importance is taken
     * into consideration for calculating the `minScreenWidth` property and for setting the `demandPopin` property
     * of the column. See {@link sap.m.Table#getAutoPopinMode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"None"`.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setImportance(
      /**
       * New value for property `importance`
       */
      sImportance?: Priority | keyof typeof Priority
    ): this;
    /**
     * Sets the visible column index Negative index values can be used to clear
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setIndex(
      /**
       * index of the visible column
       */
      nIndex: int
    ): void;
    /**
     * Sets the initial order of the column
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setInitialOrder(
      /**
       * initial order of the column
       */
      nOrder: int
    ): void;
    /**
     * Sets the last value of the column if mergeDuplicates property is true
     *
     * @since 1.16
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setLastValue(
      /**
       * Any Value
       */
      value: any
    ): this;
    /**
     * Sets a new value for property {@link #getMergeDuplicates mergeDuplicates}.
     *
     * Set `true` to merge repeating/duplicate cells into one cell block. See `mergeFunctionName` property to
     * customize.
     *
     * **Note:** Merging only happens when rendering the `sap.m.Table` control, subsequent changes on the cell
     * or item do not have any effect on the merged state of the cells, therefore this feature should not be
     * used together with two-way binding. This property is ignored if any column is configured to be shown
     * as a pop-in. Don't set this property for cells for which the content provides a user interaction, such
     * as `sap.m.Link`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.16
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMergeDuplicates(
      /**
       * New value for property `mergeDuplicates`
       */
      bMergeDuplicates?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getMergeFunctionName mergeFunctionName}.
     *
     * Defines the control serialization function if `mergeDuplicates` property is set to `true`. The control
     * itself uses this function to compare values of two repeating cells. Default value "getText" is suitable
     * for `sap.m.Label` and `sap.m.Text` controls but for the `sap.ui.core.Icon` control "getSrc" function
     * should be used to merge icons. **Note:** You can pass one string parameter to given function after "#"
     * sign. e.g. "data#myparameter"
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'getText'`.
     *
     * @since 1.16
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMergeFunctionName(
      /**
       * New value for property `mergeFunctionName`
       */
      sMergeFunctionName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getMinScreenWidth minScreenWidth}.
     *
     * Defines the minimum screen width to show or hide this column. By default column is always shown. The
     * responsive behavior of the `sap.m.Table` is determined by this property. As an example by setting `minScreenWidth`
     * property to "40em" (or "640px" or "Tablet") shows this column on tablet (and desktop) but hides on mobile.
     * As you can give specific CSS sizes (e.g: "480px" or "40em"), you can also use the {@link sap.m.ScreenSize }
     * enumeration (e.g: "Phone", "Tablet", "Desktop", "Small", "Medium", "Large", ....). Please also see `demandPopin`
     * property for further responsive design options. **Note:** This property gets overwritten if the `sap.m.Table`
     * control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinScreenWidth(
      /**
       * New value for property `minScreenWidth`
       */
      sMinScreenWidth?: string
    ): this;
    /**
     * Sets the order of the column Does not do the visual effect Table should be invalidate to re-render
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setOrder(
      /**
       * order of the column
       */
      nOrder: int
    ): void;
    /**
     * Sets a new value for property {@link #getPopinDisplay popinDisplay}.
     *
     * Defines enumerated display options for the pop-in.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Block`.
     *
     * @since 1.13.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPopinDisplay(
      /**
       * New value for property `popinDisplay`
       */
      sPopinDisplay?: PopinDisplay | keyof typeof PopinDisplay
    ): this;
    /**
     * Sets a new value for property {@link #getPopinHAlign popinHAlign}.
     *
     * Horizontal alignment of the pop-in content. Available alignment settings are "Begin", "Center", "End",
     * "Left", and "Right".
     *
     * **Note:** Controls with a text align do not inherit the horizontal alignment.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Begin`.
     *
     * @deprecated As of version 1.14. Use popinDisplay property instead.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPopinHAlign(
      /**
       * New value for property `popinHAlign`
       */
      sPopinHAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets a new value for property {@link #getSortIndicator sortIndicator}.
     *
     * Defines if a column is sorted by setting the sort indicator for this column.
     *
     * **Note:** Defining this property does not trigger the sorting.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.61
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSortIndicator(
      /**
       * New value for property `sortIndicator`
       */
      sSortIndicator?: SortOrder | keyof typeof SortOrder
    ): this;
    /**
     * Sets a new value for property {@link #getStyleClass styleClass}.
     *
     * CSS class name for column contents(header, cells and footer of column). This property can be used for
     * different column styling. If column is shown as pop-in then this class name is applied to related pop-in
     * row.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStyleClass(
      /**
       * New value for property `styleClass`
       */
      sStyleClass?: string
    ): this;
    /**
     * Sets a new value for property {@link #getVAlign vAlign}.
     *
     * Defines the vertical alignment of the cells in a column. This property does not affect the vertical alignment
     * of header and footer.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVAlign(
      /**
       * New value for property `vAlign`
       */
      sVAlign?: VerticalAlign | keyof typeof VerticalAlign
    ): this;
    /**
     * Sets a new value for property {@link #getVisible visible}.
     *
     * Specifies whether or not the column is visible. Invisible columns are not rendered.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVisible(
      /**
       * New value for property `visible`
       */
      bVisible?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the column. If you leave it empty then this column covers the remaining space. **Note:**
     * When setting `autoPopinMode=true` on the table, the columns with a fixed width must either be in px,
     * rem, or em as the table internally calculates the `minScreenWidth` property for the column. If a column
     * has a fixed width, then this width is used to calculate the `minScreenWidth` for the `autoPopinMode`.
     * If a column has a flexible width, such as % or auto, the `autoPopinWidth` property is used to calculate
     * the `minScreenWidth`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
  }
  /**
   * Describes the settings that can be provided to the Column constructor.
   */
  export interface $ColumnSettings extends $ElementSettings {
    /**
     * Defines the width of the column. If you leave it empty then this column covers the remaining space. **Note:**
     * When setting `autoPopinMode=true` on the table, the columns with a fixed width must either be in px,
     * rem, or em as the table internally calculates the `minScreenWidth` property for the column. If a column
     * has a fixed width, then this width is used to calculate the `minScreenWidth` for the `autoPopinMode`.
     * If a column has a flexible width, such as % or auto, the `autoPopinWidth` property is used to calculate
     * the `minScreenWidth`.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the horizontal alignment of the column content.
     *
     * **Note:** Text controls with a `textAlign` property inherits the horizontal alignment.
     */
    hAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the vertical alignment of the cells in a column. This property does not affect the vertical alignment
     * of header and footer.
     */
    vAlign?:
      | (VerticalAlign | keyof typeof VerticalAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * CSS class name for column contents(header, cells and footer of column). This property can be used for
     * different column styling. If column is shown as pop-in then this class name is applied to related pop-in
     * row.
     */
    styleClass?: string | PropertyBindingInfo;

    /**
     * Specifies whether or not the column is visible. Invisible columns are not rendered.
     */
    visible?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the minimum screen width to show or hide this column. By default column is always shown. The
     * responsive behavior of the `sap.m.Table` is determined by this property. As an example by setting `minScreenWidth`
     * property to "40em" (or "640px" or "Tablet") shows this column on tablet (and desktop) but hides on mobile.
     * As you can give specific CSS sizes (e.g: "480px" or "40em"), you can also use the {@link sap.m.ScreenSize }
     * enumeration (e.g: "Phone", "Tablet", "Desktop", "Small", "Medium", "Large", ....). Please also see `demandPopin`
     * property for further responsive design options. **Note:** This property gets overwritten if the `sap.m.Table`
     * control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     */
    minScreenWidth?: string | PropertyBindingInfo;

    /**
     * According to your minScreenWidth settings, the column can be hidden in different screen sizes. Setting
     * this property to true, shows this column as pop-in instead of hiding it. **Note:** This property gets
     * overwritten if the `sap.m.Table` control is configured with `autoPopinMode=true`. See {@link sap.m.Table#getAutoPopinMode}
     */
    demandPopin?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Horizontal alignment of the pop-in content. Available alignment settings are "Begin", "Center", "End",
     * "Left", and "Right".
     *
     * **Note:** Controls with a text align do not inherit the horizontal alignment.
     *
     * @deprecated As of version 1.14. Use popinDisplay property instead.
     */
    popinHAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines enumerated display options for the pop-in.
     *
     * @since 1.13.2
     */
    popinDisplay?:
      | (PopinDisplay | keyof typeof PopinDisplay)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Set `true` to merge repeating/duplicate cells into one cell block. See `mergeFunctionName` property to
     * customize.
     *
     * **Note:** Merging only happens when rendering the `sap.m.Table` control, subsequent changes on the cell
     * or item do not have any effect on the merged state of the cells, therefore this feature should not be
     * used together with two-way binding. This property is ignored if any column is configured to be shown
     * as a pop-in. Don't set this property for cells for which the content provides a user interaction, such
     * as `sap.m.Link`.
     *
     * @since 1.16
     */
    mergeDuplicates?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the control serialization function if `mergeDuplicates` property is set to `true`. The control
     * itself uses this function to compare values of two repeating cells. Default value "getText" is suitable
     * for `sap.m.Label` and `sap.m.Text` controls but for the `sap.ui.core.Icon` control "getSrc" function
     * should be used to merge icons. **Note:** You can pass one string parameter to given function after "#"
     * sign. e.g. "data#myparameter"
     *
     * @since 1.16
     */
    mergeFunctionName?: string | PropertyBindingInfo;

    /**
     * Defines if a column is sorted by setting the sort indicator for this column.
     *
     * **Note:** Defining this property does not trigger the sorting.
     *
     * @since 1.61
     */
    sortIndicator?:
      | (SortOrder | keyof typeof SortOrder)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the column importance.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the column importance is taken
     * into consideration for calculating the `minScreenWidth` property and for setting the `demandPopin` property
     * of the column. See {@link sap.m.Table#getAutoPopinMode}
     *
     * @since 1.76
     */
    importance?:
      | (Priority | keyof typeof Priority)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the auto pop-in width for the column.
     *
     * If the `sap.m.Table` control is configured with `autoPopinMode=true`, then the `autoPopinWidth` property
     * is used to calculate the `minScreenWidth` property of the column in case a fixed width is not set for
     * the column. See {@link sap.m.Column#getWidth} and {@link sap.m.Table#getAutoPopinMode}. **Note:** A float
     * value is set for the `autoPopinWidth` property which is internally treated as a rem value.
     *
     * @since 1.76
     */
    autoPopinWidth?: float | PropertyBindingInfo | `{${string}}`;

    /**
     * Control to be displayed in the column header.
     */
    header?: Control;

    /**
     * Control to be displayed in the column footer.
     */
    footer?: Control;

    /**
     * Provides a menu that is used by the column. The given menu has to follow the same pattern as the `sap.ui.core.IColumnHeaderMenu`
     * interface.
     *
     * @since 1.98.0
     */
    headerMenu?: IColumnHeaderMenu | string;
  }
}

declare module "sap/m/ColumnListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import { ITableItem } from "sap/m/library";

  import Control from "sap/ui/core/Control";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { VerticalAlign } from "sap/ui/core/library";

  /**
   * `sap.m.ColumnListItem` can be used with the `cells` aggregation to create rows for the `sap.m.Table`
   * control. The `columns` aggregation of the `sap.m.Table` should match with the cells aggregation.
   *
   * **Note:** This control should only be used within the `sap.m.Table` control. The inherited `counter`
   * property of `sap.m.ListItemBase` is not supported.
   *
   * @since 1.12
   */
  export default class ColumnListItem
    extends ListItemBase
    implements ITableItem
  {
    __implements__sap_m_ITableItem: boolean;
    /**
     * Constructor for a new ColumnListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnListItemSettings
    );
    /**
     * Constructor for a new ColumnListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ColumnListItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.ColumnListItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ColumnListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ColumnListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Returns pop-in DOMRef as a jQuery Object
     *
     * @since 1.26
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    $Popin(): void;
    /**
     * Adds some cell to the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCell(
      /**
       * The cell to add; if empty, nothing is inserted
       */
      oCell: Control
    ): this;
    /**
     * Binds aggregation {@link #getCells cells} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindCells(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the cells in the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCells(): this;
    /**
     * Gets content of aggregation {@link #getCells cells}.
     *
     * Every `control` inside the `cells` aggregation defines one cell of the row. **Note:** The order of the
     * `cells` aggregation must match the order of the `columns` aggregation of `sap.m.Table`.
     */
    getCells(): Control[];
    /**
     * Returns the pop-in element.
     *
     * @since 1.30.9
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getPopin(): void;
    /**
     * Returns the tabbable DOM elements as a jQuery collection When popin is available this separated dom should
     * also be included
     *
     * @since 1.26
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns jQuery object
     */
    getTabbables(
      /**
       * Whether only tabbables of data cells
       */
      bContentOnly?: undefined
    ): jQuery;
    /**
     * Gets current value of property {@link #getVAlign vAlign}.
     *
     * Sets the vertical alignment of all the cells within the table row (including selection and navigation).
     * **Note:** `vAlign` property of `sap.m.Column` overrides the property for cell vertical alignment if both
     * are set.
     *
     * Default value is `Inherit`.
     *
     * @since 1.20
     *
     * @returns Value of property `vAlign`
     */
    getVAlign(): VerticalAlign;
    /**
     * Determines whether control has pop-in or not.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    hasPopin(): void;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getCells cells}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCell(
      /**
       * The cell whose index is looked for
       */
      oCell: Control
    ): int;
    /**
     * Inserts a cell into the aggregation {@link #getCells cells}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCell(
      /**
       * The cell to insert; if empty, nothing is inserted
       */
      oCell: Control,
      /**
       * The `0`-based index the cell should be inserted at; for a negative value of `iIndex`, the cell is inserted
       * at position 0; for a value greater than the current size of the aggregation, the cell is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getCells cells}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCells(): Control[];
    /**
     * Removes a cell from the aggregation {@link #getCells cells}.
     *
     *
     * @returns The removed cell or `null`
     */
    removeCell(
      /**
       * The cell to remove or its index or id
       */
      vCell: int | string | Control
    ): Control | null;
    /**
     * Pemove pop-in from DOM
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    removePopin(): void;
    /**
     * Sets a new value for property {@link #getVAlign vAlign}.
     *
     * Sets the vertical alignment of all the cells within the table row (including selection and navigation).
     * **Note:** `vAlign` property of `sap.m.Column` overrides the property for cell vertical alignment if both
     * are set.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     * @since 1.20
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVAlign(
      /**
       * New value for property `vAlign`
       */
      sVAlign?: VerticalAlign | keyof typeof VerticalAlign
    ): this;
    /**
     * Unbinds aggregation {@link #getCells cells} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindCells(): this;
  }
  /**
   * Describes the settings that can be provided to the ColumnListItem constructor.
   */
  export interface $ColumnListItemSettings extends $ListItemBaseSettings {
    /**
     * Sets the vertical alignment of all the cells within the table row (including selection and navigation).
     * **Note:** `vAlign` property of `sap.m.Column` overrides the property for cell vertical alignment if both
     * are set.
     *
     * @since 1.20
     */
    vAlign?:
      | (VerticalAlign | keyof typeof VerticalAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Every `control` inside the `cells` aggregation defines one cell of the row. **Note:** The order of the
     * `cells` aggregation must match the order of the `columns` aggregation of `sap.m.Table`.
     */
    cells?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/ComboBox" {
  import {
    default as ComboBoxBase,
    $ComboBoxBaseSettings,
  } from "sap/m/ComboBoxBase";

  import { IToolbarInteractiveControl } from "sap/m/library";

  import List from "sap/m/List";

  import Popover from "sap/m/Popover";

  import Dialog from "sap/m/Dialog";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Item from "sap/ui/core/Item";

  import { ID } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import { InputBase$ChangeEventParameters } from "sap/m/InputBase";

  import Event from "sap/ui/base/Event";

  /**
   * A drop-down list for selecting and filtering values. Overview: The control represents a drop-down menu
   * with a list of the available options and a text input field to narrow down the options. Structure: The
   * combo-box consists of the following elements:
   * 	 -  Input field - displays the selected option or a custom user entry. Users can type to narrow down
   *     the list or enter their own value.
   * 	 -  Drop-down arrow - expands\collapses the option list.
   * 	 -  Option list - the list of available options. **Note:** Disabled items are not visualized in the
   *     list with the available options, however they can still be accessed through the `items` aggregation.
   *      By setting the `showSecondaryValues` property, the combo box can display an additional value for
   *     each option (if there is one). **Note:** The typeahead feature is not available on Android devices due
   *     to a OS specific issue. Usage: When to use::
   * 	 - You need to select only one item in a long list of options (between 13 and 200) or your custom user
   *     input.  When not to use::
   * 	 - You need to select between only two options. Use a {@link sap.m.Switch switch} control instead.
   * 	 - You need to select between up to 12 options. Use a {@link sap.m.Select select} control instead.
   * 	 - You need to select between more than 200 options. Use a {@link sap.m.Input input} control with value
   *     help instead.
   *
   * Note:: The control has the following behavior regarding the `selectedKey` and `value` properties:
   *
   * 	 -  On initial loading, if the control has a `selectedKey` set which corresponds to a matching item,
   *     and a set `value`, the `value` will be updated to the matching item's text.
   * 	 -  If a `selectedKey` is set and the user types an input which corresponds to an item's text, the `selectedKey`
   *     will be updated with the matching item's key.
   * 	 -  If a `selectedKey` is set and the user types an input which does not correspond to any item's text,
   *     the `selectedKey` will be set to an empty string ("")
   * 	 -  If a `selectedKey` is set and the user selects an item, the `selectedKey` will be updated to match
   *     the selected item's key.
   * 	 -  If a `selectedKey` is bound and the user types before the data is loaded, the user's input will
   *     be overwritten by the binding update.
   *
   * Responsive Behavior:
   * 	 - As the `sap.m.ComboBox` control allows free text, as well as has `selectedKey` / `selectedItem` properties,
   *     here is brief explanation of how they are updated during model change:
   * 	 - If the ComboBox has `selectedKey` and `selectedItem` set, the model changes and the item key is no
   *     longer amongst the newly added items, the value of the ComboBox will remain the same and the `selectedKey`
   *     and `selectedItem` properties **will not** be changed.
   * 	 - If the ComboBox has `selectedKey` and `selectedItem` set, the model changes and the item key corresponds
   *     to newly added item, with different text, the value of the ComboBox **will** be updated with the text
   *     of the newly corresponding item.
   * 	 - If the ComboBox has only value, but no `selectedKey` and `selectedItem` set, the model changes, the
   *     value **will** remain the same and the `selectedKey` and `selectedItem` properties **will not** be changed.
   *
   * 	 - The width of the option list adapts to its content. The minimum width is the input field plus the
   *     drop-down arrow.
   * 	 - There is no horizontal scrolling in the option list. Entries in the list that are too long will be
   *     truncated.
   * 	 - On phone devices the combo box option list opens a dialog.
   *
   * @since 1.22
   */
  export default class ComboBox
    extends ComboBoxBase
    implements IToolbarInteractiveControl
  {
    __implements__sap_m_IToolbarInteractiveControl: boolean;
    /**
     * Constructor for a new ComboBox.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/combo-box/ Combo Box}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );
    /**
     * Constructor for a new ComboBox.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/combo-box/ Combo Box}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ComboBoxSettings
    );

    /**
     * Creates a new subclass of class sap.m.ComboBox with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ComboBoxBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBox>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ComboBox.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Configures the SuggestionsPopover's list.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _configureList(
      /**
       * The list instance to be configured
       */
      oList: List
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBox` itself.
     *
     * This event is fired when the value in the text input field is changed in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the text input field
     * 	 - The Enter key is pressed
     * 	 - An item in the list is selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBox` itself.
     *
     * This event is fired when the value in the text input field is changed in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the text input field
     * 	 - The Enter key is pressed
     * 	 - An item in the list is selected
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.m.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBox` itself.
     *
     * This event is fired when the user types something that matches with an item in the list; it is also fired
     * when the user presses on a list item, or when navigating via keyboard.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:selectionChange selectionChange} event of this
     * `sap.m.ComboBox`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBox` itself.
     *
     * This event is fired when the user types something that matches with an item in the list; it is also fired
     * when the user presses on a list item, or when navigating via keyboard.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSelectionChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBox` itself
       */
      oListener?: object
    ): this;
    /**
     * Clears the selection.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    clearSelection(): void;
    /**
     * Clones the `sap.m.ComboBox` control.
     *
     * @since 1.22.1
     *
     * @returns The cloned `sap.m.ComboBox` control.
     */
    clone(
      /**
       * Suffix to be added to the IDs of the new control and its internal objects.
       */
      sIdSuffix?: string
    ): this;
    /**
     * `ComboBox` picker configuration
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    configPicker(
      /**
       * Picker instance
       */
      oPicker: Popover | Dialog
    ): void;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.m.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ComboBox$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:selectionChange selectionChange} event of
     * this `sap.m.ComboBox`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSelectionChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: ComboBox$SelectionChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * This method will be called when the ComboBox is being destroyed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    exit(): void;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ComboBox$ChangeEventParameters
    ): this;
    /**
     * Fires event {@link #event:selectionChange selectionChange} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireSelectionChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: ComboBox$SelectionChangeEventParameters
    ): this;
    /**
     * Gets the default selected item from the aggregation named `items`.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Null, as there is no default selected item
     */
    getDefaultSelectedItem(): null;
    /**
     * Gets current value of property {@link #getFilterSecondaryValues filterSecondaryValues}.
     *
     * Indicates whether the filter should check in both the `text` and the `additionalText` property of the
     * {@link sap.ui.core.ListItem} for the suggestion.
     *
     * Default value is `false`.
     *
     * @since 1.46
     *
     * @returns Value of property `filterSecondaryValues`
     */
    getFilterSecondaryValues(): boolean;
    /**
     * Gets the selected item object from the aggregation named `items`.
     *
     *
     * @returns The current target of the `selectedItem` association, or `null`.
     */
    getSelectedItem(): Item | null;
    /**
     * Gets current value of property {@link #getSelectedItemId selectedItemId}.
     *
     * ID of the selected item.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `selectedItemId`
     */
    getSelectedItemId(): string;
    /**
     * Gets current value of property {@link #getSelectedKey selectedKey}.
     *
     * Key of the selected item.
     *
     * **Note:** If duplicate keys exist, the first item matching the key is used.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `selectedKey`
     */
    getSelectedKey(): string;
    /**
     * This method will be called when the ComboBox is initially created.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    init(): void;
    /**
     * This event handler will be called after the ComboBox Picker's List is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onAfterRenderingList(): void;
    /**
     * This event handler will be called after the ComboBox's Picker is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onAfterRenderingPicker(): void;
    /**
     * This event handler is called before the picker popup is opened.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeOpen(): void;
    /**
     * This event handler will be called before the ComboBox is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRendering(): void;
    /**
     * This event handler will be called before the ComboBox' Picker of type `sap.m.Popover` is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRenderingDropdown(): void;
    /**
     * This event handler will be called before the ComboBox Picker's List is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRenderingList(): void;
    /**
     * This event handler will be called before the ComboBox's Picker is rendered.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onBeforeRenderingPicker(): void;
    /**
     * Called when the `ComboBox` is clicked or tapped.
     */
    ontap(
      /**
       * The event object.
       */
      oEvent: jQuery.Event
    ): void;
    /**
     * Opens the control's picker popup.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining.
     */
    open(): this;
    /**
     * Sets the start and end positions of the current text selection.
     *
     * @since 1.22.1
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining
     */
    selectText(
      /**
       * The index of the first selected character.
       */
      iSelectionStart: int,
      /**
       * The index of the character after the last selected character.
       */
      iSelectionEnd: int
    ): this;
    /**
     * Sets a new value for property {@link #getFilterSecondaryValues filterSecondaryValues}.
     *
     * Indicates whether the filter should check in both the `text` and the `additionalText` property of the
     * {@link sap.ui.core.ListItem} for the suggestion.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.46
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFilterSecondaryValues(
      /**
       * New value for property `filterSecondaryValues`
       */
      bFilterSecondaryValues?: boolean
    ): this;
    /**
     * Sets the `selectedItem` association.
     *
     * Default value is `null`.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectedItem(
      /**
       * New value for the `selectedItem` association. If an ID of a `sap.ui.core.Item` is given, the item with
       * this ID becomes the `selectedItem` association. Alternatively, a `sap.ui.core.Item` instance may be given
       * or `null` to clear the selection.
       */
      vItem: ID | Item | null
    ): this;
    /**
     * Sets the `selectedItemId` property.
     *
     * Default value is an empty string `""` or `undefined`.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectedItemId(
      /**
       * New value for property `selectedItemId`. If the provided `vItem` is an empty string `""` or `undefined`,
       * the selection is cleared. If the ID has no corresponding aggregated item, the selected item is not changed.
       */
      vItem: string | undefined
    ): this;
    /**
     * Sets the `selectedKey` property.
     *
     * Default value is an empty string `""` or `undefined`.
     *
     *
     * @returns `this` to allow method chaining.
     */
    setSelectedKey(
      /**
       * New value for property `selectedKey`. If the provided `sKey` is an empty string `""` or `undefined`,
       * the selection is cleared. If duplicate keys exist, the first item matching the key is selected. If a
       * key is set and no item exists with that key, the visual selection remains the same.
       */
      sKey: string
    ): this;
    /**
     * Synchronizes the `selectedItem` association and the `selectedItemId` property.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    synchronizeSelection(): void;
    /**
     * Creates picker if doesn't exist yet and sync with Control items
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    syncPickerContent(): Dialog | Popover;
  }
  /**
   * Describes the settings that can be provided to the ComboBox constructor.
   */
  export interface $ComboBoxSettings extends $ComboBoxBaseSettings {
    /**
     * Key of the selected item.
     *
     * **Note:** If duplicate keys exist, the first item matching the key is used.
     */
    selectedKey?: string | PropertyBindingInfo;

    /**
     * ID of the selected item.
     */
    selectedItemId?: string | PropertyBindingInfo;

    /**
     * Indicates whether the filter should check in both the `text` and the `additionalText` property of the
     * {@link sap.ui.core.ListItem} for the suggestion.
     *
     * @since 1.46
     */
    filterSecondaryValues?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets or retrieves the selected item from the aggregation named items.
     */
    selectedItem?: Item | string;

    /**
     * This event is fired when the value in the text input field is changed in combination with one of the
     * following actions:
     *
     *
     * 	 - The focus leaves the text input field
     * 	 - The Enter key is pressed
     * 	 - An item in the list is selected
     */
    change?: (oEvent: ComboBox$ChangeEvent) => void;

    /**
     * This event is fired when the user types something that matches with an item in the list; it is also fired
     * when the user presses on a list item, or when navigating via keyboard.
     */
    selectionChange?: (oEvent: ComboBox$SelectionChangeEvent) => void;
  }

  /**
   * Parameters of the ComboBox#change event.
   */
  export interface ComboBox$ChangeEventParameters
    extends InputBase$ChangeEventParameters {
    /**
     * Indicates whether the change event was caused by selecting an item in the list
     */
    itemPressed?: boolean;
  }

  /**
   * Event object of the ComboBox#change event.
   */
  export type ComboBox$ChangeEvent = Event<
    ComboBox$ChangeEventParameters,
    ComboBox
  >;

  /**
   * Parameters of the ComboBox#selectionChange event.
   */
  export interface ComboBox$SelectionChangeEventParameters {
    /**
     * The selected item.
     */
    selectedItem?: Item;
  }

  /**
   * Event object of the ComboBox#selectionChange event.
   */
  export type ComboBox$SelectionChangeEvent = Event<
    ComboBox$SelectionChangeEventParameters,
    ComboBox
  >;
}

declare module "sap/m/ComboBoxBase" {
  import {
    default as ComboBoxTextField,
    $ComboBoxTextFieldSettings,
  } from "sap/m/ComboBoxTextField";

  import Item from "sap/ui/core/Item";

  import Event from "sap/ui/base/Event";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Popover from "sap/m/Popover";

  import Dialog from "sap/m/Dialog";

  import List from "sap/m/List";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Input from "sap/m/Input";

  import Control from "sap/ui/core/Control";

  /**
   * An abstract class for combo boxes.
   *
   * @since 1.22.0
   */
  export default abstract class ComboBoxBase extends ComboBoxTextField {
    /**
     * Constructor for a new `sap.m.ComboBoxBase`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ComboBoxBaseSettings
    );
    /**
     * Constructor for a new `sap.m.ComboBoxBase`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ComboBoxBaseSettings
    );

    /**
     * Creates a new subclass of class sap.m.ComboBoxBase with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ComboBoxTextField.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBoxBase>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ComboBoxBase.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets the ID of the hidden label for the group header items
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Id of hidden text
     */
    _getGroupHeaderInvisibleText(): string;
    /**
     * Adds some item to the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addItem(
      /**
       * The item to add; if empty, nothing is inserted
       */
      oItem: Item
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadItems loadItems} event of this `sap.m.ComboBoxBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBoxBase` itself.
     *
     * This event is fired when the end user clicks the combo box button to open the dropdown list and the data
     * used to display items is not already loaded. Alternatively, it is fired after the user moves the cursor
     * to the combo box text field and perform an action that requires data to be loaded. For example, pressing
     * F4 to open the dropdown list or typing something in the text field fires the event.
     *
     * **Note:** Use this feature in performance critical scenarios only. Loading the data lazily (on demand)
     * to defer initialization has several implications for the end user experience. For example, the busy indicator
     * has to be shown while the items are being loaded and assistive technology software also has to announce
     * the state changes (which may be confusing for some screen reader users).
     *
     * **Note**: Currently the `sap.m.MultiComboBox` does not support this event.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadItems(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBoxBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:loadItems loadItems} event of this `sap.m.ComboBoxBase`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.ComboBoxBase` itself.
     *
     * This event is fired when the end user clicks the combo box button to open the dropdown list and the data
     * used to display items is not already loaded. Alternatively, it is fired after the user moves the cursor
     * to the combo box text field and perform an action that requires data to be loaded. For example, pressing
     * F4 to open the dropdown list or typing something in the text field fires the event.
     *
     * **Note:** Use this feature in performance critical scenarios only. Loading the data lazily (on demand)
     * to defer initialization has several implications for the end user experience. For example, the busy indicator
     * has to be shown while the items are being loaded and assistive technology software also has to announce
     * the state changes (which may be confusing for some screen reader users).
     *
     * **Note**: Currently the `sap.m.MultiComboBox` does not support this event.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLoadItems(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.ComboBoxBase` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds aggregation {@link #getItems items} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindItems(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Clears the selection. To be overwritten by subclasses.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    clearSelection(): void;
    /**
     * Closes the control's picker popup.
     *
     *
     * @returns `this` to allow method chaining.
     */
    close(): this;
    /**
     * Base method for picker configuration
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    configPicker(
      /**
       * Picker instance
       */
      oPicker: Popover | Dialog
    ): void;
    /**
     * Creates a picker popup container where the selection should take place. To be overwritten by subclasses.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The picker popup to be used.
     */
    createPicker(
      /**
       * The picker type
       */
      sPickerType: string
    ): Popover | Dialog;
    /**
     * Destroys all the items in the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyItems(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:loadItems loadItems} event of this `sap.m.ComboBoxBase`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLoadItems(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:loadItems loadItems} to attached listeners.
     *
     * @since 1.38
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLoadItems(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets the enabled items from the aggregation named `items`.
     *
     * @deprecated As of version 1.86. The enabled items should be managed by the application.
     *
     * @returns An array containing the enabled items.
     */
    getEnabledItems(
      /**
       * Items to filter.
       */
      aItems?: Item[]
    ): Item[];
    /**
     * Gets the first item from the aggregation named `items`.
     *
     *
     * @returns The first item, or `null` if there are no items.
     */
    getFirstItem(): Item | null;
    /**
     * Gets the input properties, which should be forwarded from the combobox text field to the picker text
     * field
     *
     * @since 1.66
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Array of the forwardable properties
     */
    getInputForwardableProperties(): any[];
    /**
     * Gets the item from the aggregation named `items` at the given 0-based index.
     *
     *
     * @returns Item at the given index, or `null` if none.
     */
    getItemAt(
      /**
       * Index of the item to return.
       */
      iIndex: int
    ): Item | null;
    /**
     * Gets the item with the given key from the aggregation named `items`.
     *  **Note:** If duplicate keys exist, the first item matching the key is returned.
     *
     *
     * @returns The matching item
     */
    getItemByKey(
      /**
       * An item key that specifies the item to retrieve.
       */
      sKey: string
    ): Item;
    /**
     * Gets content of aggregation {@link #getItems items}.
     *
     * Defines the items contained within this control. **Note:** Disabled items are not visualized in the list
     * with the available options, however they can still be accessed through the aggregation.
     */
    getItems(): Item[];
    /**
     * Gets the last item from the aggregation named `items`.
     *
     *
     * @returns The last item, or `null` if there are no items.
     */
    getLastItem(): Item | null;
    /**
     * Gets the `list`.
     *
     * @deprecated As of version 1.62. The list structure should not be used as per SAP note: 2746748.
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The list instance object or `null`.
     */
    getList(): List | null;
    /**
     * Gets the control's picker popup.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The picker instance the `createPicker()` method.
     */
    getPicker(): Dialog | Popover | null;
    /**
     * Gets the ID of the hidden label
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Id of hidden text
     */
    getPickerInvisibleTextId(): string;
    /**
     * Gets the control's input from the picker.
     *
     * @since 1.42
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Picker's input for filtering the list
     */
    getPickerTextField(): ComboBoxTextField | Input | null;
    /**
     * Gets the property `_sPickerType`
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The picker type
     */
    getPickerType(): string;
    /**
     * Gets the flag indicating whether the list items should be recreated
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns True if the list items should be recreated
     */
    getRecreateItems(): boolean;
    /**
     * Gets current value of property {@link #getShowClearIcon showClearIcon}.
     *
     * Specifies whether clear icon is shown. Pressing the icon will clear input's value.
     *
     * Default value is `false`.
     *
     * @since 1.96
     *
     * @returns Value of property `showClearIcon`
     */
    getShowClearIcon(): boolean;
    /**
     * Gets current value of property {@link #getShowSecondaryValues showSecondaryValues}.
     *
     * Indicates whether the text values of the `additionalText` property of a {@link sap.ui.core.ListItem }
     * are shown.
     *
     * Default value is `false`.
     *
     * @since 1.60
     *
     * @returns Value of property `showSecondaryValues`
     */
    getShowSecondaryValues(): boolean;
    /**
     * Fires when an object gets inserted in the items aggregation.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    handleItemInsertion(
      /**
       * The item that should be inserted
       */
      oItem: Item
    ): void;
    /**
     * Fires when an object gets removed from the items aggregation.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    handleItemRemoval(
      /**
       * The item that should be removed
       */
      oItem: Item
    ): void;
    /**
     * Determines whether the control has content or not.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns True if the control has content
     */
    hasContent(): boolean;
    /**
     * Handles highlighting of items after filtering.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    highlightList(
      /**
       * The value of the item
       */
      sValue: string
    ): void;
    /**
     * Checks for the provided `sap.ui.core.Item` in the aggregation {@link #getItems items}. and returns its
     * index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfItem(
      /**
       * The item whose index is looked for
       */
      oItem: Item
    ): int;
    /**
     * Inserts a item into the aggregation {@link #getItems items}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertItem(
      /**
       * The item to insert; if empty, nothing is inserted
       */
      oItem: Item,
      /**
       * The `0`-based index the item should be inserted at; for a negative value of `iIndex`, the item is inserted
       * at position 0; for a value greater than the current size of the aggregation, the item is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Finds the common items of two arrays
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Array of unique items from both arrays
     */
    intersectItems(
      /**
       * Array of Items
       */
      aItems: Item[],
      /**
       * Second array of items
       */
      aOtherItems: Item[]
    ): Item[];
    /**
     * Indicates whether the control's picker popup is open.
     *
     *
     * @returns Determines whether the control's picker popup is currently open (this includes opening and closing
     * animations).
     */
    isOpen(): boolean;
    /**
     * Called when the composition of a passage of text has been completed or cancelled.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    oncompositionend(
      /**
       * The event object.
       */
      oEvent: jQuery.Event
    ): void;
    /**
     * Handles properties' changes of items in the aggregation named `items`.
     *
     * @since 1.90
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    onItemChange(
      /**
       * The change event
       */
      oControlEvent: Event,
      /**
       * Indicates whether second values should be shown
       */
      bShowSecondaryValues: boolean
    ): void;
    /**
     * Opens the control's picker popup.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns `this` to allow method chaining.
     */
    open(): this;
    /**
     * Removes all the controls from the aggregation {@link #getItems items}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllItems(): Item[];
    /**
     * Removes a item from the aggregation {@link #getItems items}.
     *
     *
     * @returns The removed item or `null`
     */
    removeItem(
      /**
       * The item to remove or its index or id
       */
      vItem: int | string | Item
    ): Item | null;
    /**
     * Sets a custom filter function for items. The function accepts two parameters: - currenly typed value
     * in the input field - item to be matched The function should return a Boolean value (true or false) which
     * represents whether an item will be shown in the dropdown or not. If no callback is provided, the control
     * fallbacks to default filtering.
     *
     * @since 1.58
     *
     * @returns `this` to allow method chaining.
     */
    setFilterFunction(
      /**
       * A callback function called when typing in a ComboBoxBase control or ancestor.
       */
      fnFilter?: (p1?: string, p2?: Item) => boolean
    ): this;
    /**
     * Sets the property `_sPickerType`.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setPickerType(
      /**
       * The picker type
       */
      sPickerType: string
    ): void;
    /**
     * Sets whether the list items should be recreated.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setRecreateItems(
      /**
       * True if the list items should be recreated
       */
      bRecreate: boolean
    ): void;
    /**
     * Sets the selectable property of `sap.ui.core.Item`
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setSelectable(
      /**
       * The item to set the property
       */
      oItem: Item,
      /**
       * The selectable value
       */
      bSelectable: boolean
    ): void;
    /**
     * Sets a new value for property {@link #getShowClearIcon showClearIcon}.
     *
     * Specifies whether clear icon is shown. Pressing the icon will clear input's value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.96
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowClearIcon(
      /**
       * New value for property `showClearIcon`
       */
      bShowClearIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSecondaryValues showSecondaryValues}.
     *
     * Indicates whether the text values of the `additionalText` property of a {@link sap.ui.core.ListItem }
     * are shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.60
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSecondaryValues(
      /**
       * New value for property `showSecondaryValues`
       */
      bShowSecondaryValues?: boolean
    ): this;
    /**
     * Sets the TextField handler
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    setTextFieldHandler(
      /**
       * Text field instance
       */
      oTextField: ComboBoxTextField | Input
    ): void;
    /**
     * Sets the value property of the control.
     *
     *
     * @returns this instance for method chaining
     */
    setValue(
      /**
       * The new value
       */
      sValue: string
    ): this;
    /**
     * Opens the `SuggestionsPopover` with the available items.
     *
     * @since 1.64
     */
    showItems(
      /**
       * Function to filter the items shown in the SuggestionsPopover
       */
      fnFilter: Function | undefined
    ): void;
    /**
     * Creates picker if doesn't exist yet and sync with Control items To be overwritten by subclasses.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    syncPickerContent(): Control;
    /**
     * Unbinds aggregation {@link #getItems items} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindItems(): this;
  }
  /**
   * Describes the settings that can be provided to the ComboBoxBase constructor.
   */
  export interface $ComboBoxBaseSettings extends $ComboBoxTextFieldSettings {
    /**
     * Indicates whether the text values of the `additionalText` property of a {@link sap.ui.core.ListItem }
     * are shown.
     *
     * @since 1.60
     */
    showSecondaryValues?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether clear icon is shown. Pressing the icon will clear input's value.
     *
     * @since 1.96
     */
    showClearIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the items contained within this control. **Note:** Disabled items are not visualized in the list
     * with the available options, however they can still be accessed through the aggregation.
     */
    items?: Item[] | Item | AggregationBindingInfo | `{${string}}`;

    /**
     * This event is fired when the end user clicks the combo box button to open the dropdown list and the data
     * used to display items is not already loaded. Alternatively, it is fired after the user moves the cursor
     * to the combo box text field and perform an action that requires data to be loaded. For example, pressing
     * F4 to open the dropdown list or typing something in the text field fires the event.
     *
     * **Note:** Use this feature in performance critical scenarios only. Loading the data lazily (on demand)
     * to defer initialization has several implications for the end user experience. For example, the busy indicator
     * has to be shown while the items are being loaded and assistive technology software also has to announce
     * the state changes (which may be confusing for some screen reader users).
     *
     * **Note**: Currently the `sap.m.MultiComboBox` does not support this event.
     *
     * @since 1.38
     */
    loadItems?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the ComboBoxBase#loadItems event.
   */
  export interface ComboBoxBase$LoadItemsEventParameters {}

  /**
   * Event object of the ComboBoxBase#loadItems event.
   */
  export type ComboBoxBase$LoadItemsEvent = Event<
    ComboBoxBase$LoadItemsEventParameters,
    ComboBoxBase
  >;
}

declare module "sap/m/ComboBoxTextField" {
  import { default as InputBase, $InputBaseSettings } from "sap/m/InputBase";

  import { CSSSize } from "sap/ui/core/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * The `sap.m.ComboBoxTextField`.
   *
   * @since 1.34
   */
  export default class ComboBoxTextField extends InputBase {
    /**
     * Constructor for a new `sap.m.ComboBoxTextField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ComboBoxTextFieldSettings
    );
    /**
     * Constructor for a new `sap.m.ComboBoxTextField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ComboBoxTextFieldSettings
    );
    /**
     * Returns the arrow icon
     *
     * Left for backward compatibility.
     *
     * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
     */
    getIcon: undefined;

    /**
     * Creates a new subclass of class sap.m.ComboBoxTextField with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.InputBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ComboBoxTextField>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ComboBoxTextField.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getMaxWidth maxWidth}.
     *
     * Sets the maximum width of the text field.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `maxWidth`
     */
    getMaxWidth(): CSSSize;
    /**
     * Gets current value of property {@link #getShowButton showButton}.
     *
     * Indicates whether the dropdown downward-facing arrow button is shown.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Value of property `showButton`
     */
    getShowButton(): boolean;
    /**
     * Gets the `value`.
     *
     * Default value is an empty string.
     *
     *
     * @returns The value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getMaxWidth maxWidth}.
     *
     * Sets the maximum width of the text field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxWidth(
      /**
       * New value for property `maxWidth`
       */
      sMaxWidth?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getShowButton showButton}.
     *
     * Indicates whether the dropdown downward-facing arrow button is shown.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.38
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowButton(
      /**
       * New value for property `showButton`
       */
      bShowButton?: boolean
    ): this;
    /**
     * Toggles the icon pressed style on or off.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    toggleIconPressedStyle(
      /**
       * True if the icon pressed class should be applied.
       */
      bState?: boolean
    ): void;
  }
  /**
   * Describes the settings that can be provided to the ComboBoxTextField constructor.
   */
  export interface $ComboBoxTextFieldSettings extends $InputBaseSettings {
    /**
     * Sets the maximum width of the text field.
     */
    maxWidth?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the dropdown downward-facing arrow button is shown.
     *
     * @since 1.38
     */
    showButton?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/ContentConfig" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import { LinkAccessibleRole, ContentConfigType } from "sap/m/library";

  import { URI } from "sap/ui/core/library";

  import Link from "sap/m/Link";

  import Text from "sap/m/Text";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * This element is used within the TileAttribute control that generates either a link or text
   *
   * @since 1.122
   * @experimental As of version 1.122.
   */
  export default class ContentConfig extends UI5Element {
    /**
     * Constructor for a new ContentConfig.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ContentConfigSettings
    );
    /**
     * Constructor for a new ContentConfig.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, it is generated automatically if an ID is not provided.
       */
      sId?: string,
      /**
       * Initial settings for the new control.
       */
      mSettings?: $ContentConfigSettings
    );

    /**
     * Creates a new subclass of class sap.m.ContentConfig with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ContentConfig>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ContentConfig.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAccessibleRole accessibleRole}.
     *
     * Describes the accessibility role of the link:
     * 	 - `LinkAccessibleRole.Default` - a navigation is expected to the location given in `href` property
     *
     * 	 - `LinkAccessibleRole.Button` - there will be `role` attribute with value "Button" rendered. In this
     *     scenario the `href` property value shouldn't be set as navigation isn't expected to occur.
     *
     * Default value is `Default`.
     *
     *
     * @returns Value of property `accessibleRole`
     */
    getAccessibleRole(): LinkAccessibleRole;
    /**
     * Gets current value of property {@link #getHref href}.
     *
     * Defines the link target URI. Supports standard hyperlink behavior. **Note:** Don't set `href` property
     * if an action should be triggered by the link. Instead set `accessibleRole` property to `LinkAccessibleRole.Button`
     * and register a `press` event handler.
     *
     *
     * @returns Value of property `href`
     */
    getHref(): URI;
    /**
     * Returns the current element instance
     */
    getInnerControl(): Record<string, Link> | Record<string, Text>;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Defines the displayed text.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * The type of the ContentConfig.
     *
     * Default value is `Text`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): ContentConfigType;
    /**
     * Sets a new value for property {@link #getAccessibleRole accessibleRole}.
     *
     * Describes the accessibility role of the link:
     * 	 - `LinkAccessibleRole.Default` - a navigation is expected to the location given in `href` property
     *
     * 	 - `LinkAccessibleRole.Button` - there will be `role` attribute with value "Button" rendered. In this
     *     scenario the `href` property value shouldn't be set as navigation isn't expected to occur.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Default`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccessibleRole(
      /**
       * New value for property `accessibleRole`
       */
      sAccessibleRole?: LinkAccessibleRole | keyof typeof LinkAccessibleRole
    ): this;
    /**
     * Sets a new value for property {@link #getHref href}.
     *
     * Defines the link target URI. Supports standard hyperlink behavior. **Note:** Don't set `href` property
     * if an action should be triggered by the link. Instead set `accessibleRole` property to `LinkAccessibleRole.Button`
     * and register a `press` event handler.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHref(
      /**
       * New value for property `href`
       */
      sHref?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Defines the displayed text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * The type of the ContentConfig.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Text`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: ContentConfigType | keyof typeof ContentConfigType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the ContentConfig constructor.
   *
   * @experimental As of version 1.122.
   */
  export interface $ContentConfigSettings extends $ElementSettings {
    /**
     * The type of the ContentConfig.
     */
    type?:
      | (ContentConfigType | keyof typeof ContentConfigType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the displayed text.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the link target URI. Supports standard hyperlink behavior. **Note:** Don't set `href` property
     * if an action should be triggered by the link. Instead set `accessibleRole` property to `LinkAccessibleRole.Button`
     * and register a `press` event handler.
     */
    href?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Describes the accessibility role of the link:
     * 	 - `LinkAccessibleRole.Default` - a navigation is expected to the location given in `href` property
     *
     * 	 - `LinkAccessibleRole.Button` - there will be `role` attribute with value "Button" rendered. In this
     *     scenario the `href` property value shouldn't be set as navigation isn't expected to occur.
     */
    accessibleRole?:
      | (LinkAccessibleRole | keyof typeof LinkAccessibleRole)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/CustomListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import Control from "sap/ui/core/Control";

  import {
    AggregationBindingInfo,
    PropertyBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * This control with a content aggregation can be used to customize standard list items that we don't provide.
   * List mode and ListItem type are applied to CustomListItems as well. **Note:** Even though the content
   * aggregation allows any control, complex responsive layout controls (e.g. `Table, Form`) should not be
   * aggregated as content.
   */
  export default class CustomListItem extends ListItemBase {
    /**
     * Constructor for a new CustomListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomListItemSettings
    );
    /**
     * Constructor for a new CustomListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomListItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.CustomListItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.CustomListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Binds aggregation {@link #getContent content} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindContent(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets current value of property {@link #getAccDescription accDescription}.
     *
     * Defines the custom accessibility announcement.
     *
     * **Note:** If defined, then only the provided custom accessibility description is announced when there
     * is a focus on the list item.
     *
     * @since 1.84
     *
     * @returns Value of property `accDescription`
     */
    getAccDescription(): string;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * The content of this list item
     */
    getContent(): Control[];
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets a new value for property {@link #getAccDescription accDescription}.
     *
     * Defines the custom accessibility announcement.
     *
     * **Note:** If defined, then only the provided custom accessibility description is announced when there
     * is a focus on the list item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.84
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAccDescription(
      /**
       * New value for property `accDescription`
       */
      sAccDescription: string
    ): this;
    /**
     * Unbinds aggregation {@link #getContent content} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindContent(): this;
  }
  /**
   * Describes the settings that can be provided to the CustomListItem constructor.
   */
  export interface $CustomListItemSettings extends $ListItemBaseSettings {
    /**
     * Defines the custom accessibility announcement.
     *
     * **Note:** If defined, then only the provided custom accessibility description is announced when there
     * is a focus on the list item.
     *
     * @since 1.84
     */
    accDescription?: string | PropertyBindingInfo;

    /**
     * The content of this list item
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/CustomTile" {
  import { default as Tile, $TileSettings } from "sap/m/Tile";

  import Control from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * Use the CustomTile control to display application specific content in the Tile control. The tile width
   * is 8.5em and height is 10em.
   *
   * @since 1.12
   * @deprecated As of version 1.50. use {@link sap.m.GenericTile} instead
   */
  export default class CustomTile extends Tile {
    /**
     * Constructor for a new CustomTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomTileSettings
    );
    /**
     * Constructor for a new CustomTile.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomTileSettings
    );

    /**
     * Creates a new subclass of class sap.m.CustomTile with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.Tile.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomTile>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.CustomTile.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Destroys the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * Defines the content of the CustomTile.
     */
    getContent(): Control;
    /**
     * Sets the aggregated {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContent(
      /**
       * The content to set
       */
      oContent: Control
    ): this;
  }
  /**
   * Describes the settings that can be provided to the CustomTile constructor.
   *
   * @deprecated As of version 1.50. use {@link sap.m.GenericTile} instead
   */
  export interface $CustomTileSettings extends $TileSettings {
    /**
     * Defines the content of the CustomTile.
     */
    content?: Control;
  }
}

declare module "sap/m/CustomTreeItem" {
  import {
    default as TreeItemBase,
    $TreeItemBaseSettings,
  } from "sap/m/TreeItemBase";

  import Control from "sap/ui/core/Control";

  import { AggregationBindingInfo } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The `CustomTreeItem` control with a content aggregation is used to customize the tree items within the
   * `Tree` control.
   * **Note:** Even though the content aggregation can be used for any control, complex responsive layout
   * controls, such as `Table, Form` etc, should not be aggregated as content.
   *
   * @since 1.48.0
   */
  export default class CustomTreeItem extends TreeItemBase {
    /**
     * Constructor for a new CustomTreeItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomTreeItemSettings
    );
    /**
     * Constructor for a new CustomTreeItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $CustomTreeItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.CustomTreeItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.TreeItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, CustomTreeItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.CustomTreeItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Binds aggregation {@link #getContent content} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindAggregation ManagedObject.bindAggregation} for a detailed description
     * of the possible properties of `oBindingInfo`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindContent(
      /**
       * The binding information
       */
      oBindingInfo: AggregationBindingInfo
    ): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * The content of this tree item.
     */
    getContent(): Control[];
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Unbinds aggregation {@link #getContent content} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindContent(): this;
  }
  /**
   * Describes the settings that can be provided to the CustomTreeItem constructor.
   */
  export interface $CustomTreeItemSettings extends $TreeItemBaseSettings {
    /**
     * The content of this tree item.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/DatePicker" {
  import {
    default as DateTimeField,
    $DateTimeFieldSettings,
  } from "sap/m/DateTimeField";

  import DateTypeRange from "sap/ui/unified/DateTypeRange";

  import Event from "sap/ui/base/Event";

  import { AccessibilityInfo, ID } from "sap/ui/core/library";

  import CalendarWeekNumbering from "sap/base/i18n/date/CalendarWeekNumbering";

  import UI5Date from "sap/ui/core/date/UI5Date";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import CalendarType from "sap/base/i18n/date/CalendarType";

  import UI5Element from "sap/ui/core/Element";

  import CalendarLegend from "sap/ui/unified/CalendarLegend";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Control from "sap/ui/core/Control";

  import { InputBase$ChangeEventParameters } from "sap/m/InputBase";

  import DateRange from "sap/ui/unified/DateRange";

  /**
   * Enables the users to select a localized date between 0001-01-01 and 9999-12-31.
   *
   * Overview:
   *
   * The `DatePicker` lets the users select a localized date using touch, mouse, or keyboard input. It consists
   * of two parts: the date input field and the date picker.
   *
   * **Note:** The application developer should add dependency to `sap.ui.unified` library on application
   * level to ensure that the library is loaded before the module dependencies will be required. The {@link sap.ui.unified.Calendar }
   * is used internally only if the `DatePicker` is opened (not used for the initial rendering). If the `sap.ui.unified`
   * library is not loaded before the `DatePicker` is opened, it will be loaded upon opening. This could lead
   * to CSP compliance issues and adds an additional waiting time when the `DatePicker` is opened for the
   * first time. To prevent this, apps using the `DatePicker` should also load the `sap.ui.unified` library
   * in advance.
   *
   * Usage:
   *
   * The user can enter a date by:
   * 	 - Using the calendar that opens in a popup
   * 	 - Typing it directly in the input field
   *
   * On app level, there are two options to provide a date for the `DatePicker` - as a string to the `value`
   * property or as a UI5Date or JavaScript Date object to the `dateValue` property (only one of these properties
   * should be used at a time):
   *
   *
   * 	 - Use the `value` property if you want to bind the `DatePicker` to a model using the `sap.ui.model.type.Date`
   *      binding the `value` property by using types
   * ```javascript
   *
   * new sap.ui.model.json.JSONModel({
   *     date: sap.ui.core.date.UI5Date.getInstance(2022,10,10,10,10,10)
   * });
   *
   * new sap.m.DatePicker({
   *     value:{path:"/date",type:"sap.ui.model.type.Date"}
   * });
   * ```
   *
   * 	 - Use the `value` property if the date is provided as a string from the backend or inside the app (for
   *     example, as ABAP type DATS field)  binding the `value` property by using types
   * ```javascript
   *
   * new sap.ui.model.json.JSONModel({date:'2022-11-10');
   *
   * new sap.m.DatePicker({
   *     value:{
   *         path:"/date",
   *         type:"sap.ui.model.type.Date",
   *         formatOptions:{
   *             source:{
   *                 pattern:"yyyy-MM-dd"
   *             }
   *         }
   *     }
   * });
   * ```
   *  **Note:** There are multiple binding type choices, such as: sap.ui.model.type.Date sap.ui.model.odata.type.DateTime
   * sap.ui.model.odata.type.DateTimeOffset See {@link sap.ui.model.type.Date}, {@link sap.ui.model.odata.type.DateTime }
   * or {@link sap.ui.model.odata.type.DateTimeOffset}
   *
   *
   * 	 - Use the `dateValue` property if the date is already provided as a UI5Date or JavaScript Date object
   *     or you want to work with a UI5Date or JavaScript Date object. Use `dateValue` as a helper property to
   *     easily obtain the day, month and year of the chosen date. Although it's possible to bind it, it's not
   *     recommended to do so. When binding is needed, use `value` property instead
   *
   * Formatting:
   *
   * All formatting and parsing of dates from and to strings is done using the {@link sap.ui.core.format.DateFormat}.
   * If a date is entered by typing it into the input field, it must fit to the used date format and locale.
   *
   * Supported format options are pattern-based on Unicode LDML Date Format notation. See {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table}
   *
   * For example, if the `valueFormat` is "yyyy-MM-dd", the `displayFormat` is "MMM d, y", and the used locale
   * is English, a valid value string is "2015-07-30", which leads to an output of "Jul 30, 2015".
   *
   * If no placeholder is set to the `DatePicker`, the used `displayFormat` is displayed as a placeholder.
   * If another placeholder is needed, it must be set.
   *
   * **Note:** If the string does NOT match the `displayFormat` (from user input) or the `valueFormat` (on
   * app level), the {@link sap.ui.core.format.DateFormat} makes an attempt to parse it based on the locale
   * settings. For more information, see the respective documentation in the API Reference.
   *
   * Responsive behavior:
   *
   * The `DatePicker` is smaller in compact mode and provides a touch-friendly size in cozy mode.
   *
   * On mobile devices, one tap on the input field opens the `DatePicker` in full screen. To close the window,
   * the user can select a date (which triggers the close event), or select Cancel.
   *
   * @since 1.22.0
   */
  export default class DatePicker extends DateTimeField {
    /**
     * Constructor for a new `DatePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/date-picker/ Date Picker}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );
    /**
     * Constructor for a new `DatePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/date-picker/ Date Picker}
     */
    constructor(
      /**
       * Id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DatePickerSettings
    );

    /**
     * Creates a new subclass of class sap.m.DatePicker with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.DateTimeField.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DatePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DatePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some `specialDate` to the aggregation `specialDates`.
     *
     * @since 1.38.5
     *
     * @returns Reference to `this` for method chaining
     */
    addSpecialDate(
      /**
       * the specialDate to add; if empty, nothing is added
       */
      oSpecialDate: DateTypeRange
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterValueHelpClose afterValueHelpClose} event
     * of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when `value help` dialog closes.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterValueHelpClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterValueHelpClose afterValueHelpClose} event
     * of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when `value help` dialog closes.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterValueHelpClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterValueHelpOpen afterValueHelpOpen} event
     * of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when `value help` dialog opens.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterValueHelpOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterValueHelpOpen afterValueHelpOpen} event
     * of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when `value help` dialog opens.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterValueHelpOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when navigating in `Calendar` popup.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:navigate navigate} event of this `sap.m.DatePicker`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DatePicker` itself.
     *
     * Fired when navigating in `Calendar` popup.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachNavigate(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DatePicker$NavigateEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DatePicker` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the specialDates in the aggregation {@link #getSpecialDates specialDates}.
     *
     * @since 1.38.5
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySpecialDates(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterValueHelpClose afterValueHelpClose} event
     * of this `sap.m.DatePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterValueHelpClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterValueHelpOpen afterValueHelpOpen} event
     * of this `sap.m.DatePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.102.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterValueHelpOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:navigate navigate} event of this `sap.m.DatePicker`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.46.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachNavigate(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DatePicker$NavigateEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterValueHelpClose afterValueHelpClose} to attached listeners.
     *
     * @since 1.102.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterValueHelpClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:afterValueHelpOpen afterValueHelpOpen} to attached listeners.
     *
     * @since 1.102.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterValueHelpOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fire event change to attached listeners.
     *
     * Expects following event parameters:
     * 	 - 'value' of type `string` The new value of the `sap.m.DatePicker`.
     * 	 - 'valid' of type `boolean` Indicator for a valid date.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` for method chaining
     */
    fireChange(
      /**
       * the arguments to pass along with the event.
       */
      mArguments?: object
    ): this;
    /**
     * Fires event {@link #event:navigate navigate} to attached listeners.
     *
     * @since 1.46.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireNavigate(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DatePicker$NavigateEventParameters
    ): this;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control.
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Gets current value of property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.108.0
     *
     * @returns Value of property `calendarWeekNumbering`
     */
    getCalendarWeekNumbering(): CalendarWeekNumbering;
    /**
     * The date instance. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns the value of property `dateValue`
     */
    getDateValue(): Date | UI5Date | null;
    /**
     * The date is displayed in the input field using this format. By default, the medium format of the used
     * locale is used.
     *
     * Supported format options are pattern-based on Unicode LDML Date Format notation. {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table }
     * **Note:** If you use data binding on the `value` property with type `sap.ui.model.type.Date` this property
     * will be ignored. The format defined in the binding will be used.
     *
     *
     * @returns the value of property `displayFormat`
     */
    getDisplayFormat(): string;
    /**
     * Gets current value of property {@link #getDisplayFormatType displayFormatType}.
     *
     * Displays date in this given type in input field. Default value is taken from locale settings. Accepted
     * are values of {@link module:sap/base/i18n/date/CalendarType} or an empty string. If no type is set, the
     * default type of the configuration is used. **Note:** If data binding on `value` property with type `sap.ui.model.type.Date`
     * is used, this property will be ignored.
     *
     * Default value is `empty string`.
     *
     * @since 1.28.6
     *
     * @returns Value of property `displayFormatType`
     */
    getDisplayFormatType(): string;
    /**
     * Gets current value of property {@link #getHideInput hideInput}.
     *
     * Determines whether the input field of the picker is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the picker popover. In that case it can be opened
     * by another control through calling of picker's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the picker is not responsible for accessibility attributes of the control which opens its
     * popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Date
     * Picker"), and also aria-haspopup attribute with value of `sap.ui.core.aria.HasPopup.Dialog`.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Value of property `hideInput`
     */
    getHideInput(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getLegend legend}, or `null`.
     *
     * @since 1.38.5
     */
    getLegend(): ID | null;
    /**
     * Gets current value of property {@link #getMaxDate maxDate}.
     *
     * Maximum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     * **Note:** If the `maxDate` is set to be before the `minDate`, the `maxDate` and the `minDate` are switched
     * before rendering.
     *
     * @since 1.38.0
     *
     * @returns Value of property `maxDate`
     */
    getMaxDate(): object;
    /**
     * Gets current value of property {@link #getMinDate minDate}.
     *
     * Minimum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     * **Note:** If the `minDate` is set to be after the `maxDate`, the `maxDate` and the `minDate` are switched
     * before rendering.
     *
     * @since 1.38.0
     *
     * @returns Value of property `minDate`
     */
    getMinDate(): object;
    /**
     * Gets current value of property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * If set, the days in the calendar popup are also displayed in this calendar type If not set, the dates
     * are only displayed in the primary calendar type
     *
     * @since 1.34.1
     *
     * @returns Value of property `secondaryCalendarType`
     */
    getSecondaryCalendarType(): CalendarType;
    /**
     * Gets current value of property {@link #getShowCurrentDateButton showCurrentDateButton}.
     *
     * Determines whether there is a shortcut navigation to Today. When used in Month, Year or Year-range picker
     * view, the calendar navigates to Day picker view.
     *
     * Note: The Current date button appears if the `displayFormat` property allows entering day.
     *
     * Default value is `false`.
     *
     * @since 1.95
     *
     * @returns Value of property `showCurrentDateButton`
     */
    getShowCurrentDateButton(): boolean;
    /**
     * Gets current value of property {@link #getShowFooter showFooter}.
     *
     * Hides or shows the popover's footer.
     *
     * Default value is `false`.
     *
     * @since 1.70
     *
     * @returns Value of property `showFooter`
     */
    getShowFooter(): boolean;
    /**
     * Gets content of aggregation {@link #getSpecialDates specialDates}.
     *
     * Date Range with type to visualize special days in the Calendar. If one day is assigned to more than one
     * Type, only the first one will be used.
     *
     * To set a single date (instead of a range), set only the startDate property of the sap.ui.unified.DateRange
     * class.
     *
     * **Note:** Since 1.48 you could set a non-working day via the sap.ui.unified.CalendarDayType.NonWorking
     * enum type just as any other special date type using sap.ui.unified.DateRangeType.
     *
     * @since 1.38.5
     */
    getSpecialDates(): UI5Element[];
    /**
     * Getter for property `value`.
     *
     * Returns a date as a string in the format defined in property `valueFormat`.
     *
     * **Note:** If there is no data binding, the value is expected and updated in Gregorian calendar type.
     * (Otherwise, the type of the binding is used.)
     *
     * If this property is used, the `dateValue` property should not be changed from the caller.
     *
     *
     * @returns the value of property `value`
     */
    getValue(): string;
    /**
     * The date string expected and returned in the `value` property uses this format. By default the medium
     * format of the used locale is used.
     *
     * Supported format options are pattern-based on Unicode LDML Date Format notation. {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table}
     *
     * For example, if the date string represents an ABAP DATS type, the format should be "yyyyMMdd".
     *
     * **Note:** If data binding on `value` property with type `sap.ui.model.type.Date` is used, this property
     * will be ignored. The format defined in the binding will be used.
     *
     *
     * @returns the value of property `valueFormat`
     */
    getValueFormat(): string;
    /**
     * Checks for the provided `sap.ui.core.Element` in the aggregation {@link #getSpecialDates specialDates}.
     * and returns its index if found or -1 otherwise.
     *
     * @since 1.38.5
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfSpecialDate(
      /**
       * The specialDate whose index is looked for
       */
      oSpecialDate: UI5Element
    ): int;
    /**
     * Inserts a `specialDate` to the aggregation `specialDates`.
     *
     * @since 1.38.5
     *
     * @returns Reference to `this` for method chaining
     */
    insertSpecialDate(
      /**
       * the specialDate to insert; if empty, nothing is inserted
       */
      oSpecialDate: DateTypeRange,
      /**
       * the 0-based index the `specialDate` should be inserted at; for a negative value of `iIndex`, the `specialDate`
       * is inserted at position 0; for a value greater than the current size of the aggregation, the `specialDate`
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Checks if the picker is open
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    isOpen(): boolean;
    /**
     * Returns if the last entered value is valid.
     *
     * @since 1.64
     */
    isValidValue(): boolean;
    /**
     * Opens the picker popover. The popover is positioned relatively to the control given as `oDomRef` parameter
     * on tablet or desktop and is full screen on phone. Therefore the control parameter is only used on tablet
     * or desktop and is ignored on phone.
     *
     * Note: use this method to open the picker popover only when the `hideInput` property is set to `true`.
     * Please consider opening of the picker popover by another control only in scenarios that comply with Fiori
     * guidelines. For example, opening the picker popover by another popover is not recommended. The application
     * developer should implement the following accessibility attributes to the opening control: a text or tooltip
     * that describes the action (example: "Open Date Picker"), and aria-haspopup attribute with value of `sap.ui.core.aria.HasPopup.Dialog`.
     *
     * @since 1.97
     */
    openBy(
      /**
       * DOM reference of the opening control. On tablet or desktop, the popover is positioned relatively to this
       * control.
       */
      oDomRef: HTMLElement
    ): void;
    /**
     * Removes all the controls from the aggregation {@link #getSpecialDates specialDates}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.38.5
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllSpecialDates(): UI5Element[];
    /**
     * Removes a `specialDate` from the aggregation `specialDates`.
     *
     * @since 1.38.5
     *
     * @returns The removed `specialDate`
     */
    removeSpecialDate(
      /**
       * The `specialDate` to remove or its index or ID
       */
      oSpecialDate: DateTypeRange
    ): int | string | DateTypeRange;
    /**
     * Sets a new value for property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.108.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarWeekNumbering(
      /**
       * New value for property `calendarWeekNumbering`
       */
      sCalendarWeekNumbering?:
        | CalendarWeekNumbering
        | keyof typeof CalendarWeekNumbering
    ): this;
    /**
     * Sets the displayFormat of the DatePicker.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setDisplayFormat(
      /**
       * new value for `displayFormat`
       */
      sDisplayFormat: string
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayFormatType displayFormatType}.
     *
     * Displays date in this given type in input field. Default value is taken from locale settings. Accepted
     * are values of {@link module:sap/base/i18n/date/CalendarType} or an empty string. If no type is set, the
     * default type of the configuration is used. **Note:** If data binding on `value` property with type `sap.ui.model.type.Date`
     * is used, this property will be ignored.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.28.6
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayFormatType(
      /**
       * New value for property `displayFormatType`
       */
      sDisplayFormatType?: string
    ): this;
    /**
     * Sets a new value for property {@link #getHideInput hideInput}.
     *
     * Determines whether the input field of the picker is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the picker popover. In that case it can be opened
     * by another control through calling of picker's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the picker is not responsible for accessibility attributes of the control which opens its
     * popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Date
     * Picker"), and also aria-haspopup attribute with value of `sap.ui.core.aria.HasPopup.Dialog`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.97
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideInput(
      /**
       * New value for property `hideInput`
       */
      bHideInput?: boolean
    ): this;
    /**
     * Sets the associated legend.
     *
     * @since 1.38.5
     *
     * @returns Reference to `this` for method chaining
     */
    setLegend(
      /**
       * ID of an element which becomes the new target of this `legend` association; alternatively, an element
       * instance may be given
       */
      oLegend: ID | CalendarLegend
    ): this;
    /**
     * Set maximum date that can be shown and selected in the `DatePicker`. This must be a date instance.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMaxDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Set minimum date that can be shown and selected in the `DatePicker`. This must be a date instance.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMinDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Sets a new value for property {@link #getSecondaryCalendarType secondaryCalendarType}.
     *
     * If set, the days in the calendar popup are also displayed in this calendar type If not set, the dates
     * are only displayed in the primary calendar type
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.34.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondaryCalendarType(
      /**
       * New value for property `secondaryCalendarType`
       */
      sSecondaryCalendarType: CalendarType | keyof typeof CalendarType
    ): this;
    /**
     * Sets a new value for property {@link #getShowCurrentDateButton showCurrentDateButton}.
     *
     * Determines whether there is a shortcut navigation to Today. When used in Month, Year or Year-range picker
     * view, the calendar navigates to Day picker view.
     *
     * Note: The Current date button appears if the `displayFormat` property allows entering day.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.95
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCurrentDateButton(
      /**
       * New value for property `showCurrentDateButton`
       */
      bShowCurrentDateButton?: boolean
    ): this;
    /**
     * Sets `showFooter` property to the given boolean value
     *
     * @since 1.70
     */
    setShowFooter(
      /**
       * when true footer is displayed
       */
      bFlag: boolean
    ): void;
    /**
     * Setter for property `value`.
     *
     * Expects a date as a string in the format defined in property `valueFormat`.
     *
     * **Note:** If there is no data binding, the value is expected and updated in Gregorian calendar type.
     * (Otherwise, the type of the binding is used.)
     *
     * If this property is used, the `dateValue` property should not be changed from the caller.
     *
     * If Data binding using a `sap.ui.model.type.Date` is used, please set the `formatOption` `stricktParsing`
     * to `true`. This prevents unwanted automatic corrections of wrong input.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setValue(
      /**
       * The new value of the input.
       */
      sValue: string
    ): this;
    /**
     * Defines the width of the DatePicker. Default value is 100%
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setWidth(
      /**
       * new value for `width`
       */
      sWidth: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DatePicker constructor.
   */
  export interface $DatePickerSettings extends $DateTimeFieldSettings {
    /**
     * Displays date in this given type in input field. Default value is taken from locale settings. Accepted
     * are values of {@link module:sap/base/i18n/date/CalendarType} or an empty string. If no type is set, the
     * default type of the configuration is used. **Note:** If data binding on `value` property with type `sap.ui.model.type.Date`
     * is used, this property will be ignored.
     *
     * @since 1.28.6
     */
    displayFormatType?: string | PropertyBindingInfo;

    /**
     * If set, the days in the calendar popup are also displayed in this calendar type If not set, the dates
     * are only displayed in the primary calendar type
     *
     * @since 1.34.1
     */
    secondaryCalendarType?:
      | (CalendarType | keyof typeof CalendarType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Minimum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     * **Note:** If the `minDate` is set to be after the `maxDate`, the `maxDate` and the `minDate` are switched
     * before rendering.
     *
     * @since 1.38.0
     */
    minDate?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Maximum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     * **Note:** If the `maxDate` is set to be before the `minDate`, the `maxDate` and the `minDate` are switched
     * before rendering.
     *
     * @since 1.38.0
     */
    maxDate?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Hides or shows the popover's footer.
     *
     * @since 1.70
     */
    showFooter?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether there is a shortcut navigation to Today. When used in Month, Year or Year-range picker
     * view, the calendar navigates to Day picker view.
     *
     * Note: The Current date button appears if the `displayFormat` property allows entering day.
     *
     * @since 1.95
     */
    showCurrentDateButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the input field of the picker is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the picker popover. In that case it can be opened
     * by another control through calling of picker's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the picker is not responsible for accessibility attributes of the control which opens its
     * popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Date
     * Picker"), and also aria-haspopup attribute with value of `sap.ui.core.aria.HasPopup.Dialog`.
     *
     * @since 1.97
     */
    hideInput?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.108.0
     */
    calendarWeekNumbering?:
      | (CalendarWeekNumbering | keyof typeof CalendarWeekNumbering)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Date Range with type to visualize special days in the Calendar. If one day is assigned to more than one
     * Type, only the first one will be used.
     *
     * To set a single date (instead of a range), set only the startDate property of the sap.ui.unified.DateRange
     * class.
     *
     * **Note:** Since 1.48 you could set a non-working day via the sap.ui.unified.CalendarDayType.NonWorking
     * enum type just as any other special date type using sap.ui.unified.DateRangeType.
     *
     * @since 1.38.5
     */
    specialDates?:
      | UI5Element[]
      | UI5Element
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to the `CalendarLegend` explaining the colors of the `specialDates`.
     *
     * **Note** The legend does not have to be rendered but must exist, and all required types must be assigned.
     *
     * @since 1.38.5
     */
    legend?: Control | string;

    /**
     * Fired when navigating in `Calendar` popup.
     *
     * @since 1.46.0
     */
    navigate?: (oEvent: DatePicker$NavigateEvent) => void;

    /**
     * Fired when `value help` dialog opens.
     *
     * @since 1.102.0
     */
    afterValueHelpOpen?: (oEvent: Event) => void;

    /**
     * Fired when `value help` dialog closes.
     *
     * @since 1.102.0
     */
    afterValueHelpClose?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the DatePicker#afterValueHelpClose event.
   */
  export interface DatePicker$AfterValueHelpCloseEventParameters {}

  /**
   * Event object of the DatePicker#afterValueHelpClose event.
   */
  export type DatePicker$AfterValueHelpCloseEvent = Event<
    DatePicker$AfterValueHelpCloseEventParameters,
    DatePicker
  >;

  /**
   * Parameters of the DatePicker#afterValueHelpOpen event.
   */
  export interface DatePicker$AfterValueHelpOpenEventParameters {}

  /**
   * Event object of the DatePicker#afterValueHelpOpen event.
   */
  export type DatePicker$AfterValueHelpOpenEvent = Event<
    DatePicker$AfterValueHelpOpenEventParameters,
    DatePicker
  >;

  /**
   * Parameters of the DatePicker#change event.
   */
  export interface DatePicker$ChangeEventParameters
    extends InputBase$ChangeEventParameters {
    /**
     * Indicator for a valid date.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DatePicker#change event.
   */
  export type DatePicker$ChangeEvent = Event<
    DatePicker$ChangeEventParameters,
    DatePicker
  >;

  /**
   * Parameters of the DatePicker#navigate event.
   */
  export interface DatePicker$NavigateEventParameters {
    /**
     * Date range containing the start and end date displayed in the `Calendar` popup.
     */
    dateRange?: DateRange;

    /**
     * Indicates if the event is fired, due to popup being opened.
     */
    afterPopupOpened?: boolean;
  }

  /**
   * Event object of the DatePicker#navigate event.
   */
  export type DatePicker$NavigateEvent = Event<
    DatePicker$NavigateEventParameters,
    DatePicker
  >;
}

declare module "sap/m/DateRangeSelection" {
  import {
    default as DatePicker,
    $DatePickerSettings,
    DatePicker$ChangeEventParameters,
  } from "sap/m/DatePicker";

  import { AccessibilityInfo } from "sap/ui/core/library";

  import UI5Date from "sap/ui/core/date/UI5Date";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * A single-field input control that enables the users to enter a localized date range (between 0001-01-01
   * and 9999-12-31).
   *
   * Overview:
   *
   * The `DateRangeSelection` enables the users to enter a localized date range using touch, mouse, keyboard
   * input, or by selecting a date range in the calendar. They can also navigate directly from one month or
   * year to another.
   *
   * **Note:** The control is not UTC aware and the selected date range starts from 00:00:00:000 of the first
   * date and ends in 23:59:59:999 on the second date.
   *
   * The application developer should add dependency to `sap.ui.unified` library on application level to ensure
   * that the library is loaded before the module dependencies will be required. The {@link sap.ui.unified.Calendar }
   * is used internally only if the `DateRangeSelection` is opened (not used for the initial rendering). If
   * the `sap.ui.unified` library is not loaded before the `DateRangeSelection` is opened, it will be loaded
   * upon opening. This could lead to CSP compliance issues and adds an additional waiting time when the `DateRangeSelection`
   * is opened for the first time. To prevent this, apps using the `DateRangeSelection` should also load the
   * `sap.ui.unified` library in advance.
   *
   * Usage:
   *
   * When to use?
   *
   * If you need a date range and know that your user is a power user who has to input lots of data. If the
   * keyboard is the primary device used for navigating the app, use two input fields. This allows the user
   * to quickly jump from field to field. By selecting a date in one of the fields, the other field should
   * recognize the information and jump to the same selection.
   *
   * When not to use?
   *
   * If the user's primary goal is not to select ranges or if you just want to enter a date and a time. For
   * such cases, use the {@link sap.m.DatePicker} or {@link sap.m.TimePicker}.
   *
   * The user can enter a date by:
   * 	 - Using the calendar that opens in a popup
   * 	 - Typing it directly in the input field
   *
   * On app level, there are two options to provide a date for the `DateRangeSelection` - date range as a
   * string to the `value` property or UI5Date/JavaScript Date objects to the `dateValue` and `secondDateValue`
   * properties (only one of these options should be used at a time):
   *
   *
   * 	 - Use the `value` property if the date range is already provided as a formatted string  binding
   *     the `value` property by using types
   * ```javascript
   *
   * new sap.ui.model.json.JSONModel({start:'2022-11-10', end:'2022-11-15'});
   *
   * new sap.m.DateRangeSelection({
   *     value: {
   *         type: "sap.ui.model.type.DateInterval",
   *         parts: [{
   *             type: "sap.ui.model.type.Date",
   *             path: "/start",
   *             formatOptions: {
   *                 source: {
   *                     pattern: "yyyy-MM-dd"
   *                 }
   *             }
   *         },
   *         {
   *             type: "sap.ui.model.type.Date",
   *             path:"/end",
   *             formatOptions: {
   *             source: {
   *                 pattern: "yyyy-MM-dd"
   *             }
   *         }}]
   *     }
   * });
   * ```
   *  **Note:** There are multiple binding type choices, such as: sap.ui.model.type.Date sap.ui.model.odata.type.DateTime
   * sap.ui.model.odata.type.DateTimeOffset See {@link sap.ui.model.type.Date}, {@link sap.ui.model.odata.type.DateTime }
   * or {@link sap.ui.model.odata.type.DateTimeOffset}
   *
   *
   * 	 - Use the `dateValue` and `secondDateValue` properties if the date range is already provided as UI5Date
   *     or JavaScript Date objects or you want to work with UI5Date or JavaScript Date objects
   *
   * Formatting:
   *
   * All formatting and parsing of dates from and to strings is done using the {@link sap.ui.core.format.DateFormat}.
   * If a date is entered by typing it into the input field, it must fit to the used date format and locale.
   *
   * Supported format options are pattern-based on Unicode LDML Date Format notation. See {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table}
   *
   * For example, if the `displayFormat` is "MMM d, y", delimiter is "-", and the used locale is English,
   * a valid value string is "Jul 29, 2015 - Jul 31, 2015" and it is displayed in the same way in the input
   * field.
   *
   * If no placeholder is set to the `DateRangeSelection`, the used `displayFormat` is displayed as a placeholder.
   * If another placeholder is needed, it must be set.
   *
   * **Note:** If the string does NOT match the `displayFormat` (from user input) or the `valueFormat` (on
   * app level), the {@link sap.ui.core.format.DateFormat} makes an attempt to parse it based on the locale
   * settings. For more information, see the respective documentation in the API Reference.
   *
   * Responsive behavior:
   *
   * The `DateRangeSelection` is fully responsive. It is smaller in compact mode and provides a touch-friendly
   * size in cozy mode.
   *
   * @since 1.22.0
   */
  export default class DateRangeSelection extends DatePicker {
    /**
     * Constructor for a new `DateRangeSelection`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateRangeSelectionSettings
    );
    /**
     * Constructor for a new `DateRangeSelection`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateRangeSelectionSettings
    );

    /**
     * Creates a new subclass of class sap.m.DateRangeSelection with name `sClassName` and enriches it with
     * the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.DatePicker.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateRangeSelection>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DateRangeSelection.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Fire event change to attached listeners.
     *
     * Expects following event parameters:
     * 	 - 'value' of type `string` The new value of the `sap.m.DateRangeSelection`.
     * 	 - 'valid' of type `boolean` Indicator for a valid date.
     * 	 - 'from' of type `object` Current start date after change.
     * 	 - 'to' of type `object` Current end date after change.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` for method chaining
     */
    fireChange(
      /**
       * The arguments to pass along with the event.
       */
      mArguments?: object
    ): this;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Getter for property `dateValue`.
     *
     * The start date of the range as UI5Date or JavaScript Date object. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns the value of property `dateValue`
     */
    getDateValue(): Date | UI5Date | null;
    /**
     * Gets current value of property {@link #getDelimiter delimiter}.
     *
     * Delimiter between start and end date. Default value is "-". If no delimiter is given, the one defined
     * for the used locale is used.
     *
     * Default value is `'-'`.
     *
     *
     * @returns Value of property `delimiter`
     */
    getDelimiter(): string;
    /**
     * Get the start date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `dateValue` property of the {@link sap.m.DateTimeField}
     *
     * @returns the start date of the date range
     */
    getFrom(): Date | UI5Date | null;
    /**
     * Getter for property `secondDateValue`.
     *
     * The end date of the range as UI5Date or JavaScript Date object. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns the value of property `secondDateValue`
     */
    getSecondDateValue(): Date | UI5Date | null;
    /**
     * Get the end date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `secondDateValue` property
     *
     * @returns the end date of the date range
     */
    getTo(): Date | UI5Date | null;
    /**
     * Getter for property `value`.
     *
     * Returns a date as a string in the format defined in property `displayFormat`.
     *
     * **Note:** As the value string always used the `displayFormat`, it is both locale-dependent and calendar-type-dependent.
     *
     * If this property is used, the `dateValue` property should not be changed from the caller.
     *
     *
     * @returns the value of property `value`
     */
    getValue(): string;
    /**
     * Getter for property `valueFormat`.
     *
     * **Note:** Property `valueFormat` is not supported in the `sap.m.DateRangeSelection` control.
     *
     *
     * @returns the value of property valueFormat
     */
    getValueFormat(): string;
    /**
     * Setter for property `dateValue`.
     *
     * The start date of the range as UI5Date or JavaScript Date object. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setDateValue(
      /**
       * New value for property `dateValue`
       */
      oDateValue: Date | UI5Date | null
    ): this;
    /**
     * Sets a new value for property {@link #getDelimiter delimiter}.
     *
     * Delimiter between start and end date. Default value is "-". If no delimiter is given, the one defined
     * for the used locale is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `'-'`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDelimiter(
      /**
       * New value for property `delimiter`
       */
      sDelimiter?: string
    ): this;
    /**
     * Sets the displayFormat of the DatePicker.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setDisplayFormat(
      /**
       * new value for `displayFormat`
       */
      sDisplayFormat: string
    ): this;
    /**
     * Set the start date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `dateValue` property of the {@link sap.m.DateTimeField}
     *
     * @returns Reference to `this` for method chaining
     */
    setFrom(
      /**
       * A date instance
       */
      oFrom: Date | UI5Date | null
    ): this;
    /**
     * Set maximum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMaxDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Set minimum date that can be shown and selected in the `DatePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMinDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Setter for property `secondDateValue`.
     *
     * The start date of the range as UI5Date or JavaScript Date object. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setSecondDateValue(
      /**
       * New value for property `dateValue`
       */
      oSecondDateValue: Date | UI5Date | null
    ): this;
    /**
     * Set the end date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `secondDateValue` property
     *
     * @returns Reference to `this` for method chaining
     */
    setTo(
      /**
       * A date instance
       */
      oTo: Date | UI5Date | null
    ): this;
    /**
     * Setter for property `value`.
     *
     * Expects a date as a string in the format defined in property `displayFormat`.
     *
     * **Note:** As the value string always used the `displayFormat`, it is both locale-dependent and calendar-type-dependent.
     *
     * If this property is used, the `dateValue` property should not be changed from the caller.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setValue(
      /**
       * The new value of the input.
       */
      sValue: string
    ): this;
    /**
     * Setter for property `valueFormat`.
     *
     * **Note:** Property `valueFormat` is not supported in the `sap.m.DateRangeSelection` control.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setValueFormat(
      /**
       * New value for property valueFormat
       */
      sValueFormat: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DateRangeSelection constructor.
   */
  export interface $DateRangeSelectionSettings extends $DatePickerSettings {
    /**
     * Delimiter between start and end date. Default value is "-". If no delimiter is given, the one defined
     * for the used locale is used.
     */
    delimiter?: string | PropertyBindingInfo;

    /**
     * The end date of the range as UI5Date or JavaScript Date object. This is independent from any formatter.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     */
    secondDateValue?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Start date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `dateValue` property of the {@link sap.m.DateTimeField}
     */
    from?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * End date of the range.
     *
     * @deprecated As of version 1.22.0. replaced by `secondDateValue` property
     */
    to?: object | PropertyBindingInfo | `{${string}}`;
  }

  /**
   * Parameters of the DateRangeSelection#change event.
   */
  export interface DateRangeSelection$ChangeEventParameters
    extends DatePicker$ChangeEventParameters {
    /**
     * Current start date after change.
     */
    from?: object;

    /**
     * Current end date after change.
     */
    to?: object;
  }

  /**
   * Event object of the DateRangeSelection#change event.
   */
  export type DateRangeSelection$ChangeEvent = Event<
    DateRangeSelection$ChangeEventParameters,
    DateRangeSelection
  >;
}

declare module "sap/m/DateTimeField" {
  import { default as InputBase, $InputBaseSettings } from "sap/m/InputBase";

  import UI5Date from "sap/ui/core/date/UI5Date";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The `sap.m.DateTimeField` control provides a basic functionality for date/time input controls.
   *
   * To be extended by date and time picker controls. For internal use only.
   *
   * @since 1.50.0
   */
  export default abstract class DateTimeField extends InputBase {
    /**
     * Constructor for a new `sap.m.DateTimeField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimeFieldSettings
    );
    /**
     * Constructor for a new `sap.m.DateTimeField`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimeFieldSettings
    );

    /**
     * Creates a new subclass of class sap.m.DateTimeField with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.InputBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateTimeField>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DateTimeField.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.DateTimeField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DateTimeField` itself.
     *
     * Fired when the value of the `DateTimeField` is changed by user interaction - each keystroke, delete,
     * paste, etc.
     *
     * **Note:** Browsing autocomplete suggestions doesn't fire the event.
     *
     * @since 1.104.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimeField$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DateTimeField` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:liveChange liveChange} event of this `sap.m.DateTimeField`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DateTimeField` itself.
     *
     * Fired when the value of the `DateTimeField` is changed by user interaction - each keystroke, delete,
     * paste, etc.
     *
     * **Note:** Browsing autocomplete suggestions doesn't fire the event.
     *
     * @since 1.104.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachLiveChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimeField$LiveChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DateTimeField` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:liveChange liveChange} event of this `sap.m.DateTimeField`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.104.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachLiveChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateTimeField$LiveChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:liveChange liveChange} to attached listeners.
     *
     * @since 1.104.0
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireLiveChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateTimeField$LiveChangeEventParameters
    ): this;
    /**
     * Getter for property `dateValue`.
     *
     * The date and time in DateTimeField as UI5Date or JavaScript Date object.
     *
     * **Note:** If this property is used, the `value` property should not be changed from the caller.
     *
     *
     * @returns the value of property `dateValue`
     */
    getDateValue(): Date | UI5Date | null;
    /**
     * Gets current value of property {@link #getDisplayFormat displayFormat}.
     *
     * Determines the format, displayed in the input field.
     *
     *
     * @returns Value of property `displayFormat`
     */
    getDisplayFormat(): string;
    /**
     * Gets the inner input DOM value.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns The value of the input.
     */
    getDOMValue(): any;
    /**
     * Gets current value of property {@link #getInitialFocusedDateValue initialFocusedDateValue}.
     *
     * Holds a reference to a UI5Date or JavaScript Date object to define the initially focused date/time when
     * the picker popup is opened.
     *
     * **Notes:**
     * 	 - Setting this property does not change the `value` property.
     * 	 - Depending on the context this property is used in ({@link sap.m.TimePicker}, {@link sap.m.DatePicker }
     *     or {@link sap.m.DateTimePicker}), it takes into account only the time part, only the date part or both
     *     parts of the UI5Date or JavaScript Date object.
     *
     * @since 1.54
     *
     * @returns Value of property `initialFocusedDateValue`
     */
    getInitialFocusedDateValue(): object;
    /**
     * Gets current value of property {@link #getValueFormat valueFormat}.
     *
     * Determines the format of the value property.
     *
     *
     * @returns Value of property `valueFormat`
     */
    getValueFormat(): string;
    /**
     * Event handler for user input.
     */
    oninput(
      /**
       * User input.
       */
      oEvent: jQuery.Event
    ): void;
    /**
     * Setter for property `dateValue`.
     *
     * The date and time in DateTimeField as UI5Date or JavaScript Date object.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setDateValue(
      /**
       * A date instance
       */
      oDate: Date | UI5Date | null
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayFormat displayFormat}.
     *
     * Determines the format, displayed in the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayFormat(
      /**
       * New value for property `displayFormat`
       */
      sDisplayFormat?: string
    ): this;
    /**
     * Sets a new value for property {@link #getInitialFocusedDateValue initialFocusedDateValue}.
     *
     * Holds a reference to a UI5Date or JavaScript Date object to define the initially focused date/time when
     * the picker popup is opened.
     *
     * **Notes:**
     * 	 - Setting this property does not change the `value` property.
     * 	 - Depending on the context this property is used in ({@link sap.m.TimePicker}, {@link sap.m.DatePicker }
     *     or {@link sap.m.DateTimePicker}), it takes into account only the time part, only the date part or both
     *     parts of the UI5Date or JavaScript Date object.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.54
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialFocusedDateValue(
      /**
       * New value for property `initialFocusedDateValue`
       */
      oInitialFocusedDateValue?: object
    ): this;
    /**
     * Sets a new value for property {@link #getValueFormat valueFormat}.
     *
     * Determines the format of the value property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueFormat(
      /**
       * New value for property `valueFormat`
       */
      sValueFormat?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DateTimeField constructor.
   */
  export interface $DateTimeFieldSettings extends $InputBaseSettings {
    /**
     * Determines the format, displayed in the input field.
     */
    displayFormat?: string | PropertyBindingInfo;

    /**
     * Determines the format of the value property.
     */
    valueFormat?: string | PropertyBindingInfo;

    /**
     * Holds a reference to a UI5Date or JavaScript Date object. The `value` (string) property will be set according
     * to it. Alternatively, if the `value` and `valueFormat` pair properties are supplied instead, the `dateValue`
     * will be instantiated according to the parsed `value`. Use `dateValue` as a helper property to easily
     * obtain the day, month, year, hours, minutes and seconds of the chosen date and time. Although possible
     * to bind it, the recommendation is not to do it. When binding is needed, use `value` property instead.
     */
    dateValue?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Holds a reference to a UI5Date or JavaScript Date object to define the initially focused date/time when
     * the picker popup is opened.
     *
     * **Notes:**
     * 	 - Setting this property does not change the `value` property.
     * 	 - Depending on the context this property is used in ({@link sap.m.TimePicker}, {@link sap.m.DatePicker }
     *     or {@link sap.m.DateTimePicker}), it takes into account only the time part, only the date part or both
     *     parts of the UI5Date or JavaScript Date object.
     *
     * @since 1.54
     */
    initialFocusedDateValue?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Fired when the value of the `DateTimeField` is changed by user interaction - each keystroke, delete,
     * paste, etc.
     *
     * **Note:** Browsing autocomplete suggestions doesn't fire the event.
     *
     * @since 1.104.0
     */
    liveChange?: (oEvent: DateTimeField$LiveChangeEvent) => void;
  }

  /**
   * Parameters of the DateTimeField#liveChange event.
   */
  export interface DateTimeField$LiveChangeEventParameters {
    /**
     * The current value of the input, after a live change event.
     */
    value?: string;

    /**
     * The previous value of the input, before the last user interaction.
     */
    previousValue?: string;
  }

  /**
   * Event object of the DateTimeField#liveChange event.
   */
  export type DateTimeField$LiveChangeEvent = Event<
    DateTimeField$LiveChangeEventParameters,
    DateTimeField
  >;
}

declare module "sap/m/DateTimeInput" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { IToolbarInteractiveControl, DateTimeInputType } from "sap/m/library";

  import {
    ID,
    AccessibilityInfo,
    TextAlign,
    TextDirection,
    ValueState,
    CSSSize,
  } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import Event from "sap/ui/base/Event";

  /**
   * Allows end users to interact with date (between 0001-01-01 and 9999-12-31) and/or time and select from
   * a date and/or time pad.
   *
   * **Note:** This control should not be used any longer, instead please use the dedicated `sap.m.DatePicker`,
   * `sap.m.TimePicker` or `sap.m.DateTimePicker` control.
   *
   * @since 1.9.1
   * @deprecated As of version 1.32.8. replaced by {@link sap.m.DatePicker}, {@link sap.m.TimePicker} or {@link sap.m.DateTimePicker}
   */
  export default class DateTimeInput
    extends Control
    implements IToolbarInteractiveControl
  {
    __implements__sap_m_IToolbarInteractiveControl: boolean;
    /**
     * Constructor for a new DateTimeInput.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimeInputSettings
    );
    /**
     * Constructor for a new DateTimeInput.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimeInputSettings
    );

    /**
     * Creates a new subclass of class sap.m.DateTimeInput with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateTimeInput>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DateTimeInput.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.DateTimeInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DateTimeInput` itself.
     *
     * This event gets fired when the selection has finished and the value has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimeInput$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DateTimeInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.DateTimeInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DateTimeInput` itself.
     *
     * This event gets fired when the selection has finished and the value has changed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DateTimeInput$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DateTimeInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Binds property {@link #getValue value} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindValue(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.m.DateTimeInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DateTimeInput$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DateTimeInput$ChangeEventParameters
    ): this;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getDateValue dateValue}.
     *
     * This property as JavaScript Date Object can be used to assign a new value which is independent from valueFormat.
     *
     *
     * @returns Value of property `dateValue`
     */
    getDateValue(): object;
    /**
     * Gets current value of property {@link #getDisplayFormat displayFormat}.
     *
     * Displays date value in this given format in text field. Default value is taken from locale settings.
     * If you use data-binding on value property with type sap.ui.model.type.Date then you can ignore this property
     * or the latter wins. If the user's browser supports native picker then this property is overwritten by
     * browser with locale settings.
     *
     *
     * @returns Value of property `displayFormat`
     */
    getDisplayFormat(): string;
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to non-editable
     * control, highlight it, and copy the text from it.
     *
     * Default value is `true`.
     *
     * @since 1.12.0
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Defines the name of the control for the purposes of form submission.
     *
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getShowValueStateMessage showValueStateMessage}.
     *
     * Indicates whether the value state message should be shown or not.
     *
     * Default value is `true`.
     *
     * @since 1.26.0
     *
     * @returns Value of property `showValueStateMessage`
     */
    getShowValueStateMessage(): boolean;
    /**
     * Gets current value of property {@link #getTextAlign textAlign}.
     *
     * Defines the horizontal alignment of the text that is shown inside the input field.
     *
     * Default value is `Initial`.
     *
     * @since 1.26.0
     *
     * @returns Value of property `textAlign`
     */
    getTextAlign(): TextAlign;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Defines the text directionality of the input field, e.g. `RTL`, `LTR`
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Type of DateTimeInput (e.g. Date, Time, DateTime)
     *
     * Default value is `Date`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): DateTimeInputType;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the control.
     *
     * The new value must be in the format set by `valueFormat`.
     *
     * The "Now" literal can also be assigned as a parameter to show the current date and/or time.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueFormat valueFormat}.
     *
     * Given value property should match with valueFormat to parse date. Default value is taken from locale
     * settings. You can only set and get value in this format. If you use data-binding on value property with
     * type sap.ui.model.type.Date you can ignore this property or the latter wins.
     *
     *
     * @returns Value of property `valueFormat`
     */
    getValueFormat(): string;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Visualizes the validation state of the control, e.g. `Error`, `Warning`, `Success`.
     *
     * Default value is `None`.
     *
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState;
    /**
     * Gets current value of property {@link #getValueStateText valueStateText}.
     *
     * Defines the text that appears in the value state message pop-up. If this is not specified, a default
     * text is shown from the resource bundle.
     *
     * @since 1.26.0
     *
     * @returns Value of property `valueStateText`
     */
    getValueStateText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.27.0
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Setter for property `dateValue`.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setDateValue(
      /**
       * A JavaScript Date
       */
      oDate: Date
    ): this;
    /**
     * Sets a new value for property {@link #getDisplayFormat displayFormat}.
     *
     * Displays date value in this given format in text field. Default value is taken from locale settings.
     * If you use data-binding on value property with type sap.ui.model.type.Date then you can ignore this property
     * or the latter wins. If the user's browser supports native picker then this property is overwritten by
     * browser with locale settings.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDisplayFormat(
      /**
       * New value for property `displayFormat`
       */
      sDisplayFormat?: string
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to non-editable
     * control, highlight it, and copy the text from it.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.12.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Defines the name of the control for the purposes of form submission.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getShowValueStateMessage showValueStateMessage}.
     *
     * Indicates whether the value state message should be shown or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.26.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowValueStateMessage(
      /**
       * New value for property `showValueStateMessage`
       */
      bShowValueStateMessage?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTextAlign textAlign}.
     *
     * Defines the horizontal alignment of the text that is shown inside the input field.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Initial`.
     *
     * @since 1.26.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextAlign(
      /**
       * New value for property `textAlign`
       */
      sTextAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Defines the text directionality of the input field, e.g. `RTL`, `LTR`
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Type of DateTimeInput (e.g. Date, Time, DateTime)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Date`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: DateTimeInputType | keyof typeof DateTimeInputType
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the control.
     *
     * The new value must be in the format set by `valueFormat`.
     *
     * The "Now" literal can also be assigned as a parameter to show the current date and/or time.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueFormat valueFormat}.
     *
     * Given value property should match with valueFormat to parse date. Default value is taken from locale
     * settings. You can only set and get value in this format. If you use data-binding on value property with
     * type sap.ui.model.type.Date you can ignore this property or the latter wins.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueFormat(
      /**
       * New value for property `valueFormat`
       */
      sValueFormat?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Visualizes the validation state of the control, e.g. `Error`, `Warning`, `Success`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateText valueStateText}.
     *
     * Defines the text that appears in the value state message pop-up. If this is not specified, a default
     * text is shown from the resource bundle.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.26.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateText(
      /**
       * New value for property `valueStateText`
       */
      sValueStateText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"100%"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Unbinds property {@link #getValue value} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindValue(): this;
  }
  /**
   * Describes the settings that can be provided to the DateTimeInput constructor.
   *
   * @deprecated As of version 1.32.8. replaced by {@link sap.m.DatePicker}, {@link sap.m.TimePicker} or {@link sap.m.DateTimePicker}
   */
  export interface $DateTimeInputSettings extends $ControlSettings {
    /**
     * Defines the value of the control.
     *
     * The new value must be in the format set by `valueFormat`.
     *
     * The "Now" literal can also be assigned as a parameter to show the current date and/or time.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the width of the control.
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to non-editable
     * control, highlight it, and copy the text from it.
     *
     * @since 1.12.0
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Visualizes the validation state of the control, e.g. `Error`, `Warning`, `Success`.
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the text that appears in the value state message pop-up. If this is not specified, a default
     * text is shown from the resource bundle.
     *
     * @since 1.26.0
     */
    valueStateText?: string | PropertyBindingInfo;

    /**
     * Indicates whether the value state message should be shown or not.
     *
     * @since 1.26.0
     */
    showValueStateMessage?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the name of the control for the purposes of form submission.
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines the horizontal alignment of the text that is shown inside the input field.
     *
     * @since 1.26.0
     */
    textAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the text directionality of the input field, e.g. `RTL`, `LTR`
     *
     * @since 1.28.0
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Type of DateTimeInput (e.g. Date, Time, DateTime)
     */
    type?:
      | (DateTimeInputType | keyof typeof DateTimeInputType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Displays date value in this given format in text field. Default value is taken from locale settings.
     * If you use data-binding on value property with type sap.ui.model.type.Date then you can ignore this property
     * or the latter wins. If the user's browser supports native picker then this property is overwritten by
     * browser with locale settings.
     */
    displayFormat?: string | PropertyBindingInfo;

    /**
     * Given value property should match with valueFormat to parse date. Default value is taken from locale
     * settings. You can only set and get value in this format. If you use data-binding on value property with
     * type sap.ui.model.type.Date you can ignore this property or the latter wins.
     */
    valueFormat?: string | PropertyBindingInfo;

    /**
     * This property as JavaScript Date Object can be used to assign a new value which is independent from valueFormat.
     */
    dateValue?: object | PropertyBindingInfo | `{${string}}`;

    /**
     * Association to controls / IDs that label this control (see WAI-ARIA attribute aria-labelledby).
     *
     * @since 1.27.0
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * This event gets fired when the selection has finished and the value has changed.
     */
    change?: (oEvent: DateTimeInput$ChangeEvent) => void;
  }

  /**
   * Parameters of the DateTimeInput#change event.
   */
  export interface DateTimeInput$ChangeEventParameters {
    /**
     * The string value of the control in given valueFormat (or locale format).
     */
    value?: string;

    /**
     * The value of control as JavaScript Date Object or null if value is empty.
     */
    dateValue?: object;

    /**
     * if set, the entered value is a valid date. If not set the entered value cannot be converted to a date.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DateTimeInput#change event.
   */
  export type DateTimeInput$ChangeEvent = Event<
    DateTimeInput$ChangeEventParameters,
    DateTimeInput
  >;
}

declare module "sap/m/DateTimePicker" {
  import { default as DatePicker, $DatePickerSettings } from "sap/m/DatePicker";

  import { AccessibilityInfo } from "sap/ui/core/library";

  import UI5Date from "sap/ui/core/date/UI5Date";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Enables the users to select date (between 0001-01-01 and 9999-12-31) and time values in a combined input.
   *
   * Overview:
   *
   * The `DateTimePicker` control consists of two parts: the input field and the date/time picker.
   *
   * **Note:** The application developer should add dependency to `sap.ui.unified` library on application
   * level to ensure that the library is loaded before the module dependencies will be required. The {@link sap.ui.unified.Calendar }
   * is used internally only if the `DateTimePicker` is opened (not used for the initial rendering). If the
   * `sap.ui.unified` library is not loaded before the `DateTimePicker` is opened, it will be loaded upon
   * opening. This could lead to CSP compliance issues and adds an additional waiting time when the `DateTimePicker`
   * is opened for the first time. To prevent this, apps using the `DateTimePicker` should also load the `sap.ui.unified`
   * library in advance.
   *
   * Usage:
   *
   * Use this control if you need a combined date and time input control.
   *
   * Don't use it if you want to use either a date or a time value. In this case, use the {@link sap.m.DatePicker }
   * or the {@link sap.m.TimePicker} controls instead.
   *
   * The user can enter a date by:
   * 	 - Using the calendar or a time selector that opens in a popup
   * 	 - Typing it in directly in the input field
   *
   * On app level, there are two options to provide a date for the `DateTimePicker` - as a string to the `value`
   * property or as a UI5Date or JavaScript Date object to the `dateValue` property (only one of these properties
   * should be used at a time):
   *
   *
   * 	 - Use the `value` property if you want to bind the `DateTimePicker` to a model using the `sap.ui.model.type.DateTime`
   *      binding the `value` property by using types
   * ```javascript
   *
   * new sap.ui.model.json.JSONModel({date: sap.ui.core.date.UI5Date.getInstance(2022,10,10,12,10,10)});
   *
   * new sap.m.DateTimePicker({
   *     value: {
   *         type: "sap.ui.model.type.DateTime",
   *         path: "/date"
   *     }
   * });
   * ```
   *
   * 	 - Use the `value` property if the date is provided as a string from the backend or inside the app (for
   *     example, as ABAP type DATS field)  binding the `value` property by using types
   * ```javascript
   *
   * new sap.ui.model.json.JSONModel({date:"2022-11-10-12-10-10"});
   *
   * new sap.m.DateTimePicker({
   *     value: {
   *         type: "sap.ui.model.type.DateTime",
   *         path: "/date",
   *         formatOptions: {
   *             source: {
   *                 pattern: "yyyy-MM-dd-HH-mm-ss"
   *             }
   *          }
   *     }
   * });
   * ```
   *  **Note:** There are multiple binding type choices, such as: sap.ui.model.type.Date sap.ui.model.odata.type.DateTime
   * sap.ui.model.odata.type.DateTimeOffset sap.ui.model.odata.type.DateTimeWithTimezone See {@link sap.ui.model.type.Date},
   * {@link sap.ui.model.odata.type.DateTime}, {@link sap.ui.model.odata.type.DateTimeOffset} or {@link sap.ui.model.odata.type.DateTimeWithTimezone}
   *
   *
   * 	 - Use the `dateValue` property if the date is already provided as a UI5Date or JavaScript Date object
   *     or you want to work with a UI5Date or JavaScript Date object. Use `dateValue` as a helper property to
   *     easily obtain the day, month, year, hours, minutes and seconds of the chosen date and time. Although
   *     it's possible to bind it, it's not recommended to do so. When binding is needed, use `value` property
   *     instead
   *
   * Formatting:
   *
   * All formatting and parsing of dates from and to strings is done using the {@link sap.ui.core.format.DateFormat}.
   * If a date is entered by typing it into the input field, it must fit to the used date format and locale.
   *
   * Supported format options are pattern-based on Unicode LDML Date Format notation. See {@link http://unicode.org/reports/tr35/#Date_Field_Symbol_Table}
   *
   * For example, if the `valueFormat` is "yyyy-MM-dd-HH-mm-ss", the `displayFormat` is "MMM d, y, HH:mm:ss",
   * and the used locale is English, a valid value string is "2015-07-30-10-30-15", which leads to an output
   * of "Jul 30, 2015, 10:30:15".
   *
   * If no placeholder is set to the `DateTimePicker`, the used `displayFormat` is displayed as a placeholder.
   * If another placeholder is needed, it must be set.
   *
   * **Note:** If the string does NOT match the `displayFormat` (from user input) or the `valueFormat` (on
   * app level), the {@link sap.ui.core.format.DateFormat} makes an attempt to parse it based on the locale
   * settings. For more information, see the respective documentation in the API Reference.
   *
   * Responsive behavior:
   *
   * The `DateTimePicker` is responsive and fully adapts to all devices. For larger screens, such as tablet
   * or desktop, it opens as a popover. For mobile devices, it opens in full screen.
   *
   * @since 1.38.0
   */
  export default class DateTimePicker extends DatePicker {
    /**
     * Constructor for a new `DateTimePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/datetime-picker/ Date/Time Picker}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimePickerSettings
    );
    /**
     * Constructor for a new `DateTimePicker`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/datetime-picker/ Date/Time Picker}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DateTimePickerSettings
    );

    /**
     * Creates a new subclass of class sap.m.DateTimePicker with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.DatePicker.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DateTimePicker>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DateTimePicker.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Current accessibility state of the control
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * This method should not be used because it could produce unpredictable results. Use `getValue()` instead.
     *
     * @since 1.102
     *
     * @returns date instance
     */
    getDateValue(): Date | UI5Date;
    /**
     * Apply the correct icon to the used Date control
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    getIconSrc(): void;
    /**
     * Gets current value of property {@link #getMinutesStep minutesStep}.
     *
     * Sets the minutes step. If the step is less than 1, it will be automatically converted back to 1. The
     * minutes clock is populated only by multiples of the step.
     *
     * Default value is `1`.
     *
     * @since 1.56
     *
     * @returns Value of property `minutesStep`
     */
    getMinutesStep(): int;
    /**
     * Gets current value of property {@link #getSecondsStep secondsStep}.
     *
     * Sets the seconds step. If the step is less than 1, it will be automatically converted back to 1. The
     * seconds clock is populated only by multiples of the step.
     *
     * Default value is `1`.
     *
     * @since 1.56
     *
     * @returns Value of property `secondsStep`
     */
    getSecondsStep(): int;
    /**
     * Gets current value of property {@link #getShowCurrentTimeButton showCurrentTimeButton}.
     *
     * Determines whether there is a shortcut navigation to current time.
     *
     * Default value is `false`.
     *
     * @since 1.98
     *
     * @returns Value of property `showCurrentTimeButton`
     */
    getShowCurrentTimeButton(): boolean;
    /**
     * Gets current value of property {@link #getShowFooter showFooter}.
     *
     * This property is inherited from `DatePicker` but its usage makes no sense in `DateTimePicker` because
     * `DateTimePicker` always have footer with buttons. Additionally, the setter for this property is overriden
     * to deny changing its value.
     *
     * Default value is `false`.
     *
     * @since 1.70
     *
     * @returns Value of property `showFooter`
     */
    getShowFooter(): boolean;
    /**
     * Gets current value of property {@link #getShowTimezone showTimezone}.
     *
     * Determines whether to show the timezone or not.
     *
     * @since 1.99
     *
     * @returns Value of property `showTimezone`
     */
    getShowTimezone(): boolean;
    /**
     * Gets current value of property {@link #getTimezone timezone}.
     *
     * The IANA timezone ID, e.g `"Europe/Berlin"`. For display purposes only in combination with `showTimezone`
     * property. The `value` property is a string representation of a date and time and is not related to the
     * displayed time zone. The `dateValue` property should not be used as this could lead to unpredictable
     * results. Use `getValue()` instead.
     *
     * @since 1.99
     *
     * @returns Value of property `timezone`
     */
    getTimezone(): string;
    /**
     * Set maximum date that can be shown and selected in the `DateTimePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMaxDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Set minimum date that can be shown and selected in the `DateTimePicker`. This must be a UI5Date or JavaScript
     * Date object.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setMinDate(
      /**
       * A date instance
       */
      oDate: Date | UI5Date
    ): this;
    /**
     * Sets a new value for property {@link #getMinutesStep minutesStep}.
     *
     * Sets the minutes step. If the step is less than 1, it will be automatically converted back to 1. The
     * minutes clock is populated only by multiples of the step.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @since 1.56
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinutesStep(
      /**
       * New value for property `minutesStep`
       */
      iMinutesStep?: int
    ): this;
    /**
     * Sets a new value for property {@link #getSecondsStep secondsStep}.
     *
     * Sets the seconds step. If the step is less than 1, it will be automatically converted back to 1. The
     * seconds clock is populated only by multiples of the step.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1`.
     *
     * @since 1.56
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSecondsStep(
      /**
       * New value for property `secondsStep`
       */
      iSecondsStep?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowCurrentTimeButton showCurrentTimeButton}.
     *
     * Determines whether there is a shortcut navigation to current time.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.98
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowCurrentTimeButton(
      /**
       * New value for property `showCurrentTimeButton`
       */
      bShowCurrentTimeButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowTimezone showTimezone}.
     *
     * Determines whether to show the timezone or not.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.99
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowTimezone(
      /**
       * New value for property `showTimezone`
       */
      bShowTimezone: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTimezone timezone}.
     *
     * The IANA timezone ID, e.g `"Europe/Berlin"`. For display purposes only in combination with `showTimezone`
     * property. The `value` property is a string representation of a date and time and is not related to the
     * displayed time zone. The `dateValue` property should not be used as this could lead to unpredictable
     * results. Use `getValue()` instead.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.99
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTimezone(
      /**
       * New value for property `timezone`
       */
      sTimezone: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DateTimePicker constructor.
   */
  export interface $DateTimePickerSettings extends $DatePickerSettings {
    /**
     * Sets the minutes step. If the step is less than 1, it will be automatically converted back to 1. The
     * minutes clock is populated only by multiples of the step.
     *
     * @since 1.56
     */
    minutesStep?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets the seconds step. If the step is less than 1, it will be automatically converted back to 1. The
     * seconds clock is populated only by multiples of the step.
     *
     * @since 1.56
     */
    secondsStep?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether there is a shortcut navigation to current time.
     *
     * @since 1.98
     */
    showCurrentTimeButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether to show the timezone or not.
     *
     * @since 1.99
     */
    showTimezone?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The IANA timezone ID, e.g `"Europe/Berlin"`. For display purposes only in combination with `showTimezone`
     * property. The `value` property is a string representation of a date and time and is not related to the
     * displayed time zone. The `dateValue` property should not be used as this could lead to unpredictable
     * results. Use `getValue()` instead.
     *
     * @since 1.99
     */
    timezone?: string | PropertyBindingInfo;

    /**
     * This property is inherited from `DatePicker` but its usage makes no sense in `DateTimePicker` because
     * `DateTimePicker` always have footer with buttons. Additionally, the setter for this property is overriden
     * to deny changing its value.
     *
     * @since 1.70
     */
    showFooter?: boolean | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/Dialog" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    PopupInterface,
    ID,
    CSSSize,
    URI,
    ValueState,
  } from "sap/ui/core/library";

  import Button from "sap/m/Button";

  import Event from "sap/ui/base/Event";

  import { IBar, TitleAlignment, DialogType } from "sap/m/library";

  import Toolbar from "sap/m/Toolbar";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * A popup that interrupts the current processing and prompts the user for an action or an input in a modal
   * mode. Overview: The Dialog control is used to prompt the user for an action or a confirmation. It interrupts
   * the current app processing as it is the only focused UI element and the main screen is dimmed/blocked.
   * The content of the Dialog is fully customizable. Structure: A Dialog consists of a title, optional subtitle,
   * content area and a footer for action buttons. The Dialog is usually displayed at the center of the screen.
   * Its size and position can be changed by the user. To enable this, you need to set the properties `resizable`
   * and `draggable` accordingly. In that case the dialog title bar can be focused. While the keyboard focus
   * is located on the title bar, the dialog can be moved with the arrow keys and resized with shift+arrow
   * keys.
   *
   * There are other specialized types of dialogs:
   * 	 - {@link sap.m.P13nDialog Personalization Dialog} - used for personalizing sorting, filtering and grouping
   *     in tables
   * 	 - {@link sap.m.SelectDialog Select Dialog} - used to select one or more items from a comprehensive
   *     list
   * 	 - {@link sap.m.TableSelectDialog Table Select Dialog} - used to make a selection from a comprehensive
   *     table containing multiple attributes or values
   * 	 - {@link sap.ui.comp.valuehelpdialog.ValueHelpDialog Value Help Dialog} - used to help the user find
   *     and select single and multiple values
   * 	 - {@link sap.m.ViewSettingsDialog View Settings Dialog} - used to sort, filter, or group data within
   *     a (master) list or a table
   * 	 - {@link sap.m.BusyDialog Busy Dialog} - used to block the screen and inform the user about an ongoing
   *     operation  Usage: When to use::
   * 	 - You want to display a system message.
   * 	 - You want to interrupt the user’s action.
   * 	 - You want to show a message with a short and a long description.  When not to use::
   * 	 - You just want to confirm a successful action.  Responsive Behavior:
   * 	 - If the `stretch` property is set to `true`, the Dialog displays on full screen.
   * 	 - If the `contentWidth` and/or `contentHeight` properties are set, the Dialog will try to fill those
   *     sizes.
   * 	 - If there is no specific sizing, the Dialog will try to adjust its size to its content.  When
   *     using the `sap.m.Dialog` in SAP Quartz and Horizon themes, the breakpoints and layout paddings could
   *     be determined by the Dialog's width. To enable this concept and add responsive paddings to an element
   *     of the Dialog control, you have to add the following classes depending on your use case: `sapUiResponsivePadding--header`,
   *     `sapUiResponsivePadding--subHeader`, `sapUiResponsivePadding--content`, `sapUiResponsivePadding--footer`.
   *     Smartphones: If the Dialog has one or two actions, they will cover the entire footer. If there are more
   *     actions, they will overflow. Tablets: The action buttons in the toolbar are **right-aligned**. Use **cozy**
   *     mode on tablet devices. Desktop: The action buttons in the toolbar are **right-aligned**. Use **compact**
   *     mode on desktop.
   */
  export default class Dialog extends Control implements PopupInterface {
    __implements__sap_ui_core_PopupInterface: boolean;
    /**
     * Constructor for a new Dialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/dialog/ Dialog}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DialogSettings
    );
    /**
     * Constructor for a new Dialog.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:https://experience.sap.com/fiori-design-web/dialog/ Dialog}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DialogSettings
    );

    /**
     * Creates a new subclass of class sap.m.Dialog with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, Dialog>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.Dialog.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Returns the custom header instance when the `customHeader` aggregation is set. Otherwise, it returns
     * the internal managed header instance. This method can be called within composite controls which use `sap.m.Dialog`
     * inside.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    _getAnyHeader(): void;
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some button to the aggregation {@link #getButtons buttons}.
     *
     * @since 1.21.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addButton(
      /**
       * The button to add; if empty, nothing is inserted
       */
      oButton: Button
    ): this;
    /**
     * Adds some content to the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addContent(
      /**
       * The content to add; if empty, nothing is inserted
       */
      oContent: Control
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired after the Dialog is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$AfterCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterClose afterClose} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired after the Dialog is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$AfterCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired after the Dialog is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:afterOpen afterOpen} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired after the Dialog is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachAfterOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired before the Dialog is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeClose beforeClose} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired before the Dialog is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired before the Dialog is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:beforeOpen beforeOpen} event of this `sap.m.Dialog`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.Dialog` itself.
     *
     * This event will be fired before the Dialog is opened.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachBeforeOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.Dialog` itself
       */
      oListener?: object
    ): this;
    /**
     * Close the dialog.
     *
     *
     * @returns `this` to allow method chaining
     */
    close(): this;
    /**
     * Destroys the beginButton in the aggregation {@link #getBeginButton beginButton}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyBeginButton(): this;
    /**
     * Destroys all the buttons in the aggregation {@link #getButtons buttons}.
     *
     * @since 1.21.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyButtons(): this;
    /**
     * Destroys all the content in the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyContent(): this;
    /**
     * Destroys the customHeader in the aggregation {@link #getCustomHeader customHeader}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomHeader(): this;
    /**
     * Destroys the endButton in the aggregation {@link #getEndButton endButton}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyEndButton(): this;
    /**
     * Destroys the footer in the aggregation {@link #getFooter footer}.
     *
     * @since 1.110
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyFooter(): this;
    /**
     * Destroys the subHeader in the aggregation {@link #getSubHeader subHeader}.
     *
     * @since 1.12.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroySubHeader(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterClose afterClose} event of this `sap.m.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Dialog$AfterCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:afterOpen afterOpen} event of this `sap.m.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachAfterOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeClose beforeClose} event of this `sap.m.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Dialog$BeforeCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:beforeOpen beforeOpen} event of this `sap.m.Dialog`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachBeforeOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:afterClose afterClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Dialog$AfterCloseEventParameters
    ): this;
    /**
     * Fires event {@link #event:afterOpen afterOpen} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireAfterOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:beforeClose beforeClose} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: Dialog$BeforeCloseEventParameters
    ): boolean;
    /**
     * Fires event {@link #event:beforeOpen beforeOpen} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireBeforeOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): boolean;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets content of aggregation {@link #getBeginButton beginButton}.
     *
     * The button which is rendered to the left side (right side in RTL mode) of the `endButton` in the footer
     * area inside the Dialog. As of version 1.21.1, there's a new aggregation `buttons` created with which
     * more than 2 buttons can be added to the footer area of the Dialog. If the new `buttons` aggregation is
     * set, any change made to this aggregation has no effect anymore. With the Belize themes when running on
     * a phone, this `button` (and the `endButton` together when set) is (are) rendered at the center of the
     * footer area. While with the Quartz themes when running on a phone, this `button` (and the `endButton`
     * together when set) is (are) rendered on the right side of the footer area. When running on other platforms,
     * this `button` (and the `endButton` together when set) is (are) rendered at the right side (left side
     * in RTL mode) of the footer area.
     *
     * @since 1.15.1
     */
    getBeginButton(): Button;
    /**
     * Gets content of aggregation {@link #getButtons buttons}.
     *
     * Buttons can be added to the footer area of the Dialog through this aggregation. When this aggregation
     * is set, any change to the `beginButton` and `endButton` has no effect anymore. Buttons which are inside
     * this aggregation are aligned at the right side (left side in RTL mode) of the footer instead of in the
     * middle of the footer. The buttons aggregation can not be used together with the footer aggregation.
     *
     * @since 1.21.1
     */
    getButtons(): Button[];
    /**
     * Gets current value of property {@link #getCloseOnNavigation closeOnNavigation}.
     *
     * Indicates whether the Dialog will be closed automatically when a routing navigation occurs.
     *
     * Default value is `true`.
     *
     * @since 1.72
     *
     * @returns Value of property `closeOnNavigation`
     */
    getCloseOnNavigation(): boolean;
    /**
     * Gets content of aggregation {@link #getContent content}.
     *
     * The content inside the Dialog.
     * **Note:** When the content of the Dialog is comprised of controls that use `position: absolute`, such
     * as `SplitContainer`, the Dialog has to have either `stretch: true` or `contentHeight` set.
     */
    getContent(): Control[];
    /**
     * Gets current value of property {@link #getContentHeight contentHeight}.
     *
     * Preferred height of the content in the Dialog. If the preferred height is bigger than the available space
     * on a screen, it will be overwritten by the maximum available height on a screen in order to make sure
     * that the Dialog isn't cut off.
     *
     * @since 1.12.1
     *
     * @returns Value of property `contentHeight`
     */
    getContentHeight(): CSSSize;
    /**
     * Gets current value of property {@link #getContentWidth contentWidth}.
     *
     * Preferred width of the content in the Dialog. This property affects the width of the Dialog on a phone
     * in landscape mode, a tablet or a desktop, because the Dialog has a fixed width on a phone in portrait
     * mode. If the preferred width is less than the minimum width of the Dialog or more than the available
     * width of the screen, it will be overwritten by the min or max value. The current mininum value of the
     * Dialog width on tablet is 400px.
     *
     * @since 1.12.1
     *
     * @returns Value of property `contentWidth`
     */
    getContentWidth(): CSSSize;
    /**
     * Gets content of aggregation {@link #getCustomHeader customHeader}.
     *
     * When it is set, the `icon`, `title` and `showHeader` properties are ignored. Only the `customHeader`
     * is shown as the header of the Dialog.
     * **Note:** To improve accessibility, titles with heading level `H1` should be used inside the custom header.
     *
     * @since 1.15.1
     */
    getCustomHeader(): IBar;
    /**
     * Gets current value of property {@link #getDraggable draggable}.
     *
     * Indicates whether the Dialog is draggable. If this property is set to `true`, the Dialog will be draggable
     * by its header. This property has a default value `false`. The Dialog can be draggable only in desktop
     * mode.
     *
     * Default value is `false`.
     *
     * @since 1.30
     *
     * @returns Value of property `draggable`
     */
    getDraggable(): boolean;
    /**
     * Gets content of aggregation {@link #getEndButton endButton}.
     *
     * The button which is rendered to the right side (left side in RTL mode) of the `beginButton` in the footer
     * area inside the Dialog. As of version 1.21.1, there's a new aggregation `buttons` created with which
     * more than 2 buttons can be added to the footer area of Dialog. If the new `buttons` aggregation is set,
     * any change made to this aggregation has no effect anymore. With the Belize themes when running on a phone,
     * this `button` (and the `beginButton` together when set) is (are) rendered at the center of the footer
     * area. While with the Quartz themes when running on a phone, this `button` (and the `beginButton` together
     * when set) is (are) rendered on the right side of the footer area. When running on other platforms, this
     * `button` (and the `beginButton` together when set) is (are) rendered at the right side (left side in
     * RTL mode) of the footer area.
     *
     * @since 1.15.1
     */
    getEndButton(): Button;
    /**
     * Gets current value of property {@link #getEscapeHandler escapeHandler}.
     *
     * This property allows to define custom behavior if the Escape key is pressed. By default, the Dialog is
     * closed.
     *  The property expects a function with one object parameter with `resolve` and `reject` properties. In
     * the function, either call `resolve` to close the dialog or call `reject` to prevent it from being closed.
     *
     * @since 1.44
     *
     * @returns Value of property `escapeHandler`
     */
    getEscapeHandler(): EscapeHandler;
    /**
     * Gets content of aggregation {@link #getFooter footer}.
     *
     * The footer of this dialog. It is always located at the bottom of the dialog. The footer aggregation can
     * not be used together with the buttons aggregation.
     *
     * @since 1.110
     */
    getFooter(): Toolbar;
    /**
     * Gets current value of property {@link #getHorizontalScrolling horizontalScrolling}.
     *
     * Indicates if the user can scroll horizontally inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of the property.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Value of property `horizontalScrolling`
     */
    getHorizontalScrolling(): boolean;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon displayed in the Dialog header. This `icon` is invisible on the iOS platform and it is density-aware.
     * You can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density
     * screen.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * ID of the element which is the current target of the association {@link #getInitialFocus initialFocus},
     * or `null`.
     *
     * @since 1.15.0
     */
    getInitialFocus(): ID | null;
    /**
     * ID of the element which is the current target of the association {@link #getLeftButton leftButton}, or
     * `null`.
     *
     * @deprecated As of version 1.15.1. `LeftButton` has been deprecated since 1.15.1. Please use the `beginButton`
     * instead which is more RTL friendly.
     */
    getLeftButton(): ID | null;
    /**
     * Gets current value of property {@link #getResizable resizable}.
     *
     * Indicates whether the Dialog is resizable. If this property is set to `true`, the Dialog will have a
     * resize handler in its bottom right corner. This property has a default value `false`. The Dialog can
     * be resizable only in desktop mode.
     *
     * Default value is `false`.
     *
     * @since 1.30
     *
     * @returns Value of property `resizable`
     */
    getResizable(): boolean;
    /**
     * ID of the element which is the current target of the association {@link #getRightButton rightButton},
     * or `null`.
     *
     * @deprecated As of version 1.15.1. `RightButton` has been deprecated since 1.15.1. Please use the `endButton`
     * instead which is more RTL friendly.
     */
    getRightButton(): ID | null;
    /**
     * Gets current value of property {@link #getShowHeader showHeader}.
     *
     * Determines whether the header is shown inside the Dialog. If this property is set to `false`, the `text`
     * and `icon` properties are ignored. This property has a default value `true`.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Value of property `showHeader`
     */
    getShowHeader(): boolean;
    /**
     * Gets current value of property {@link #getState state}.
     *
     * Affects the `icon` and the `title` color.
     *
     * If a value other than `None` is set, a predefined icon will be added to the Dialog. Setting the `icon`
     * property will overwrite the predefined icon.
     *
     * Default value is `None`.
     *
     * @since 1.11.2
     *
     * @returns Value of property `state`
     */
    getState(): ValueState;
    /**
     * Gets current value of property {@link #getStretch stretch}.
     *
     * Determines if the Dialog will be stretched to full screen on mobile. On desktop, the Dialog will be stretched
     * to approximately 90% of the viewport. This property is only applicable to a Standard Dialog. Message-type
     * Dialog ignores it.
     *
     * Default value is `false`.
     *
     * @since 1.13.1
     *
     * @returns Value of property `stretch`
     */
    getStretch(): boolean;
    /**
     * Gets current value of property {@link #getStretchOnPhone stretchOnPhone}.
     *
     * Determines whether the Dialog will be displayed on full screen on a phone.
     *
     * Default value is `false`.
     *
     * @since 1.11.2
     * @deprecated As of version 1.13.1. Please use the new stretch property instead. This enables a stretched
     * Dialog even on tablet and desktop. If you want to achieve the same effect as `stretchOnPhone`, please
     * set the stretch with `Device.system.phone`, then the Dialog is only stretched when it runs on a phone.
     *
     * @returns Value of property `stretchOnPhone`
     */
    getStretchOnPhone(): boolean;
    /**
     * Gets content of aggregation {@link #getSubHeader subHeader}.
     *
     * When a `subHeader` is assigned to the Dialog, it's rendered directly after the main header in the Dialog.
     * The `subHeader` is out of the content area and won't be scrolled when the content size is bigger than
     * the content area size.
     *
     * @since 1.12.2
     */
    getSubHeader(): IBar;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Title text appears in the Dialog header.
     * **Note:** The heading level of the Dialog is `H1`. Headings in the Dialog content should start with `H2`
     * heading level.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * Default value is `Auto`.
     *
     * @since 1.72
     *
     * @returns Value of property `titleAlignment`
     */
    getTitleAlignment(): TitleAlignment;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * The `type` of the Dialog. In some themes, the type Message will limit the Dialog width within 480px on
     * tablet and desktop.
     *
     * Default value is `Standard`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): DialogType;
    /**
     * Gets current value of property {@link #getVerticalScrolling verticalScrolling}.
     *
     * Indicates if the user can scroll vertically inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of this property.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Value of property `verticalScrolling`
     */
    getVerticalScrolling(): boolean;
    /**
     * Checks for the provided `sap.m.Button` in the aggregation {@link #getButtons buttons}. and returns its
     * index if found or -1 otherwise.
     *
     * @since 1.21.1
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfButton(
      /**
       * The button whose index is looked for
       */
      oButton: Button
    ): int;
    /**
     * Checks for the provided `sap.ui.core.Control` in the aggregation {@link #getContent content}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfContent(
      /**
       * The content whose index is looked for
       */
      oContent: Control
    ): int;
    /**
     * Inserts a button into the aggregation {@link #getButtons buttons}.
     *
     * @since 1.21.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertButton(
      /**
       * The button to insert; if empty, nothing is inserted
       */
      oButton: Button,
      /**
       * The `0`-based index the button should be inserted at; for a negative value of `iIndex`, the button is
       * inserted at position 0; for a value greater than the current size of the aggregation, the button is inserted
       * at the last position
       */
      iIndex: int
    ): this;
    /**
     * Inserts a content into the aggregation {@link #getContent content}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertContent(
      /**
       * The content to insert; if empty, nothing is inserted
       */
      oContent: Control,
      /**
       * The `0`-based index the content should be inserted at; for a negative value of `iIndex`, the content
       * is inserted at position 0; for a value greater than the current size of the aggregation, the content
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * The method checks if the Dialog is open.
     *
     * It returns `true` when the Dialog is currently open (this includes opening and closing animations), otherwise
     * it returns `false`.
     *
     * @since 1.9.1
     *
     * @returns Whether the dialog is open.
     */
    isOpen(): boolean;
    /**
     * Open the dialog.
     *
     *
     * @returns `this` to allow method chaining
     */
    open(): this;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getButtons buttons}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     * @since 1.21.1
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllButtons(): Button[];
    /**
     * Removes all the controls from the aggregation {@link #getContent content}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllContent(): Control[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes a button from the aggregation {@link #getButtons buttons}.
     *
     * @since 1.21.1
     *
     * @returns The removed button or `null`
     */
    removeButton(
      /**
       * The button to remove or its index or id
       */
      vButton: int | string | Button
    ): Button | null;
    /**
     * Removes a content from the aggregation {@link #getContent content}.
     *
     *
     * @returns The removed content or `null`
     */
    removeContent(
      /**
       * The content to remove or its index or id
       */
      vContent: int | string | Control
    ): Control | null;
    /**
     * Sets the aggregated {@link #getBeginButton beginButton}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setBeginButton(
      /**
       * The beginButton to set
       */
      oBeginButton: Button
    ): this;
    /**
     * Sets a new value for property {@link #getCloseOnNavigation closeOnNavigation}.
     *
     * Indicates whether the Dialog will be closed automatically when a routing navigation occurs.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.72
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCloseOnNavigation(
      /**
       * New value for property `closeOnNavigation`
       */
      bCloseOnNavigation?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getContentHeight contentHeight}.
     *
     * Preferred height of the content in the Dialog. If the preferred height is bigger than the available space
     * on a screen, it will be overwritten by the maximum available height on a screen in order to make sure
     * that the Dialog isn't cut off.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.12.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentHeight(
      /**
       * New value for property `contentHeight`
       */
      sContentHeight?: CSSSize
    ): this;
    /**
     * Sets a new value for property {@link #getContentWidth contentWidth}.
     *
     * Preferred width of the content in the Dialog. This property affects the width of the Dialog on a phone
     * in landscape mode, a tablet or a desktop, because the Dialog has a fixed width on a phone in portrait
     * mode. If the preferred width is less than the minimum width of the Dialog or more than the available
     * width of the screen, it will be overwritten by the min or max value. The current mininum value of the
     * Dialog width on tablet is 400px.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.12.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentWidth(
      /**
       * New value for property `contentWidth`
       */
      sContentWidth?: CSSSize
    ): this;
    /**
     * Sets the aggregated {@link #getCustomHeader customHeader}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCustomHeader(
      /**
       * The customHeader to set
       */
      oCustomHeader: IBar
    ): this;
    /**
     * Sets a new value for property {@link #getDraggable draggable}.
     *
     * Indicates whether the Dialog is draggable. If this property is set to `true`, the Dialog will be draggable
     * by its header. This property has a default value `false`. The Dialog can be draggable only in desktop
     * mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.30
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDraggable(
      /**
       * New value for property `draggable`
       */
      bDraggable?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getEndButton endButton}.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEndButton(
      /**
       * The endButton to set
       */
      oEndButton: Button
    ): this;
    /**
     * Sets a new value for property {@link #getEscapeHandler escapeHandler}.
     *
     * This property allows to define custom behavior if the Escape key is pressed. By default, the Dialog is
     * closed.
     *  The property expects a function with one object parameter with `resolve` and `reject` properties. In
     * the function, either call `resolve` to close the dialog or call `reject` to prevent it from being closed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.44
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEscapeHandler(
      /**
       * New value for property `escapeHandler`
       */
      sEscapeHandler?: EscapeHandler
    ): this;
    /**
     * Sets the aggregated {@link #getFooter footer}.
     *
     * @since 1.110
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setFooter(
      /**
       * The footer to set
       */
      oFooter: Toolbar
    ): this;
    /**
     * Sets a new value for property {@link #getHorizontalScrolling horizontalScrolling}.
     *
     * Indicates if the user can scroll horizontally inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of the property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHorizontalScrolling(
      /**
       * New value for property `horizontalScrolling`
       */
      bHorizontalScrolling?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon displayed in the Dialog header. This `icon` is invisible on the iOS platform and it is density-aware.
     * You can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density
     * screen.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets the associated {@link #getInitialFocus initialFocus}.
     *
     * @since 1.15.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setInitialFocus(
      /**
       * ID of an element which becomes the new target of this initialFocus association; alternatively, an element
       * instance may be given
       */
      oInitialFocus: ID | Control
    ): this;
    /**
     * Sets the associated {@link #getLeftButton leftButton}.
     *
     * @deprecated As of version 1.15.1. `LeftButton` has been deprecated since 1.15.1. Please use the `beginButton`
     * instead which is more RTL friendly.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLeftButton(
      /**
       * ID of an element which becomes the new target of this leftButton association; alternatively, an element
       * instance may be given
       */
      oLeftButton: ID | Button
    ): this;
    /**
     * Sets a new value for property {@link #getResizable resizable}.
     *
     * Indicates whether the Dialog is resizable. If this property is set to `true`, the Dialog will have a
     * resize handler in its bottom right corner. This property has a default value `false`. The Dialog can
     * be resizable only in desktop mode.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.30
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setResizable(
      /**
       * New value for property `resizable`
       */
      bResizable?: boolean
    ): this;
    /**
     * Sets the associated {@link #getRightButton rightButton}.
     *
     * @deprecated As of version 1.15.1. `RightButton` has been deprecated since 1.15.1. Please use the `endButton`
     * instead which is more RTL friendly.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRightButton(
      /**
       * ID of an element which becomes the new target of this rightButton association; alternatively, an element
       * instance may be given
       */
      oRightButton: ID | Button
    ): this;
    /**
     * Sets a new value for property {@link #getShowHeader showHeader}.
     *
     * Determines whether the header is shown inside the Dialog. If this property is set to `false`, the `text`
     * and `icon` properties are ignored. This property has a default value `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowHeader(
      /**
       * New value for property `showHeader`
       */
      bShowHeader?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getState state}.
     *
     * Affects the `icon` and the `title` color.
     *
     * If a value other than `None` is set, a predefined icon will be added to the Dialog. Setting the `icon`
     * property will overwrite the predefined icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.11.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setState(
      /**
       * New value for property `state`
       */
      sState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getStretch stretch}.
     *
     * Determines if the Dialog will be stretched to full screen on mobile. On desktop, the Dialog will be stretched
     * to approximately 90% of the viewport. This property is only applicable to a Standard Dialog. Message-type
     * Dialog ignores it.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.13.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStretch(
      /**
       * New value for property `stretch`
       */
      bStretch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStretchOnPhone stretchOnPhone}.
     *
     * Determines whether the Dialog will be displayed on full screen on a phone.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.11.2
     * @deprecated As of version 1.13.1. Please use the new stretch property instead. This enables a stretched
     * Dialog even on tablet and desktop. If you want to achieve the same effect as `stretchOnPhone`, please
     * set the stretch with `Device.system.phone`, then the Dialog is only stretched when it runs on a phone.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStretchOnPhone(
      /**
       * New value for property `stretchOnPhone`
       */
      bStretchOnPhone?: boolean
    ): this;
    /**
     * Sets the aggregated {@link #getSubHeader subHeader}.
     *
     * @since 1.12.2
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSubHeader(
      /**
       * The subHeader to set
       */
      oSubHeader: IBar
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Title text appears in the Dialog header.
     * **Note:** The heading level of the Dialog is `H1`. Headings in the Dialog content should start with `H2`
     * heading level.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTitleAlignment titleAlignment}.
     *
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @since 1.72
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitleAlignment(
      /**
       * New value for property `titleAlignment`
       */
      sTitleAlignment?: TitleAlignment | keyof typeof TitleAlignment
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * The `type` of the Dialog. In some themes, the type Message will limit the Dialog width within 480px on
     * tablet and desktop.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Standard`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: DialogType | keyof typeof DialogType
    ): this;
    /**
     * Sets a new value for property {@link #getVerticalScrolling verticalScrolling}.
     *
     * Indicates if the user can scroll vertically inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of this property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.15.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setVerticalScrolling(
      /**
       * New value for property `verticalScrolling`
       */
      bVerticalScrolling?: boolean
    ): this;
  }
  /**
   * Escape handler for sap.m.Dialog control.
   */
  export type EscapeHandler = (oHandlers: {
    /**
     * Call this function if the dialog should be closed.
     */
    resolve: () => void;
    /**
     * Call this function if the dialog should not be closed.
     */
    reject: () => void;
  }) => void;

  /**
   * Describes the settings that can be provided to the Dialog constructor.
   */
  export interface $DialogSettings extends $ControlSettings {
    /**
     * Icon displayed in the Dialog header. This `icon` is invisible on the iOS platform and it is density-aware.
     * You can use the density convention (@2, @1.5, etc.) to provide higher resolution image for higher density
     * screen.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Title text appears in the Dialog header.
     * **Note:** The heading level of the Dialog is `H1`. Headings in the Dialog content should start with `H2`
     * heading level.
     */
    title?: string | PropertyBindingInfo;

    /**
     * Determines whether the header is shown inside the Dialog. If this property is set to `false`, the `text`
     * and `icon` properties are ignored. This property has a default value `true`.
     *
     * @since 1.15.1
     */
    showHeader?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The `type` of the Dialog. In some themes, the type Message will limit the Dialog width within 480px on
     * tablet and desktop.
     */
    type?:
      | (DialogType | keyof typeof DialogType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Affects the `icon` and the `title` color.
     *
     * If a value other than `None` is set, a predefined icon will be added to the Dialog. Setting the `icon`
     * property will overwrite the predefined icon.
     *
     * @since 1.11.2
     */
    state?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Determines whether the Dialog will be displayed on full screen on a phone.
     *
     * @since 1.11.2
     * @deprecated As of version 1.13.1. Please use the new stretch property instead. This enables a stretched
     * Dialog even on tablet and desktop. If you want to achieve the same effect as `stretchOnPhone`, please
     * set the stretch with `Device.system.phone`, then the Dialog is only stretched when it runs on a phone.
     */
    stretchOnPhone?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines if the Dialog will be stretched to full screen on mobile. On desktop, the Dialog will be stretched
     * to approximately 90% of the viewport. This property is only applicable to a Standard Dialog. Message-type
     * Dialog ignores it.
     *
     * @since 1.13.1
     */
    stretch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Preferred width of the content in the Dialog. This property affects the width of the Dialog on a phone
     * in landscape mode, a tablet or a desktop, because the Dialog has a fixed width on a phone in portrait
     * mode. If the preferred width is less than the minimum width of the Dialog or more than the available
     * width of the screen, it will be overwritten by the min or max value. The current mininum value of the
     * Dialog width on tablet is 400px.
     *
     * @since 1.12.1
     */
    contentWidth?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Preferred height of the content in the Dialog. If the preferred height is bigger than the available space
     * on a screen, it will be overwritten by the maximum available height on a screen in order to make sure
     * that the Dialog isn't cut off.
     *
     * @since 1.12.1
     */
    contentHeight?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the user can scroll horizontally inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of the property.
     *
     * @since 1.15.1
     */
    horizontalScrolling?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates if the user can scroll vertically inside the Dialog when the content is bigger than the content
     * area. The Dialog detects if there's `sap.m.NavContainer`, `sap.m.Page`, `sap.m.ScrollContainer` or `sap.m.SplitContainer`
     * as a direct child added to the Dialog. If there is, the Dialog will turn off `scrolling` by setting this
     * property to `false`, automatically ignoring the existing value of this property.
     *
     * @since 1.15.1
     */
    verticalScrolling?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the Dialog is resizable. If this property is set to `true`, the Dialog will have a
     * resize handler in its bottom right corner. This property has a default value `false`. The Dialog can
     * be resizable only in desktop mode.
     *
     * @since 1.30
     */
    resizable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the Dialog is draggable. If this property is set to `true`, the Dialog will be draggable
     * by its header. This property has a default value `false`. The Dialog can be draggable only in desktop
     * mode.
     *
     * @since 1.30
     */
    draggable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * This property allows to define custom behavior if the Escape key is pressed. By default, the Dialog is
     * closed.
     *  The property expects a function with one object parameter with `resolve` and `reject` properties. In
     * the function, either call `resolve` to close the dialog or call `reject` to prevent it from being closed.
     *
     * @since 1.44
     */
    escapeHandler?: EscapeHandler | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the Dialog will be closed automatically when a routing navigation occurs.
     *
     * @since 1.72
     */
    closeOnNavigation?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies the Title alignment (theme specific). If set to `TitleAlignment.Auto`, the Title will be aligned
     * as it is set in the theme (if not set, the default value is `center`); Other possible values are `TitleAlignment.Start`
     * (left or right depending on LTR/RTL), and `TitleAlignment.Center` (centered)
     *
     * @since 1.72
     */
    titleAlignment?:
      | (TitleAlignment | keyof typeof TitleAlignment)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The content inside the Dialog.
     * **Note:** When the content of the Dialog is comprised of controls that use `position: absolute`, such
     * as `SplitContainer`, the Dialog has to have either `stretch: true` or `contentHeight` set.
     */
    content?: Control[] | Control | AggregationBindingInfo | `{${string}}`;

    /**
     * When a `subHeader` is assigned to the Dialog, it's rendered directly after the main header in the Dialog.
     * The `subHeader` is out of the content area and won't be scrolled when the content size is bigger than
     * the content area size.
     *
     * @since 1.12.2
     */
    subHeader?: IBar;

    /**
     * When it is set, the `icon`, `title` and `showHeader` properties are ignored. Only the `customHeader`
     * is shown as the header of the Dialog.
     * **Note:** To improve accessibility, titles with heading level `H1` should be used inside the custom header.
     *
     * @since 1.15.1
     */
    customHeader?: IBar;

    /**
     * The button which is rendered to the left side (right side in RTL mode) of the `endButton` in the footer
     * area inside the Dialog. As of version 1.21.1, there's a new aggregation `buttons` created with which
     * more than 2 buttons can be added to the footer area of the Dialog. If the new `buttons` aggregation is
     * set, any change made to this aggregation has no effect anymore. With the Belize themes when running on
     * a phone, this `button` (and the `endButton` together when set) is (are) rendered at the center of the
     * footer area. While with the Quartz themes when running on a phone, this `button` (and the `endButton`
     * together when set) is (are) rendered on the right side of the footer area. When running on other platforms,
     * this `button` (and the `endButton` together when set) is (are) rendered at the right side (left side
     * in RTL mode) of the footer area.
     *
     * @since 1.15.1
     */
    beginButton?: Button;

    /**
     * The button which is rendered to the right side (left side in RTL mode) of the `beginButton` in the footer
     * area inside the Dialog. As of version 1.21.1, there's a new aggregation `buttons` created with which
     * more than 2 buttons can be added to the footer area of Dialog. If the new `buttons` aggregation is set,
     * any change made to this aggregation has no effect anymore. With the Belize themes when running on a phone,
     * this `button` (and the `beginButton` together when set) is (are) rendered at the center of the footer
     * area. While with the Quartz themes when running on a phone, this `button` (and the `beginButton` together
     * when set) is (are) rendered on the right side of the footer area. When running on other platforms, this
     * `button` (and the `beginButton` together when set) is (are) rendered at the right side (left side in
     * RTL mode) of the footer area.
     *
     * @since 1.15.1
     */
    endButton?: Button;

    /**
     * Buttons can be added to the footer area of the Dialog through this aggregation. When this aggregation
     * is set, any change to the `beginButton` and `endButton` has no effect anymore. Buttons which are inside
     * this aggregation are aligned at the right side (left side in RTL mode) of the footer instead of in the
     * middle of the footer. The buttons aggregation can not be used together with the footer aggregation.
     *
     * @since 1.21.1
     */
    buttons?: Button[] | Button | AggregationBindingInfo | `{${string}}`;

    /**
     * The footer of this dialog. It is always located at the bottom of the dialog. The footer aggregation can
     * not be used together with the buttons aggregation.
     *
     * @since 1.110
     */
    footer?: Toolbar;

    /**
     * `LeftButton` is shown at the left edge of the bar in iOS, and at the right side of the bar for the other
     * platforms. Please set this to `null` if you want to remove the Left button from the bar. And the button
     * is only removed from the bar, not destroyed. When `showHeader` is set to `false`, this property will
     * be ignored. Setting `leftButton` will also set the `beginButton` internally.
     *
     * @deprecated As of version 1.15.1. `LeftButton` has been deprecated since 1.15.1. Please use the `beginButton`
     * instead which is more RTL friendly.
     */
    leftButton?: Button | string;

    /**
     * `RightButton` is always shown at the right edge of the bar. Please set this to null if you want to remove
     * the Right button from the bar. And the button is only removed from the bar, not destroyed. When `showHeader`
     * is set to false, this property will be ignored. Setting `rightButton` will also set the `endButton` internally.
     *
     * @deprecated As of version 1.15.1. `RightButton` has been deprecated since 1.15.1. Please use the `endButton`
     * instead which is more RTL friendly.
     */
    rightButton?: Button | string;

    /**
     * In the Dialog focus is set first on the `beginButton` and then on `endButton`, when available. If another
     * control needs to get the focus, set the `initialFocus` with the control which should be focused on. Setting
     * `initialFocus` to input controls doesn't open the On-Screen keyboard on mobile device as, due to browser
     * restriction, the On-Screen keyboard can't be opened with JavaScript code. The opening of On-Screen keyboard
     * must be triggered by real user action.
     *
     * @since 1.15.0
     */
    initialFocus?: Control | string;

    /**
     * Association to controls/IDs which describe this control (see WAI-ARIA attribute aria-describedby).
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Association to controls/IDs which label this control (see WAI-ARIA attribute aria-labelledby).
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * This event will be fired before the Dialog is opened.
     */
    beforeOpen?: (oEvent: Event) => void;

    /**
     * This event will be fired after the Dialog is opened.
     */
    afterOpen?: (oEvent: Event) => void;

    /**
     * This event will be fired before the Dialog is closed.
     */
    beforeClose?: (oEvent: Dialog$BeforeCloseEvent) => void;

    /**
     * This event will be fired after the Dialog is closed.
     */
    afterClose?: (oEvent: Dialog$AfterCloseEvent) => void;
  }

  /**
   * Parameters of the Dialog#afterClose event.
   */
  export interface Dialog$AfterCloseEventParameters {
    /**
     * This indicates the trigger of closing the Dialog. If the Dialog is closed by either the `beginButton`
     * or the `endButton`, the button that closes the Dialog is set to this parameter. Otherwise, the parameter
     * is set to `null`.
     */
    origin?: Button;
  }

  /**
   * Event object of the Dialog#afterClose event.
   */
  export type Dialog$AfterCloseEvent = Event<
    Dialog$AfterCloseEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#afterOpen event.
   */
  export interface Dialog$AfterOpenEventParameters {}

  /**
   * Event object of the Dialog#afterOpen event.
   */
  export type Dialog$AfterOpenEvent = Event<
    Dialog$AfterOpenEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#beforeClose event.
   */
  export interface Dialog$BeforeCloseEventParameters {
    /**
     * This indicates the trigger of closing the Dialog. If the Dialog is closed by either the `beginButton`
     * or the `endButton`, the button that closes the Dialog is set to this parameter. Otherwise, the parameter
     * is set to `null`.
     */
    origin?: Button;
  }

  /**
   * Event object of the Dialog#beforeClose event.
   */
  export type Dialog$BeforeCloseEvent = Event<
    Dialog$BeforeCloseEventParameters,
    Dialog
  >;

  /**
   * Parameters of the Dialog#beforeOpen event.
   */
  export interface Dialog$BeforeOpenEventParameters {}

  /**
   * Event object of the Dialog#beforeOpen event.
   */
  export type Dialog$BeforeOpenEvent = Event<
    Dialog$BeforeOpenEventParameters,
    Dialog
  >;
}

declare module "sap/m/DisplayListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { TextDirection } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * `sap.m.DisplayListItem` can be used to represent a label and a value.
   */
  export default class DisplayListItem extends ListItemBase {
    /**
     * Constructor for a new DisplayListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:/display-list-item/ Display List Item}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DisplayListItemSettings
    );
    /**
     * Constructor for a new DisplayListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link fiori:/display-list-item/ Display List Item}
     */
    constructor(
      /**
       * Id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DisplayListItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.DisplayListItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DisplayListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DisplayListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getLabel label}.
     *
     * Defines the label of the list item.
     *
     *
     * @returns Value of property `label`
     */
    getLabel(): string;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * Defines the value of the list item.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueTextDirection valueTextDirection}.
     *
     * Defines the `value` text directionality with enumerated options. By default, the control inherits text
     * direction from the DOM.
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Value of property `valueTextDirection`
     */
    getValueTextDirection(): TextDirection;
    /**
     * Sets a new value for property {@link #getLabel label}.
     *
     * Defines the label of the list item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLabel(
      /**
       * New value for property `label`
       */
      sLabel?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * Defines the value of the list item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueTextDirection valueTextDirection}.
     *
     * Defines the `value` text directionality with enumerated options. By default, the control inherits text
     * direction from the DOM.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     * @since 1.28.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueTextDirection(
      /**
       * New value for property `valueTextDirection`
       */
      sValueTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DisplayListItem constructor.
   */
  export interface $DisplayListItemSettings extends $ListItemBaseSettings {
    /**
     * Defines the label of the list item.
     */
    label?: string | PropertyBindingInfo;

    /**
     * Defines the value of the list item.
     */
    value?: string | PropertyBindingInfo;

    /**
     * Defines the `value` text directionality with enumerated options. By default, the control inherits text
     * direction from the DOM.
     *
     * @since 1.28.0
     */
    valueTextDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/DraftIndicator" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { DraftIndicatorState } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A draft indicator is {@link sap.m.Label}.
   *
   * @since 1.32.0
   */
  export default class DraftIndicator extends Control {
    /**
     * Constructor for a new DraftIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $DraftIndicatorSettings
    );
    /**
     * Constructor for a new DraftIndicator.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $DraftIndicatorSettings
    );

    /**
     * Creates a new subclass of class sap.m.DraftIndicator with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DraftIndicator>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DraftIndicator.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Clears the indicator state
     */
    clearDraftState(): void;
    /**
     * Gets current value of property {@link #getMinDisplayTime minDisplayTime}.
     *
     * Minimum time in milliseconds for showing the draft indicator
     *
     * Default value is `1500`.
     *
     *
     * @returns Value of property `minDisplayTime`
     */
    getMinDisplayTime(): int;
    /**
     * Gets current value of property {@link #getState state}.
     *
     * State of the indicator. Could be "Saving", "Saved" and "Clear".
     *
     * Default value is `Clear`.
     *
     *
     * @returns Value of property `state`
     */
    getState(): DraftIndicatorState;
    /**
     * Sets a new value for property {@link #getMinDisplayTime minDisplayTime}.
     *
     * Minimum time in milliseconds for showing the draft indicator
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `1500`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMinDisplayTime(
      /**
       * New value for property `minDisplayTime`
       */
      iMinDisplayTime?: int
    ): this;
    /**
     * Sets a new value for property {@link #getState state}.
     *
     * State of the indicator. Could be "Saving", "Saved" and "Clear".
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Clear`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setState(
      /**
       * New value for property `state`
       */
      sState?: DraftIndicatorState | keyof typeof DraftIndicatorState
    ): this;
    /**
     * Sets the indicator in "Saved" state
     */
    showDraftSaved(): void;
    /**
     * Sets the indicator in "Saving..." state
     */
    showDraftSaving(): void;
  }
  /**
   * Describes the settings that can be provided to the DraftIndicator constructor.
   */
  export interface $DraftIndicatorSettings extends $ControlSettings {
    /**
     * State of the indicator. Could be "Saving", "Saved" and "Clear".
     */
    state?:
      | (DraftIndicatorState | keyof typeof DraftIndicatorState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Minimum time in milliseconds for showing the draft indicator
     */
    minDisplayTime?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/DynamicDate" {
  import SimpleType from "sap/ui/model/SimpleType";

  import Metadata from "sap/ui/base/Metadata";

  /**
   * This class represents the dynamic date range type. Model values should be in the following format: {
   * operator: "KEY", values: [param1, param2] }. Where the supported parameters are timestamps, month indexes
   * and numbers (all three are numbers). Their type is defined by the corresponding DynamicDateOption instance
   * identified by the same "KEY". This class is capable of formatting only the value parameters expected
   * by the DynamicDateRange control. A display format may be provided via the format options.
   *
   * @since 1.92
   */
  export default class DynamicDate extends SimpleType {
    /**
     * Constructor for a dynamic date range type.
     */
    constructor(
      /**
       * Format options. There are format options for each of the supported types of value parameters.
       */
      oFormatOptions?: {
        /**
         * Display format options for the values that contain dates. For a list of all available options, see {@link sap.ui.core.format.DateFormat.getDateInstance DateFormat}.
         */
        date?: object;
        /**
         * Display format options for the values that contain month names. The only supported option is the `pattern`
         * using the respective symbols for displaying months "MM", "MMM" or "MMMM".
         */
        month?: object;
        /**
         * Display format options for the values that contain numbers. For a list of all available options, see
         * {@link sap.ui.core.format.NumberFormat.getInstance NumberFormat}.
         */
        int?: object;
      },
      /**
       * Value constraints
       */
      oConstraints?: {
        /**
         * Smallest resulting date allowed for this type. Must be provided as a timestamps.
         */
        minimum?: int;
        /**
         * Greatest resulting date allowed for this type. Must be provided as a timestamps.
         */
        maximum?: int;
      }
    );

    /**
     * Creates a new subclass of class sap.m.DynamicDate with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.model.SimpleType.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DynamicDate>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DynamicDate.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): Metadata;
    /**
     * Formats the given object value to a similar object. The whole value is in the following format { operator:
     * "KEY", values: [...array with dates or numbers to be formatted]}. Only formats the 'values' part of the
     * given object. The dates are expected as 'timestamp' numbers and are converted to Javascript Date objects.
     * The numbers and strings are left untouched.
     *
     *
     * @returns A value object in a similar form
     */
    formatValue(
      /**
       * The value to be formatted
       */
      oValue: {
        operator: string;

        values: Array<number | string>;
      }
    ): {
      operator: string;

      values: Array<Date | number | string>;
    };
    /**
     * Parses the given object value to a similar object. The whole value is in the following format { operator:
     * "KEY", values: [...array with JS dates or numbers to be parsed]}. Only parses the 'values' part of the
     * given object. The dates are expected as Javascript Dates and are converted to timestamps. The numbers
     * and strings are left untouched. Special values with operator: "PARSEERROR" generate a parse exception.
     *
     *
     * @returns A value object in a similar form
     */
    parseValue(
      /**
       * The value to be parsed
       */
      oValue: {
        operator: string;

        values: Array<Date | number | string>;
      }
    ): {
      operator: string;

      values: Array<number | string | null>;
    };
  }
}

declare module "sap/m/DynamicDateFormat" {
  import { DynamicDateRangeValue } from "sap/m/library";

  import Locale from "sap/ui/core/Locale";

  /**
   * The DynamicDateFormat is a static class for formatting and parsing an array of strings in a locale-sensitive
   * manner according to a set of format options.
   */
  export default class DynamicDateFormat {
    /**
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     */
    protected constructor();

    /**
     * Get an instance of the DynamicDateFormat which can be used for formatting.
     *
     *
     * @returns Instance of the DynamicDateFormat
     */
    static getInstance(
      /**
       * Object which defines the format options
       */
      oFormatOptions?: DynamicDateFormatOptions,
      /**
       * Locale to get the formatter for
       */
      oLocale?: Locale
    ): DynamicDateFormat;
    /**
     * Get an instance of the DynamicDateFormat which can be used for formatting.
     *
     *
     * @returns Instance of the DynamicDateFormat
     */
    static getInstance(
      /**
       * Locale to get the formatter for
       */
      oLocale?: Locale
    ): DynamicDateFormat;
    /**
     * Formats a list according to the given format options.
     *
     *
     * @returns The formatted output value.
     */
    format(
      /**
       * The value to format
       */
      oObj: DynamicDateRangeValue,
      /**
       * If set to `true` the formatter does not format to the equivalent user-friendly string. Instead, the formatter
       * uses the specified option key and parameters.
       */
      bSkipCustomFormatting: boolean
    ): string;
    /**
     * Parses a given list string into an array.
     *
     *
     * @returns The parsed output value
     */
    parse(
      /**
       * String value to be parsed
       */
      sValue: string,
      /**
       * String value of the key we will parse for
       */
      sKey: string
    ): DynamicDateRangeValue[];
  }
  /**
   * Object which defines the format options
   *
   * @since 1.111
   */
  export type DynamicDateFormatOptions = () => object;
}

declare module "sap/m/DynamicDateOption" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import DynamicDateRange from "sap/m/DynamicDateRange";

  import Event from "sap/ui/base/Event";

  import Control from "sap/ui/core/Control";

  import { DynamicDateRangeValue } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import DynamicDateValueHelpUIType from "sap/m/DynamicDateValueHelpUIType";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A base type for the options used by the DynamicDateRange control.
   *
   * @since 1.92
   */
  export default class DynamicDateOption extends UI5Element {
    /**
     * Constructor for a new DynamicDateOption.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateOptionSettings
    );
    /**
     * Constructor for a new DynamicDateOption.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateOptionSettings
    );

    /**
     * Creates a new subclass of class sap.m.DynamicDateOption with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DynamicDateOption>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DynamicDateOption.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Creates the option's value help UI. Mainly used for custom scenarios where getValueHelpUITypes is not
     * enough to define the UI. In custom options, you can create different controls that are used by the user
     * to input data via interaction.
     *
     *
     * @returns An array with the option's value help UI controls
     */
    createValueHelpUI(
      /**
       * The control instance
       */
      oControl: DynamicDateRange,
      /**
       * A callback invoked when any of the created controls updates its value
       */
      fnControlsUpdated: (p1: Event) => void
    ): Control[];
    /**
     * Controls whether the formatted date range should be concatenated to the formatted value when displayed.
     *
     *
     * @returns True if the formatted value should be enhanced
     */
    enhanceFormattedValue(): boolean;
    /**
     * Formats the option's value to a string.
     *
     *
     * @returns A string representing this option's value
     */
    format(
      /**
       * A `sap.m.DynamicDateRangeValue`
       */
      oValue: DynamicDateRangeValue
    ): string;
    /**
     * Provides the order index of the option's group. Used for grouping within the options list inside a DynamicDateRange's
     * popup. Standard options are arranged in 6 groups - from 1 to 6. 1 - Single Dates 2 - Date Ranges 3 -
     * Weeks 4 - Months 5 - Quarters 6 - Years
     *
     *
     * @returns A group key from {@link sap.m.DynamicDateRangeGroups}
     */
    getGroup(): int | string;
    /**
     * Provides the option's group header text.
     *
     *
     * @returns A group header
     */
    getGroupHeader(): string;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * A key which identifies the option. The option produces DynamicDateRange values with operator same as
     * the option key.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Defines the option's label for the DynamicDateRange's list of options.
     *
     *
     * @returns The option's label
     */
    getText(
      /**
       * The control instance which the label may depend on
       */
      oControl: DynamicDateRange
    ): string;
    /**
     * Gets the value help controls' output values and converts them to a `sap.m.DynamicDateRangeValue`.
     *
     *
     * @returns A `sap.m.DynamicDateRangeValue`
     */
    getValueHelpOutput(
      /**
       * The control instance
       */
      oControl: DynamicDateRange
    ): DynamicDateRangeValue;
    /**
     * Defines the UI types of the option. They are used to create predefined UI for the DynamicDateRange's
     * value help dialog corresponding to this option. The types are DynamicDateValueHelpUIType instances. Their
     * possible values are "date", "datetime", "daterange", "month", "int". The created UI consists of Calendar
     * or Input controls.
     *
     *
     * @returns An array with the option's UI types
     */
    getValueHelpUITypes(
      /**
       * The control instance
       */
      oControl: DynamicDateRange
    ): DynamicDateValueHelpUIType[];
    /**
     * Gets current value of property {@link #getValueTypes valueTypes}.
     *
     * Defines the types of the option's parameters. Possible values for the array items are "date" and "int".
     * A date range is usually represented with two consecutive "date" values.
     *
     *
     * @returns Value of property `valueTypes`
     */
    getValueTypes(): string[];
    /**
     * Parses a string to a `sap.m.DynamicDateRangeValue`.
     *
     *
     * @returns This parsed value
     */
    parse(
      /**
       * An input string
       */
      sValue: string
    ): DynamicDateRangeValue;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * A key which identifies the option. The option produces DynamicDateRange values with operator same as
     * the option key.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueTypes valueTypes}.
     *
     * Defines the types of the option's parameters. Possible values for the array items are "date" and "int".
     * A date range is usually represented with two consecutive "date" values.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueTypes(
      /**
       * New value for property `valueTypes`
       */
      sValueTypes: string[]
    ): this;
    /**
     * Calculates an absolute date range from the options relative value.
     *
     *
     * @returns A couple of dates marking the start and the end of the range
     */
    toDates(
      /**
       * A `sap.m.DynamicDateRangeValue`
       */
      oValue: DynamicDateRangeValue,
      /**
       * The type of calendar week numbering
       */
      sCalendarWeekNumbering: string
    ): /* was: sap.ui.core.date.UniversalDate */ any[];
    /**
     * Validates all input controls in the value help UI related to the current option. If one of the input
     * controls contains invalid value, then validation will return `false`. If all input controls contain valid
     * value, then the validation will return `true`.
     *
     *
     * @returns value help UI validity indicator
     */
    validateValueHelpUI(
      /**
       * The control instance
       */
      oControl: DynamicDateRange
    ): boolean;
  }
  /**
   * Describes the settings that can be provided to the DynamicDateOption constructor.
   */
  export interface $DynamicDateOptionSettings extends $ElementSettings {
    /**
     * A key which identifies the option. The option produces DynamicDateRange values with operator same as
     * the option key.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Defines the types of the option's parameters. Possible values for the array items are "date" and "int".
     * A date range is usually represented with two consecutive "date" values.
     */
    valueTypes?: string[] | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/DynamicDateRange" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { ID, ValueState, CSSSize } from "sap/ui/core/library";

  import DynamicDateOption from "sap/m/DynamicDateOption";

  import CalendarWeekNumbering from "sap/base/i18n/date/CalendarWeekNumbering";

  import DynamicDateFormat from "sap/m/DynamicDateFormat";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { DynamicDateRangeValue } from "sap/m/library";

  import TooltipBase from "sap/ui/core/TooltipBase";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * A control base type.
   *
   * Overview:
   *
   * The dynamic date range is a control that offers a choice of absolute and relative dates, using different
   * offset from the current date. The list of values offered must be defined by the application.
   *
   * Usage:
   *
   * The control usage is recommended when:
   * 	 - Flexibility of choosing from absolute or relative dates and date ranges.
   * 	 - The relative representation of a date should be reused. (For example, show values from today regardless
   *     of when you open the application)
   *
   * The `DynamicDateRange` control supports a number of standard options: see {@link sap.m.StandardDynamicDateRangeKeys}.
   * A custom option could be defined by extending the `sap.m.DynamicDateOption` class and adding an instance
   * of this class into the `sap.m.DynamicDateRange` customOptions aggregation. In order for a specific option
   * to be used its key should be added into the `standardOptions` property of the control. No options are
   * added by default.
   *
   * **Note:** Property binding with the `value` and `formatter` properties is not supported. Instead, you
   * should use their public getter and setter methods.
   *
   * Suggestions are available when the user types in the control input field.
   *
   * Responsive behavior:
   *
   * On mobile devices, when user taps on the `DynamicDateRange` input icon a full screen dialog is opened.
   * The dialog is closed via a date time period value selection or by pressing the "Cancel" button.
   *
   * @since 1.92.0
   */
  export default class DynamicDateRange extends Control {
    /**
     * Constructor for a new DynamicDateRange.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateRangeSettings
    );
    /**
     * Constructor for a new DynamicDateRange.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateRangeSettings
    );

    /**
     * Creates a new subclass of class sap.m.DynamicDateRange with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DynamicDateRange>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DynamicDateRange.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Returns a date range from a provided object in the format of the DynamicDateRange's value.
     *
     *
     * @returns An array of two date objects - start and end date
     */
    static toDates(
      /**
       * A `sap.m.DynamicDateRangeValue`
       */
      oValue: DynamicDateRangeValue,
      /**
       * The type of calendar week numbering
       */
      sCalendarWeekNumbering: string
    ): Date[];
    /**
     * Adds some ariaDescribedBy into the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaDescribedBy(
      /**
       * The ariaDescribedBy to add; if empty, nothing is inserted
       */
      vAriaDescribedBy: ID | Control
    ): this;
    /**
     * Adds some ariaLabelledBy into the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAriaLabelledBy(
      /**
       * The ariaLabelledBy to add; if empty, nothing is inserted
       */
      vAriaLabelledBy: ID | Control
    ): this;
    /**
     * Adds some customOption to the aggregation {@link #getCustomOptions customOptions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addCustomOption(
      /**
       * The customOption to add; if empty, nothing is inserted
       */
      oCustomOption: DynamicDateOption
    ): this;
    /**
     * Adds a group to the enumeration containing the current groups in `sap.m.DynamicDateRange`
     *
     * @since 1.118
     */
    addGroup(
      /**
       * the name that the group will be selected by.
       */
      sGroupName: string,
      /**
       * the group header that will be presented in the list.
       */
      sGroupHeader: string
    ): void;
    /**
     * Appends an option key, identifying an additional standard option to be used by the control.
     *
     * @since 1.92
     */
    addStandardOption(
      /**
       * option key
       */
      sKey: string
    ): void;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.DynamicDateRange`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DynamicDateRange` itself.
     *
     * Is fired when the text in the input field has changed and the focus leaves the input field or the Enter
     * key is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DynamicDateRange$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DynamicDateRange` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:change change} event of this `sap.m.DynamicDateRange`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.DynamicDateRange` itself.
     *
     * Is fired when the text in the input field has changed and the focus leaves the input field or the Enter
     * key is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachChange(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: DynamicDateRange$ChangeEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.DynamicDateRange` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the customOptions in the aggregation {@link #getCustomOptions customOptions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyCustomOptions(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:change change} event of this `sap.m.DynamicDateRange`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachChange(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: DynamicDateRange$ChangeEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:change change} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireChange(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: DynamicDateRange$ChangeEventParameters
    ): this;
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.92
     */
    getAriaDescribedBy(): ID[];
    /**
     * Returns array of IDs of the elements which are the current targets of the association {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     */
    getAriaLabelledBy(): ID[];
    /**
     * Gets current value of property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.111.0
     *
     * @returns Value of property `calendarWeekNumbering`
     */
    getCalendarWeekNumbering(): CalendarWeekNumbering;
    /**
     * Gets content of aggregation {@link #getCustomOptions customOptions}.
     *
     * Custom options for the `DynamicDateRange`.
     */
    getCustomOptions(): DynamicDateOption[];
    /**
     * Gets current value of property {@link #getEditable editable}.
     *
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to the non-editable
     * control, highlight it, and copy the text from it.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Value of property `editable`
     */
    getEditable(): boolean;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getEnableGroupHeaders enableGroupHeaders}.
     *
     * Disable list group headers.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Value of property `enableGroupHeaders`
     */
    getEnableGroupHeaders(): boolean;
    /**
     * Getter for the `formatter` of the control.
     *
     *
     * @returns A `sap.m.DynamicDateFormat`
     */
    getFormatter(): DynamicDateFormat;
    /**
     * Provides the option's group header text.
     *
     * @since 1.118
     *
     * @returns A group header
     */
    getGroupHeader(): string;
    /**
     * Gets current value of property {@link #getHideInput hideInput}.
     *
     * Determines whether the input field of the control is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the value help popover. In that case it can be opened
     * by another control through calling of control's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the Dynamic Date Range is not responsible for accessibility attributes of the control which
     * opens its popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Dynamic
     * Date Range"), and also aria-haspopup attribute with value of `true`.
     *
     * Default value is `false`.
     *
     * @since 1.105
     *
     * @returns Value of property `hideInput`
     */
    getHideInput(): boolean;
    /**
     * Returns the DOMNode Id to be used for the "labelFor" attribute of the label.
     *
     * By default, this is the Id of the control itself.
     *
     *
     * @returns Id to be used for the `labelFor`
     */
    getIdForLabel(): string;
    /**
     * Gets current value of property {@link #getName name}.
     *
     * Defines the name of the control for the purposes of form submission.
     *
     * @since 1.92
     *
     * @returns Value of property `name`
     */
    getName(): string;
    /**
     * Gets an option object by its key.
     *
     *
     * @returns The option
     */
    getOption(
      /**
       * The option key
       */
      sKey: string
    ): DynamicDateOption;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     *
     * @since 1.92
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getRequired required}.
     *
     * Indicates that user input is required. This property is only needed for accessibility purposes when a
     * single relationship between the field and a label (see aggregation `labelFor` of `sap.m.Label`) cannot
     * be established (e.g. one label should label multiple fields).
     *
     * Default value is `false`.
     *
     * @since 1.92
     *
     * @returns Value of property `required`
     */
    getRequired(): boolean;
    /**
     * Gets current value of property {@link #getShowClearIcon showClearIcon}.
     *
     * Specifies whether clear icon is shown. Pressing the icon will clear input's value and fire the liveChange
     * event.
     *
     * Default value is `false`.
     *
     * @since 1.117
     *
     * @returns Value of property `showClearIcon`
     */
    getShowClearIcon(): boolean;
    /**
     * Gets current value of property {@link #getStandardOptions standardOptions}.
     *
     * Array of standard option keys
     *
     * Default value is `["DATE", "TODAY", "YESTERDAY", "TOMORROW", "FIRSTDAYWEEK", "LASTDAYWEEK", "FIRSTDAYMONTH",
     * "LASTDAYMONTH", "FIRSTDAYQUARTER", "LASTDAYQUARTER", "FIRSTDAYYEAR", "LASTDAYYEAR", "DATERANGE", "DATETIMERANGE",
     * "FROM", "TO", "FROMDATETIME", "TODATETIME", "YEARTODATE", "DATETOYEAR", "LASTMINUTES", "LASTHOURS", "LASTDAYS",
     * "LASTWEEKS", "LASTMONTHS", "LASTQUARTERS", "LASTYEARS", "LASTMINUTESINCLUDED", "LASTHOURSINCLUDED", "LASTDAYSINCLUDED",
     * "LASTWEEKSINCLUDED", "LASTMONTHSINCLUDED", "LASTQUARTERSINCLUDED", "LASTYEARSINCLUDED", "NEXTMINUTES",
     * "NEXTHOURS", "NEXTDAYS", "NEXTWEEKS", "NEXTMONTHS", "NEXTQUARTERS", "NEXTYEARS", "NEXTMINUTESINCLUDED",
     * "NEXTHOURSINCLUDED", "NEXTDAYSINCLUDED", "NEXTWEEKSINCLUDED", "NEXTMONTHSINCLUDED", "NEXTQUARTERSINCLUDED",
     * "NEXTYEARSINCLUDED", "TODAYFROMTO", "THISWEEK", "LASTWEEK", "NEXTWEEK", "SPECIFICMONTH", "SPECIFICMONTHINYEAR",
     * "THISMONTH", "LASTMONTH", "NEXTMONTH", "THISQUARTER", "LASTQUARTER", "NEXTQUARTER", "QUARTER1", "QUARTER2",
     * "QUARTER3", "QUARTER4", "THISYEAR", "LASTYEAR", "NEXTYEAR", "DATETIME"]`.
     *
     * @since 1.92
     *
     * @returns Value of property `standardOptions`
     */
    getStandardOptions(): string[];
    /**
     * Getter for the `value` of the control.
     *
     *
     * @returns A `sap.m.DynamicDateRangeValue`
     */
    getValue(): DynamicDateRangeValue;
    /**
     * Gets current value of property {@link #getValueState valueState}.
     *
     * Accepts the core enumeration ValueState.type that supports `None`, `Error`, `Warning` and `Success`.
     * ValueState is managed internally only when validation is triggered by user interaction.
     *
     * Default value is `None`.
     *
     * @since 1.92
     *
     * @returns Value of property `valueState`
     */
    getValueState(): ValueState;
    /**
     * Gets current value of property {@link #getValueStateText valueStateText}.
     *
     * Defines the text that appears in the value state message popup.
     *
     * @since 1.92
     *
     * @returns Value of property `valueStateText`
     */
    getValueStateText(): string;
    /**
     * Gets current value of property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * @since 1.92
     *
     * @returns Value of property `width`
     */
    getWidth(): CSSSize;
    /**
     * Checks for the provided `sap.m.DynamicDateOption` in the aggregation {@link #getCustomOptions customOptions}.
     * and returns its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfCustomOption(
      /**
       * The customOption whose index is looked for
       */
      oCustomOption: DynamicDateOption
    ): int;
    /**
     * Inserts a customOption into the aggregation {@link #getCustomOptions customOptions}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertCustomOption(
      /**
       * The customOption to insert; if empty, nothing is inserted
       */
      oCustomOption: DynamicDateOption,
      /**
       * The `0`-based index the customOption should be inserted at; for a negative value of `iIndex`, the customOption
       * is inserted at position 0; for a value greater than the current size of the aggregation, the customOption
       * is inserted at the last position
       */
      iIndex: int
    ): this;
    /**
     * Opens the value help dialog.
     *
     * @since 1.92
     */
    open(
      /**
       * DOM reference of the opening control. On tablet or desktop, the popover is positioned relatively to this
       * control.
       */
      oDomRef: HTMLElement
    ): void;
    /**
     * Opens the value help popover. The popover is positioned relatively to the control given as `oDomRef`
     * parameter on tablet or desktop and is full screen on phone. Therefore the control parameter is only used
     * on tablet or desktop and is ignored on phone.
     *
     * Note: use this method to open the value help popover only when the `hideInput` property is set to `true`.
     * Please consider opening of the value help popover by another control only in scenarios that comply with
     * Fiori guidelines. For example, opening the value help popover by another popover is not recommended.
     * The application developer should implement the following accessibility attributes to the opening control:
     * a text or tooltip that describes the action (example: "Open Dynamic Date Range"), and aria-haspopup attribute
     * with value of `true`.
     *
     * @since 1.105
     */
    openBy(
      /**
       * DOM reference of the opening control. On tablet or desktop, the popover is positioned relatively to this
       * control.
       */
      oDomRef: HTMLElement
    ): void;
    /**
     * Removes all the controls in the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.92
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaDescribedBy(): ID[];
    /**
     * Removes all the controls in the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllAriaLabelledBy(): ID[];
    /**
     * Removes all the controls from the aggregation {@link #getCustomOptions customOptions}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllCustomOptions(): DynamicDateOption[];
    /**
     * Removes an ariaDescribedBy from the association named {@link #getAriaDescribedBy ariaDescribedBy}.
     *
     * @since 1.92
     *
     * @returns The removed ariaDescribedBy or `null`
     */
    removeAriaDescribedBy(
      /**
       * The ariaDescribedBy to be removed or its index or ID
       */
      vAriaDescribedBy: int | ID | Control
    ): ID | null;
    /**
     * Removes an ariaLabelledBy from the association named {@link #getAriaLabelledBy ariaLabelledBy}.
     *
     * @since 1.92
     *
     * @returns The removed ariaLabelledBy or `null`
     */
    removeAriaLabelledBy(
      /**
       * The ariaLabelledBy to be removed or its index or ID
       */
      vAriaLabelledBy: int | ID | Control
    ): ID | null;
    /**
     * Removes all additionally added groups
     */
    removeCustomGroups(): void;
    /**
     * Removes a customOption from the aggregation {@link #getCustomOptions customOptions}.
     *
     *
     * @returns The removed customOption or `null`
     */
    removeCustomOption(
      /**
       * The customOption to remove or its index or id
       */
      vCustomOption: int | string | DynamicDateOption
    ): DynamicDateOption | null;
    /**
     * Sets a new value for property {@link #getCalendarWeekNumbering calendarWeekNumbering}.
     *
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.111.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setCalendarWeekNumbering(
      /**
       * New value for property `calendarWeekNumbering`
       */
      sCalendarWeekNumbering?:
        | CalendarWeekNumbering
        | keyof typeof CalendarWeekNumbering
    ): this;
    /**
     * Sets a new value for property {@link #getEditable editable}.
     *
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to the non-editable
     * control, highlight it, and copy the text from it.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEditable(
      /**
       * New value for property `editable`
       */
      bEditable?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getEnableGroupHeaders enableGroupHeaders}.
     *
     * Disable list group headers.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableGroupHeaders(
      /**
       * New value for property `enableGroupHeaders`
       */
      bEnableGroupHeaders?: boolean
    ): this;
    /**
     * Setter for the `formatter` of the control.
     *
     *
     * @returns A `sap.m.DynamicDateFormat`
     */
    setFormatter(
      /**
       * A `sap.m.DynamicDateFormat`
       */
      oFormatter: DynamicDateFormat
    ): DynamicDateFormat;
    /**
     * Sets a new header to an existing custom group.
     */
    setGroupHeader(
      /**
       * the name that the group will be selected by.
       */
      sGroupName: string,
      /**
       * the group header that will be presented in the list.
       */
      sGroupHeader: string
    ): void;
    /**
     * Sets a new value for property {@link #getHideInput hideInput}.
     *
     * Determines whether the input field of the control is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the value help popover. In that case it can be opened
     * by another control through calling of control's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the Dynamic Date Range is not responsible for accessibility attributes of the control which
     * opens its popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Dynamic
     * Date Range"), and also aria-haspopup attribute with value of `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.105
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setHideInput(
      /**
       * New value for property `hideInput`
       */
      bHideInput?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getName name}.
     *
     * Defines the name of the control for the purposes of form submission.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setName(
      /**
       * New value for property `name`
       */
      sName?: string
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRequired required}.
     *
     * Indicates that user input is required. This property is only needed for accessibility purposes when a
     * single relationship between the field and a label (see aggregation `labelFor` of `sap.m.Label`) cannot
     * be established (e.g. one label should label multiple fields).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRequired(
      /**
       * New value for property `required`
       */
      bRequired?: boolean
    ): this;
    /**
     * Sets the showClearIcon for the `DynamicDateRange`.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setShowClearIcon(
      /**
       * Whether to show clear icon.
       */
      bShowClearIcon: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getStandardOptions standardOptions}.
     *
     * Array of standard option keys
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `["DATE", "TODAY", "YESTERDAY", "TOMORROW", "FIRSTDAYWEEK", "LASTDAYWEEK", "FIRSTDAYMONTH",
     * "LASTDAYMONTH", "FIRSTDAYQUARTER", "LASTDAYQUARTER", "FIRSTDAYYEAR", "LASTDAYYEAR", "DATERANGE", "DATETIMERANGE",
     * "FROM", "TO", "FROMDATETIME", "TODATETIME", "YEARTODATE", "DATETOYEAR", "LASTMINUTES", "LASTHOURS", "LASTDAYS",
     * "LASTWEEKS", "LASTMONTHS", "LASTQUARTERS", "LASTYEARS", "LASTMINUTESINCLUDED", "LASTHOURSINCLUDED", "LASTDAYSINCLUDED",
     * "LASTWEEKSINCLUDED", "LASTMONTHSINCLUDED", "LASTQUARTERSINCLUDED", "LASTYEARSINCLUDED", "NEXTMINUTES",
     * "NEXTHOURS", "NEXTDAYS", "NEXTWEEKS", "NEXTMONTHS", "NEXTQUARTERS", "NEXTYEARS", "NEXTMINUTESINCLUDED",
     * "NEXTHOURSINCLUDED", "NEXTDAYSINCLUDED", "NEXTWEEKSINCLUDED", "NEXTMONTHSINCLUDED", "NEXTQUARTERSINCLUDED",
     * "NEXTYEARSINCLUDED", "TODAYFROMTO", "THISWEEK", "LASTWEEK", "NEXTWEEK", "SPECIFICMONTH", "SPECIFICMONTHINYEAR",
     * "THISMONTH", "LASTMONTH", "NEXTMONTH", "THISQUARTER", "LASTQUARTER", "NEXTQUARTER", "QUARTER1", "QUARTER2",
     * "QUARTER3", "QUARTER4", "THISYEAR", "LASTYEAR", "NEXTYEAR", "DATETIME"]`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setStandardOptions(
      /**
       * New value for property `standardOptions`
       */
      sStandardOptions?: string[]
    ): this;
    /**
     * Sets the tooltip for the `DynamicDateRange`.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setTooltip(
      /**
       * The tooltip that should be shown.
       */
      vTooltip: TooltipBase | string
    ): this;
    /**
     * Setter for the `value` control property.
     *
     *
     * @returns Reference to `this` for method chaining
     */
    setValue(
      /**
       * A `sap.m.DynamicDateRangeValue`
       */
      oValue: DynamicDateRangeValue
    ): this;
    /**
     * Sets a new value for property {@link #getValueState valueState}.
     *
     * Accepts the core enumeration ValueState.type that supports `None`, `Error`, `Warning` and `Success`.
     * ValueState is managed internally only when validation is triggered by user interaction.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `None`.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueState(
      /**
       * New value for property `valueState`
       */
      sValueState?: ValueState | keyof typeof ValueState
    ): this;
    /**
     * Sets a new value for property {@link #getValueStateText valueStateText}.
     *
     * Defines the text that appears in the value state message popup.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueStateText(
      /**
       * New value for property `valueStateText`
       */
      sValueStateText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWidth width}.
     *
     * Defines the width of the control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @since 1.92
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWidth(
      /**
       * New value for property `width`
       */
      sWidth?: CSSSize
    ): this;
    /**
     * Calculates a date range from a provided object in the format of the DynamicDateRange's value.
     *
     *
     * @returns An array of two date objects - start and end date
     */
    toDates(
      /**
       * A `sap.m.DynamicDateRangeValue`
       */
      oValue: DynamicDateRangeValue
    ): /* was: sap.ui.core.date.UniversalDate */ any[];
  }
  /**
   * Describes the settings that can be provided to the DynamicDateRange constructor.
   */
  export interface $DynamicDateRangeSettings extends $ControlSettings {
    /**
     * Defines the width of the control.
     *
     * @since 1.92
     */
    width?: CSSSize | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates whether the user can interact with the control or not. **Note:** Disabled controls cannot be
     * focused and they are out of the tab-chain.
     *
     * @since 1.92
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Accepts the core enumeration ValueState.type that supports `None`, `Error`, `Warning` and `Success`.
     * ValueState is managed internally only when validation is triggered by user interaction.
     *
     * @since 1.92
     */
    valueState?:
      | (ValueState | keyof typeof ValueState)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the name of the control for the purposes of form submission.
     *
     * @since 1.92
     */
    name?: string | PropertyBindingInfo;

    /**
     * Defines a short hint intended to aid the user with data entry when the control has no value.
     *
     * @since 1.92
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * Defines whether the control can be modified by the user or not. **Note:** A user can tab to the non-editable
     * control, highlight it, and copy the text from it.
     *
     * @since 1.92
     */
    editable?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the text that appears in the value state message popup.
     *
     * @since 1.92
     */
    valueStateText?: string | PropertyBindingInfo;

    /**
     * Indicates that user input is required. This property is only needed for accessibility purposes when a
     * single relationship between the field and a label (see aggregation `labelFor` of `sap.m.Label`) cannot
     * be established (e.g. one label should label multiple fields).
     *
     * @since 1.92
     */
    required?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Disable list group headers.
     *
     * @since 1.92
     */
    enableGroupHeaders?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Array of standard option keys
     *
     * @since 1.92
     */
    standardOptions?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the input field of the control is hidden or visible. When set to `true`, the input
     * field becomes invisible and there is no way to open the value help popover. In that case it can be opened
     * by another control through calling of control's `openBy` method, and the opening control's DOM reference
     * must be provided as parameter.
     *
     * Note: Since the Dynamic Date Range is not responsible for accessibility attributes of the control which
     * opens its popover, those attributes should be added by the application developer. The following is recommended
     * to be added to the opening control: a text or tooltip that describes the action (example: "Open Dynamic
     * Date Range"), and also aria-haspopup attribute with value of `true`.
     *
     * @since 1.105
     */
    hideInput?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set, the calendar week numbering is used for display. If not set, the calendar week numbering of the
     * global configuration is used.
     *
     * @since 1.111.0
     */
    calendarWeekNumbering?:
      | (CalendarWeekNumbering | keyof typeof CalendarWeekNumbering)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies whether clear icon is shown. Pressing the icon will clear input's value and fire the liveChange
     * event.
     *
     * @since 1.117
     */
    showClearIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Custom options for the `DynamicDateRange`.
     */
    customOptions?:
      | DynamicDateOption[]
      | DynamicDateOption
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Association to controls / IDs that label this control (see WAI-ARIA attribute aria-labelledby).
     *
     * @since 1.92
     */
    ariaLabelledBy?: Array<Control | string>;

    /**
     * Association to controls / IDs that describe this control (see WAI-ARIA attribute aria-describedby).
     *
     * @since 1.92
     */
    ariaDescribedBy?: Array<Control | string>;

    /**
     * Is fired when the text in the input field has changed and the focus leaves the input field or the Enter
     * key is pressed.
     */
    change?: (oEvent: DynamicDateRange$ChangeEvent) => void;
  }

  /**
   * Parameters of the DynamicDateRange#change event.
   */
  export interface DynamicDateRange$ChangeEventParameters {
    /**
     * The current value of the control.
     */
    value?: object;

    /**
     * Whether the new value is valid.
     */
    valid?: boolean;
  }

  /**
   * Event object of the DynamicDateRange#change event.
   */
  export type DynamicDateRange$ChangeEvent = Event<
    DynamicDateRange$ChangeEventParameters,
    DynamicDateRange
  >;
}

declare module "sap/m/DynamicDateUtil" {
  import DynamicDateOption from "sap/m/DynamicDateOption";

  import DynamicDateFormat from "sap/m/DynamicDateFormat";

  import { DynamicDateRangeValue } from "sap/m/library";

  /**
   * The DynamicDateUtil is a utility class for working with the DynamicDateOption instances.
   *
   * @ui5-protected DO NOT USE IN APPLICATIONS (only for related classes in the framework)
   */
  interface DynamicDateUtil {
    /**
     * Adds an option to be reused as a global object.
     */
    addOption(
      /**
       * The option to be added
       */
      option: DynamicDateOption
    ): void;
    /**
     * Gets all available standard and custom dynamic date option keys.
     *
     *
     * @returns An array of all option keys
     */
    getAllOptionKeys(): string[];
    /**
     * Gets an option by its key.
     *
     *
     * @returns The option
     */
    getOption(
      /**
       * The option key
       */
      sKey: string
    ): DynamicDateOption;
    /**
     * Gets sorted array of all standard keys.
     *
     *
     * @returns An array of standard option keys
     */
    getStandardKeys(): string[];
    /**
     * Parses a string to an array of objects of type `sap.m.DynamicDateRangeValue`. Uses the provided formatter.
     *
     *
     * @returns An array of `sap.m.DynamicDateRangeValue` objects
     */
    parse(
      /**
       * The string to be parsed
       */
      sValue: string,
      /**
       * A dynamic date formatter
       */
      oFormatter: DynamicDateFormat,
      /**
       * array of option names
       */
      aOptionKeys: string[]
    ): DynamicDateRangeValue[];
    /**
     * Returns a date in machine timezone setting, removing the offset added by the application configuration.
     *
     *
     * @returns A local JS date with removed offset
     */
    removeTimezoneOffset(
      /**
       * A local JS date with added offset
       */
      oDate: Date
    ): Date;
    /**
     * Calculates a date range from a provided object in the format of the DynamicDateRange's value.
     *
     *
     * @returns An array of two date objects - start and end date
     */
    toDates(
      /**
       * The provided value
       */
      oValue: string,
      /**
       * The type of calendar week numbering
       */
      sCalendarWeekNumbering: string
    ): /* was: sap.ui.core.date.UniversalDate */ any[];
  }
  const DynamicDateUtil: DynamicDateUtil;
  export default DynamicDateUtil;
}

declare module "sap/m/DynamicDateValueHelpUIType" {
  import { default as UI5Element, $ElementSettings } from "sap/ui/core/Element";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * A class that describes the predefined value help UI type of DynamicDateRange options.
   *
   * @since 1.92
   */
  export default class DynamicDateValueHelpUIType extends UI5Element {
    /**
     * Constructor for a new DynamicDateValueHelpUIType.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateValueHelpUITypeSettings
    );
    /**
     * Constructor for a new DynamicDateValueHelpUIType.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $DynamicDateValueHelpUITypeSettings
    );

    /**
     * Creates a new subclass of class sap.m.DynamicDateValueHelpUIType with name `sClassName` and enriches
     * it with the information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Element.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, DynamicDateValueHelpUIType>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.DynamicDateValueHelpUIType.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getAdditionalText additionalText}.
     *
     * A text for an additional label that describes the interactive UI and is placed after the UI element.
     *
     *
     * @returns Value of property `additionalText`
     */
    getAdditionalText(): string;
    /**
     * Gets current value of property {@link #getIncluded included}.
     *
     * Describes if the current period is included.
     *
     *
     * @returns Value of property `included`
     */
    getIncluded(): string;
    /**
     * Gets current value of property {@link #getOptions options}.
     *
     * Options are displayed into a select element.
     *
     *
     * @returns Value of property `options`
     */
    getOptions(): string[];
    /**
     * Gets current value of property {@link #getText text}.
     *
     * A text for an additional label that describes the interactive UI and is placed before the UI element.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * One of the predefined types - "date", "daterange", "month", "int". They determine controls - calendar
     * or input.
     *
     *
     * @returns Value of property `type`
     */
    getType(): string;
    /**
     * Sets a new value for property {@link #getAdditionalText additionalText}.
     *
     * A text for an additional label that describes the interactive UI and is placed after the UI element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAdditionalText(
      /**
       * New value for property `additionalText`
       */
      sAdditionalText: string
    ): this;
    /**
     * Sets a new value for property {@link #getIncluded included}.
     *
     * Describes if the current period is included.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIncluded(
      /**
       * New value for property `included`
       */
      sIncluded?: string
    ): this;
    /**
     * Sets a new value for property {@link #getOptions options}.
     *
     * Options are displayed into a select element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOptions(
      /**
       * New value for property `options`
       */
      sOptions?: string[]
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * A text for an additional label that describes the interactive UI and is placed before the UI element.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText: string
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * One of the predefined types - "date", "daterange", "month", "int". They determine controls - calendar
     * or input.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the DynamicDateValueHelpUIType constructor.
   */
  export interface $DynamicDateValueHelpUITypeSettings
    extends $ElementSettings {
    /**
     * One of the predefined types - "date", "daterange", "month", "int". They determine controls - calendar
     * or input.
     */
    type?: string | PropertyBindingInfo;

    /**
     * A text for an additional label that describes the interactive UI and is placed before the UI element.
     */
    text?: string | PropertyBindingInfo;

    /**
     * A text for an additional label that describes the interactive UI and is placed after the UI element.
     */
    additionalText?: string | PropertyBindingInfo;

    /**
     * Options are displayed into a select element.
     */
    options?: string[] | PropertyBindingInfo | `{${string}}`;

    /**
     * Describes if the current period is included.
     */
    included?: string | PropertyBindingInfo;
  }
}

declare module "sap/m/ExpandableText" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import {
    IFormContent,
    ILabelable,
    AccessibilityInfo,
    TextAlign,
    TextDirection,
  } from "sap/ui/core/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import {
    EmptyIndicatorMode,
    ExpandableTextOverflowMode,
    WrappingType,
  } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  /**
   * The `ExpandableText` control can be used to display long texts inside a table, list or form.
   *
   * Overview: Only the first characters from the text field are shown initially and a "More" link which allows
   * the full text to be displayed. The `overflowMode` property determines if the full text will be displayed
   * expanded in place (default) or in a popover. If the text is expanded a "Less" link is displayed, which
   * allows collapsing the text field.
   *
   * Usage:
   *
   * When to use
   * 	 - You specifically have to deal with long texts/descriptions.
   *
   * When not to use
   * 	 - Do not use long texts and descriptions if you can provide short and meaningful alternatives.
   * 	 - The content is critical for the user. In this case use short descriptions that can fit in.
   *
   * @since 1.87
   */
  export default class ExpandableText
    extends Control
    implements IFormContent, ILabelable
  {
    __implements__sap_ui_core_IFormContent: boolean;
    __implements__sap_ui_core_ILabelable: boolean;
    /**
     * Constructor for a new ExpandableText.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandableTextSettings
    );
    /**
     * Constructor for a new ExpandableText.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $ExpandableTextSettings
    );

    /**
     * Creates a new subclass of class sap.m.ExpandableText with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, ExpandableText>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.ExpandableText.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Binds property {@link #getText text} to model data.
     *
     * See {@link sap.ui.base.ManagedObject#bindProperty ManagedObject.bindProperty} for a detailed description
     * of the possible properties of `oBindingInfo`
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    bindText(
      /**
       * The binding information
       */
      oBindingInfo: PropertyBindingInfo
    ): this;
    /**
     * Gets the accessibility information for the text.
     * See:
     * 	sap.ui.core.Control#getAccessibilityInfo
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Accessibility information for the text.
     */
    getAccessibilityInfo(): AccessibilityInfo;
    /**
     * Gets current value of property {@link #getEmptyIndicatorMode emptyIndicatorMode}.
     *
     * Specifies if an empty indicator should be displayed when there is no text.
     *
     * Default value is `Off`.
     *
     * @since 1.91
     *
     * @returns Value of property `emptyIndicatorMode`
     */
    getEmptyIndicatorMode(): EmptyIndicatorMode;
    /**
     * Gets current value of property {@link #getMaxCharacters maxCharacters}.
     *
     * Specifies the maximum number of characters from the beginning of the text field that are shown initially.
     *
     * Default value is `100`.
     *
     *
     * @returns Value of property `maxCharacters`
     */
    getMaxCharacters(): int;
    /**
     * Gets current value of property {@link #getOverflowMode overflowMode}.
     *
     * Determines how the full text will be displayed - InPlace or Popover
     *
     * Default value is `InPlace`.
     *
     *
     * @returns Value of property `overflowMode`
     */
    getOverflowMode(): ExpandableTextOverflowMode;
    /**
     * Gets current value of property {@link #getRenderWhitespace renderWhitespace}.
     *
     * Specifies how whitespace and tabs inside the control are handled. If true, whitespace will be preserved
     * by the browser.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `renderWhitespace`
     */
    getRenderWhitespace(): boolean;
    /**
     * Gets the text.
     *
     *
     * @returns Text value.
     */
    getText(
      /**
       * Indication for normalized text.
       */
      bNormalize?: boolean
    ): string;
    /**
     * Gets current value of property {@link #getTextAlign textAlign}.
     *
     * Sets the horizontal alignment of the text.
     *
     * Default value is `Begin`.
     *
     *
     * @returns Value of property `textAlign`
     */
    getTextAlign(): TextAlign;
    /**
     * Gets current value of property {@link #getTextDirection textDirection}.
     *
     * Available options for the text direction are left-to-right (LTR) and right-to-left (RTL) By default the
     * control inherits the text direction from its parent control.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Value of property `textDirection`
     */
    getTextDirection(): TextDirection;
    /**
     * Returns the text node container's DOM reference. This can be different from `getDomRef` when inner wrapper
     * is needed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns DOM reference of the text.
     */
    getTextDomRef(): HTMLElement | null;
    /**
     * Gets current value of property {@link #getWrappingType wrappingType}.
     *
     * Defines the type of text wrapping to be used (hyphenated or normal).
     *
     * Default value is `Normal`.
     *
     *
     * @returns Value of property `wrappingType`
     */
    getWrappingType(): WrappingType;
    /**
     * Returns if the control can be bound to a label
     *
     *
     * @returns `true` if the control can be bound to a label
     */
    hasLabelableHTMLElement(): boolean;
    /**
     * Sets a new value for property {@link #getEmptyIndicatorMode emptyIndicatorMode}.
     *
     * Specifies if an empty indicator should be displayed when there is no text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Off`.
     *
     * @since 1.91
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEmptyIndicatorMode(
      /**
       * New value for property `emptyIndicatorMode`
       */
      sEmptyIndicatorMode?: EmptyIndicatorMode | keyof typeof EmptyIndicatorMode
    ): this;
    /**
     * Sets a new value for property {@link #getMaxCharacters maxCharacters}.
     *
     * Specifies the maximum number of characters from the beginning of the text field that are shown initially.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `100`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxCharacters(
      /**
       * New value for property `maxCharacters`
       */
      iMaxCharacters?: int
    ): this;
    /**
     * Sets a new value for property {@link #getOverflowMode overflowMode}.
     *
     * Determines how the full text will be displayed - InPlace or Popover
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `InPlace`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setOverflowMode(
      /**
       * New value for property `overflowMode`
       */
      sOverflowMode?:
        | ExpandableTextOverflowMode
        | keyof typeof ExpandableTextOverflowMode
    ): this;
    /**
     * Sets a new value for property {@link #getRenderWhitespace renderWhitespace}.
     *
     * Specifies how whitespace and tabs inside the control are handled. If true, whitespace will be preserved
     * by the browser.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRenderWhitespace(
      /**
       * New value for property `renderWhitespace`
       */
      bRenderWhitespace?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Determines the text to be displayed.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTextAlign textAlign}.
     *
     * Sets the horizontal alignment of the text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Begin`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextAlign(
      /**
       * New value for property `textAlign`
       */
      sTextAlign?: TextAlign | keyof typeof TextAlign
    ): this;
    /**
     * Sets a new value for property {@link #getTextDirection textDirection}.
     *
     * Available options for the text direction are left-to-right (LTR) and right-to-left (RTL) By default the
     * control inherits the text direction from its parent control.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Inherit`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTextDirection(
      /**
       * New value for property `textDirection`
       */
      sTextDirection?: TextDirection | keyof typeof TextDirection
    ): this;
    /**
     * Sets a new value for property {@link #getWrappingType wrappingType}.
     *
     * Defines the type of text wrapping to be used (hyphenated or normal).
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Normal`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWrappingType(
      /**
       * New value for property `wrappingType`
       */
      sWrappingType?: WrappingType | keyof typeof WrappingType
    ): this;
    /**
     * Unbinds property {@link #getText text} from model data.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    unbindText(): this;
  }
  /**
   * Describes the settings that can be provided to the ExpandableText constructor.
   */
  export interface $ExpandableTextSettings extends $ControlSettings {
    /**
     * Determines the text to be displayed.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Available options for the text direction are left-to-right (LTR) and right-to-left (RTL) By default the
     * control inherits the text direction from its parent control.
     */
    textDirection?:
      | (TextDirection | keyof typeof TextDirection)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the type of text wrapping to be used (hyphenated or normal).
     */
    wrappingType?:
      | (WrappingType | keyof typeof WrappingType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Sets the horizontal alignment of the text.
     */
    textAlign?:
      | (TextAlign | keyof typeof TextAlign)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies how whitespace and tabs inside the control are handled. If true, whitespace will be preserved
     * by the browser.
     */
    renderWhitespace?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines how the full text will be displayed - InPlace or Popover
     */
    overflowMode?:
      | (ExpandableTextOverflowMode | keyof typeof ExpandableTextOverflowMode)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Specifies the maximum number of characters from the beginning of the text field that are shown initially.
     */
    maxCharacters?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies if an empty indicator should be displayed when there is no text.
     *
     * @since 1.91
     */
    emptyIndicatorMode?:
      | (EmptyIndicatorMode | keyof typeof EmptyIndicatorMode)
      | PropertyBindingInfo
      | `{${string}}`;
  }
}

declare module "sap/m/FacetFilter" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import { IShrinkable } from "sap/ui/core/library";

  import FacetFilterList from "sap/m/FacetFilterList";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { FacetFilterType } from "sap/m/library";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  /**
   * Provides filtering functionality with multiple parameters.
   *
   * Overview:
   *
   * The `FacetFilter` control is used to provide filtering functionality with multiple parameters and supports
   * the users in finding the information they need from potentially very large data sets.
   *
   * Your app can have dependencies between facets where selection of filter items in one facet list limits
   * the list of valid filters in another facet list.
   *
   * The `FacetFilter` uses {@link sap.m.FacetFilterList FacetFilterList} and {@link sap.m.FacetFilterItem FacetFilterItem }
   * to model facets and their associated filters.
   *
   * **Note: **{@link sap.m.FacetFilterList FacetFilterList} is a subclass of {@link sap.m.List} and supports
   * growing enablement feature via the property `growing`. When you use this feature, be aware that it only
   * works with one-way data binding. Having growing feature enabled when the `items` aggregation is bound
   * to a model with two-way data binding, may lead to unexpected and/or inconsistent behavior across browsers,
   * such as unexpected closing of the list.
   *
   * Usage:
   *
   * Use the `FacetFilter` if your app displays a large list of items that can be grouped by multiple parameters,
   * for example products by category and supplier. With the `FacetFilter`, you allow the users to dynamically
   * filter the list so it only displays products from the categories and suppliers they want to see.
   *
   * While the {@link sap.m.FacetFilterList} popup is opened (when the user selects a button corresponding
   * to the list's name), any other activities leading to focus change will close it. For example, when the
   * popup is opened and the app developer loads a {@link sap.m.BusyDialog} or any other dialog that obtains
   * the focus, the popup will be closed.
   *
   * Responsive behavior:
   *
   * The `FacetFilter` supports the following two types, which can be configured using the control's `type`
   * property:
   *
   *
   * 	 - Simple type (default) - only available for desktop and tablet screen sizes. The active facets are
   *     displayed as individually selectable buttons on the toolbar.
   * 	 - Light type - automatically enabled on smart phone sized devices, but also available for desktop and
   *     tablets. The active facets and selected filter items are displayed in the summary bar. When the user
   *     selects the summary bar, a navigable dialog list of all facets is displayed. When the user selects a
   *     facet, the dialog scrolls to show the list of filters that are available for the selected facet.
   *
   * Additional Information:
   *
   * For more information, go to **Developer Guide** section in the Demo Kit and navigate to **More About
   * Controls** > **sap.m** > **Facet Filter**
   */
  export default class FacetFilter extends Control implements IShrinkable {
    __implements__sap_ui_core_IShrinkable: boolean;
    /**
     * Constructor for a new `FacetFilter`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/c6c38217a4a64001a22ad76cdfa97fae Facet Filter}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterSettings
    );
    /**
     * Constructor for a new `FacetFilter`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/c6c38217a4a64001a22ad76cdfa97fae Facet Filter}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterSettings
    );

    /**
     * Creates a new subclass of class sap.m.FacetFilter with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FacetFilter>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FacetFilter.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some list to the aggregation {@link #getLists lists}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addList(
      /**
       * The list to add; if empty, nothing is inserted
       */
      oList: FacetFilterList
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:confirm confirm} event of this `sap.m.FacetFilter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilter` itself.
     *
     * Fired when the user confirms filter selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConfirm(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:confirm confirm} event of this `sap.m.FacetFilter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilter` itself.
     *
     * Fired when the user confirms filter selection.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachConfirm(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:reset reset} event of this `sap.m.FacetFilter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilter` itself.
     *
     * Fired when the Reset button is pressed to inform that all FacetFilterLists need to be reset.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `search` and `reset` event handler
     * functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachReset(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilter` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:reset reset} event of this `sap.m.FacetFilter`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilter` itself.
     *
     * Fired when the Reset button is pressed to inform that all FacetFilterLists need to be reset.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `search` and `reset` event handler
     * functions.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachReset(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilter` itself
       */
      oListener?: object
    ): this;
    /**
     * Destroys all the lists in the aggregation {@link #getLists lists}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    destroyLists(): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:confirm confirm} event of this `sap.m.FacetFilter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachConfirm(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:reset reset} event of this `sap.m.FacetFilter`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachReset(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:confirm confirm} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireConfirm(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Fires event {@link #event:reset reset} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireReset(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets content of aggregation {@link #getLists lists}.
     *
     * Collection of FacetFilterList controls.
     */
    getLists(): FacetFilterList[];
    /**
     * Gets current value of property {@link #getLiveSearch liveSearch}.
     *
     * Enables/disables live search in the search field of all `sap.m.FacetFilterList` instances.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `liveSearch`
     */
    getLiveSearch(): boolean;
    /**
     * Gets current value of property {@link #getShowPersonalization showPersonalization}.
     *
     * If set to `true` and the FacetFilter type is `Simple`, then the Add Facet icon will be displayed and
     * each facet button will also have a Facet Remove icon displayed beside it, allowing the user to deactivate
     * the facet.
     *
     * **Note:** Always set this property to `true` when your facet lists are not active, so that the user is
     * able to select them and interact with them.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showPersonalization`
     */
    getShowPersonalization(): boolean;
    /**
     * Gets current value of property {@link #getShowPopoverOKButton showPopoverOKButton}.
     *
     * If set to `true`, an OK button is displayed for every FacetFilterList popover. This button allows the
     * user to close the popover from within the popover instead of having to click outside of it.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showPopoverOKButton`
     */
    getShowPopoverOKButton(): boolean;
    /**
     * Gets current value of property {@link #getShowReset showReset}.
     *
     * Shows/hides the FacetFilter Reset button.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showReset`
     */
    getShowReset(): boolean;
    /**
     * Gets current value of property {@link #getShowSummaryBar showSummaryBar}.
     *
     * Shows the summary bar instead of the FacetFilter buttons bar when set to `true`.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showSummaryBar`
     */
    getShowSummaryBar(): boolean;
    /**
     * Gets current value of property {@link #getType type}.
     *
     * Defines the default appearance of the FacetFilter on the device. Possible values are `Simple` (default)
     * and `Light`.
     *
     * Default value is `Simple`.
     *
     *
     * @returns Value of property `type`
     */
    getType(): FacetFilterType;
    /**
     * Checks for the provided `sap.m.FacetFilterList` in the aggregation {@link #getLists lists}. and returns
     * its index if found or -1 otherwise.
     *
     *
     * @returns The index of the provided control in the aggregation if found, or -1 otherwise
     */
    indexOfList(
      /**
       * The list whose index is looked for
       */
      oList: FacetFilterList
    ): int;
    /**
     * Inserts a list into the aggregation {@link #getLists lists}.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    insertList(
      /**
       * The list to insert; if empty, nothing is inserted
       */
      oList: FacetFilterList,
      /**
       * The `0`-based index the list should be inserted at; for a negative value of `iIndex`, the list is inserted
       * at position 0; for a value greater than the current size of the aggregation, the list is inserted at
       * the last position
       */
      iIndex: int
    ): this;
    /**
     * Opens the FacetFilter dialog.
     *
     *
     * @returns this pointer for chaining
     */
    openFilterDialog(): this;
    /**
     * Removes all the controls from the aggregation {@link #getLists lists}.
     *
     * Additionally, it unregisters them from the hosting UIArea.
     *
     *
     * @returns An array of the removed elements (might be empty)
     */
    removeAllLists(): FacetFilterList[];
    /**
     * Removes a list from the aggregation {@link #getLists lists}.
     *
     *
     * @returns The removed list or `null`
     */
    removeList(
      /**
       * The list to remove or its index or id
       */
      vList: int | string | FacetFilterList
    ): FacetFilterList | null;
    /**
     * Sets a new value for property {@link #getLiveSearch liveSearch}.
     *
     * Enables/disables live search in the search field of all `sap.m.FacetFilterList` instances.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setLiveSearch(
      /**
       * New value for property `liveSearch`
       */
      bLiveSearch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPersonalization showPersonalization}.
     *
     * If set to `true` and the FacetFilter type is `Simple`, then the Add Facet icon will be displayed and
     * each facet button will also have a Facet Remove icon displayed beside it, allowing the user to deactivate
     * the facet.
     *
     * **Note:** Always set this property to `true` when your facet lists are not active, so that the user is
     * able to select them and interact with them.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPersonalization(
      /**
       * New value for property `showPersonalization`
       */
      bShowPersonalization?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowPopoverOKButton showPopoverOKButton}.
     *
     * If set to `true`, an OK button is displayed for every FacetFilterList popover. This button allows the
     * user to close the popover from within the popover instead of having to click outside of it.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowPopoverOKButton(
      /**
       * New value for property `showPopoverOKButton`
       */
      bShowPopoverOKButton?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowReset showReset}.
     *
     * Shows/hides the FacetFilter Reset button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowReset(
      /**
       * New value for property `showReset`
       */
      bShowReset?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowSummaryBar showSummaryBar}.
     *
     * Shows the summary bar instead of the FacetFilter buttons bar when set to `true`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowSummaryBar(
      /**
       * New value for property `showSummaryBar`
       */
      bShowSummaryBar?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getType type}.
     *
     * Defines the default appearance of the FacetFilter on the device. Possible values are `Simple` (default)
     * and `Light`.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Simple`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setType(
      /**
       * New value for property `type`
       */
      sType?: FacetFilterType | keyof typeof FacetFilterType
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FacetFilter constructor.
   */
  export interface $FacetFilterSettings extends $ControlSettings {
    /**
     * If set to `true` and the FacetFilter type is `Simple`, then the Add Facet icon will be displayed and
     * each facet button will also have a Facet Remove icon displayed beside it, allowing the user to deactivate
     * the facet.
     *
     * **Note:** Always set this property to `true` when your facet lists are not active, so that the user is
     * able to select them and interact with them.
     */
    showPersonalization?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the default appearance of the FacetFilter on the device. Possible values are `Simple` (default)
     * and `Light`.
     */
    type?:
      | (FacetFilterType | keyof typeof FacetFilterType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Enables/disables live search in the search field of all `sap.m.FacetFilterList` instances.
     */
    liveSearch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Shows the summary bar instead of the FacetFilter buttons bar when set to `true`.
     */
    showSummaryBar?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Shows/hides the FacetFilter Reset button.
     */
    showReset?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, an OK button is displayed for every FacetFilterList popover. This button allows the
     * user to close the popover from within the popover instead of having to click outside of it.
     */
    showPopoverOKButton?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Collection of FacetFilterList controls.
     */
    lists?:
      | FacetFilterList[]
      | FacetFilterList
      | AggregationBindingInfo
      | `{${string}}`;

    /**
     * Fired when the Reset button is pressed to inform that all FacetFilterLists need to be reset.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `search` and `reset` event handler
     * functions.
     */
    reset?: (oEvent: Event) => void;

    /**
     * Fired when the user confirms filter selection.
     */
    confirm?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FacetFilter#confirm event.
   */
  export interface FacetFilter$ConfirmEventParameters {}

  /**
   * Event object of the FacetFilter#confirm event.
   */
  export type FacetFilter$ConfirmEvent = Event<
    FacetFilter$ConfirmEventParameters,
    FacetFilter
  >;

  /**
   * Parameters of the FacetFilter#reset event.
   */
  export interface FacetFilter$ResetEventParameters {}

  /**
   * Event object of the FacetFilter#reset event.
   */
  export type FacetFilter$ResetEvent = Event<
    FacetFilter$ResetEventParameters,
    FacetFilter
  >;
}

declare module "sap/m/FacetFilterItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Represents a value for the {@link sap.m.FacetFilterList} control.
   */
  export default class FacetFilterItem extends ListItemBase {
    /**
     * Constructor for a new `FacetFilterItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/395392f30f2a4c4d80d110d5f923da77 Facet Filter Item}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterItemSettings
    );
    /**
     * Constructor for a new `FacetFilterItem`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/395392f30f2a4c4d80d110d5f923da77 Facet Filter Item}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.FacetFilterItem with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FacetFilterItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FacetFilterItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Gets current value of property {@link #getCount count}.
     *
     * Defines the number of objects that match this item in the target data set.
     *
     * @deprecated As of version 1.18.11. replaced by `setCounter` method
     *
     * @returns Value of property `count`
     */
    getCount(): int;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Can be used as input for subsequent actions.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getText text}.
     *
     * Determines the text to be displayed for the item.
     *
     *
     * @returns Value of property `text`
     */
    getText(): string;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Can be used as input for subsequent actions.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Sets a new value for property {@link #getText text}.
     *
     * Determines the text to be displayed for the item.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setText(
      /**
       * New value for property `text`
       */
      sText?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FacetFilterItem constructor.
   */
  export interface $FacetFilterItemSettings extends $ListItemBaseSettings {
    /**
     * Can be used as input for subsequent actions.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Determines the text to be displayed for the item.
     */
    text?: string | PropertyBindingInfo;

    /**
     * Defines the number of objects that match this item in the target data set.
     *
     * @deprecated As of version 1.18.11. replaced by `setCounter` method
     */
    count?: int | PropertyBindingInfo | `{${string}}`;
  }
}

declare module "sap/m/FacetFilterList" {
  import { default as List, $ListSettings } from "sap/m/List";

  import Event from "sap/ui/base/Event";

  import { FacetFilterListDataType, ListMode } from "sap/m/library";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import FacetFilterItem from "sap/m/FacetFilterItem";

  /**
   * Represents a list of values for the {@link sap.m.FacetFilter} control.
   *
   * **Note: **`FacetFilterList` is a subclass of {@link sap.m.List} and supports growing enablement feature
   * via the property `growing`. When you use this feature, be aware that it only works with one-way data
   * binding. Having growing feature enabled when the `items` aggregation is bound to a model with two-way
   * data binding, may lead to unexpected and/or inconsistent behavior across browsers, such as unexpected
   * closing of the list.
   *
   * While the `FacetFilterList` popup is opened (when the user selects a button corresponding to the list's
   * name), any other activities leading to focus change will close it. For example, when the popup is opened
   * and the app developer loads a {@link sap.m.BusyDialog} or any other dialog that obtains the focus, the
   * popup will be closed.
   */
  export default class FacetFilterList extends List {
    /**
     * Constructor for a new `FacetFilterList`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/395392f30f2a4c4d80d110d5f923da77 Facet Filter List}
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterListSettings
    );
    /**
     * Constructor for a new `FacetFilterList`.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     * See:
     * 	{@link https://ui5.sap.com/#/topic/395392f30f2a4c4d80d110d5f923da77 Facet Filter List}
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FacetFilterListSettings
    );

    /**
     * Creates a new subclass of class sap.m.FacetFilterList with name `sClassName` and enriches it with the
     * information contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.List.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FacetFilterList>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FacetFilterList.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:listClose listClose} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Triggered after the list of items is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachListClose(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FacetFilterList$ListCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:listClose listClose} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Triggered after the list of items is closed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachListClose(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FacetFilterList$ListCloseEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:listOpen listOpen} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Fired before the filter list is opened.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `listOpen` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `listOpen` event handler function.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachListOpen(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:listOpen listOpen} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Fired before the filter list is opened.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `listOpen` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `listOpen` event handler function.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachListOpen(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:search search} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Triggered after the Search button is pressed or by pressing Enter in search input field.
     *
     * The default filtering behavior of the control can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. Preventing the default behavior is useful in cases when
     * items aggregation could be taking long time fetching from the OData model. As a result, no list items
     * are loaded initially. If the default filtering behavior is prevented then filtering behavior has to be
     * defined at application level inside the `search` event handler function.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearch(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FacetFilterList$SearchEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:search search} event of this `sap.m.FacetFilterList`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FacetFilterList` itself.
     *
     * Triggered after the Search button is pressed or by pressing Enter in search input field.
     *
     * The default filtering behavior of the control can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. Preventing the default behavior is useful in cases when
     * items aggregation could be taking long time fetching from the OData model. As a result, no list items
     * are loaded initially. If the default filtering behavior is prevented then filtering behavior has to be
     * defined at application level inside the `search` event handler function.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSearch(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FacetFilterList$SearchEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FacetFilterList` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:listClose listClose} event of this `sap.m.FacetFilterList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachListClose(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FacetFilterList$ListCloseEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:listOpen listOpen} event of this `sap.m.FacetFilterList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachListOpen(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:search search} event of this `sap.m.FacetFilterList`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     * @since 1.76
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachSearch(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FacetFilterList$SearchEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:listClose listClose} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    fireListClose(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FacetFilterList$ListCloseEventParameters
    ): this;
    /**
     * Fires event {@link #event:listOpen listOpen} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireListOpen(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): boolean;
    /**
     * Fires event {@link #event:search search} to attached listeners.
     *
     * Listeners may prevent the default action of this event by calling the `preventDefault` method on the
     * event object. The return value of this method indicates whether the default action should be executed.
     *
     * @since 1.76
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Whether or not to prevent the default action
     */
    fireSearch(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FacetFilterList$SearchEventParameters
    ): boolean;
    /**
     * Gets current value of property {@link #getActive active}.
     *
     * Indicates that the list is displayed as a button when the FacetFilter type is set to `Simple`.
     *
     * **Note:** Set the `showPersonalization` property of the `FacetFilter` to `true` when this property is
     * set to `false`. This is needed, as the non-active lists are not displayed, and without a personalization
     * button they can't be selected by the user.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `active`
     */
    getActive(): boolean;
    /**
     * Gets current value of property {@link #getAllCount allCount}.
     *
     * Determines the number of objects that match this item in the target data set when all filter items are
     * selected.
     *
     *
     * @returns Value of property `allCount`
     */
    getAllCount(): int;
    /**
     * Gets current value of property {@link #getDataType dataType}.
     *
     * FacetFilterList data type. Only String data type will provide search function.
     *
     * Default value is `String`.
     *
     *
     * @returns Value of property `dataType`
     */
    getDataType(): FacetFilterListDataType;
    /**
     * Gets current value of property {@link #getEnableCaseInsensitiveSearch enableCaseInsensitiveSearch}.
     *
     * If set to `true`, enables case-insensitive search for OData.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `enableCaseInsensitiveSearch`
     */
    getEnableCaseInsensitiveSearch(): boolean;
    /**
     * Gets current value of property {@link #getKey key}.
     *
     * Unique identifier for this filter list.
     *
     *
     * @returns Value of property `key`
     */
    getKey(): string;
    /**
     * Gets current value of property {@link #getMultiSelect multiSelect}.
     *
     * Specifies whether multiple or single selection is used.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.20.0. replaced by `setMode` method. `FacetFilterList` overrides the `setMode`
     * method to restrict the possible modes to `MultiSelect` and `SingleSelectMaster`. All other modes are
     * ignored and will not be set.
     *
     * @returns Value of property `multiSelect`
     */
    getMultiSelect(): boolean;
    /**
     * Gets current value of property {@link #getRetainListSequence retainListSequence}.
     *
     * Retains the list sequence if it is inactive and made active again.
     *
     * Default value is `false`.
     *
     * @since 1.22.1
     *
     * @returns Value of property `retainListSequence`
     */
    getRetainListSequence(): boolean;
    /**
     * Returns the keys of the selected elements as an associative array. An empty object is returned if no
     * items are selected.
     *
     * @since 1.20.3
     *
     * @returns Object with the selected keys
     */
    getSelectedKeys(): Record<string, string>;
    /**
     * Gets current value of property {@link #getSequence sequence}.
     *
     * Sequence that determines the order in which FacetFilterList is shown on the FacetFilter. Lists are rendered
     * by ascending order of sequence.
     *
     * Default value is `-1`.
     *
     *
     * @returns Value of property `sequence`
     */
    getSequence(): int;
    /**
     * Gets current value of property {@link #getShowRemoveFacetIcon showRemoveFacetIcon}.
     *
     * Specifies whether remove icon for facet is visible or hidden.
     *
     * Default value is `true`.
     *
     * @since 1.20.4
     *
     * @returns Value of property `showRemoveFacetIcon`
     */
    getShowRemoveFacetIcon(): boolean;
    /**
     * Gets current value of property {@link #getTitle title}.
     *
     * Defines the title of the facet. The facet title is displayed on the facet button when the FacetFilter
     * type is set to `Simple`. It is also displayed as a list item in the facet page of the dialog.
     *
     *
     * @returns Value of property `title`
     */
    getTitle(): string;
    /**
     * Gets current value of property {@link #getWordWrap wordWrap}.
     *
     * If set to `true`, the item text wraps when it is too long.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `wordWrap`
     */
    getWordWrap(): boolean;
    /**
     * Removes the specified key from the selected keys cache and deselects the item.
     *
     * @since 1.20.4
     */
    removeSelectedKey(
      /**
       * The key of the selected item to be removed from the cache. If `null` then the text parameter will be
       * used as the key.
       */
      sKey: string,
      /**
       * The text of the selected item to be removed from the cache. If the key parameter is `null` then text
       * will be used as the key.
       */
      sText: string
    ): void;
    /**
     * Removes all selected keys from the selected keys cache and deselects all items.
     *
     * @since 1.20.4
     */
    removeSelectedKeys(): void;
    /**
     * Sets a new value for property {@link #getActive active}.
     *
     * Indicates that the list is displayed as a button when the FacetFilter type is set to `Simple`.
     *
     * **Note:** Set the `showPersonalization` property of the `FacetFilter` to `true` when this property is
     * set to `false`. This is needed, as the non-active lists are not displayed, and without a personalization
     * button they can't be selected by the user.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setActive(
      /**
       * New value for property `active`
       */
      bActive?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getAllCount allCount}.
     *
     * Determines the number of objects that match this item in the target data set when all filter items are
     * selected.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAllCount(
      /**
       * New value for property `allCount`
       */
      iAllCount?: int
    ): this;
    /**
     * Sets a new value for property {@link #getDataType dataType}.
     *
     * FacetFilterList data type. Only String data type will provide search function.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `String`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setDataType(
      /**
       * New value for property `dataType`
       */
      sDataType?: FacetFilterListDataType | keyof typeof FacetFilterListDataType
    ): this;
    /**
     * Sets a new value for property {@link #getEnableCaseInsensitiveSearch enableCaseInsensitiveSearch}.
     *
     * If set to `true`, enables case-insensitive search for OData.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnableCaseInsensitiveSearch(
      /**
       * New value for property `enableCaseInsensitiveSearch`
       */
      bEnableCaseInsensitiveSearch?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getKey key}.
     *
     * Unique identifier for this filter list.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setKey(
      /**
       * New value for property `key`
       */
      sKey?: string
    ): this;
    /**
     * Overrides to allow only MultiSelect and SingleSelectMaster list modes. If an invalid mode is given then
     * the mode will not be changed.
     *
     *
     * @returns `this` to allow method chaining
     */
    setMode(
      /**
       * The list mode
       */
      mode: ListMode | keyof typeof ListMode
    ): this;
    /**
     * Sets a new value for property {@link #getRetainListSequence retainListSequence}.
     *
     * Retains the list sequence if it is inactive and made active again.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     * @since 1.22.1
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRetainListSequence(
      /**
       * New value for property `retainListSequence`
       */
      bRetainListSequence?: boolean
    ): this;
    /**
     * Used to pre-select FacetFilterItems, such as when restoring FacetFilterList selections from a variant.
     * Keys are cached separately from the actual FacetFilterItems so that they remain even when the physical
     * items are removed by filtering or sorting. If oKeys is `undefined`, `null`, or {} (empty object) then
     * all items will be deselected. After this method completes, only those items with matching keys will be
     * selected. All other items in the list will be deselected.
     *
     * @since 1.20.3
     */
    setSelectedKeys(
      /**
       * Associative array indicating which FacetFilterItems should be selected in the list. Each property must
       * be set to the value of a FacetFilterItem.key property. Each property value should be set to the FacetFilterItem.text
       * property value. The text value is used to display the FacetFilterItem text when the FacetFilterList button
       * or FacetFilter summary bar is displayed. If no property value is set then the property key is used for
       * the text.
       */
      oKeys?: Record<string, string | undefined> | null
    ): void;
    /**
     * Sets a new value for property {@link #getSequence sequence}.
     *
     * Sequence that determines the order in which FacetFilterList is shown on the FacetFilter. Lists are rendered
     * by ascending order of sequence.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `-1`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSequence(
      /**
       * New value for property `sequence`
       */
      iSequence?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowRemoveFacetIcon showRemoveFacetIcon}.
     *
     * Specifies whether remove icon for facet is visible or hidden.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @since 1.20.4
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowRemoveFacetIcon(
      /**
       * New value for property `showRemoveFacetIcon`
       */
      bShowRemoveFacetIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getTitle title}.
     *
     * Defines the title of the facet. The facet title is displayed on the facet button when the FacetFilter
     * type is set to `Simple`. It is also displayed as a list item in the facet page of the dialog.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTitle(
      /**
       * New value for property `title`
       */
      sTitle?: string
    ): this;
    /**
     * Sets a new value for property {@link #getWordWrap wordWrap}.
     *
     * If set to `true`, the item text wraps when it is too long.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setWordWrap(
      /**
       * New value for property `wordWrap`
       */
      bWordWrap?: boolean
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FacetFilterList constructor.
   */
  export interface $FacetFilterListSettings extends $ListSettings {
    /**
     * Defines the title of the facet. The facet title is displayed on the facet button when the FacetFilter
     * type is set to `Simple`. It is also displayed as a list item in the facet page of the dialog.
     */
    title?: string | PropertyBindingInfo;

    /**
     * If set to `true`, the item text wraps when it is too long.
     */
    wordWrap?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Specifies whether multiple or single selection is used.
     *
     * @deprecated As of version 1.20.0. replaced by `setMode` method. `FacetFilterList` overrides the `setMode`
     * method to restrict the possible modes to `MultiSelect` and `SingleSelectMaster`. All other modes are
     * ignored and will not be set.
     */
    multiSelect?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates that the list is displayed as a button when the FacetFilter type is set to `Simple`.
     *
     * **Note:** Set the `showPersonalization` property of the `FacetFilter` to `true` when this property is
     * set to `false`. This is needed, as the non-active lists are not displayed, and without a personalization
     * button they can't be selected by the user.
     */
    active?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * If set to `true`, enables case-insensitive search for OData.
     */
    enableCaseInsensitiveSearch?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines the number of objects that match this item in the target data set when all filter items are
     * selected.
     */
    allCount?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Sequence that determines the order in which FacetFilterList is shown on the FacetFilter. Lists are rendered
     * by ascending order of sequence.
     */
    sequence?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Unique identifier for this filter list.
     */
    key?: string | PropertyBindingInfo;

    /**
     * Specifies whether remove icon for facet is visible or hidden.
     *
     * @since 1.20.4
     */
    showRemoveFacetIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Retains the list sequence if it is inactive and made active again.
     *
     * @since 1.22.1
     */
    retainListSequence?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * FacetFilterList data type. Only String data type will provide search function.
     */
    dataType?:
      | (FacetFilterListDataType | keyof typeof FacetFilterListDataType)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Fired before the filter list is opened.
     *
     * The default filtering behavior of the sap.m.FacetFilterList can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `listOpen` event handler function. If the default filtering behavior is prevented then
     * filtering behavior has to be defined at application level inside the `listOpen` event handler function.
     */
    listOpen?: (oEvent: Event) => void;

    /**
     * Triggered after the list of items is closed.
     */
    listClose?: (oEvent: FacetFilterList$ListCloseEvent) => void;

    /**
     * Triggered after the Search button is pressed or by pressing Enter in search input field.
     *
     * The default filtering behavior of the control can be prevented by calling `sap.ui.base.Event.prototype.preventDefault`
     * function in the `search` event handler function. Preventing the default behavior is useful in cases when
     * items aggregation could be taking long time fetching from the OData model. As a result, no list items
     * are loaded initially. If the default filtering behavior is prevented then filtering behavior has to be
     * defined at application level inside the `search` event handler function.
     *
     * @since 1.76
     */
    search?: (oEvent: FacetFilterList$SearchEvent) => void;
  }

  /**
   * Parameters of the FacetFilterList#listClose event.
   */
  export interface FacetFilterList$ListCloseEventParameters {
    /**
     * Array of selected items. Items returned are only copies and therefore can only be used to read properties,
     * not set them.
     */
    selectedItems?: FacetFilterItem[];

    /**
     * `True` if the select All checkbox is selected. This will be `false` if all items are actually selected
     * (every FacetFilterItem.selected == true). In that case selectedItems will contain all selected items.
     */
    allSelected?: boolean;

    /**
     * Associative array containing the keys of selected FacetFilterItems. Unlike the selectedItems parameter,
     * this contains only the keys for all selected items, not the items themselves. Being an associative array,
     * each object property is the FacetFilterItem key value and the value of the property is the FacetFilterItem
     * text.
     */
    selectedKeys?: object;
  }

  /**
   * Event object of the FacetFilterList#listClose event.
   */
  export type FacetFilterList$ListCloseEvent = Event<
    FacetFilterList$ListCloseEventParameters,
    FacetFilterList
  >;

  /**
   * Parameters of the FacetFilterList#listOpen event.
   */
  export interface FacetFilterList$ListOpenEventParameters {}

  /**
   * Event object of the FacetFilterList#listOpen event.
   */
  export type FacetFilterList$ListOpenEvent = Event<
    FacetFilterList$ListOpenEventParameters,
    FacetFilterList
  >;

  /**
   * Parameters of the FacetFilterList#search event.
   */
  export interface FacetFilterList$SearchEventParameters {
    /**
     * Value received as user input in the `sap.m.SearchField`, and taken as a JavaScript string object.
     */
    term?: string;
  }

  /**
   * Event object of the FacetFilterList#search event.
   */
  export type FacetFilterList$SearchEvent = Event<
    FacetFilterList$SearchEventParameters,
    FacetFilterList
  >;
}

declare module "sap/m/FeedContent" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import Event from "sap/ui/base/Event";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { Size, ValueColor } from "sap/m/library";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  /**
   * Displays a tile containing the text of the feed, a subheader, and a numeric value.
   *
   * @since 1.34
   */
  export default class FeedContent extends Control {
    /**
     * Constructor for a new sap.m.FeedContent control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * Initial settings for the new control
       */
      mSettings?: $FeedContentSettings
    );
    /**
     * Constructor for a new sap.m.FeedContent control.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * ID for the new control, generated automatically if no ID is given
       */
      sId?: string,
      /**
       * Initial settings for the new control
       */
      mSettings?: $FeedContentSettings
    );

    /**
     * Creates a new subclass of class sap.m.FeedContent with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FeedContent>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FeedContent.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.FeedContent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedContent` itself.
     *
     * The event is triggered when the feed content is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedContent` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:press press} event of this `sap.m.FeedContent`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedContent` itself.
     *
     * The event is triggered when the feed content is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedContent` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:press press} event of this `sap.m.FeedContent`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPress(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: Event) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:press press} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePress(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: object
    ): this;
    /**
     * Gets current value of property {@link #getContentText contentText}.
     *
     * The content text.
     *
     *
     * @returns Value of property `contentText`
     */
    getContentText(): string;
    /**
     * Gets current value of property {@link #getSize size}.
     *
     * Updates the size of the chart. If not set then the default size is applied based on the device tile.
     *
     * Default value is `Auto`.
     *
     * @deprecated As of version 1.38.0. The FeedContent control has now a fixed size, depending on the used
     * media (desktop, tablet or phone).
     *
     * @returns Value of property `size`
     */
    getSize(): Size;
    /**
     * Gets current value of property {@link #getSubheader subheader}.
     *
     * The subheader.
     *
     *
     * @returns Value of property `subheader`
     */
    getSubheader(): string;
    /**
     * Gets current value of property {@link #getTruncateValueTo truncateValueTo}.
     *
     * The number of characters to display for the value property.
     *
     * Default value is `4`.
     *
     *
     * @returns Value of property `truncateValueTo`
     */
    getTruncateValueTo(): int;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The actual value.
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Gets current value of property {@link #getValueColor valueColor}.
     *
     * The semantic color of the value.
     *
     *
     * @returns Value of property `valueColor`
     */
    getValueColor(): ValueColor;
    /**
     * Sets a new value for property {@link #getContentText contentText}.
     *
     * The content text.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setContentText(
      /**
       * New value for property `contentText`
       */
      sContentText?: string
    ): this;
    /**
     * Sets a new value for property {@link #getSize size}.
     *
     * Updates the size of the chart. If not set then the default size is applied based on the device tile.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Auto`.
     *
     * @deprecated As of version 1.38.0. The FeedContent control has now a fixed size, depending on the used
     * media (desktop, tablet or phone).
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSize(
      /**
       * New value for property `size`
       */
      sSize?: Size | keyof typeof Size
    ): this;
    /**
     * Sets a new value for property {@link #getSubheader subheader}.
     *
     * The subheader.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setSubheader(
      /**
       * New value for property `subheader`
       */
      sSubheader?: string
    ): this;
    /**
     * Sets a new value for property {@link #getTruncateValueTo truncateValueTo}.
     *
     * The number of characters to display for the value property.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `4`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setTruncateValueTo(
      /**
       * New value for property `truncateValueTo`
       */
      iTruncateValueTo?: int
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The actual value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
    /**
     * Sets a new value for property {@link #getValueColor valueColor}.
     *
     * The semantic color of the value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValueColor(
      /**
       * New value for property `valueColor`
       */
      sValueColor?: ValueColor | keyof typeof ValueColor
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FeedContent constructor.
   */
  export interface $FeedContentSettings extends $ControlSettings {
    /**
     * Updates the size of the chart. If not set then the default size is applied based on the device tile.
     *
     * @deprecated As of version 1.38.0. The FeedContent control has now a fixed size, depending on the used
     * media (desktop, tablet or phone).
     */
    size?: (Size | keyof typeof Size) | PropertyBindingInfo | `{${string}}`;

    /**
     * The content text.
     */
    contentText?: string | PropertyBindingInfo;

    /**
     * The subheader.
     */
    subheader?: string | PropertyBindingInfo;

    /**
     * The actual value.
     */
    value?: string | PropertyBindingInfo;

    /**
     * The semantic color of the value.
     */
    valueColor?:
      | (ValueColor | keyof typeof ValueColor)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * The number of characters to display for the value property.
     */
    truncateValueTo?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The event is triggered when the feed content is pressed.
     */
    press?: (oEvent: Event) => void;
  }

  /**
   * Parameters of the FeedContent#press event.
   */
  export interface FeedContent$PressEventParameters {}

  /**
   * Event object of the FeedContent#press event.
   */
  export type FeedContent$PressEvent = Event<
    FeedContent$PressEventParameters,
    FeedContent
  >;
}

declare module "sap/m/FeedInput" {
  import { default as Control, $ControlSettings } from "sap/ui/core/Control";

  import TooltipBase from "sap/ui/core/TooltipBase";

  import { URI } from "sap/ui/core/library";

  import AvatarShape from "sap/m/AvatarShape";

  import AvatarSize from "sap/m/AvatarSize";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import { PropertyBindingInfo } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The Feed Input allows the user to enter text for a new feed entry and then post it.
   *
   * @since 1.22
   */
  export default class FeedInput extends Control {
    /**
     * Constructor for a new FeedInput.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedInputSettings
    );
    /**
     * Constructor for a new FeedInput.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedInputSettings
    );

    /**
     * Creates a new subclass of class sap.m.FeedInput with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.ui.core.Control.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FeedInput>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FeedInput.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:post post} event of this `sap.m.FeedInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedInput` itself.
     *
     * The Post event is triggered when the user has entered a value and pressed the post button. After firing
     * this event, the value is reset.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPost(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedInput$PostEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:post post} event of this `sap.m.FeedInput`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedInput` itself.
     *
     * The Post event is triggered when the user has entered a value and pressed the post button. After firing
     * this event, the value is reset.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachPost(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedInput$PostEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedInput` itself
       */
      oListener?: object
    ): this;
    /**
     * Detaches event handler `fnFunction` from the {@link #event:post post} event of this `sap.m.FeedInput`.
     *
     * The passed function and listener object must match the ones used for event registration.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    detachPost(
      /**
       * The function to be called, when the event occurs
       */
      fnFunction: (p1: FeedInput$PostEvent) => void,
      /**
       * Context object on which the given function had to be called
       */
      oListener?: object
    ): this;
    /**
     * Fires event {@link #event:post post} to attached listeners.
     *
     * @ui5-protected Do not call from applications (only from related classes in the framework)
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    firePost(
      /**
       * Parameters to pass along with the event
       */
      mParameters?: FeedInput$PostEventParameters
    ): this;
    /**
     * Gets current value of property {@link #getAriaLabelForPicture ariaLabelForPicture}.
     *
     * Text for Picture which will be read by screenreader. If a new ariaLabelForPicture is set, any previously
     * set ariaLabelForPicture is deactivated.
     *
     * @deprecated As of version 1.88. This will not have any effect in code now.
     *
     * @returns Value of property `ariaLabelForPicture`
     */
    getAriaLabelForPicture(): string;
    /**
     * Gets current value of property {@link #getButtonTooltip buttonTooltip}.
     *
     * Sets a new tooltip for Submit button. The tooltip can either be a simple string (which in most cases
     * will be rendered as the title attribute of this element) or an instance of sap.ui.core.TooltipBase. If
     * a new tooltip is set, any previously set tooltip is deactivated. The default value is set language dependent.
     *
     * Default value is `"Submit"`.
     *
     * @since 1.28
     *
     * @returns Value of property `buttonTooltip`
     */
    getButtonTooltip(): TooltipBase | string;
    /**
     * Gets current value of property {@link #getEnabled enabled}.
     *
     * Set this flag to "false" to disable both text input and post button.
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `enabled`
     */
    getEnabled(): boolean;
    /**
     * Gets current value of property {@link #getGrowing growing}.
     *
     * Indicates the ability of the control to automatically grow and shrink dynamically with its content.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `growing`
     */
    getGrowing(): boolean;
    /**
     * Gets current value of property {@link #getGrowingMaxLines growingMaxLines}.
     *
     * Defines the maximum number of lines that the control can grow. Value is set to 0 by default, which means
     * an unlimited numbers of rows. **Note:** Minimum value to set is equal to the `rows` property value, maximum
     * value is 15.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `growingMaxLines`
     */
    getGrowingMaxLines(): int;
    /**
     * Gets current value of property {@link #getIcon icon}.
     *
     * Icon to be displayed as a graphical element within the feed input. This can be an image or an icon from
     * the icon font.
     *
     *
     * @returns Value of property `icon`
     */
    getIcon(): URI;
    /**
     * Gets current value of property {@link #getIconDensityAware iconDensityAware}.
     *
     * Some mobile devices support higher resolution images while others do not. Therefore, you should provide
     * image resources for all relevant densities. If the property is set to "true", one or more requests are
     * sent to the server to try and get the perfect density version of an image. If an image of a certain density
     * is not available, the image control falls back to the default image, which should be provided.
     *
     * If you do not have higher resolution images, you should set the property to "false" to avoid unnecessary
     * round-trips.
     *
     * Please be aware that this property is relevant only for images and not for icons.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.88. Image replaced by {@link sap.m.Avatar }
     *
     * @returns Value of property `iconDensityAware`
     */
    getIconDensityAware(): boolean;
    /**
     * Gets current value of property {@link #getIconDisplayShape iconDisplayShape}.
     *
     * Defines the shape of the icon.
     *
     * Default value is `Circle`.
     *
     * @since 1.88
     *
     * @returns Value of property `iconDisplayShape`
     */
    getIconDisplayShape(): AvatarShape;
    /**
     * Gets current value of property {@link #getIconInitials iconInitials}.
     *
     * Defines the initials of the icon.
     *
     * Default value is `empty string`.
     *
     * @since 1.88
     *
     * @returns Value of property `iconInitials`
     */
    getIconInitials(): string;
    /**
     * Gets current value of property {@link #getIconSize iconSize}.
     *
     * Defines the size of the icon.
     *
     * Default value is `M`.
     *
     * @since 1.88
     *
     * @returns Value of property `iconSize`
     */
    getIconSize(): AvatarSize;
    /**
     * Gets current value of property {@link #getMaxLength maxLength}.
     *
     * The maximum length (the maximum number of characters) for the feed's input value. By default this is
     * not limited.
     *
     * Default value is `0`.
     *
     *
     * @returns Value of property `maxLength`
     */
    getMaxLength(): int;
    /**
     * Gets current value of property {@link #getPlaceholder placeholder}.
     *
     * The placeholder text shown in the input area as long as the user has not entered any text value.
     *
     * Default value is `"Post something here"`.
     *
     *
     * @returns Value of property `placeholder`
     */
    getPlaceholder(): string;
    /**
     * Gets current value of property {@link #getRows rows}.
     *
     * Defines the number of visible text lines for the control. **Note:** Minimum value is 2, maximum value
     * is 15.
     *
     * Default value is `2`.
     *
     *
     * @returns Value of property `rows`
     */
    getRows(): int;
    /**
     * Gets current value of property {@link #getShowExceededText showExceededText}.
     *
     * Determines whether the characters, exceeding the maximum allowed character count, are visible in the
     * input field.
     *
     * If set to `false`, the user is not allowed to enter more characters than what is set in the `maxLength`
     * property. If set to `true`, the characters exceeding the `maxLength` value are selected on paste and
     * the counter below the input field displays their number.
     *
     * Default value is `false`.
     *
     *
     * @returns Value of property `showExceededText`
     */
    getShowExceededText(): boolean;
    /**
     * Gets current value of property {@link #getShowIcon showIcon}.
     *
     * If set to "true" (default), icons will be displayed. In case no icon is provided the standard placeholder
     * will be displayed. if set to "false" icons are hidden
     *
     * Default value is `true`.
     *
     *
     * @returns Value of property `showIcon`
     */
    getShowIcon(): boolean;
    /**
     * Gets current value of property {@link #getValue value}.
     *
     * The text value of the feed input. As long as the user has not entered any text the post button is disabled
     *
     *
     * @returns Value of property `value`
     */
    getValue(): string;
    /**
     * Sets a new value for property {@link #getAriaLabelForPicture ariaLabelForPicture}.
     *
     * Text for Picture which will be read by screenreader. If a new ariaLabelForPicture is set, any previously
     * set ariaLabelForPicture is deactivated.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * @deprecated As of version 1.88. This will not have any effect in code now.
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setAriaLabelForPicture(
      /**
       * New value for property `ariaLabelForPicture`
       */
      sAriaLabelForPicture?: string
    ): this;
    /**
     * Sets a new value for property {@link #getButtonTooltip buttonTooltip}.
     *
     * Sets a new tooltip for Submit button. The tooltip can either be a simple string (which in most cases
     * will be rendered as the title attribute of this element) or an instance of sap.ui.core.TooltipBase. If
     * a new tooltip is set, any previously set tooltip is deactivated. The default value is set language dependent.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Submit"`.
     *
     * @since 1.28
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setButtonTooltip(
      /**
       * New value for property `buttonTooltip`
       */
      sButtonTooltip?: TooltipBase | string
    ): this;
    /**
     * Sets a new value for property {@link #getEnabled enabled}.
     *
     * Set this flag to "false" to disable both text input and post button.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setEnabled(
      /**
       * New value for property `enabled`
       */
      bEnabled?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGrowing growing}.
     *
     * Indicates the ability of the control to automatically grow and shrink dynamically with its content.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowing(
      /**
       * New value for property `growing`
       */
      bGrowing?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getGrowingMaxLines growingMaxLines}.
     *
     * Defines the maximum number of lines that the control can grow. Value is set to 0 by default, which means
     * an unlimited numbers of rows. **Note:** Minimum value to set is equal to the `rows` property value, maximum
     * value is 15.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setGrowingMaxLines(
      /**
       * New value for property `growingMaxLines`
       */
      iGrowingMaxLines?: int
    ): this;
    /**
     * Sets a new value for property {@link #getIcon icon}.
     *
     * Icon to be displayed as a graphical element within the feed input. This can be an image or an icon from
     * the icon font.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIcon(
      /**
       * New value for property `icon`
       */
      sIcon?: URI
    ): this;
    /**
     * Sets a new value for property {@link #getIconDensityAware iconDensityAware}.
     *
     * Some mobile devices support higher resolution images while others do not. Therefore, you should provide
     * image resources for all relevant densities. If the property is set to "true", one or more requests are
     * sent to the server to try and get the perfect density version of an image. If an image of a certain density
     * is not available, the image control falls back to the default image, which should be provided.
     *
     * If you do not have higher resolution images, you should set the property to "false" to avoid unnecessary
     * round-trips.
     *
     * Please be aware that this property is relevant only for images and not for icons.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     * @deprecated As of version 1.88. Image replaced by {@link sap.m.Avatar }
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconDensityAware(
      /**
       * New value for property `iconDensityAware`
       */
      bIconDensityAware?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getIconDisplayShape iconDisplayShape}.
     *
     * Defines the shape of the icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `Circle`.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconDisplayShape(
      /**
       * New value for property `iconDisplayShape`
       */
      sIconDisplayShape?: AvatarShape | keyof typeof AvatarShape
    ): this;
    /**
     * Sets a new value for property {@link #getIconInitials iconInitials}.
     *
     * Defines the initials of the icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `empty string`.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconInitials(
      /**
       * New value for property `iconInitials`
       */
      sIconInitials?: string
    ): this;
    /**
     * Sets a new value for property {@link #getIconSize iconSize}.
     *
     * Defines the size of the icon.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `M`.
     *
     * @since 1.88
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setIconSize(
      /**
       * New value for property `iconSize`
       */
      sIconSize?: AvatarSize | keyof typeof AvatarSize
    ): this;
    /**
     * Sets a new value for property {@link #getMaxLength maxLength}.
     *
     * The maximum length (the maximum number of characters) for the feed's input value. By default this is
     * not limited.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `0`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setMaxLength(
      /**
       * New value for property `maxLength`
       */
      iMaxLength?: int
    ): this;
    /**
     * Sets a new value for property {@link #getPlaceholder placeholder}.
     *
     * The placeholder text shown in the input area as long as the user has not entered any text value.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `"Post something here"`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setPlaceholder(
      /**
       * New value for property `placeholder`
       */
      sPlaceholder?: string
    ): this;
    /**
     * Sets a new value for property {@link #getRows rows}.
     *
     * Defines the number of visible text lines for the control. **Note:** Minimum value is 2, maximum value
     * is 15.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `2`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setRows(
      /**
       * New value for property `rows`
       */
      iRows?: int
    ): this;
    /**
     * Sets a new value for property {@link #getShowExceededText showExceededText}.
     *
     * Determines whether the characters, exceeding the maximum allowed character count, are visible in the
     * input field.
     *
     * If set to `false`, the user is not allowed to enter more characters than what is set in the `maxLength`
     * property. If set to `true`, the characters exceeding the `maxLength` value are selected on paste and
     * the counter below the input field displays their number.
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `false`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowExceededText(
      /**
       * New value for property `showExceededText`
       */
      bShowExceededText?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getShowIcon showIcon}.
     *
     * If set to "true" (default), icons will be displayed. In case no icon is provided the standard placeholder
     * will be displayed. if set to "false" icons are hidden
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     * Default value is `true`.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setShowIcon(
      /**
       * New value for property `showIcon`
       */
      bShowIcon?: boolean
    ): this;
    /**
     * Sets a new value for property {@link #getValue value}.
     *
     * The text value of the feed input. As long as the user has not entered any text the post button is disabled
     *
     * When called with a value of `null` or `undefined`, the default value of the property will be restored.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    setValue(
      /**
       * New value for property `value`
       */
      sValue?: string
    ): this;
  }
  /**
   * Describes the settings that can be provided to the FeedInput constructor.
   */
  export interface $FeedInputSettings extends $ControlSettings {
    /**
     * Set this flag to "false" to disable both text input and post button.
     */
    enabled?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the number of visible text lines for the control. **Note:** Minimum value is 2, maximum value
     * is 15.
     */
    rows?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Determines whether the characters, exceeding the maximum allowed character count, are visible in the
     * input field.
     *
     * If set to `false`, the user is not allowed to enter more characters than what is set in the `maxLength`
     * property. If set to `true`, the characters exceeding the `maxLength` value are selected on paste and
     * the counter below the input field displays their number.
     */
    showExceededText?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * The maximum length (the maximum number of characters) for the feed's input value. By default this is
     * not limited.
     */
    maxLength?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * Indicates the ability of the control to automatically grow and shrink dynamically with its content.
     */
    growing?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the maximum number of lines that the control can grow. Value is set to 0 by default, which means
     * an unlimited numbers of rows. **Note:** Minimum value to set is equal to the `rows` property value, maximum
     * value is 15.
     */
    growingMaxLines?: int | PropertyBindingInfo | `{${string}}`;

    /**
     * The placeholder text shown in the input area as long as the user has not entered any text value.
     */
    placeholder?: string | PropertyBindingInfo;

    /**
     * The text value of the feed input. As long as the user has not entered any text the post button is disabled
     */
    value?: string | PropertyBindingInfo;

    /**
     * Icon to be displayed as a graphical element within the feed input. This can be an image or an icon from
     * the icon font.
     */
    icon?: URI | PropertyBindingInfo | `{${string}}`;

    /**
     * Defines the shape of the icon.
     *
     * @since 1.88
     */
    iconDisplayShape?:
      | (AvatarShape | keyof typeof AvatarShape)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * Defines the initials of the icon.
     *
     * @since 1.88
     */
    iconInitials?: string | PropertyBindingInfo;

    /**
     * Defines the size of the icon.
     *
     * @since 1.88
     */
    iconSize?:
      | (AvatarSize | keyof typeof AvatarSize)
      | PropertyBindingInfo
      | `{${string}}`;

    /**
     * If set to "true" (default), icons will be displayed. In case no icon is provided the standard placeholder
     * will be displayed. if set to "false" icons are hidden
     */
    showIcon?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Some mobile devices support higher resolution images while others do not. Therefore, you should provide
     * image resources for all relevant densities. If the property is set to "true", one or more requests are
     * sent to the server to try and get the perfect density version of an image. If an image of a certain density
     * is not available, the image control falls back to the default image, which should be provided.
     *
     * If you do not have higher resolution images, you should set the property to "false" to avoid unnecessary
     * round-trips.
     *
     * Please be aware that this property is relevant only for images and not for icons.
     *
     * @deprecated As of version 1.88. Image replaced by {@link sap.m.Avatar }
     */
    iconDensityAware?: boolean | PropertyBindingInfo | `{${string}}`;

    /**
     * Sets a new tooltip for Submit button. The tooltip can either be a simple string (which in most cases
     * will be rendered as the title attribute of this element) or an instance of sap.ui.core.TooltipBase. If
     * a new tooltip is set, any previously set tooltip is deactivated. The default value is set language dependent.
     *
     * @since 1.28
     */
    buttonTooltip?: TooltipBase | string | PropertyBindingInfo | `{${string}}`;

    /**
     * Text for Picture which will be read by screenreader. If a new ariaLabelForPicture is set, any previously
     * set ariaLabelForPicture is deactivated.
     *
     * @deprecated As of version 1.88. This will not have any effect in code now.
     */
    ariaLabelForPicture?: string | PropertyBindingInfo;

    /**
     * The Post event is triggered when the user has entered a value and pressed the post button. After firing
     * this event, the value is reset.
     */
    post?: (oEvent: FeedInput$PostEvent) => void;
  }

  /**
   * Parameters of the FeedInput#post event.
   */
  export interface FeedInput$PostEventParameters {
    /**
     * The value of the feed input before reseting it.
     */
    value?: string;
  }

  /**
   * Event object of the FeedInput#post event.
   */
  export type FeedInput$PostEvent = Event<
    FeedInput$PostEventParameters,
    FeedInput
  >;
}

declare module "sap/m/FeedListItem" {
  import {
    default as ListItemBase,
    $ListItemBaseSettings,
  } from "sap/m/ListItemBase";

  import FeedListItemAction from "sap/m/FeedListItemAction";

  import { URI } from "sap/ui/core/library";

  import { LinkConversion, ListType } from "sap/m/library";

  import AvatarShape from "sap/m/AvatarShape";

  import AvatarSize from "sap/m/AvatarSize";

  import ElementMetadata from "sap/ui/core/ElementMetadata";

  import {
    PropertyBindingInfo,
    AggregationBindingInfo,
  } from "sap/ui/base/ManagedObject";

  import Event from "sap/ui/base/Event";

  /**
   * The control provides a set of properties for text, sender information, time stamp. Beginning with release
   * 1.23 the new feature expand / collapse was introduced, which uses the property maxCharacters. Beginning
   * with release 1.44, sap.m.FormattedText was introduced which allows html formatted text to be displayed
   *
   * @since 1.12
   */
  export default class FeedListItem extends ListItemBase {
    /**
     * Constructor for a new FeedListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedListItemSettings
    );
    /**
     * Constructor for a new FeedListItem.
     *
     * Accepts an object literal `mSettings` that defines initial property values, aggregated and associated
     * objects as well as event handlers. See {@link sap.ui.base.ManagedObject#constructor} for a general description
     * of the syntax of the settings object.
     */
    constructor(
      /**
       * id for the new control, generated automatically if no id is given
       */
      sId?: string,
      /**
       * initial settings for the new control
       */
      mSettings?: $FeedListItemSettings
    );

    /**
     * Creates a new subclass of class sap.m.FeedListItem with name `sClassName` and enriches it with the information
     * contained in `oClassInfo`.
     *
     * `oClassInfo` might contain the same kind of information as described in {@link sap.m.ListItemBase.extend}.
     *
     *
     * @returns Created class / constructor function
     */
    static extend<T extends Record<string, unknown>>(
      /**
       * Name of the class being created
       */
      sClassName: string,
      /**
       * Object literal with information about the class
       */
      oClassInfo?: sap.ClassInfo<T, FeedListItem>,
      /**
       * Constructor function for the metadata object; if not given, it defaults to the metadata implementation
       * used by this class
       */
      FNMetaImpl?: Function
    ): Function;
    /**
     * Returns a metadata object for class sap.m.FeedListItem.
     *
     *
     * @returns Metadata object describing this class
     */
    static getMetadata(): ElementMetadata;
    /**
     * Adds some action to the aggregation {@link #getActions actions}.
     *
     * @since 1.52.0
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    addAction(
      /**
       * The action to add; if empty, nothing is inserted
       */
      oAction: FeedListItemAction
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:iconPress iconPress} event of this `sap.m.FeedListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedListItem` itself.
     *
     * Event is fired when the icon is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachIconPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedListItem$IconPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedListItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:iconPress iconPress} event of this `sap.m.FeedListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedListItem` itself.
     *
     * Event is fired when the icon is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachIconPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedListItem$IconPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedListItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:senderPress senderPress} event of this `sap.m.FeedListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedListItem` itself.
     *
     * Event is fired when name of the sender is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSenderPress(
      /**
       * An application-specific payload object that will be passed to the event handler along with the event
       * object when firing the event
       */
      oData: object,
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedListItem$SenderPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedListItem` itself
       */
      oListener?: object
    ): this;
    /**
     * Attaches event handler `fnFunction` to the {@link #event:senderPress senderPress} event of this `sap.m.FeedListItem`.
     *
     * When called, the context of the event handler (its `this`) will be bound to `oListener` if specified,
     * otherwise it will be bound to this `sap.m.FeedListItem` itself.
     *
     * Event is fired when name of the sender is pressed.
     *
     *
     * @returns Reference to `this` in order to allow method chaining
     */
    attachSenderPress(
      /**
       * The function to be called when the event occurs
       */
      fnFunction: (p1: FeedListItem$SenderPressEvent) => void,
      /**
       * Context object to call the event handler with. Defaults to this `sap.m.FeedListItem` itsel