/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.csharp.dependencies;

import java.beans.ConstructorProperties;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.csharp.dependencies.trait.PackageReference;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.maven.table.DependenciesInUse;
import org.openrewrite.semver.Semver;
import org.openrewrite.semver.VersionComparator;
import org.openrewrite.xml.tree.Xml;

public final class DependencyInsight
extends Recipe {
    private final transient DependenciesInUse dependenciesInUse = new DependenciesInUse((Recipe)this);
    @Option(displayName="Package pattern", description="Package glob pattern used to match dependencies.", example="Microsoft*", required=false)
    private final @Nullable String packagePattern;
    @Option(displayName="Version", description="Match only dependencies with the specified version. Node-style [version selectors](https://docs.openrewrite.org/reference/dependency-version-selectors) may be used. All versions are searched by default.", example="1.x", required=false)
    private final @Nullable String version;

    public String getDisplayName() {
        return "Dependency insight for C#";
    }

    public String getDescription() {
        return "Finds dependencies in `*.csproj` and `packages.config`.";
    }

    public Validated<Object> validate() {
        Validated v = super.validate();
        if (this.version != null) {
            v = v.and(Semver.validate((String)this.version, null));
        }
        return v;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new PackageReference.Matcher().asVisitor((ref, ctx) -> {
            if (this.packagePattern != null && !StringUtils.matchesGlob((String)ref.getInclude(), (String)this.packagePattern)) {
                return ref.getTree();
            }
            if (this.version != null && !((VersionComparator)Semver.validate((String)this.version, null).getValue()).isValid(null, ref.getVersion())) {
                return ref.getTree();
            }
            this.dependenciesInUse.insertRow(ctx, (Object)new DependenciesInUse.Row(null, null, null, ref.getInclude(), ref.getVersion(), null, null, Integer.valueOf(0)));
            return SearchResult.found((Tree)((Xml.Tag)ref.getTree()), (String)String.format("%s:%s", ref.getInclude(), ref.getVersion()));
        });
    }

    @ConstructorProperties(value={"packagePattern", "version"})
    @Generated
    public DependencyInsight(@Nullable String packagePattern, @Nullable String version) {
        this.packagePattern = packagePattern;
        this.version = version;
    }

    @Generated
    public DependenciesInUse getDependenciesInUse() {
        return this.dependenciesInUse;
    }

    @Generated
    public @Nullable String getPackagePattern() {
        return this.packagePattern;
    }

    @Generated
    public @Nullable String getVersion() {
        return this.version;
    }

    @NonNull
    @Generated
    public String toString() {
        return "DependencyInsight(dependenciesInUse=" + this.getDependenciesInUse() + ", packagePattern=" + this.getPackagePattern() + ", version=" + this.getVersion() + ")";
    }

    @Generated
    public boolean equals(@org.openrewrite.internal.lang.Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DependencyInsight)) {
            return false;
        }
        DependencyInsight other = (DependencyInsight)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$packagePattern = this.getPackagePattern();
        String other$packagePattern = other.getPackagePattern();
        if (this$packagePattern == null ? other$packagePattern != null : !this$packagePattern.equals(other$packagePattern)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        return !(this$version == null ? other$version != null : !this$version.equals(other$version));
    }

    @Generated
    protected boolean canEqual(@org.openrewrite.internal.lang.Nullable Object other) {
        return other instanceof DependencyInsight;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $packagePattern = this.getPackagePattern();
        result = result * 59 + ($packagePattern == null ? 43 : $packagePattern.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        return result;
    }
}

