/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.jenkins;

import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.maven.MavenVisitor;
import org.openrewrite.xml.AddOrUpdateChild;
import org.openrewrite.xml.tree.Xml;

public final class DisableLocalResolutionForParentPom
extends Recipe {
    public String getDisplayName() {
        return "Disables local file resolution for parent POM";
    }

    public String getDescription() {
        return "Explicitly sets `<relativePath/>` to disable file resolution, as recommended in the [plugin development guide](https://www.jenkins.io/doc/developer/plugin-development/updating-parent/).";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new MavenVisitor<ExecutionContext>(){

            public Xml visitTag(Xml.Tag tag, ExecutionContext ctx) {
                if (this.isParentTag()) {
                    Xml.Tag relativePathTag = Xml.Tag.build((String)"<relativePath/>");
                    return AddOrUpdateChild.addOrUpdateChild((Xml.Tag)tag, (Xml.Tag)relativePathTag, (Cursor)this.getCursor().getParentOrThrow());
                }
                return super.visitTag(tag, (Object)ctx);
            }
        };
    }

    @NonNull
    public String toString() {
        return "DisableLocalResolutionForParentPom()";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DisableLocalResolutionForParentPom)) {
            return false;
        }
        DisableLocalResolutionForParentPom other = (DisableLocalResolutionForParentPom)((Object)o);
        return other.canEqual((Object)this);
    }

    protected boolean canEqual(@Nullable Object other) {
        return other instanceof DisableLocalResolutionForParentPom;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

