/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.reactive.reactor;

import org.openrewrite.java.template.RecipeDescriptor;
import reactor.core.publisher.ReplayProcessor;
import reactor.core.publisher.Sinks;

@RecipeDescriptor(name="Replace various `Processor.cache` calls with their `Sinks` equivalent", description="As of 3.5 Processors are deprecated and Sinks are preferred.")
public class ReactorProcessorCacheToSink {

    @RecipeDescriptor(name="Replace `ReplayProcessor.cacheLast()` with `Sinks.many().replay().latest()`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCacheDefaultToSink {
        void createBefore(Object value) {
            ReplayProcessor.cacheLastOrDefault((Object)value);
        }

        void sinkAfter(Object value) {
            Sinks.many().replay().latestOrDefault(value);
        }
    }

    @RecipeDescriptor(name="Replace `ReplayProcessor.cacheLast()` with `Sinks.many().replay().latest()`", description="As of 3.5 ReplayProcessor is deprecated and Sinks are preferred")
    public static class ReplayProcessorCacheToSink {
        void createBefore() {
            ReplayProcessor.cacheLast();
        }

        void sinkAfter() {
            Sinks.many().replay().latest();
        }
    }
}

