/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.ShortenFullyQualifiedTypeReferences;
import org.openrewrite.java.service.AnnotationService;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.staticanalysis.NullableOnMethodReturnType;
import org.openrewrite.staticanalysis.java.MoveFieldAnnotationToType;

public final class AnnotateNullableMethods
extends Recipe {
    @Option(displayName="`@Nullable` annotation class", description="The fully qualified name of the @Nullable annotation. The annotation should be meta annotated with `@Target(TYPE_USE)`. Defaults to `org.jspecify.annotations.Nullable`", example="org.jspecify.annotations.Nullable", required=false)
    private final @Nullable String nullableAnnotationClass;
    private static final String DEFAULT_NULLABLE_ANN_CLASS = "org.jspecify.annotations.Nullable";

    public String getDisplayName() {
        return "Annotate methods which may return `null` with `@Nullable`";
    }

    public String getDescription() {
        return "Add `@Nullable` to non-private methods that may return `null`. By default `org.jspecify.annotations.Nullable` is used, but through the `nullableAnnotationClass` option a custom annotation can be provided. When providing a custom `nullableAnnotationClass` that annotation should be meta annotated with `@Target(TYPE_USE)`. This recipe scans for methods that do not already have a `@Nullable` annotation and checks their return statements for potential null values. It also identifies known methods from standard libraries that may return null, such as methods from `Map`, `Queue`, `Deque`, `NavigableSet`, and `Spliterator`. The return of streams, or lambdas are not taken into account.";
    }

    public Validated<Object> validate() {
        return super.validate().and(Validated.test((String)"nullableAnnotationClass", (String)"Property `nullableAnnotationClass` must be a fully qualified classname.", (Object)this.nullableAnnotationClass, it -> it == null || it.contains(".")));
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        final String fullyQualifiedName = this.nullableAnnotationClass != null ? this.nullableAnnotationClass : DEFAULT_NULLABLE_ANN_CLASS;
        final String fullyQualifiedPackage = fullyQualifiedName.substring(0, fullyQualifiedName.lastIndexOf(46));
        final String simpleName = fullyQualifiedName.substring(fullyQualifiedName.lastIndexOf(46) + 1);
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration methodDeclaration, ExecutionContext ctx) {
                if (!methodDeclaration.hasModifier(J.Modifier.Type.Public) || methodDeclaration.getMethodType() == null || methodDeclaration.getMethodType().getReturnType() instanceof JavaType.Primitive || ((AnnotationService)this.service(AnnotationService.class)).matches(this.getCursor(), new AnnotationMatcher("@" + fullyQualifiedName)) || methodDeclaration.getReturnTypeExpression() != null && ((AnnotationService)this.service(AnnotationService.class)).matches(new Cursor(null, (Object)methodDeclaration.getReturnTypeExpression()), new AnnotationMatcher("@" + fullyQualifiedName))) {
                    return methodDeclaration;
                }
                J.MethodDeclaration md = super.visitMethodDeclaration(methodDeclaration, (Object)ctx);
                this.updateCursor((Tree)md);
                if (FindNullableReturnStatements.find((J)md.getBody(), this.getCursor().getParentTreeCursor())) {
                    J.MethodDeclaration annotatedMethod = (J.MethodDeclaration)JavaTemplate.builder((String)("@" + fullyQualifiedName)).javaParser(JavaParser.fromJavaVersion().dependsOn(new String[]{String.format("package %s;public @interface %s {}", fullyQualifiedPackage, simpleName)})).build().apply(this.getCursor(), md.getCoordinates().addAnnotation(Comparator.comparing(J.Annotation::getSimpleName)), new Object[0]);
                    this.doAfterVisit((TreeVisitor)ShortenFullyQualifiedTypeReferences.modifyOnly((J)annotatedMethod));
                    this.doAfterVisit(new MoveFieldAnnotationToType(fullyQualifiedName).getVisitor());
                    return (J.MethodDeclaration)new NullableOnMethodReturnType().getVisitor().visitNonNull((Tree)annotatedMethod, (Object)ctx, this.getCursor().getParentTreeCursor());
                }
                return md;
            }
        };
    }

    @Generated
    public AnnotateNullableMethods(@Nullable String nullableAnnotationClass) {
        this.nullableAnnotationClass = nullableAnnotationClass;
    }

    @Generated
    public @Nullable String getNullableAnnotationClass() {
        return this.nullableAnnotationClass;
    }

    @Generated
    public String toString() {
        return "AnnotateNullableMethods(nullableAnnotationClass=" + this.getNullableAnnotationClass() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnnotateNullableMethods)) {
            return false;
        }
        AnnotateNullableMethods other = (AnnotateNullableMethods)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$nullableAnnotationClass = this.getNullableAnnotationClass();
        String other$nullableAnnotationClass = other.getNullableAnnotationClass();
        return !(this$nullableAnnotationClass == null ? other$nullableAnnotationClass != null : !this$nullableAnnotationClass.equals(other$nullableAnnotationClass));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AnnotateNullableMethods;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $nullableAnnotationClass = this.getNullableAnnotationClass();
        result = result * 59 + ($nullableAnnotationClass == null ? 43 : $nullableAnnotationClass.hashCode());
        return result;
    }

    private static class FindNullableReturnStatements
    extends JavaIsoVisitor<AtomicBoolean> {
        private static final List<MethodMatcher> KNOWN_NULLABLE_METHODS = Arrays.asList(new MethodMatcher("java.util.Map get(..)"), new MethodMatcher("java.util.Map merge(..)"), new MethodMatcher("java.util.Map put(..)"), new MethodMatcher("java.util.Map putIfAbsent(..)"), new MethodMatcher("java.util.Queue poll(..)"), new MethodMatcher("java.util.Queue peek(..)"), new MethodMatcher("java.util.Deque peekFirst(..)"), new MethodMatcher("java.util.Deque pollFirst(..)"), new MethodMatcher("java.util.Deque peekLast(..)"), new MethodMatcher("java.util.NavigableSet lower(..)"), new MethodMatcher("java.util.NavigableSet floor(..)"), new MethodMatcher("java.util.NavigableSet ceiling(..)"), new MethodMatcher("java.util.NavigableSet higher(..)"), new MethodMatcher("java.util.NavigableSet pollFirst(..)"), new MethodMatcher("java.util.NavigableSet pollLast(..)"), new MethodMatcher("java.util.NavigableMap lowerEntry(..)"), new MethodMatcher("java.util.NavigableMap floorEntry(..)"), new MethodMatcher("java.util.NavigableMap ceilingEntry(..)"), new MethodMatcher("java.util.NavigableMap higherEntry(..)"), new MethodMatcher("java.util.NavigableMap lowerKey(..)"), new MethodMatcher("java.util.NavigableMap floorKey(..)"), new MethodMatcher("java.util.NavigableMap ceilingKey(..)"), new MethodMatcher("java.util.NavigableMap higherKey(..)"), new MethodMatcher("java.util.NavigableMap firstEntry(..)"), new MethodMatcher("java.util.NavigableMap lastEntry(..)"), new MethodMatcher("java.util.NavigableMap pollFirstEntry(..)"), new MethodMatcher("java.util.NavigableMap pollLastEntry(..)"), new MethodMatcher("java.util.Spliterator trySplit(..)"));

        private FindNullableReturnStatements() {
        }

        static boolean find(@Nullable J subtree, Cursor parentTreeCursor) {
            return ((AtomicBoolean)new FindNullableReturnStatements().reduce((Tree)subtree, new AtomicBoolean(), parentTreeCursor)).get();
        }

        public J.Lambda visitLambda(J.Lambda lambda, AtomicBoolean atomicBoolean) {
            return lambda;
        }

        public J.NewClass visitNewClass(J.NewClass newClass, AtomicBoolean atomicBoolean) {
            return newClass;
        }

        public J.Return visitReturn(J.Return retrn, AtomicBoolean found) {
            if (found.get()) {
                return retrn;
            }
            J.Return r = super.visitReturn(retrn, (Object)found);
            found.set(this.maybeIsNull(r.getExpression()));
            return r;
        }

        private boolean maybeIsNull(@Nullable Expression returnExpression) {
            if (returnExpression instanceof J.Literal) {
                return ((J.Literal)returnExpression).getValue() == null;
            }
            if (returnExpression instanceof J.MethodInvocation) {
                return this.isKnowNullableMethod((J.MethodInvocation)returnExpression);
            }
            if (returnExpression instanceof J.Ternary) {
                J.Ternary ternary = (J.Ternary)returnExpression;
                return this.maybeIsNull(ternary.getTruePart()) || this.maybeIsNull(ternary.getFalsePart());
            }
            return false;
        }

        private boolean isKnowNullableMethod(J.MethodInvocation methodInvocation) {
            for (MethodMatcher m : KNOWN_NULLABLE_METHODS) {
                if (!m.matches((MethodCall)methodInvocation)) continue;
                return true;
            }
            return false;
        }
    }
}

