/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.staticanalysis;

import java.util.Collections;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JRightPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class RemoveSystemOutPrintln
extends Recipe {
    private static final MethodMatcher SYSTEM_OUT_PRINTLN = new MethodMatcher("java.io.PrintStream println(..)");

    public String getDisplayName() {
        return "Remove `System.out#println` statements";
    }

    public String getDescription() {
        return "Print statements are often left accidentally after debugging an issue. This recipe removes all `System.out#println` and `System.err#println` statements from the code.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(SYSTEM_OUT_PRINTLN), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.Lambda visitLambda(J.Lambda lambda, ExecutionContext ctx) {
                J.Lambda l = super.visitLambda(lambda, (Object)ctx);
                if (l.getBody() == null) {
                    l = l.withBody((J)new J.Block(Tree.randomId(), lambda.getPrefix(), Markers.EMPTY, JRightPadded.build((Object)false), Collections.emptyList(), Space.EMPTY));
                }
                return l;
            }

            public // Could not load outer class - annotation placement on inner may be incorrect
            @Nullable J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                if (SYSTEM_OUT_PRINTLN.matches((MethodCall)method) && method.getSelect() instanceof J.FieldAccess && ((J.FieldAccess)method.getSelect()).getTarget() instanceof J.Identifier && TypeUtils.isAssignableTo((String)"java.lang.System", (JavaType)((J.FieldAccess)method.getSelect()).getTarget().getType())) {
                    return null;
                }
                return super.visitMethodInvocation(method, (Object)ctx);
            }
        });
    }
}

