/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.junit5;

import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Supplier;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Parser;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.AnnotationMatcher;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.search.FindTypes;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;
import org.openrewrite.maven.UpgradeDependencyVersion;
import org.openrewrite.template.SourceTemplate;

public class UpdateMockWebServer
extends Recipe {
    private static final AnnotationMatcher RULE_MATCHER = new AnnotationMatcher("@org.junit.Rule");
    private static final AnnotationMatcher AFTER_EACH_MATCHER = new AnnotationMatcher("@org.junit.jupiter.api.AfterEach");
    private static final String AFTER_EACH_FQN = "org.junit.jupiter.api.AfterEach";
    private static final String MOCK_WEB_SERVER_FQN = "okhttp3.mockwebserver.MockWebServer";
    private static final String IO_EXCEPTION_FQN = "java.io.IOException";
    private static final String MOCK_WEBSERVER_VARIABLE = "mock-web-server-variable";
    private static final String AFTER_EACH_METHOD = "after-each-method";
    private static final Supplier<JavaParser> OKHTTP3_PARSER = () -> JavaParser.fromJavaVersion().dependsOn(Arrays.asList(Parser.Input.fromString((String)"package okhttp3.mockwebserver;public final class MockWebServer  extends ExternalResource implements Closeable {   @Override   public void close() throws IOException {}}"), Parser.Input.fromString((String)"package org.junit.jupiter.api;\npublic @interface AfterEach {}"))).build();

    public String getDisplayName() {
        return "okhttp3 3.x MockWebserver @Rule To 4.x MockWebServer";
    }

    public String getDescription() {
        return "Replace usages of okhttp3 3.x @Rule MockWebServer with 4.x MockWebServer.";
    }

    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(5L);
    }

    protected TreeVisitor<?, ExecutionContext> getSingleSourceApplicableTest() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext executionContext) {
                J.CompilationUnit c = super.visitCompilationUnit(cu, (Object)executionContext);
                if (!FindTypes.find((J)cu, (String)"org.junit.Rule").isEmpty() && !FindTypes.find((J)cu, (String)UpdateMockWebServer.MOCK_WEB_SERVER_FQN).isEmpty()) {
                    c = c.withMarkers(c.getMarkers().searchResult());
                }
                return c;
            }
        };
    }

    protected TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext executionContext) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)executionContext);
                J.Identifier mockWebServerVariable = (J.Identifier)this.getCursor().pollMessage(UpdateMockWebServer.MOCK_WEBSERVER_VARIABLE);
                J.MethodDeclaration afterEachMethod = (J.MethodDeclaration)this.getCursor().pollMessage(UpdateMockWebServer.AFTER_EACH_METHOD);
                if (mockWebServerVariable != null) {
                    if (afterEachMethod == null) {
                        String closeMethod = "@AfterEach\nvoid afterEachTest() throws IOException {#{any(okhttp3.mockwebserver.MockWebServer)}.close();\n}";
                        J.Block body = cd.getBody();
                        body = (J.Block)this.maybeAutoFormat((J)body, (J)((J.Block)body.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"@AfterEach\nvoid afterEachTest() throws IOException {#{any(okhttp3.mockwebserver.MockWebServer)}.close();\n}").imports(new String[]{UpdateMockWebServer.AFTER_EACH_FQN, UpdateMockWebServer.MOCK_WEB_SERVER_FQN, UpdateMockWebServer.IO_EXCEPTION_FQN}).javaParser(OKHTTP3_PARSER).build(), body.getCoordinates().lastStatement(), new Object[]{mockWebServerVariable})), executionContext);
                        cd = cd.withBody(body);
                        this.maybeAddImport(UpdateMockWebServer.AFTER_EACH_FQN);
                        this.maybeAddImport(UpdateMockWebServer.IO_EXCEPTION_FQN);
                    } else {
                        J.Block body = cd.getBody();
                        body = (J.Block)this.maybeAutoFormat((J)body, (J)body.withStatements(ListUtils.map((List)cd.getBody().getStatements(), statement -> {
                            if (statement == afterEachMethod) {
                                J.MethodDeclaration method = (J.MethodDeclaration)statement;
                                if (method.getBody() != null && ((method = (J.MethodDeclaration)method.withTemplate((SourceTemplate)JavaTemplate.builder(() -> (this).getCursor(), (String)"#{any(okhttp3.mockwebserver.MockWebServer)}.close();").javaParser(OKHTTP3_PARSER).build(), method.getBody().getCoordinates().lastStatement(), new Object[]{mockWebServerVariable})).getThrows() == null || method.getThrows().stream().noneMatch(n -> TypeUtils.isOfClassType((JavaType)n.getType(), (String)UpdateMockWebServer.IO_EXCEPTION_FQN)))) {
                                    J.Identifier ioExceptionIdent = new J.Identifier(UUID.randomUUID(), Space.format((String)" "), Markers.EMPTY, "IOException", (JavaType)JavaType.ShallowClass.build((String)UpdateMockWebServer.IO_EXCEPTION_FQN), null);
                                    method = method.withThrows(ListUtils.concat((List)method.getThrows(), (Object)ioExceptionIdent));
                                    this.maybeAddImport(UpdateMockWebServer.IO_EXCEPTION_FQN);
                                }
                                statement = method;
                            }
                            return statement;
                        })), executionContext);
                        cd = cd.withBody(body);
                    }
                    this.maybeRemoveImport("org.junit.Rule");
                    UpdateMockWebServer.this.doNext((Recipe)new UpgradeDependencyVersion("com.squareup.okhttp3", "mockwebserver", "4.X", null, Boolean.valueOf(false)));
                }
                return cd;
            }

            public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext executionContext) {
                J.VariableDeclarations variableDeclarations = super.visitVariableDeclarations(multiVariable, (Object)executionContext);
                JavaType.FullyQualified fieldType = variableDeclarations.getTypeAsFullyQualified();
                if (TypeUtils.isOfClassType((JavaType)fieldType, (String)UpdateMockWebServer.MOCK_WEB_SERVER_FQN)) {
                    variableDeclarations = variableDeclarations.withLeadingAnnotations(ListUtils.map((List)variableDeclarations.getLeadingAnnotations(), annotation -> {
                        if (RULE_MATCHER.matches(annotation)) {
                            return null;
                        }
                        return annotation;
                    }));
                }
                if (multiVariable != variableDeclarations) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, UpdateMockWebServer.MOCK_WEBSERVER_VARIABLE, (Object)((J.VariableDeclarations.NamedVariable)variableDeclarations.getVariables().get(0)).getName());
                }
                return variableDeclarations;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext executionContext) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)executionContext);
                if (md.getLeadingAnnotations().stream().anyMatch(arg_0 -> ((AnnotationMatcher)AFTER_EACH_MATCHER).matches(arg_0))) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, UpdateMockWebServer.AFTER_EACH_METHOD, (Object)md);
                }
                return md;
            }
        };
    }
}

