/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class AssertThatBooleanToAssertJ
extends Recipe {
    private static final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(String, boolean)");

    public String getDisplayName() {
        return "Migrate Hamcrest `assertThat(boolean, Matcher)` to AssertJ";
    }

    public String getDescription() {
        return "Replace Hamcrest `assertThat(String, boolean)` with AssertJ `assertThat(boolean).as(String).isTrue()`.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                    Expression reasonArgument = (Expression)mi.getArguments().get(0);
                    Expression booleanArgument = (Expression)mi.getArguments().get(1);
                    this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
                    this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"assertThat(#{any(boolean)}).as(#{any(String)}).isTrue()").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{booleanArgument, reasonArgument});
                }
                return mi;
            }
        };
    }
}

