/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.hamcrest;

import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;

public class HamcrestNotMatcherToAssertJ
extends Recipe {
    @Option(displayName="Hamcrest Matcher", description="The Hamcrest `not(Matcher)` to migrate to JUnit5.", example="equalTo", required=false)
    @Nullable String notMatcher;
    @Option(displayName="AssertJ Assertion", description="The AssertJ method to migrate to.", example="isNotEqualTo", required=false)
    @Nullable String assertion;

    public String getDisplayName() {
        return "Migrate Hamcrest `not(Matcher)` to AssertJ";
    }

    public String getDescription() {
        return "Migrate from Hamcrest `not(Matcher)` to AssertJ assertions.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod("org.hamcrest.*Matchers " + this.notMatcher + "(..)"), (TreeVisitor)new MigrateToAssertJVisitor());
    }

    @Generated
    public HamcrestNotMatcherToAssertJ() {
    }

    @ConstructorProperties(value={"notMatcher", "assertion"})
    @Generated
    public HamcrestNotMatcherToAssertJ(@Nullable String notMatcher, @Nullable String assertion) {
        this.notMatcher = notMatcher;
        this.assertion = assertion;
    }

    private class MigrateToAssertJVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private final MethodMatcher ASSERT_THAT_MATCHER = new MethodMatcher("org.hamcrest.MatcherAssert assertThat(..)");
        private final MethodMatcher NOT_MATCHER = new MethodMatcher("org.hamcrest.*Matchers not(org.hamcrest.Matcher)");
        private final MethodMatcher MATCHERS_MATCHER;
        private final MethodMatcher SUB_MATCHER;

        private MigrateToAssertJVisitor() {
            this.MATCHERS_MATCHER = new MethodMatcher("org.hamcrest.*Matchers " + HamcrestNotMatcherToAssertJ.this.notMatcher + "(..)");
            this.SUB_MATCHER = new MethodMatcher("org.hamcrest.*Matchers *(org.hamcrest.Matcher)");
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (this.ASSERT_THAT_MATCHER.matches((MethodCall)mi)) {
                Expression notMethodInvocation = (Expression)mi.getArguments().get(mi.getArguments().size() - 1);
                if (!this.NOT_MATCHER.matches(notMethodInvocation)) {
                    return mi;
                }
                Expression matcherArgument = (Expression)((J.MethodInvocation)notMethodInvocation).getArguments().get(0);
                if (mi.getArguments().size() == 2) {
                    return this.handleTwoArgumentCase(mi, matcherArgument, ctx);
                }
                if (mi.getArguments().size() == 3) {
                    return this.handleThreeArgumentCase(mi, matcherArgument, ctx);
                }
            }
            return mi;
        }

        private J.MethodInvocation handleTwoArgumentCase(J.MethodInvocation mi, Expression matcherArgument, ExecutionContext ctx) {
            Expression actualArgument = (Expression)mi.getArguments().get(0);
            if (!this.MATCHERS_MATCHER.matches(matcherArgument) || this.SUB_MATCHER.matches(matcherArgument)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            List originalArguments = ((J.MethodInvocation)matcherArgument).getArguments().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toList());
            String argumentsTemplate = originalArguments.stream().map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s).%s(%s)", actual, HamcrestNotMatcherToAssertJ.this.assertion, argumentsTemplate)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build();
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.hamcrest.Matchers.not");
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestNotMatcherToAssertJ.this.notMatcher);
            this.maybeRemoveImport("org.hamcrest.CoreMatchers.not");
            this.maybeRemoveImport("org.hamcrest.CoreMatchers." + HamcrestNotMatcherToAssertJ.this.notMatcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert");
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            ArrayList<Object> templateArguments = new ArrayList<Object>();
            templateArguments.add(actualArgument);
            templateArguments.addAll(originalArguments);
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private J.MethodInvocation handleThreeArgumentCase(J.MethodInvocation mi, Expression matcherArgument, ExecutionContext ctx) {
            Expression reasonArgument = (Expression)mi.getArguments().get(0);
            Expression actualArgument = (Expression)mi.getArguments().get(1);
            if (!this.MATCHERS_MATCHER.matches(matcherArgument) || this.SUB_MATCHER.matches(matcherArgument)) {
                return mi;
            }
            String actual = this.typeToIndicator(actualArgument.getType());
            List originalArguments = ((J.MethodInvocation)matcherArgument).getArguments().stream().filter(a -> !(a instanceof J.Empty)).collect(Collectors.toList());
            String argumentsTemplate = originalArguments.stream().map(a -> this.typeToIndicator(a.getType())).collect(Collectors.joining(", "));
            JavaTemplate template = JavaTemplate.builder((String)String.format("assertThat(%s).as(#{any(String)}).%s(%s)", actual, HamcrestNotMatcherToAssertJ.this.assertion, argumentsTemplate)).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"assertj-core-3.24"})).staticImports(new String[]{"org.assertj.core.api.Assertions.assertThat"}).build();
            this.maybeAddImport("org.assertj.core.api.Assertions", "assertThat");
            this.maybeRemoveImport("org.hamcrest.Matchers.not");
            this.maybeRemoveImport("org.hamcrest.Matchers." + HamcrestNotMatcherToAssertJ.this.notMatcher);
            this.maybeRemoveImport("org.hamcrest.MatcherAssert");
            this.maybeRemoveImport("org.hamcrest.MatcherAssert.assertThat");
            ArrayList<Object> templateArguments = new ArrayList<Object>();
            templateArguments.add(actualArgument);
            templateArguments.add(reasonArgument);
            templateArguments.addAll(originalArguments);
            return (J.MethodInvocation)template.apply(this.getCursor(), mi.getCoordinates().replace(), templateArguments.toArray());
        }

        private String typeToIndicator(JavaType type) {
            String str = type instanceof JavaType.Primitive || type.toString().startsWith("java.") ? type.toString().replaceAll("<.*>", "") : "java.lang.Object";
            return String.format("#{any(%s)}", str);
        }
    }
}

