/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.java.testing.truth;

import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.marker.SearchResult;

public class TruthAssertToAssertThat
extends Recipe {
    private static final MethodMatcher ASSERT_MATCHER = new MethodMatcher("com.google.common.truth.Truth assert_()");

    public String getDisplayName() {
        return "Convert Truth `assert_()` to AssertJ";
    }

    public String getDescription() {
        return "Converts Google Truth's `assert_()` method to AssertJ's standard assertion pattern.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(ASSERT_MATCHER), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
                if (ASSERT_MATCHER.matches((MethodCall)mi)) {
                    return (J.MethodInvocation)SearchResult.found((Tree)mi, (String)"Truth's assert_() requires manual review for migration to AssertJ");
                }
                return mi;
            }
        });
    }
}

