/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Incubating;
import org.openrewrite.Recipe;

@JsonIgnoreType
@Incubating(since="7.35.0")
public class DataTable<Row> {
    private final String name;
    private final Class<Row> type;
    @Language(value="markdown")
    private final String displayName;
    @Language(value="markdown")
    private final String description;

    public DataTable(Recipe recipe, Class<Row> type, String name, @Language(value="markdown") String displayName, @Language(value="markdown") String description) {
        this.name = name;
        this.type = type;
        this.displayName = displayName;
        this.description = description;
        recipe.addDataTable(this);
    }

    public void insertRow(ExecutionContext ctx, Row row) {
        ctx.computeMessage("org.openrewrite.dataTables", row, HashMap::new, (extract, allDataTables) -> {
            List dataTablesOfType = (List)allDataTables.computeIfAbsent(this, c -> new ArrayList());
            dataTablesOfType.add(row);
            return allDataTables;
        });
    }

    public String getName() {
        return this.name;
    }

    public Class<Row> getType() {
        return this.type;
    }

    @Language(value="markdown")
    public String getDisplayName() {
        return this.displayName;
    }

    @Language(value="markdown")
    public String getDescription() {
        return this.description;
    }
}

