/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.openrewrite.Recipe;
import org.openrewrite.config.DataTableDescriptor;

public class CompositeRecipe
extends Recipe {
    @Override
    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public Duration getEstimatedEffortPerOccurrence() {
        Duration total = Duration.ofMinutes(0L);
        for (Recipe recipe : this.getRecipeList()) {
            if (recipe.getEstimatedEffortPerOccurrence() == null) continue;
            total = total.plus(recipe.getEstimatedEffortPerOccurrence());
        }
        if (total.getSeconds() == 0L) {
            return Duration.ofMinutes(5L);
        }
        return total;
    }

    @Override
    public List<DataTableDescriptor> getDataTableDescriptors() {
        ArrayList<DataTableDescriptor> dataTableDescriptors = null;
        for (Recipe recipe : this.getRecipeList()) {
            List<DataTableDescriptor> dtd = recipe.getDataTableDescriptors();
            if (dtd.isEmpty()) continue;
            if (dataTableDescriptors == null) {
                dataTableDescriptors = new ArrayList<DataTableDescriptor>();
            }
            dataTableDescriptors.addAll(dtd);
        }
        return dataTableDescriptors == null ? Collections.emptyList() : dataTableDescriptors;
    }
}

