/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.StringJoiner;
import org.openrewrite.internal.RecipeRunException;

public class ExceptionUtils {
    public static String sanitizeStackTrace(Throwable t, Class<?> until) {
        StringJoiner sanitized = new StringJoiner("\n");
        Throwable cause = t instanceof RecipeRunException ? t.getCause() : t;
        sanitized.add(cause.getClass().getName() + ": " + cause.getLocalizedMessage());
        int i = 0;
        for (StackTraceElement stackTraceElement : cause.getStackTrace()) {
            if (stackTraceElement.getClassName().equals(until.getName())) break;
            if (i++ >= 8) {
                sanitized.add("  ...");
                break;
            }
            sanitized.add("  " + stackTraceElement);
        }
        return sanitized.toString();
    }
}

