/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.table;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import org.openrewrite.Column;
import org.openrewrite.DataTable;
import org.openrewrite.Recipe;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

@JsonIgnoreType
public class ParseFailures
extends DataTable<Row> {
    public ParseFailures(Recipe recipe) {
        super(recipe, Row.class, ParseFailures.class.getName(), "Parser failures", "A list of files that failed to parse along with stack traces of their failures.");
    }

    public static final class Row {
        @Column(displayName="Source path", description="The file that failed to parse.")
        private final String sourcePath;
        @Column(displayName="Stack trace", description="The stack trace of the failure.")
        private final String stackTrace;

        public Row(String sourcePath, String stackTrace) {
            this.sourcePath = sourcePath;
            this.stackTrace = stackTrace;
        }

        public String getSourcePath() {
            return this.sourcePath;
        }

        public String getStackTrace() {
            return this.stackTrace;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Row)) {
                return false;
            }
            Row other = (Row)o;
            String this$sourcePath = this.getSourcePath();
            String other$sourcePath = other.getSourcePath();
            if (this$sourcePath == null ? other$sourcePath != null : !this$sourcePath.equals(other$sourcePath)) {
                return false;
            }
            String this$stackTrace = this.getStackTrace();
            String other$stackTrace = other.getStackTrace();
            return !(this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $sourcePath = this.getSourcePath();
            result = result * 59 + ($sourcePath == null ? 43 : $sourcePath.hashCode());
            String $stackTrace = this.getStackTrace();
            result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ParseFailures.Row(sourcePath=" + this.getSourcePath() + ", stackTrace=" + this.getStackTrace() + ")";
        }
    }
}

