/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.time.LocalDate;
import java.time.ZoneOffset;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.ParseExceptionResult;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.Validated;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.BuildMetadata;
import org.openrewrite.marker.DeserializationError;
import org.openrewrite.marker.Markup;
import org.openrewrite.table.ParseFailures;

public final class FindParseFailures
extends Recipe {
    @Option(displayName="Max snippet length", description="When the failure occurs on a granular tree element, its source code will be included as a column in the data table up to this maximum snippet length.", required=false)
    private final @org.jspecify.annotations.Nullable Integer maxSnippetLength;
    @Option(displayName="Parser type", description="Only display failures from parsers with this simple name.", required=false, example="YamlParser")
    private final @org.jspecify.annotations.Nullable String parserType;
    @Option(example="RuntimeException", displayName="Stack trace", description="Only mark stack traces with a message containing this text.", required=false)
    private final @org.jspecify.annotations.Nullable String stackTrace;
    @Option(displayName="Created after", description="Only report on source files that were created after this date.", example="2025-01-01", required=false)
    private final @org.jspecify.annotations.Nullable String createdAfter;
    private final transient ParseFailures failures = new ParseFailures(this);

    @Override
    public String getDisplayName() {
        return "Find source files with `ParseExceptionResult` markers";
    }

    @Override
    public String getDescription() {
        return "This recipe explores parse failures after an LST is produced for classifying the types of failures that can occur and prioritizing fixes according to the most common problems.";
    }

    @Override
    public Validated<Object> validate() {
        return super.validate().and(Validated.test("createdAfter", "Must be empty or a valid date of format yyyy-MM-dd", this.createdAfter, date -> {
            if (date != null && !date.isEmpty()) {
                try {
                    LocalDate.parse(date);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return true;
        }));
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor() {
        TreeVisitor<Tree, ExecutionContext> precondition = new TreeVisitor<Tree, ExecutionContext>(){
            final long createdAfterEpoch;
            {
                this.createdAfterEpoch = FindParseFailures.this.createdAfter == null ? -1L : LocalDate.parse(FindParseFailures.this.createdAfter).atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
            }

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                return this.createdAfterEpoch == -1L || tree != null && tree.getMarkers().findFirst(BuildMetadata.class).map(BuildMetadata::getMetadata).map(m -> (String)m.get("createdAt")).map(Long::parseLong).map(t -> t >= this.createdAfterEpoch).orElse(false) != false ? null : tree;
            }
        };
        return Preconditions.check(precondition, new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree postVisit(Tree tree, ExecutionContext ctx) {
                return tree.getMarkers().findFirst(ParseExceptionResult.class).map(exceptionResult -> this.report(tree, (ParseExceptionResult)exceptionResult, ctx)).orElse(tree.getMarkers().findFirst(DeserializationError.class).map(error -> this.report(tree, (DeserializationError)error, ctx)).orElse(tree));
            }

            private Tree report(Tree tree, DeserializationError error, ExecutionContext ctx) {
                if (FindParseFailures.this.stackTrace != null && !error.getDetail().contains(FindParseFailures.this.stackTrace)) {
                    return tree;
                }
                FindParseFailures.this.failures.insertRow(ctx, new ParseFailures.Row("Unknown", (tree instanceof SourceFile ? (SourceFile)tree : this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), "DeserializationError", null, null, error.getDetail()));
                return Markup.info(tree, error.getMessage());
            }

            private Tree report(Tree tree, ParseExceptionResult exceptionResult, ExecutionContext ctx) {
                String snippet;
                if (FindParseFailures.this.parserType != null && !Objects.equals(exceptionResult.getParserType(), FindParseFailures.this.parserType)) {
                    return tree;
                }
                if (FindParseFailures.this.stackTrace != null && !exceptionResult.getMessage().contains(FindParseFailures.this.stackTrace)) {
                    return tree;
                }
                String string = snippet = tree instanceof SourceFile ? null : tree.printTrimmed(this.getCursor().getParentTreeCursor());
                if (snippet != null && FindParseFailures.this.maxSnippetLength != null && snippet.length() > FindParseFailures.this.maxSnippetLength) {
                    snippet = snippet.substring(0, FindParseFailures.this.maxSnippetLength);
                }
                FindParseFailures.this.failures.insertRow(ctx, new ParseFailures.Row(exceptionResult.getParserType(), (tree instanceof SourceFile ? (SourceFile)tree : this.getCursor().firstEnclosingOrThrow(SourceFile.class)).getSourcePath().toString(), exceptionResult.getExceptionType(), exceptionResult.getTreeType(), snippet, exceptionResult.getMessage()));
                return Markup.info(tree, exceptionResult.getMessage());
            }
        });
    }

    @Generated
    public FindParseFailures(@org.jspecify.annotations.Nullable Integer maxSnippetLength, @org.jspecify.annotations.Nullable String parserType, @org.jspecify.annotations.Nullable String stackTrace, @org.jspecify.annotations.Nullable String createdAfter) {
        this.maxSnippetLength = maxSnippetLength;
        this.parserType = parserType;
        this.stackTrace = stackTrace;
        this.createdAfter = createdAfter;
    }

    @Generated
    public @org.jspecify.annotations.Nullable Integer getMaxSnippetLength() {
        return this.maxSnippetLength;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getParserType() {
        return this.parserType;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getStackTrace() {
        return this.stackTrace;
    }

    @Generated
    public @org.jspecify.annotations.Nullable String getCreatedAfter() {
        return this.createdAfter;
    }

    @Generated
    public ParseFailures getFailures() {
        return this.failures;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindParseFailures(maxSnippetLength=" + this.getMaxSnippetLength() + ", parserType=" + this.getParserType() + ", stackTrace=" + this.getStackTrace() + ", createdAfter=" + this.getCreatedAfter() + ", failures=" + this.getFailures() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindParseFailures)) {
            return false;
        }
        FindParseFailures other = (FindParseFailures)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$maxSnippetLength = this.getMaxSnippetLength();
        Integer other$maxSnippetLength = other.getMaxSnippetLength();
        if (this$maxSnippetLength == null ? other$maxSnippetLength != null : !((Object)this$maxSnippetLength).equals(other$maxSnippetLength)) {
            return false;
        }
        String this$parserType = this.getParserType();
        String other$parserType = other.getParserType();
        if (this$parserType == null ? other$parserType != null : !this$parserType.equals(other$parserType)) {
            return false;
        }
        String this$stackTrace = this.getStackTrace();
        String other$stackTrace = other.getStackTrace();
        if (this$stackTrace == null ? other$stackTrace != null : !this$stackTrace.equals(other$stackTrace)) {
            return false;
        }
        String this$createdAfter = this.getCreatedAfter();
        String other$createdAfter = other.getCreatedAfter();
        return !(this$createdAfter == null ? other$createdAfter != null : !this$createdAfter.equals(other$createdAfter));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindParseFailures;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $maxSnippetLength = this.getMaxSnippetLength();
        result = result * 59 + ($maxSnippetLength == null ? 43 : ((Object)$maxSnippetLength).hashCode());
        String $parserType = this.getParserType();
        result = result * 59 + ($parserType == null ? 43 : $parserType.hashCode());
        String $stackTrace = this.getStackTrace();
        result = result * 59 + ($stackTrace == null ? 43 : $stackTrace.hashCode());
        String $createdAfter = this.getCreatedAfter();
        result = result * 59 + ($createdAfter == null ? 43 : $createdAfter.hashCode());
        return result;
    }
}

