/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.internal;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;

public class ManagedThreadLocal<T extends AutoCloseable> {
    private final ThreadLocal<@Nullable T> threadLocal = new ThreadLocal();

    public T require() {
        AutoCloseable value = (AutoCloseable)this.threadLocal.get();
        if (value == null) {
            throw new IllegalStateException("No managed resource found in current thread context");
        }
        return (T)value;
    }

    public Scope<T> requireOrCreate(Supplier<T> factory) {
        AutoCloseable existing = (AutoCloseable)this.threadLocal.get();
        if (existing != null) {
            return new Scope<AutoCloseable>(existing, () -> {});
        }
        AtomicReference<@Nullable V> resourceRef = new AtomicReference();
        return new Scope<AutoCloseable>(() -> {
            AutoCloseable resource = (AutoCloseable)resourceRef.get();
            if (resource == null) {
                resource = (AutoCloseable)factory.get();
                this.threadLocal.set(resource);
                resourceRef.set(resource);
            }
            return resource;
        }, () -> {
            AutoCloseable resource = (AutoCloseable)resourceRef.get();
            if (resource != null) {
                try {
                    this.threadLocal.remove();
                }
                finally {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        System.err.println("Error closing managed resource: " + e.getMessage());
                    }
                }
            }
        });
    }

    public Scope<T> create(Supplier<T> factory) {
        AutoCloseable previousValue = (AutoCloseable)this.threadLocal.get();
        AtomicReference<@Nullable V> resourceRef = new AtomicReference();
        return new Scope<AutoCloseable>(() -> {
            AutoCloseable resource = (AutoCloseable)resourceRef.get();
            if (resource == null) {
                resource = (AutoCloseable)factory.get();
                this.threadLocal.set(resource);
                resourceRef.set(resource);
            }
            return resource;
        }, () -> {
            AutoCloseable resource = (AutoCloseable)resourceRef.get();
            try {
                if (previousValue != null) {
                    this.threadLocal.set(previousValue);
                } else {
                    this.threadLocal.remove();
                }
            }
            finally {
                if (resource != null) {
                    try {
                        resource.close();
                    }
                    catch (Exception e) {
                        System.err.println("Error closing created resource: " + e.getMessage());
                    }
                }
            }
        });
    }

    public Scope<T> using(T value) {
        AutoCloseable previousValue = (AutoCloseable)this.threadLocal.get();
        this.threadLocal.set(value);
        return new Scope<T>(value, () -> {
            if (previousValue != null) {
                this.threadLocal.set(previousValue);
            } else {
                this.threadLocal.remove();
            }
        });
    }

    public ThreadLocal<@Nullable T> asThreadLocal() {
        return this.threadLocal;
    }

    public boolean isPresent() {
        return this.threadLocal.get() != null;
    }

    public static class Scope<T extends AutoCloseable>
    implements AutoCloseable {
        private final Supplier<T> resourceSupplier;
        private final AutoCloseable cleanup;

        Scope(T resource, AutoCloseable cleanup) {
            this.resourceSupplier = () -> resource;
            this.cleanup = cleanup;
        }

        Scope(Supplier<T> resourceSupplier, AutoCloseable cleanup) {
            this.resourceSupplier = resourceSupplier;
            this.cleanup = cleanup;
        }

        public <R> R map(Function<T, R> mapper) {
            return mapper.apply((AutoCloseable)this.resourceSupplier.get());
        }

        @Override
        public void close() {
            try {
                this.cleanup.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

