/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite;

import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.ScanningRecipe;
import org.openrewrite.SourceFile;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.table.CollidingSourceFiles;

public final class FindCollidingSourceFiles
extends ScanningRecipe<Accumulator> {
    private final transient CollidingSourceFiles collidingSourceFiles = new CollidingSourceFiles(this);

    @Override
    public String getDisplayName() {
        return "Find colliding source files";
    }

    @Override
    public String getDescription() {
        return "Finds source files which share a path with another source file. There should always be exactly one source file per path within a repository. This is a diagnostic for finding problems in OpenRewrite parsers/build plugins.";
    }

    @Override
    public Accumulator getInitialValue(ExecutionContext ctx) {
        return new Accumulator();
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getScanner(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                assert (tree instanceof SourceFile);
                Path p = ((SourceFile)tree).getSourcePath();
                if (!acc.getSourcePaths().add(p)) {
                    acc.getDuplicates().add(p);
                }
                return tree;
            }
        };
    }

    @Override
    public Collection<? extends SourceFile> generate(Accumulator acc, ExecutionContext ctx) {
        acc.getSourcePaths().clear();
        return super.generate(acc, ctx);
    }

    @Override
    public TreeVisitor<?, ExecutionContext> getVisitor(final Accumulator acc) {
        return new TreeVisitor<Tree, ExecutionContext>(){

            @Override
            public @org.jspecify.annotations.Nullable Tree visit(@org.jspecify.annotations.Nullable Tree tree, ExecutionContext ctx) {
                if (tree instanceof SourceFile) {
                    Path p = ((SourceFile)tree).getSourcePath();
                    if (acc.getDuplicates().contains(p)) {
                        FindCollidingSourceFiles.this.collidingSourceFiles.insertRow(ctx, new CollidingSourceFiles.Row(p.toString(), tree.getClass().toString()));
                        return SearchResult.found(tree, "Duplicate source file " + p);
                    }
                }
                return tree;
            }
        };
    }

    @Generated
    public FindCollidingSourceFiles() {
    }

    @Generated
    public CollidingSourceFiles getCollidingSourceFiles() {
        return this.collidingSourceFiles;
    }

    @NonNull
    @Generated
    public String toString() {
        return "FindCollidingSourceFiles(collidingSourceFiles=" + this.getCollidingSourceFiles() + ")";
    }

    @Override
    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindCollidingSourceFiles)) {
            return false;
        }
        FindCollidingSourceFiles other = (FindCollidingSourceFiles)o;
        return other.canEqual(this);
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof FindCollidingSourceFiles;
    }

    @Override
    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }

    static final class Accumulator {
        private final Set<Path> sourcePaths = new LinkedHashSet<Path>();
        private final Set<Path> duplicates = new LinkedHashSet<Path>();

        @Generated
        public Accumulator() {
        }

        @Generated
        public Set<Path> getSourcePaths() {
            return this.sourcePaths;
        }

        @Generated
        public Set<Path> getDuplicates() {
            return this.duplicates;
        }

        @Generated
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Accumulator)) {
                return false;
            }
            Accumulator other = (Accumulator)o;
            Set<Path> this$sourcePaths = this.getSourcePaths();
            Set<Path> other$sourcePaths = other.getSourcePaths();
            if (this$sourcePaths == null ? other$sourcePaths != null : !((Object)this$sourcePaths).equals(other$sourcePaths)) {
                return false;
            }
            Set<Path> this$duplicates = this.getDuplicates();
            Set<Path> other$duplicates = other.getDuplicates();
            return !(this$duplicates == null ? other$duplicates != null : !((Object)this$duplicates).equals(other$duplicates));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Path> $sourcePaths = this.getSourcePaths();
            result = result * 59 + ($sourcePaths == null ? 43 : ((Object)$sourcePaths).hashCode());
            Set<Path> $duplicates = this.getDuplicates();
            result = result * 59 + ($duplicates == null ? 43 : ((Object)$duplicates).hashCode());
            return result;
        }

        @NonNull
        @Generated
        public String toString() {
            return "FindCollidingSourceFiles.Accumulator(sourcePaths=" + this.getSourcePaths() + ", duplicates=" + this.getDuplicates() + ")";
        }
    }
}

